/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.deltacommit;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.action.commit.SmallFile;
import org.apache.hudi.table.action.commit.UpsertPartitioner;

public class SparkUpsertDeltaCommitPartitioner<T extends HoodieRecordPayload<T>>
extends UpsertPartitioner<T> {
    SparkUpsertDeltaCommitPartitioner(WorkloadProfile profile, HoodieSparkEngineContext context, HoodieTable table, HoodieWriteConfig config) {
        super(profile, context, table, config);
    }

    @Override
    protected List<SmallFile> getSmallFiles(String partitionPath) {
        ArrayList<SmallFile> smallFileLocations = new ArrayList<SmallFile>();
        HoodieTimeline commitTimeline = this.table.getCompletedCommitsTimeline();
        if (!commitTimeline.empty()) {
            HoodieInstant latestCommitTime = commitTimeline.lastInstant().get();
            ArrayList<FileSlice> allSmallFileSlices = new ArrayList<FileSlice>();
            if (!this.table.getIndex().canIndexLogFiles()) {
                Option<FileSlice> smallFileSlice = Option.fromJavaOptional(this.table.getSliceView().getLatestFileSlicesBeforeOrOn(partitionPath, latestCommitTime.getTimestamp(), false).filter(fileSlice -> fileSlice.getLogFiles().count() < 1L && fileSlice.getBaseFile().get().getFileSize() < (long)this.config.getParquetSmallFileLimit()).min((left, right) -> left.getBaseFile().get().getFileSize() < right.getBaseFile().get().getFileSize() ? -1 : 1));
                if (smallFileSlice.isPresent()) {
                    allSmallFileSlices.add(smallFileSlice.get());
                }
            } else {
                List allFileSlices = this.table.getSliceView().getLatestFileSlicesBeforeOrOn(partitionPath, latestCommitTime.getTimestamp(), true).collect(Collectors.toList());
                for (FileSlice fileSlice2 : allFileSlices) {
                    if (!this.isSmallFile(fileSlice2)) continue;
                    allSmallFileSlices.add(fileSlice2);
                }
            }
            for (FileSlice smallFileSlice : allSmallFileSlices) {
                SmallFile sf = new SmallFile();
                if (smallFileSlice.getBaseFile().isPresent()) {
                    String filename = smallFileSlice.getBaseFile().get().getFileName();
                    sf.location = new HoodieRecordLocation(FSUtils.getCommitTime(filename), FSUtils.getFileId(filename));
                    sf.sizeBytes = this.getTotalFileSize(smallFileSlice);
                    smallFileLocations.add(sf);
                    continue;
                }
                HoodieLogFile logFile = smallFileSlice.getLogFiles().findFirst().get();
                sf.location = new HoodieRecordLocation(FSUtils.getBaseCommitTimeFromLogPath(logFile.getPath()), FSUtils.getFileIdFromLogPath(logFile.getPath()));
                sf.sizeBytes = this.getTotalFileSize(smallFileSlice);
                smallFileLocations.add(sf);
            }
        }
        return smallFileLocations;
    }

    public List<String> getSmallFileIds() {
        return this.smallFiles.stream().map(smallFile -> smallFile.location.getFileId()).collect(Collectors.toList());
    }

    private long getTotalFileSize(FileSlice fileSlice) {
        if (!fileSlice.getBaseFile().isPresent()) {
            return this.convertLogFilesSizeToExpectedParquetSize(fileSlice.getLogFiles().collect(Collectors.toList()));
        }
        return fileSlice.getBaseFile().get().getFileSize() + this.convertLogFilesSizeToExpectedParquetSize(fileSlice.getLogFiles().collect(Collectors.toList()));
    }

    private boolean isSmallFile(FileSlice fileSlice) {
        long totalSize = this.getTotalFileSize(fileSlice);
        return totalSize < this.config.getParquetMaxFileSize();
    }

    public long convertLogFilesSizeToExpectedParquetSize(List<HoodieLogFile> hoodieLogFiles) {
        long totalSizeOfLogFiles = hoodieLogFiles.stream().map(HoodieLogFile::getFileSize).filter(size -> size > 0L).reduce(Long::sum).orElse(0L);
        return (long)((double)totalSizeOfLogFiles * this.config.getLogFileToParquetCompressionRatio());
    }
}

