/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.MarkerFiles;
import org.apache.hudi.table.upgrade.DowngradeHandler;

public class OneToZeroDowngradeHandler
implements DowngradeHandler {
    @Override
    public void downgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime) {
        HoodieSparkTable table = HoodieSparkTable.create(config, context);
        HoodieTimeline inflightTimeline = table.getMetaClient().getCommitsTimeline().filterPendingExcludingCompaction();
        List commits = inflightTimeline.getReverseOrderedInstants().collect(Collectors.toList());
        for (HoodieInstant commitInstant : commits) {
            MarkerFiles markerFiles = new MarkerFiles(table, commitInstant.getTimestamp());
            markerFiles.quietDeleteMarkerDir(context, config.getMarkersDeleteParallelism());
        }
    }
}

