/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.checkpointing;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.checkpointing.InitialCheckPointProvider;

public class InitialCheckpointFromAnotherHoodieTimelineProvider
extends InitialCheckPointProvider {
    private HoodieTableMetaClient anotherDsHoodieMetaclient;

    public InitialCheckpointFromAnotherHoodieTimelineProvider(TypedProperties props) {
        super(props);
    }

    @Override
    public void init(Configuration config) throws HoodieException {
        super.init(config);
        this.anotherDsHoodieMetaclient = new HoodieTableMetaClient(config, this.path.toString());
    }

    @Override
    public String getCheckpoint() throws HoodieException {
        return this.anotherDsHoodieMetaclient.getCommitsTimeline().filterCompletedInstants().getReverseOrderedInstants().map(instant -> {
            try {
                HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(this.anotherDsHoodieMetaclient.getActiveTimeline().getInstantDetails((HoodieInstant)instant).get(), HoodieCommitMetadata.class);
                return commitMetadata.getMetadata("deltastreamer.checkpoint.key");
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().get();
    }
}

