/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;

public class BootstrapExecutor
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(BootstrapExecutor.class);
    private final HoodieDeltaStreamer.Config cfg;
    private transient SchemaProvider schemaProvider;
    private transient JavaSparkContext jssc;
    private final TypedProperties props;
    private final Configuration configuration;
    private final HoodieWriteConfig bootstrapConfig;
    private transient FileSystem fs;
    private String bootstrapBasePath;

    public BootstrapExecutor(HoodieDeltaStreamer.Config cfg, JavaSparkContext jssc, FileSystem fs, Configuration conf, TypedProperties properties) throws IOException {
        this.cfg = cfg;
        this.jssc = jssc;
        this.fs = fs;
        this.configuration = conf;
        this.props = properties;
        ValidationUtils.checkArgument(properties.containsKey("hoodie.bootstrap.base.path"), "hoodie.bootstrap.base.path must be specified.");
        this.bootstrapBasePath = properties.getString("hoodie.bootstrap.base.path");
        this.props.putIfAbsent(DataSourceWriteOptions.PAYLOAD_CLASS_OPT_KEY(), DataSourceWriteOptions.DEFAULT_PAYLOAD_OPT_VAL());
        this.schemaProvider = UtilHelpers.createSchemaProvider(cfg.schemaProviderClassName, this.props, jssc);
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath(cfg.targetBasePath).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(false).build()).forTable(cfg.targetTableName).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withAutoCommit(true).withProps(this.props);
        if (null != this.schemaProvider && null != this.schemaProvider.getTargetSchema()) {
            builder = builder.withSchema(this.schemaProvider.getTargetSchema().toString());
        }
        this.bootstrapConfig = builder.build();
        LOG.info((Object)("Created bootstrap executor with configs : " + this.bootstrapConfig.getProps()));
    }

    public void execute() throws IOException {
        this.initializeTable();
        try (SparkRDDWriteClient bootstrapClient = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(this.jssc), this.bootstrapConfig, true);){
            HashMap<String, String> checkpointCommitMetadata = new HashMap<String, String>();
            checkpointCommitMetadata.put("deltastreamer.checkpoint.key", this.cfg.checkpoint);
            if (this.cfg.checkpoint != null) {
                checkpointCommitMetadata.put("deltastreamer.checkpoint.reset_key", this.cfg.checkpoint);
            }
            bootstrapClient.bootstrap(Option.of(checkpointCommitMetadata));
            this.syncHive();
        }
    }

    private void syncHive() {
        if (this.cfg.enableHiveSync.booleanValue()) {
            HiveSyncConfig hiveSyncConfig = DataSourceUtils.buildHiveSyncConfig(this.props, this.cfg.targetBasePath, this.cfg.baseFileFormat);
            LOG.info((Object)("Syncing target hoodie table with hive table(" + hiveSyncConfig.tableName + "). Hive metastore URL :" + hiveSyncConfig.jdbcUrl + ", basePath :" + this.cfg.targetBasePath));
            new HiveSyncTool(hiveSyncConfig, new HiveConf(this.configuration, HiveConf.class), this.fs).syncHoodieTable();
        }
    }

    private void initializeTable() throws IOException {
        if (this.fs.exists(new Path(this.cfg.targetBasePath))) {
            throw new HoodieException("target base path already exists at " + this.cfg.targetBasePath + ". Cannot bootstrap data on top of an existing table");
        }
        HoodieTableMetaClient.initTableTypeWithBootstrap(new Configuration(this.jssc.hadoopConfiguration()), this.cfg.targetBasePath, HoodieTableType.valueOf(this.cfg.tableType), this.cfg.targetTableName, "archived", this.cfg.payloadClassName, this.cfg.baseFileFormat, this.cfg.bootstrapIndexClass, this.bootstrapBasePath);
    }

    public HoodieWriteConfig getBootstrapConfig() {
        return this.bootstrapConfig;
    }
}

