/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.async.AsyncCompactService;
import org.apache.hudi.async.HoodieAsyncService;
import org.apache.hudi.async.SparkAsyncCompactService;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.com.beust.jcommander.IStringConverter;
import org.apache.hudi.com.beust.jcommander.JCommander;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.com.beust.jcommander.ParameterException;
import org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.utilities.IdentitySplitter;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.checkpointing.InitialCheckPointProvider;
import org.apache.hudi.utilities.deltastreamer.BootstrapExecutor;
import org.apache.hudi.utilities.deltastreamer.DeltaSync;
import org.apache.hudi.utilities.deltastreamer.SchedulerConfGenerator;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.JsonDFSSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;

public class HoodieDeltaStreamer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(HoodieDeltaStreamer.class);
    public static final String CHECKPOINT_KEY = "deltastreamer.checkpoint.key";
    public static final String CHECKPOINT_RESET_KEY = "deltastreamer.checkpoint.reset_key";
    protected final transient Config cfg;
    private final TypedProperties properties;
    protected transient Option<DeltaSyncService> deltaSyncService;
    private final Option<BootstrapExecutor> bootstrapExecutor;
    public static final String DELTASYNC_POOL_NAME = "hoodiedeltasync";

    public HoodieDeltaStreamer(Config cfg, JavaSparkContext jssc) throws IOException {
        this(cfg, jssc, FSUtils.getFs(cfg.targetBasePath, jssc.hadoopConfiguration()), jssc.hadoopConfiguration(), Option.empty());
    }

    public HoodieDeltaStreamer(Config cfg, JavaSparkContext jssc, Option<TypedProperties> props) throws IOException {
        this(cfg, jssc, FSUtils.getFs(cfg.targetBasePath, jssc.hadoopConfiguration()), jssc.hadoopConfiguration(), props);
    }

    public HoodieDeltaStreamer(Config cfg, JavaSparkContext jssc, FileSystem fs, Configuration conf) throws IOException {
        this(cfg, jssc, fs, conf, Option.empty());
    }

    public HoodieDeltaStreamer(Config cfg, JavaSparkContext jssc, FileSystem fs, Configuration conf, Option<TypedProperties> props) throws IOException {
        this.properties = props.isPresent() ? props.get() : (cfg.propsFilePath.equals(Config.DEFAULT_DFS_SOURCE_PROPERTIES) ? UtilHelpers.getConfig(cfg.configs).getConfig() : UtilHelpers.readConfig(FSUtils.getFs(cfg.propsFilePath, jssc.hadoopConfiguration()), new Path(cfg.propsFilePath), cfg.configs).getConfig());
        if (cfg.initialCheckpointProvider != null && cfg.checkpoint == null) {
            InitialCheckPointProvider checkPointProvider = UtilHelpers.createInitialCheckpointProvider(cfg.initialCheckpointProvider, this.properties);
            checkPointProvider.init(conf);
            cfg.checkpoint = checkPointProvider.getCheckpoint();
        }
        this.cfg = cfg;
        this.bootstrapExecutor = Option.ofNullable(cfg.runBootstrap != false ? new BootstrapExecutor(cfg, jssc, fs, conf, this.properties) : null);
        this.deltaSyncService = Option.ofNullable(cfg.runBootstrap != false ? null : new DeltaSyncService(cfg, jssc, fs, conf, Option.ofNullable(this.properties)));
    }

    public void shutdownGracefully() {
        this.deltaSyncService.ifPresent(ds -> ds.shutdown(false));
    }

    public void sync() throws Exception {
        if (this.bootstrapExecutor.isPresent()) {
            LOG.info((Object)("Performing bootstrap. Source=" + this.bootstrapExecutor.get().getBootstrapConfig().getBootstrapSourceBasePath()));
            this.bootstrapExecutor.get().execute();
        } else if (this.cfg.continuousMode.booleanValue()) {
            this.deltaSyncService.ifPresent(ds -> {
                ds.start(this::onDeltaSyncShutdown);
                try {
                    ds.waitForShutdown();
                }
                catch (Exception e) {
                    throw new HoodieException(e.getMessage(), e);
                }
            });
            LOG.info((Object)"Delta Sync shutting down");
        } else {
            LOG.info((Object)"Delta Streamer running only single round");
            try {
                this.deltaSyncService.ifPresent(ds -> {
                    try {
                        ds.getDeltaSync().syncOnce();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException(e.getMessage(), e);
                    }
                });
            }
            catch (Exception ex) {
                LOG.error((Object)"Got error running delta sync once. Shutting down", (Throwable)ex);
                throw ex;
            }
            finally {
                this.deltaSyncService.ifPresent(DeltaSyncService::close);
                LOG.info((Object)"Shut down delta streamer");
            }
        }
    }

    public Config getConfig() {
        return this.cfg;
    }

    private boolean onDeltaSyncShutdown(boolean error) {
        LOG.info((Object)("DeltaSync shutdown. Closing write client. Error?" + error));
        this.deltaSyncService.ifPresent(DeltaSyncService::close);
        return true;
    }

    public static final Config getConfig(String[] args) {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config cfg = HoodieDeltaStreamer.getConfig(args);
        Map<String, String> additionalSparkConfigs = SchedulerConfGenerator.getSparkSchedulingConfigs(cfg);
        JavaSparkContext jssc = UtilHelpers.buildSparkContext("delta-streamer-" + cfg.targetTableName, cfg.sparkMaster, additionalSparkConfigs);
        if (cfg.enableHiveSync.booleanValue()) {
            LOG.warn((Object)"--enable-hive-sync will be deprecated in a future release; please use --enable-sync instead for Hive syncing");
        }
        try {
            new HoodieDeltaStreamer(cfg, jssc).sync();
        }
        finally {
            jssc.stop();
        }
    }

    public DeltaSyncService getDeltaSyncService() {
        return this.deltaSyncService.get();
    }

    public static class DeltaSyncService
    extends HoodieAsyncService {
        private static final long serialVersionUID = 1L;
        private final Config cfg;
        private transient SchemaProvider schemaProvider;
        private transient SparkSession sparkSession;
        private transient JavaSparkContext jssc;
        TypedProperties props;
        private Option<AsyncCompactService> asyncCompactService;
        private final HoodieTableType tableType;
        private transient DeltaSync deltaSync;

        public DeltaSyncService(Config cfg, JavaSparkContext jssc, FileSystem fs, Configuration conf, Option<TypedProperties> properties) throws IOException {
            this.cfg = cfg;
            this.jssc = jssc;
            this.sparkSession = SparkSession.builder().config(jssc.getConf()).getOrCreate();
            this.asyncCompactService = Option.empty();
            if (fs.exists(new Path(cfg.targetBasePath))) {
                HoodieTableMetaClient meta = new HoodieTableMetaClient(new Configuration(fs.getConf()), cfg.targetBasePath, false);
                this.tableType = meta.getTableType();
                ValidationUtils.checkArgument(this.tableType.equals((Object)HoodieTableType.valueOf(cfg.tableType)), "Hoodie table is of type " + (Object)((Object)this.tableType) + " but passed in CLI argument is " + cfg.tableType);
                String baseFileFormat = meta.getTableConfig().getBaseFileFormat().toString();
                ValidationUtils.checkArgument(baseFileFormat.equals(cfg.baseFileFormat) || cfg.baseFileFormat == null, "Hoodie table's base file format is of type " + baseFileFormat + " but passed in CLI argument is " + cfg.baseFileFormat);
                this.cfg.baseFileFormat = cfg.baseFileFormat = meta.getTableConfig().getBaseFileFormat().toString();
            } else {
                this.tableType = HoodieTableType.valueOf(cfg.tableType);
                if (cfg.baseFileFormat == null) {
                    cfg.baseFileFormat = "PARQUET";
                }
            }
            ValidationUtils.checkArgument(cfg.filterDupes == false || cfg.operation != WriteOperationType.UPSERT, "'--filter-dupes' needs to be disabled when '--op' is 'UPSERT' to ensure updates are not missed.");
            this.props = properties.get();
            LOG.info((Object)("Creating delta streamer with configs : " + this.props.toString()));
            this.schemaProvider = UtilHelpers.wrapSchemaProviderWithPostProcessor(UtilHelpers.createSchemaProvider(cfg.schemaProviderClassName, this.props, jssc), this.props, jssc, cfg.transformerClassNames);
            this.deltaSync = new DeltaSync(cfg, this.sparkSession, this.schemaProvider, this.props, jssc, fs, conf, this::onInitializingWriteClient);
        }

        public DeltaSyncService(Config cfg, JavaSparkContext jssc, FileSystem fs, Configuration conf) throws IOException {
            this(cfg, jssc, fs, conf, Option.empty());
        }

        public DeltaSync getDeltaSync() {
            return this.deltaSync;
        }

        @Override
        protected Pair<CompletableFuture, ExecutorService> startService() {
            ExecutorService executor = Executors.newFixedThreadPool(1);
            return Pair.of(CompletableFuture.supplyAsync(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }, executor), executor);
        }

        private void shutdownCompactor(boolean error) {
            LOG.info((Object)("Delta Sync shutdown. Error ?" + error));
            if (this.asyncCompactService.isPresent()) {
                LOG.warn((Object)"Gracefully shutting down compactor");
                this.asyncCompactService.get().shutdown(false);
            }
        }

        protected Boolean onInitializingWriteClient(SparkRDDWriteClient writeClient) {
            if (this.cfg.isAsyncCompactionEnabled()) {
                if (this.asyncCompactService.isPresent()) {
                    this.asyncCompactService.get().updateWriteClient(writeClient);
                } else {
                    this.asyncCompactService = Option.ofNullable(new SparkAsyncCompactService(new HoodieSparkEngineContext(this.jssc), writeClient));
                    HoodieTableMetaClient meta = new HoodieTableMetaClient(new Configuration(this.jssc.hadoopConfiguration()), this.cfg.targetBasePath, true);
                    List<HoodieInstant> pending = CompactionUtils.getPendingCompactionInstantTimes(meta);
                    pending.forEach(hoodieInstant -> this.asyncCompactService.get().enqueuePendingCompaction((HoodieInstant)hoodieInstant));
                    this.asyncCompactService.get().start(error -> {
                        this.shutdown(false);
                        return true;
                    });
                    try {
                        this.asyncCompactService.get().waitTillPendingCompactionsReducesTo(this.cfg.maxPendingCompactions);
                    }
                    catch (InterruptedException ie) {
                        throw new HoodieException(ie);
                    }
                }
            }
            return true;
        }

        public void close() {
            if (null != this.deltaSync) {
                this.deltaSync.close();
            }
        }

        public SchemaProvider getSchemaProvider() {
            return this.schemaProvider;
        }

        public SparkSession getSparkSession() {
            return this.sparkSession;
        }

        public TypedProperties getProps() {
            return this.props;
        }
    }

    public static class Config
    implements Serializable {
        public static final String DEFAULT_DFS_SOURCE_PROPERTIES = "file://" + System.getProperty("user.dir") + "/src/test/resources/delta-streamer-config/dfs-source.properties";
        @Parameter(names={"--target-base-path"}, description="base path for the target hoodie table. (Will be created if did not exist first time around. If exists, expected to be a hoodie table)", required=true)
        public String targetBasePath;
        @Parameter(names={"--target-table"}, description="name of the target table", required=true)
        public String targetTableName;
        @Parameter(names={"--table-type"}, description="Type of table. COPY_ON_WRITE (or) MERGE_ON_READ", required=true)
        public String tableType;
        @Parameter(names={"--base-file-format"}, description="File format for the base files. PARQUET (or) HFILE", required=false)
        public String baseFileFormat = "PARQUET";
        @Parameter(names={"--props"}, description="path to properties file on localfs or dfs, with configurations for hoodie client, schema provider, key generator and data source. For hoodie client props, sane defaults are used, but recommend use to provide basic things like metrics endpoints, hive configs etc. For sources, referto individual classes, for supported properties. Properties in this file can be overridden by \"--hoodie-conf\"")
        public String propsFilePath = DEFAULT_DFS_SOURCE_PROPERTIES;
        @Parameter(names={"--hoodie-conf"}, description="Any configuration that can be set in the properties file (using the CLI parameter \"--props\") can also be passed command line using this parameter. This can be repeated", splitter=IdentitySplitter.class)
        public List<String> configs = new ArrayList<String>();
        @Parameter(names={"--source-class"}, description="Subclass of org.apache.hudi.utilities.sources to read data. Built-in options: org.apache.hudi.utilities.sources.{JsonDFSSource (default), AvroDFSSource, JsonKafkaSource, AvroKafkaSource, HiveIncrPullSource}")
        public String sourceClassName = JsonDFSSource.class.getName();
        @Parameter(names={"--source-ordering-field"}, description="Field within source record to decide how to break ties between records with same key in input data. Default: 'ts' holding unix timestamp of record")
        public String sourceOrderingField = "ts";
        @Parameter(names={"--payload-class"}, description="subclass of HoodieRecordPayload, that works off a GenericRecord. Implement your own, if you want to do something other than overwriting existing value")
        public String payloadClassName = OverwriteWithLatestAvroPayload.class.getName();
        @Parameter(names={"--schemaprovider-class"}, description="subclass of org.apache.hudi.utilities.schema.SchemaProvider to attach schemas to input & target table data, built in options: org.apache.hudi.utilities.schema.FilebasedSchemaProvider.Source (See org.apache.hudi.utilities.sources.Source) implementation can implement their own SchemaProvider. For Sources that return Dataset<Row>, the schema is obtained implicitly. However, this CLI option allows overriding the schemaprovider returned by Source.")
        public String schemaProviderClassName = null;
        @Parameter(names={"--transformer-class"}, description="A subclass or a list of subclasses of org.apache.hudi.utilities.transform.Transformer. Allows transforming raw source Dataset to a target Dataset (conforming to target schema) before writing. Default : Not set. E:g - org.apache.hudi.utilities.transform.SqlQueryBasedTransformer (which allows a SQL query templated to be passed as a transformation function). Pass a comma-separated list of subclass names to chain the transformations.")
        public List<String> transformerClassNames = null;
        @Parameter(names={"--source-limit"}, description="Maximum amount of data to read from source. Default: No limit, e.g: DFS-Source => max bytes to read, Kafka-Source => max events to read")
        public long sourceLimit = Long.MAX_VALUE;
        @Parameter(names={"--op"}, description="Takes one of these values : UPSERT (default), INSERT (use when input is purely new data/inserts to gain speed)", converter=OperationConverter.class)
        public WriteOperationType operation = WriteOperationType.UPSERT;
        @Parameter(names={"--filter-dupes"}, description="Should duplicate records from source be dropped/filtered out before insert/bulk-insert")
        public Boolean filterDupes = false;
        @Parameter(names={"--enable-hive-sync"}, description="Enable syncing to hive")
        public Boolean enableHiveSync = false;
        @Parameter(names={"--enable-sync"}, description="Enable syncing meta")
        public Boolean enableMetaSync = false;
        @Parameter(names={"--sync-tool-classes"}, description="Meta sync client tool, using comma to separate multi tools")
        public String syncClientToolClass = HiveSyncTool.class.getName();
        @Parameter(names={"--max-pending-compactions"}, description="Maximum number of outstanding inflight/requested compactions. Delta Sync will not happen unlessoutstanding compactions is less than this number")
        public Integer maxPendingCompactions = 5;
        @Parameter(names={"--continuous"}, description="Delta Streamer runs in continuous mode running source-fetch -> Transform -> Hudi Write in loop")
        public Boolean continuousMode = false;
        @Parameter(names={"--min-sync-interval-seconds"}, description="the min sync interval of each sync in continuous mode")
        public Integer minSyncIntervalSeconds = 0;
        @Parameter(names={"--spark-master"}, description="spark master to use.")
        public String sparkMaster = "local[2]";
        @Parameter(names={"--commit-on-errors"}, description="Commit even when some records failed to be written")
        public Boolean commitOnErrors = false;
        @Parameter(names={"--delta-sync-scheduling-weight"}, description="Scheduling weight for delta sync as defined in https://spark.apache.org/docs/latest/job-scheduling.html")
        public Integer deltaSyncSchedulingWeight = 1;
        @Parameter(names={"--compact-scheduling-weight"}, description="Scheduling weight for compaction as defined in https://spark.apache.org/docs/latest/job-scheduling.html")
        public Integer compactSchedulingWeight = 1;
        @Parameter(names={"--delta-sync-scheduling-minshare"}, description="Minshare for delta sync as defined in https://spark.apache.org/docs/latest/job-scheduling.html")
        public Integer deltaSyncSchedulingMinShare = 0;
        @Parameter(names={"--compact-scheduling-minshare"}, description="Minshare for compaction as defined in https://spark.apache.org/docs/latest/job-scheduling.html")
        public Integer compactSchedulingMinShare = 0;
        @Parameter(names={"--disable-compaction"}, description="Compaction is enabled for MoR table by default. This flag disables it ")
        public Boolean forceDisableCompaction = false;
        @Parameter(names={"--checkpoint"}, description="Resume Delta Streamer from this checkpoint.")
        public String checkpoint = null;
        @Parameter(names={"--initial-checkpoint-provider"}, description="subclass of org.apache.hudi.utilities.checkpointing.InitialCheckpointProvider. Generate check point for delta streamer for the first run. This field will override the checkpoint of last commit using the checkpoint field. Use this field only when switching source, for example, from DFS source to Kafka Source.")
        public String initialCheckpointProvider = null;
        @Parameter(names={"--run-bootstrap"}, description="Run bootstrap if bootstrap index is not found")
        public Boolean runBootstrap = false;
        @Parameter(names={"--bootstrap-index-class"}, description="subclass of BootstrapIndex")
        public String bootstrapIndexClass = HFileBootstrapIndex.class.getName();
        @Parameter(names={"--help", "-h"}, help=true)
        public Boolean help = false;

        public boolean isAsyncCompactionEnabled() {
            return this.continuousMode != false && this.forceDisableCompaction == false && HoodieTableType.MERGE_ON_READ.equals((Object)HoodieTableType.valueOf(this.tableType));
        }

        public boolean isInlineCompactionEnabled() {
            return this.continuousMode == false && this.forceDisableCompaction == false && HoodieTableType.MERGE_ON_READ.equals((Object)HoodieTableType.valueOf(this.tableType));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Config config = (Config)o;
            return this.sourceLimit == config.sourceLimit && Objects.equals(this.targetBasePath, config.targetBasePath) && Objects.equals(this.targetTableName, config.targetTableName) && Objects.equals(this.tableType, config.tableType) && Objects.equals(this.baseFileFormat, config.baseFileFormat) && Objects.equals(this.propsFilePath, config.propsFilePath) && Objects.equals(this.configs, config.configs) && Objects.equals(this.sourceClassName, config.sourceClassName) && Objects.equals(this.sourceOrderingField, config.sourceOrderingField) && Objects.equals(this.payloadClassName, config.payloadClassName) && Objects.equals(this.schemaProviderClassName, config.schemaProviderClassName) && Objects.equals(this.transformerClassNames, config.transformerClassNames) && this.operation == config.operation && Objects.equals(this.filterDupes, config.filterDupes) && Objects.equals(this.enableHiveSync, config.enableHiveSync) && Objects.equals(this.maxPendingCompactions, config.maxPendingCompactions) && Objects.equals(this.continuousMode, config.continuousMode) && Objects.equals(this.minSyncIntervalSeconds, config.minSyncIntervalSeconds) && Objects.equals(this.sparkMaster, config.sparkMaster) && Objects.equals(this.commitOnErrors, config.commitOnErrors) && Objects.equals(this.deltaSyncSchedulingWeight, config.deltaSyncSchedulingWeight) && Objects.equals(this.compactSchedulingWeight, config.compactSchedulingWeight) && Objects.equals(this.deltaSyncSchedulingMinShare, config.deltaSyncSchedulingMinShare) && Objects.equals(this.compactSchedulingMinShare, config.compactSchedulingMinShare) && Objects.equals(this.forceDisableCompaction, config.forceDisableCompaction) && Objects.equals(this.checkpoint, config.checkpoint) && Objects.equals(this.initialCheckpointProvider, config.initialCheckpointProvider) && Objects.equals(this.help, config.help);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.targetBasePath, this.targetTableName, this.tableType, this.baseFileFormat, this.propsFilePath, this.configs, this.sourceClassName, this.sourceOrderingField, this.payloadClassName, this.schemaProviderClassName, this.transformerClassNames, this.sourceLimit, this.operation, this.filterDupes, this.enableHiveSync, this.maxPendingCompactions, this.continuousMode, this.minSyncIntervalSeconds, this.sparkMaster, this.commitOnErrors, this.deltaSyncSchedulingWeight, this.compactSchedulingWeight, this.deltaSyncSchedulingMinShare, this.compactSchedulingMinShare, this.forceDisableCompaction, this.checkpoint, this.initialCheckpointProvider, this.help});
        }

        public String toString() {
            return "Config{targetBasePath='" + this.targetBasePath + '\'' + ", targetTableName='" + this.targetTableName + '\'' + ", tableType='" + this.tableType + '\'' + ", baseFileFormat='" + this.baseFileFormat + '\'' + ", propsFilePath='" + this.propsFilePath + '\'' + ", configs=" + this.configs + ", sourceClassName='" + this.sourceClassName + '\'' + ", sourceOrderingField='" + this.sourceOrderingField + '\'' + ", payloadClassName='" + this.payloadClassName + '\'' + ", schemaProviderClassName='" + this.schemaProviderClassName + '\'' + ", transformerClassNames=" + this.transformerClassNames + ", sourceLimit=" + this.sourceLimit + ", operation=" + (Object)((Object)this.operation) + ", filterDupes=" + this.filterDupes + ", enableHiveSync=" + this.enableHiveSync + ", maxPendingCompactions=" + this.maxPendingCompactions + ", continuousMode=" + this.continuousMode + ", minSyncIntervalSeconds=" + this.minSyncIntervalSeconds + ", sparkMaster='" + this.sparkMaster + '\'' + ", commitOnErrors=" + this.commitOnErrors + ", deltaSyncSchedulingWeight=" + this.deltaSyncSchedulingWeight + ", compactSchedulingWeight=" + this.compactSchedulingWeight + ", deltaSyncSchedulingMinShare=" + this.deltaSyncSchedulingMinShare + ", compactSchedulingMinShare=" + this.compactSchedulingMinShare + ", forceDisableCompaction=" + this.forceDisableCompaction + ", checkpoint='" + this.checkpoint + '\'' + ", initialCheckpointProvider='" + this.initialCheckpointProvider + '\'' + ", help=" + this.help + '}';
        }
    }

    protected static class OperationConverter
    implements IStringConverter<WriteOperationType> {
        protected OperationConverter() {
        }

        @Override
        public WriteOperationType convert(String value) throws ParameterException {
            return WriteOperationType.valueOf(value);
        }
    }
}

