/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class HoodieMergeOnReadRDD$
implements scala.Serializable {
    public static HoodieMergeOnReadRDD$ MODULE$;
    private final Object CONFIG_INSTANTIATION_LOCK;

    static {
        new HoodieMergeOnReadRDD$();
    }

    public Object CONFIG_INSTANTIATION_LOCK() {
        return this.CONFIG_INSTANTIATION_LOCK;
    }

    public HoodieMergedLogRecordScanner scanLog(List<HoodieLogFile> logFiles, Path partitionPath, Schema logSchema, HoodieTableState tableState, long maxCompactionMemoryInBytes, Configuration hadoopConf, InternalSchema internalSchema) {
        HoodieMergedLogRecordScanner hoodieMergedLogRecordScanner;
        String tablePath = tableState.tablePath();
        FileSystem fs = FSUtils.getFs(tablePath, hadoopConf);
        if (HoodieTableMetadata.isMetadataTable(tablePath)) {
            HoodieMetadataConfig metadataConfig = tableState.metadataConfig();
            String dataTableBasePath = HoodieTableMetadata.getDataTableBasePathFromMetadataTable(tablePath);
            HoodieBackedTableMetadata metadataTable = new HoodieBackedTableMetadata(new HoodieLocalEngineContext(hadoopConf), metadataConfig, dataTableBasePath, hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/"));
            boolean forceFullScan = true;
            String relativePartitionPath = FSUtils.getRelativePartitionPath(new Path(tablePath), partitionPath);
            hoodieMergedLogRecordScanner = metadataTable.getLogRecordScanner((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(logFiles).asJava(), relativePartitionPath, HoodieConversionUtils$.MODULE$.toJavaOption(new Some((Object)Predef$.MODULE$.boolean2Boolean(forceFullScan)))).getLeft();
        } else {
            HoodieMergedLogRecordScanner.Builder logRecordScannerBuilder = ((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withFileSystem(fs).withBasePath(tablePath).withLogFilePaths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)logFiles.map((Function1 & Serializable & scala.Serializable)logFile -> logFile.getPath().toString(), List$.MODULE$.canBuildFrom())).asJava())).withReaderSchema(logSchema).withLatestInstantTime(tableState.latestCommitTimestamp()).withReadBlocksLazily(BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(hadoopConf.get("compaction.lazy.block.read.enabled", "true"))).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))).withReverseReader(false).withInternalSchema(internalSchema).withBufferSize(hadoopConf.getInt("hoodie.memory.dfs.buffer.max.size", 0x100000)).withMaxMemorySizeInBytes(Predef$.MODULE$.long2Long(maxCompactionMemoryInBytes)).withSpillableMapBasePath(hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/"));
            Object object = logFiles.nonEmpty() ? logRecordScannerBuilder.withPartition(FSUtils.getRelativePartitionPath(new Path(tableState.tablePath()), ((HoodieLogFile)logFiles.head()).getPath().getParent())) : BoxedUnit.UNIT;
            hoodieMergedLogRecordScanner = logRecordScannerBuilder.build();
        }
        return hoodieMergedLogRecordScanner;
    }

    public InternalSchema scanLog$default$7() {
        return InternalSchema.getEmptyInternalSchema();
    }

    public InternalRow org$apache$hudi$HoodieMergeOnReadRDD$$projectRowUnsafe(InternalRow row, StructType projectedSchema, Seq<Object> ordinals) {
        SpecificInternalRow projectedRow = new SpecificInternalRow(projectedSchema);
        IntRef curIndex = IntRef.create((int)0);
        ((IterableLike)projectedSchema.zip(ordinals, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HoodieMergeOnReadRDD$.$anonfun$projectRowUnsafe$1(row, projectedRow, curIndex, x0$1);
            return BoxedUnit.UNIT;
        });
        return projectedRow;
    }

    public GenericRecord projectAvroUnsafe(IndexedRecord record, Schema projectedSchema, List<Object> ordinals, GenericRecordBuilder recordBuilder) {
        Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(projectedSchema.getFields()).asScala();
        ValidationUtils.checkState(fields.length() == ordinals.length());
        ((IterableLike)fields.zip(ordinals, Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Schema.Field field = (Schema.Field)tuple2._1();
            int pos = tuple2._2$mcI$sp();
            GenericRecordBuilder genericRecordBuilder = recordBuilder.set(field, record.get(pos));
            return genericRecordBuilder;
        });
        return recordBuilder.build();
    }

    public GenericRecord projectAvro(IndexedRecord record, Schema projectedSchema, GenericRecordBuilder recordBuilder) {
        return this.projectAvroUnsafe(record, projectedSchema, this.org$apache$hudi$HoodieMergeOnReadRDD$$collectFieldOrdinals(projectedSchema, record.getSchema()), recordBuilder);
    }

    public List<Object> org$apache$hudi$HoodieMergeOnReadRDD$$collectFieldOrdinals(Schema projected, Schema source) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(projected.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)HoodieMergeOnReadRDD$.$anonfun$collectFieldOrdinals$1(source, f)), Buffer$.MODULE$.canBuildFrom())).toList();
    }

    public Path org$apache$hudi$HoodieMergeOnReadRDD$$getPartitionPath(HoodieMergeOnReadFileSplit split) {
        return ((Path)split.dataFile().map((Function1 & Serializable & scala.Serializable)baseFile -> new Path(baseFile.filePath())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ((HoodieLogFile)split.logFiles().head()).getPath())).getParent();
    }

    public boolean org$apache$hudi$HoodieMergeOnReadRDD$$resolveAvroSchemaNullability(Schema schema) {
        boolean nullable;
        Tuple2<Object, Schema> tuple2 = AvroConversionUtils$.MODULE$.resolveAvroTypeNullability(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean bl = nullable = tuple2._1$mcZ$sp();
        return bl;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$projectRowUnsafe$1(InternalRow row$1, SpecificInternalRow projectedRow$1, IntRef curIndex$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int pos = tuple2._2$mcI$sp();
            Object curField = row$1.isNullAt(pos) ? null : row$1.get(pos, field.dataType());
            projectedRow$1.update(curIndex$1.elem, curField);
            ++curIndex$1.elem;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$collectFieldOrdinals$1(Schema source$1, Schema.Field f) {
        return source$1.getField(f.name()).pos();
    }

    private HoodieMergeOnReadRDD$() {
        MODULE$ = this;
        this.CONFIG_INSTANTIATION_LOCK = new Object();
    }
}

