/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.async;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.IntStream;
import org.apache.hudi.async.HoodieAsyncTableService;
import org.apache.hudi.client.BaseClusterer;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AsyncClusteringService
extends HoodieAsyncTableService {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(AsyncClusteringService.class);
    public static final String CLUSTERING_POOL_NAME = "hoodiecluster";
    private final int maxConcurrentClustering;
    private transient BaseClusterer clusteringClient;
    protected transient HoodieEngineContext context;

    public AsyncClusteringService(HoodieEngineContext context, BaseHoodieWriteClient writeClient) {
        this(context, writeClient, false);
    }

    public AsyncClusteringService(HoodieEngineContext context, BaseHoodieWriteClient writeClient, boolean runInDaemonMode) {
        super(writeClient.getConfig(), runInDaemonMode);
        this.clusteringClient = this.createClusteringClient(writeClient);
        this.maxConcurrentClustering = 1;
        this.context = context;
    }

    protected abstract BaseClusterer createClusteringClient(BaseHoodieWriteClient var1);

    @Override
    protected Pair<CompletableFuture, ExecutorService> startService() {
        ExecutorService executor = Executors.newFixedThreadPool(this.maxConcurrentClustering, r -> {
            Thread t = new Thread(r, "async_clustering_thread");
            t.setDaemon(this.isRunInDaemonMode());
            return t;
        });
        return Pair.of(CompletableFuture.allOf((CompletableFuture[])IntStream.range(0, this.maxConcurrentClustering).mapToObj(i -> CompletableFuture.supplyAsync(() -> {
            try {
                LOG.info((Object)"Setting pool name for clustering to hoodiecluster");
                this.context.setProperty(EngineProperty.CLUSTERING_POOL_NAME, CLUSTERING_POOL_NAME);
                while (!this.isShutdownRequested()) {
                    HoodieInstant instant = this.fetchNextAsyncServiceInstant();
                    if (null == instant) continue;
                    LOG.info((Object)("Starting clustering for instant " + instant));
                    this.clusteringClient.cluster(instant);
                    LOG.info((Object)("Finished clustering for instant " + instant));
                }
                LOG.info((Object)"Clustering executor shutting down properly");
            }
            catch (InterruptedException ie) {
                this.hasError = true;
                LOG.warn((Object)"Clustering executor got interrupted exception! Stopping", (Throwable)ie);
            }
            catch (IOException e) {
                this.hasError = true;
                LOG.error((Object)"Clustering executor failed due to IOException", (Throwable)e);
                throw new HoodieIOException(e.getMessage(), e);
            }
            catch (Exception e) {
                this.hasError = true;
                LOG.error((Object)"Clustering executor failed", (Throwable)e);
                throw e;
            }
            return true;
        }, executor)).toArray(CompletableFuture[]::new)), executor);
    }

    public synchronized void updateWriteClient(BaseHoodieWriteClient writeClient) {
        this.clusteringClient.updateWriteClient(writeClient);
    }
}

