/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.transaction.lock;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.dynamodbv2.AcquireLockOptions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClientOptions;
import com.amazonaws.services.dynamodbv2.LockItem;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LockNotGrantedException;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.util.TableUtils;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.aws.credentials.HoodieAWSCredentialsProviderFactory;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.lock.LockState;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.DynamoDbBasedLockConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@NotThreadSafe
public class DynamoDBBasedLockProvider
implements LockProvider<LockItem> {
    private static final Logger LOG = LogManager.getLogger(DynamoDBBasedLockProvider.class);
    private static final String DYNAMODB_ATTRIBUTE_NAME = "key";
    private final AmazonDynamoDBLockClient client;
    private final String tableName;
    private final String dynamoDBPartitionKey;
    protected LockConfiguration lockConfiguration;
    private volatile LockItem lock;

    public DynamoDBBasedLockProvider(LockConfiguration lockConfiguration, Configuration conf) {
        this(lockConfiguration, conf, null);
    }

    public DynamoDBBasedLockProvider(LockConfiguration lockConfiguration, Configuration conf, AmazonDynamoDB dynamoDB) {
        this.checkRequiredProps(lockConfiguration);
        this.lockConfiguration = lockConfiguration;
        this.tableName = lockConfiguration.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME.key());
        this.dynamoDBPartitionKey = lockConfiguration.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY.key());
        long leaseDuration = Long.parseLong(lockConfiguration.getConfig().getString("hoodie.write.lock.wait_time_ms"));
        if (dynamoDB == null) {
            dynamoDB = this.getDynamoDBClient();
        }
        this.client = new AmazonDynamoDBLockClient(AmazonDynamoDBLockClientOptions.builder((AmazonDynamoDB)dynamoDB, (String)this.tableName).withTimeUnit(TimeUnit.MILLISECONDS).withLeaseDuration(Long.valueOf(leaseDuration)).withHeartbeatPeriod(Long.valueOf(leaseDuration / 3L)).withCreateHeartbeatBackgroundThread(Boolean.valueOf(true)).build());
        if (!this.client.lockTableExists()) {
            this.createLockTableInDynamoDB(dynamoDB, this.tableName);
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        LOG.info((Object)this.generateLogStatement(LockState.ACQUIRING, this.generateLogSuffixString()));
        try {
            this.lock = this.client.acquireLock(AcquireLockOptions.builder((String)this.dynamoDBPartitionKey).withAdditionalTimeToWaitForLock(Long.valueOf(time)).withTimeUnit(TimeUnit.MILLISECONDS).build());
            LOG.info((Object)this.generateLogStatement(LockState.ACQUIRED, this.generateLogSuffixString()));
        }
        catch (InterruptedException e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE, this.generateLogSuffixString()), e);
        }
        catch (LockNotGrantedException e) {
            return false;
        }
        return this.lock != null && !this.lock.isExpired();
    }

    @Override
    public void unlock() {
        try {
            LOG.info((Object)this.generateLogStatement(LockState.RELEASING, this.generateLogSuffixString()));
            if (this.lock == null) {
                return;
            }
            if (!this.client.releaseLock(this.lock)) {
                LOG.warn((Object)"The lock has already been stolen");
            }
            this.lock = null;
            LOG.info((Object)this.generateLogStatement(LockState.RELEASED, this.generateLogSuffixString()));
        }
        catch (Exception e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()), e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.lock != null) {
                if (!this.client.releaseLock(this.lock)) {
                    LOG.warn((Object)"The lock has already been stolen");
                }
                this.lock = null;
            }
            this.client.close();
        }
        catch (Exception e) {
            LOG.error((Object)this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()));
        }
    }

    @Override
    public LockItem getLock() {
        return this.lock;
    }

    private AmazonDynamoDB getDynamoDBClient() {
        String region = this.lockConfiguration.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_REGION.key());
        String endpointURL = this.lockConfiguration.getConfig().containsKey(DynamoDbBasedLockConfig.DYNAMODB_ENDPOINT_URL.key()) ? this.lockConfiguration.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_ENDPOINT_URL.key()) : RegionUtils.getRegion((String)region).getServiceEndpoint("dynamodb");
        AwsClientBuilder.EndpointConfiguration dynamodbEndpoint = new AwsClientBuilder.EndpointConfiguration(endpointURL, region);
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(dynamodbEndpoint)).withCredentials(HoodieAWSCredentialsProviderFactory.getAwsCredentialsProvider(this.lockConfiguration.getConfig()))).build();
    }

    private void createLockTableInDynamoDB(AmazonDynamoDB dynamoDB, String tableName) {
        String billingMode = this.lockConfiguration.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_BILLING_MODE.key());
        KeySchemaElement partitionKeyElement = new KeySchemaElement();
        partitionKeyElement.setAttributeName(DYNAMODB_ATTRIBUTE_NAME);
        partitionKeyElement.setKeyType(KeyType.HASH);
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(partitionKeyElement);
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition().withAttributeName(DYNAMODB_ATTRIBUTE_NAME).withAttributeType(ScalarAttributeType.S));
        CreateTableRequest createTableRequest = new CreateTableRequest(tableName, keySchema);
        createTableRequest.setAttributeDefinitions(attributeDefinitions);
        createTableRequest.setBillingMode(billingMode);
        if (billingMode.equals(BillingMode.PROVISIONED.name())) {
            createTableRequest.setProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(Long.parseLong(this.lockConfiguration.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_READ_CAPACITY.key())))).withWriteCapacityUnits(Long.valueOf(Long.parseLong(this.lockConfiguration.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_WRITE_CAPACITY.key())))));
        }
        dynamoDB.createTable(createTableRequest);
        LOG.info((Object)("Creating dynamoDB table " + tableName + ", waiting for table to be active"));
        try {
            TableUtils.waitUntilActive((AmazonDynamoDB)dynamoDB, (String)tableName, (int)Integer.parseInt(this.lockConfiguration.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_CREATION_TIMEOUT.key())), (int)20000);
        }
        catch (TableUtils.TableNeverTransitionedToStateException e) {
            throw new HoodieLockException("Created dynamoDB table never transits to active", e);
        }
        catch (InterruptedException e) {
            throw new HoodieLockException("Thread interrupted while waiting for dynamoDB table to turn active", e);
        }
        LOG.info((Object)("Created dynamoDB table " + tableName));
    }

    private void checkRequiredProps(LockConfiguration config) {
        ValidationUtils.checkArgument(config.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME.key()) != null);
        ValidationUtils.checkArgument(config.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_REGION.key()) != null);
        ValidationUtils.checkArgument(config.getConfig().getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY.key()) != null);
        config.getConfig().putIfAbsent(DynamoDbBasedLockConfig.DYNAMODB_LOCK_BILLING_MODE.key(), BillingMode.PAY_PER_REQUEST.name());
        config.getConfig().putIfAbsent(DynamoDbBasedLockConfig.DYNAMODB_LOCK_READ_CAPACITY.key(), "20");
        config.getConfig().putIfAbsent(DynamoDbBasedLockConfig.DYNAMODB_LOCK_WRITE_CAPACITY.key(), "10");
        config.getConfig().putIfAbsent(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_CREATION_TIMEOUT.key(), "600000");
    }

    private String generateLogSuffixString() {
        return StringUtils.join("DynamoDb table = ", this.tableName, ", partition key = ", this.dynamoDBPartitionKey);
    }

    protected String generateLogStatement(LockState state, String suffix) {
        return StringUtils.join(state.name(), " lock at ", suffix);
    }
}

