/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metrics.DistributedRegistry;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.compact.CompactHelpers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngradeHelper;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

public class SparkRDDWriteClient<T extends HoodieRecordPayload>
extends BaseHoodieWriteClient<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(SparkRDDWriteClient.class);

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        this(context, clientConfig, Option.empty());
    }

    @Deprecated
    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending) {
        this(context, writeConfig, Option.empty());
    }

    @Deprecated
    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending, Option<EmbeddedTimelineService> timelineService) {
        this(context, writeConfig, timelineService);
    }

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, Option<EmbeddedTimelineService> timelineService) {
        super(context, writeConfig, timelineService, SparkUpgradeDowngradeHelper.getInstance());
    }

    public static SparkConf registerClasses(SparkConf conf) {
        conf.registerKryoClasses(new Class[]{HoodieWriteConfig.class, HoodieRecord.class, HoodieKey.class});
        return conf;
    }

    @Override
    protected HoodieIndex createIndex(HoodieWriteConfig writeConfig) {
        return SparkHoodieIndexFactory.createIndex(this.config);
    }

    @Override
    public boolean commit(String instantTime, JavaRDD<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Committing stats");
        List writeStats = writeStatuses.map(WriteStatus::getStat).collect();
        return this.commitStats(instantTime, writeStats, extraMetadata, commitActionType, partitionToReplacedFileIds);
    }

    @Override
    protected HoodieTable createTable(HoodieWriteConfig config, Configuration hadoopConf, boolean refreshTimeline) {
        return HoodieSparkTable.create(config, this.context, refreshTimeline);
    }

    @Override
    public JavaRDD<HoodieRecord<T>> filterExists(JavaRDD<HoodieRecord<T>> hoodieRecords) {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context);
        Timer.Context indexTimer = this.metrics.getIndexCtx();
        JavaRDD recordsWithLocation = HoodieJavaRDD.getJavaRDD(this.getIndex().tagLocation(HoodieJavaRDD.of(hoodieRecords), this.context, (HoodieTable)table));
        this.metrics.updateIndexMetrics("lookup", this.metrics.getDurationInMs(indexTimer == null ? 0L : indexTimer.stop()));
        return recordsWithLocation.filter((Function & Serializable)v1 -> !v1.isCurrentLocationKnown());
    }

    @Override
    public void bootstrap(Option<Map<String, String>> extraMetadata) {
        this.initTable(WriteOperationType.UPSERT, Option.ofNullable("00000000000001")).bootstrap(this.context, extraMetadata);
    }

    @Override
    public JavaRDD<WriteStatus> upsert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT, Option.ofNullable(instantTime));
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.upsert(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata<JavaRDD<WriteStatus>> resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics("lookup", result.getIndexLookupDuration().get().toMillis());
        }
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> upsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT_PREPPED, Option.ofNullable(instantTime));
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.upsertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords));
        HoodieWriteMetadata<JavaRDD<WriteStatus>> resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> insert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.insert(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata<JavaRDD<WriteStatus>> resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> insertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_PREPPED, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.insertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords));
        HoodieWriteMetadata<JavaRDD<WriteStatus>> resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    public HoodieWriteResult insertOverwrite(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_OVERWRITE, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_OVERWRITE, table.getMetaClient());
        HoodieWriteMetadata result = table.insertOverwrite(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata<JavaRDD<WriteStatus>> resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return new HoodieWriteResult(this.postWrite(resultRDD, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    public HoodieWriteResult insertOverwriteTable(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_OVERWRITE_TABLE, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_OVERWRITE_TABLE, table.getMetaClient());
        HoodieWriteMetadata result = table.insertOverwriteTable(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata<JavaRDD<WriteStatus>> resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return new HoodieWriteResult(this.postWrite(resultRDD, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        return this.bulkInsert(records, instantTime, Option.empty());
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsert(JavaRDD<HoodieRecord<T>> records, String instantTime, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
        HoodieTable table = this.initTable(WriteOperationType.BULK_INSERT, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.bulkInsert(this.context, instantTime, HoodieJavaRDD.of(records), userDefinedBulkInsertPartitioner);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        HoodieTable table = this.initTable(WriteOperationType.BULK_INSERT_PREPPED, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.bulkInsertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords), bulkInsertPartitioner);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> delete(JavaRDD<HoodieKey> keys2, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE, Option.ofNullable(instantTime));
        this.preWrite(instantTime, WriteOperationType.DELETE, table.getMetaClient());
        HoodieWriteMetadata result = table.delete(this.context, instantTime, HoodieJavaRDD.of(keys2));
        HoodieWriteMetadata<JavaRDD<WriteStatus>> resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    public HoodieWriteResult deletePartitions(List<String> partitions, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE_PARTITION, Option.ofNullable(instantTime));
        this.preWrite(instantTime, WriteOperationType.DELETE_PARTITION, table.getMetaClient());
        HoodieWriteMetadata result = table.deletePartitions(this.context, instantTime, partitions);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return new HoodieWriteResult(this.postWrite(resultRDD, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    @Override
    protected JavaRDD<WriteStatus> postWrite(HoodieWriteMetadata<JavaRDD<WriteStatus>> result, String instantTime, HoodieTable hoodieTable) {
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics(this.getOperationType().name(), result.getIndexUpdateDuration().get().toMillis());
        }
        if (result.isCommitted()) {
            if (result.getFinalizeDuration().isPresent()) {
                this.metrics.updateFinalizeWriteMetrics(result.getFinalizeDuration().get().toMillis(), result.getWriteStats().get().size());
            }
            this.postCommit(hoodieTable, result.getCommitMetadata().get(), instantTime, Option.empty(), true);
            this.emitCommitMetrics(instantTime, result.getCommitMetadata().get(), hoodieTable.getMetaClient().getCommitActionType());
        }
        return result.getWriteStatuses();
    }

    @Override
    public void commitCompaction(String compactionInstantTime, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context);
        extraMetadata.ifPresent(m -> m.forEach(metadata::addMetadata));
        this.completeCompaction(metadata, table, compactionInstantTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completeCompaction(HoodieCommitMetadata metadata, HoodieTable table, String compactionCommitTime) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Collect compaction write status and commit compaction");
        List<HoodieWriteStat> writeStats = metadata.getWriteStats();
        HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionCommitTime);
        try {
            this.txnManager.beginTransaction(Option.of(compactionInstant), Option.empty());
            this.finalizeWrite(table, compactionCommitTime, writeStats);
            this.updateTableMetadata(table, metadata, compactionInstant);
            LOG.info((Object)("Committing Compaction " + compactionCommitTime + ". Finished with result " + metadata));
            CompactHelpers.getInstance().completeInflightCompaction(table, compactionCommitTime, metadata);
        }
        finally {
            this.txnManager.endTransaction(Option.of(compactionInstant));
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), table, compactionCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.compactionTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.compactionTimer.stop());
            try {
                this.metrics.updateCommitMetrics(HoodieActiveTimeline.parseDateFromInstantTime(compactionCommitTime).getTime(), durationInMs, metadata, "compaction");
            }
            catch (ParseException e) {
                throw new HoodieCommitException("Commit time is not of valid format. Failed to commit compaction " + this.config.getBasePath() + " at time " + compactionCommitTime, e);
            }
        }
        LOG.info((Object)("Compacted successfully on commit " + compactionCommitTime));
    }

    @Override
    protected HoodieWriteMetadata<JavaRDD<WriteStatus>> compact(String compactionInstantTime, boolean shouldComplete) {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context, true);
        this.preWrite(compactionInstantTime, WriteOperationType.COMPACT, table.getMetaClient());
        HoodieTimeline pendingCompactionTimeline = table.getActiveTimeline().filterPendingCompactionTimeline();
        HoodieInstant inflightInstant = HoodieTimeline.getCompactionInflightInstant(compactionInstantTime);
        if (pendingCompactionTimeline.containsInstant(inflightInstant)) {
            table.rollbackInflightCompaction(inflightInstant, commitToRollback -> this.getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false));
            table.getMetaClient().reloadActiveTimeline();
        }
        this.compactionTimer = this.metrics.getCompactionCtx();
        HoodieWriteMetadata writeMetadata = table.compact(this.context, compactionInstantTime);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> compactionMetadata = writeMetadata.clone(HoodieJavaRDD.getJavaRDD((HoodieData)writeMetadata.getWriteStatuses()));
        if (shouldComplete && compactionMetadata.getCommitMetadata().isPresent()) {
            this.completeTableService(TableServiceType.COMPACT, compactionMetadata.getCommitMetadata().get(), table, compactionInstantTime);
        }
        return compactionMetadata;
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> cluster(String clusteringInstant, boolean shouldComplete) {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context, this.config.isMetadataTableEnabled());
        this.preWrite(clusteringInstant, WriteOperationType.CLUSTER, table.getMetaClient());
        HoodieTimeline pendingClusteringTimeline = table.getActiveTimeline().filterPendingReplaceTimeline();
        HoodieInstant inflightInstant = HoodieTimeline.getReplaceCommitInflightInstant(clusteringInstant);
        if (pendingClusteringTimeline.containsInstant(inflightInstant)) {
            this.rollbackInflightClustering(inflightInstant, table);
            table.getMetaClient().reloadActiveTimeline();
        }
        this.clusteringTimer = this.metrics.getClusteringCtx();
        LOG.info((Object)("Starting clustering at " + clusteringInstant));
        HoodieWriteMetadata writeMetadata = table.cluster(this.context, clusteringInstant);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> clusteringMetadata = writeMetadata.clone(HoodieJavaRDD.getJavaRDD((HoodieData)writeMetadata.getWriteStatuses()));
        if (shouldComplete && clusteringMetadata.getCommitMetadata().isPresent()) {
            this.completeTableService(TableServiceType.CLUSTER, clusteringMetadata.getCommitMetadata().get(), table, clusteringInstant);
        }
        return clusteringMetadata;
    }

    private void completeClustering(HoodieReplaceCommitMetadata metadata, HoodieTable table, String clusteringCommitTime) {
        List<HoodieWriteStat> writeStats = metadata.getPartitionToWriteStats().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
        if (writeStats.stream().mapToLong(s -> s.getTotalWriteErrors()).sum() > 0L) {
            throw new HoodieClusteringException("Clustering failed to write to files:" + writeStats.stream().filter(s -> s.getTotalWriteErrors() > 0L).map(s -> s.getFileId()).collect(Collectors.joining(",")));
        }
        HoodieInstant clusteringInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "replacecommit", clusteringCommitTime);
        try {
            this.txnManager.beginTransaction(Option.of(clusteringInstant), Option.empty());
            this.finalizeWrite(table, clusteringCommitTime, writeStats);
            this.updateTableMetadata(table, metadata, clusteringInstant);
            LOG.info((Object)("Committing Clustering " + clusteringCommitTime + ". Finished with result " + metadata));
            table.getActiveTimeline().transitionReplaceInflightToComplete(HoodieTimeline.getReplaceCommitInflightInstant(clusteringCommitTime), Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e2) {
            throw new HoodieClusteringException("unable to transition clustering inflight to complete: " + clusteringCommitTime, e2);
        }
        finally {
            this.txnManager.endTransaction(Option.of(clusteringInstant));
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), table, clusteringCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.clusteringTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.clusteringTimer.stop());
            try {
                this.metrics.updateCommitMetrics(HoodieActiveTimeline.parseDateFromInstantTime(clusteringCommitTime).getTime(), durationInMs, metadata, "replacecommit");
            }
            catch (ParseException e3) {
                throw new HoodieCommitException("Commit time is not of valid format. Failed to commit compaction " + this.config.getBasePath() + " at time " + clusteringCommitTime, e3);
            }
        }
        LOG.info((Object)("Clustering successfully on commit " + clusteringCommitTime));
    }

    private void updateTableMetadata(HoodieTable table, HoodieCommitMetadata commitMetadata, HoodieInstant hoodieInstant) {
        boolean isTableServiceAction = table.isTableServiceAction(hoodieInstant.getAction());
        table.getMetadataWriter(hoodieInstant.getTimestamp()).ifPresent(writer -> ((HoodieTableMetadataWriter)writer).update(commitMetadata, hoodieInstant.getTimestamp(), isTableServiceAction));
    }

    @Override
    protected HoodieTable doInitTable(HoodieTableMetaClient metaClient, Option<String> instantTime, boolean initialMetadataTableIfNecessary) {
        if (initialMetadataTableIfNecessary) {
            this.initializeMetadataTable(instantTime);
        }
        return HoodieSparkTable.create(this.config, (HoodieSparkEngineContext)this.context, metaClient, this.config.isMetadataTableEnabled());
    }

    private void initializeMetadataTable(Option<String> inFlightInstantTimestamp) {
        if (this.config.isMetadataTableEnabled()) {
            SparkHoodieBackedTableMetadataWriter.create(this.context.getHadoopConf().get(), this.config, this.context, Option.empty(), inFlightInstantTimestamp);
        }
    }

    private void completeTableService(TableServiceType tableServiceType, HoodieCommitMetadata metadata, HoodieTable table, String commitInstant) {
        switch (tableServiceType) {
            case CLUSTER: {
                this.completeClustering((HoodieReplaceCommitMetadata)metadata, table, commitInstant);
                break;
            }
            case COMPACT: {
                this.completeCompaction(metadata, table, commitInstant);
                break;
            }
            default: {
                throw new IllegalArgumentException("This table service is not valid " + (Object)((Object)tableServiceType));
            }
        }
    }

    @Override
    protected void preCommit(HoodieInstant inflightInstant, HoodieCommitMetadata metadata) {
        HoodieTable table = this.createTable(this.config, this.hadoopConf);
        TransactionUtils.resolveWriteConflictIfAny(table, this.txnManager.getCurrentTransactionOwner(), Option.of(metadata), this.config, this.txnManager.getLastCompletedTransactionOwner(), false, this.pendingInflightAndRequestedInstants);
    }

    @Override
    protected void initWrapperFSMetrics() {
        if (this.config.isMetricsOn()) {
            Registry registryMeta;
            Registry registry;
            JavaSparkContext jsc = ((HoodieSparkEngineContext)this.context).getJavaSparkContext();
            if (this.config.isExecutorMetricsEnabled()) {
                registry = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName(), DistributedRegistry.class.getName());
                ((DistributedRegistry)registry).register(jsc);
                registryMeta = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName() + "MetaFolder", DistributedRegistry.class.getName());
                ((DistributedRegistry)registryMeta).register(jsc);
            } else {
                registry = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName());
                registryMeta = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName() + "MetaFolder");
            }
            HoodieWrapperFileSystem.setMetricsRegistry(registry, registryMeta);
        }
    }

    @Override
    protected void releaseResources() {
        if (this.config.areReleaseResourceEnabled()) {
            ((HoodieSparkEngineContext)this.context).getJavaSparkContext().getPersistentRDDs().values().forEach(JavaRDD::unpersist);
        }
    }
}

