/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.FailSafeConsistencyGuard;
import org.apache.hudi.common.fs.FileSystemRetryConfig;
import org.apache.hudi.common.fs.HoodieRetryWrapperFileSystem;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.fs.NoOpConsistencyGuard;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.hadoop.CachingPath;
import org.apache.hudi.hadoop.SerializablePath;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTableMetaClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(HoodieTableMetaClient.class);
    public static final String METAFOLDER_NAME = ".hoodie";
    public static final String TEMPFOLDER_NAME = ".hoodie/.temp";
    public static final String AUXILIARYFOLDER_NAME = ".hoodie/.aux";
    public static final String BOOTSTRAP_INDEX_ROOT_FOLDER_PATH = ".hoodie/.aux/.bootstrap";
    public static final String HEARTBEAT_FOLDER_NAME = ".hoodie/.heartbeat";
    public static final String METADATA_TABLE_FOLDER_PATH = ".hoodie/metadata";
    public static final String BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH = ".hoodie/.aux/.bootstrap/.partitions";
    public static final String BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH = ".hoodie/.aux/.bootstrap/.fileids";
    public static final String SCHEMA_FOLDER_NAME = ".schema";
    public static final String MARKER_EXTN = ".marker";
    private SerializablePath basePath;
    private SerializablePath metaPath;
    private transient HoodieWrapperFileSystem fs;
    private boolean loadActiveTimelineOnLoad;
    private SerializableConfiguration hadoopConf;
    private HoodieTableType tableType;
    private TimelineLayoutVersion timelineLayoutVersion;
    private HoodieTableConfig tableConfig;
    private HoodieActiveTimeline activeTimeline;
    private HoodieArchivedTimeline archivedTimeline;
    private ConsistencyGuardConfig consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();
    private FileSystemRetryConfig fileSystemRetryConfig = FileSystemRetryConfig.newBuilder().build();

    private HoodieTableMetaClient(Configuration conf, String basePath, boolean loadActiveTimelineOnLoad, ConsistencyGuardConfig consistencyGuardConfig, Option<TimelineLayoutVersion> layoutVersion, String payloadClassName, FileSystemRetryConfig fileSystemRetryConfig) {
        LOG.info((Object)("Loading HoodieTableMetaClient from " + basePath));
        this.consistencyGuardConfig = consistencyGuardConfig;
        this.fileSystemRetryConfig = fileSystemRetryConfig;
        this.hadoopConf = new SerializableConfiguration(conf);
        this.basePath = new SerializablePath(new CachingPath(basePath));
        this.metaPath = new SerializablePath(new CachingPath(basePath, METAFOLDER_NAME));
        this.fs = this.getFs();
        TableNotFoundException.checkTableValidity(this.fs, this.basePath.get(), this.metaPath.get());
        this.tableConfig = new HoodieTableConfig(this.fs, this.metaPath.toString(), payloadClassName);
        this.tableType = this.tableConfig.getTableType();
        Option<TimelineLayoutVersion> tableConfigVersion = this.tableConfig.getTimelineLayoutVersion();
        if (layoutVersion.isPresent() && tableConfigVersion.isPresent()) {
            ValidationUtils.checkArgument(layoutVersion.get().compareTo(tableConfigVersion.get()) >= 0, "Layout Version defined in hoodie properties has higher version (" + tableConfigVersion.get() + ") than the one passed in config (" + layoutVersion.get() + ")");
        }
        this.timelineLayoutVersion = layoutVersion.orElseGet(() -> this.tableConfig.getTimelineLayoutVersion().get());
        this.loadActiveTimelineOnLoad = loadActiveTimelineOnLoad;
        LOG.info((Object)("Finished Loading Table of type " + (Object)((Object)this.tableType) + "(version=" + this.timelineLayoutVersion + ", baseFileFormat=" + (Object)((Object)this.tableConfig.getBaseFileFormat()) + ") from " + basePath));
        if (loadActiveTimelineOnLoad) {
            LOG.info((Object)("Loading Active commit timeline for " + basePath));
            this.getActiveTimeline();
        }
    }

    public HoodieTableMetaClient() {
    }

    public static HoodieTableMetaClient reload(HoodieTableMetaClient oldMetaClient) {
        return HoodieTableMetaClient.builder().setConf(oldMetaClient.hadoopConf.get()).setBasePath(oldMetaClient.basePath.toString()).setLoadActiveTimelineOnLoad(oldMetaClient.loadActiveTimelineOnLoad).setConsistencyGuardConfig(oldMetaClient.consistencyGuardConfig).setLayoutVersion(Option.of(oldMetaClient.timelineLayoutVersion)).setPayloadClassName(null).setFileSystemRetryConfig(oldMetaClient.fileSystemRetryConfig).build();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fs = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public Path getBasePathV2() {
        return this.basePath.get();
    }

    @Deprecated
    public String getBasePath() {
        return this.basePath.get().toString();
    }

    public HoodieTableType getTableType() {
        return this.tableType;
    }

    public String getMetaPath() {
        return this.metaPath.get().toString();
    }

    public String getSchemaFolderName() {
        return new Path(this.metaPath.get(), SCHEMA_FOLDER_NAME).toString();
    }

    public String getTempFolderPath() {
        return this.basePath + "/" + TEMPFOLDER_NAME;
    }

    public String getMarkerFolderPath(String instantTs) {
        return String.format("%s%s%s", this.getTempFolderPath(), "/", instantTs);
    }

    public String getMetaAuxiliaryPath() {
        return this.basePath + "/" + AUXILIARYFOLDER_NAME;
    }

    public static String getHeartbeatFolderPath(String basePath) {
        return String.format("%s%s%s", basePath, "/", HEARTBEAT_FOLDER_NAME);
    }

    public String getBootstrapIndexByPartitionFolderPath() {
        return this.basePath + "/" + BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH;
    }

    public String getBootstrapIndexByFileIdFolderNameFolderPath() {
        return this.basePath + "/" + BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH;
    }

    public String getArchivePath() {
        String archiveFolder = this.tableConfig.getArchivelogFolder();
        return this.getMetaPath() + "/" + archiveFolder;
    }

    public HoodieTableConfig getTableConfig() {
        return this.tableConfig;
    }

    public TimelineLayoutVersion getTimelineLayoutVersion() {
        return this.timelineLayoutVersion;
    }

    public HoodieWrapperFileSystem getFs() {
        if (this.fs == null) {
            FileSystem fileSystem = FSUtils.getFs(this.metaPath.get(), this.hadoopConf.newCopy());
            if (this.fileSystemRetryConfig.isFileSystemActionRetryEnable()) {
                fileSystem = new HoodieRetryWrapperFileSystem(fileSystem, this.fileSystemRetryConfig.getMaxRetryIntervalMs(), this.fileSystemRetryConfig.getMaxRetryNumbers(), this.fileSystemRetryConfig.getInitialRetryIntervalMs(), this.fileSystemRetryConfig.getRetryExceptions());
            }
            ValidationUtils.checkArgument(!(fileSystem instanceof HoodieWrapperFileSystem), "File System not expected to be that of HoodieWrapperFileSystem");
            this.fs = new HoodieWrapperFileSystem(fileSystem, this.consistencyGuardConfig.isConsistencyCheckEnabled() ? new FailSafeConsistencyGuard(fileSystem, this.consistencyGuardConfig) : new NoOpConsistencyGuard());
        }
        return this.fs;
    }

    public void setFs(HoodieWrapperFileSystem fs) {
        this.fs = fs;
    }

    public FileSystem getRawFs() {
        return this.getFs().getFileSystem();
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf.get();
    }

    public synchronized HoodieActiveTimeline getActiveTimeline() {
        if (this.activeTimeline == null) {
            this.activeTimeline = new HoodieActiveTimeline(this);
        }
        return this.activeTimeline;
    }

    public synchronized HoodieActiveTimeline reloadActiveTimeline() {
        this.activeTimeline = new HoodieActiveTimeline(this);
        return this.activeTimeline;
    }

    public ConsistencyGuardConfig getConsistencyGuardConfig() {
        return this.consistencyGuardConfig;
    }

    public FileSystemRetryConfig getFileSystemRetryConfig() {
        return this.fileSystemRetryConfig;
    }

    public synchronized HoodieArchivedTimeline getArchivedTimeline() {
        if (this.archivedTimeline == null) {
            this.archivedTimeline = new HoodieArchivedTimeline(this);
        }
        return this.archivedTimeline;
    }

    public HoodieArchivedTimeline getArchivedTimeline(String startTs) {
        return new HoodieArchivedTimeline(this, startTs);
    }

    public void validateTableProperties(Properties properties) {
        if (!this.getTableConfig().populateMetaFields() && Boolean.parseBoolean((String)properties.getOrDefault((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), HoodieTableConfig.POPULATE_META_FIELDS.defaultValue()))) {
            throw new HoodieException(HoodieTableConfig.POPULATE_META_FIELDS.key() + " already disabled for the table. Can't be re-enabled back");
        }
        if (!this.getTableConfig().populateMetaFields() && !properties.getProperty(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), "org.apache.hudi.keygen.SimpleKeyGenerator").equals("org.apache.hudi.keygen.SimpleKeyGenerator")) {
            throw new HoodieException("Only simple key generator is supported when meta fields are disabled. KeyGenerator used : " + properties.getProperty(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()));
        }
    }

    public static HoodieTableMetaClient initTableAndGetMetaClient(Configuration hadoopConf, String basePath, Properties props) throws IOException {
        Path auxiliaryFolder;
        Path temporaryFolder;
        Path archiveLogDir;
        String archiveLogPropVal;
        Path schemaPathDir;
        Path metaPathDir;
        LOG.info((Object)("Initializing " + basePath + " as hoodie table " + basePath));
        Path basePathDir = new Path(basePath);
        FileSystem fs = FSUtils.getFs(basePath, hadoopConf);
        if (!fs.exists(basePathDir)) {
            fs.mkdirs(basePathDir);
        }
        if (!fs.exists(metaPathDir = new Path(basePath, METAFOLDER_NAME))) {
            fs.mkdirs(metaPathDir);
        }
        if (!fs.exists(schemaPathDir = new Path(metaPathDir, SCHEMA_FOLDER_NAME))) {
            fs.mkdirs(schemaPathDir);
        }
        if (!StringUtils.isNullOrEmpty(archiveLogPropVal = new HoodieConfig(props).getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER)) && !fs.exists(archiveLogDir = new Path(metaPathDir, archiveLogPropVal))) {
            fs.mkdirs(archiveLogDir);
        }
        if (!fs.exists(temporaryFolder = new Path(basePath, TEMPFOLDER_NAME))) {
            fs.mkdirs(temporaryFolder);
        }
        if (!fs.exists(auxiliaryFolder = new Path(basePath, AUXILIARYFOLDER_NAME))) {
            fs.mkdirs(auxiliaryFolder);
        }
        HoodieTableMetaClient.initializeBootstrapDirsIfNotExists(hadoopConf, basePath, fs);
        HoodieTableConfig.create(fs, metaPathDir, props);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(hadoopConf).setBasePath(basePath).build();
        LOG.info((Object)("Finished initializing Table of type " + (Object)((Object)metaClient.getTableConfig().getTableType()) + " from " + basePath));
        return metaClient;
    }

    public static void initializeBootstrapDirsIfNotExists(Configuration hadoopConf, String basePath, FileSystem fs) throws IOException {
        Path bootstrap_index_folder_by_fileids;
        Path bootstrap_index_folder_by_partition = new Path(basePath, BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH);
        if (!fs.exists(bootstrap_index_folder_by_partition)) {
            fs.mkdirs(bootstrap_index_folder_by_partition);
        }
        if (!fs.exists(bootstrap_index_folder_by_fileids = new Path(basePath, BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH))) {
            fs.mkdirs(bootstrap_index_folder_by_fileids);
        }
    }

    public static FileStatus[] scanFiles(FileSystem fs, Path metaPath, PathFilter nameFilter) throws IOException {
        return fs.listStatus(metaPath, nameFilter);
    }

    public boolean isTimelineNonEmpty() {
        return this.getCommitsTimeline().filterCompletedInstants().getInstants().collect(Collectors.toList()).size() > 0;
    }

    public HoodieTimeline getCommitsTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: {
                return this.getActiveTimeline().getCommitTimeline();
            }
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getCommitsTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public HoodieTimeline getCommitsAndCompactionTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: {
                return this.getActiveTimeline().getCommitTimeline();
            }
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getWriteTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public HoodieTimeline getCommitTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: 
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getCommitTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public String getCommitActionType() {
        return CommitUtils.getCommitActionType(this.getTableType());
    }

    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(Set<String> includedExtensions, boolean applyLayoutVersionFilters) throws IOException {
        return this.scanHoodieInstantsFromFileSystem(this.metaPath.get(), includedExtensions, applyLayoutVersionFilters);
    }

    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(Path timelinePath, Set<String> includedExtensions, boolean applyLayoutVersionFilters) throws IOException {
        Stream<HoodieInstant> instantStream = Arrays.stream(HoodieTableMetaClient.scanFiles(this.getFs(), timelinePath, path -> {
            String extension = HoodieInstant.getTimelineFileExtension(path.getName());
            return includedExtensions.contains(extension);
        })).map(HoodieInstant::new);
        if (applyLayoutVersionFilters) {
            instantStream = TimelineLayout.getLayout(this.getTimelineLayoutVersion()).filterHoodieInstants(instantStream);
        }
        return instantStream.sorted().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieTableMetaClient that = (HoodieTableMetaClient)o;
        return Objects.equals(this.basePath, that.basePath) && this.tableType == that.tableType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.basePath, this.tableType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieTableMetaClient{");
        sb.append("basePath='").append(this.basePath).append('\'');
        sb.append(", metaPath='").append(this.metaPath).append('\'');
        sb.append(", tableType=").append((Object)this.tableType);
        sb.append('}');
        return sb.toString();
    }

    public void initializeBootstrapDirsIfNotExists() throws IOException {
        HoodieTableMetaClient.initializeBootstrapDirsIfNotExists(this.getHadoopConf(), this.basePath.toString(), this.getFs());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PropertyBuilder withPropertyBuilder() {
        return new PropertyBuilder();
    }

    public static class PropertyBuilder {
        private HoodieTableType tableType;
        private String databaseName;
        private String tableName;
        private String tableCreateSchema;
        private String recordKeyFields;
        private String archiveLogFolder;
        private String payloadClassName;
        private Integer timelineLayoutVersion;
        private String baseFileFormat;
        private String preCombineField;
        private String partitionFields;
        private String bootstrapIndexClass;
        private String bootstrapBasePath;
        private Boolean bootstrapIndexEnable;
        private Boolean populateMetaFields;
        private String keyGeneratorClassProp;
        private Boolean hiveStylePartitioningEnable;
        private Boolean urlEncodePartitioning;
        private HoodieTimelineTimeZone commitTimeZone;
        private Boolean partitionMetafileUseBaseFormat;
        private Boolean shouldDropPartitionColumns;
        private String metadataPartitions;
        private String inflightMetadataPartitions;
        private Properties others = new Properties();

        private PropertyBuilder() {
        }

        public PropertyBuilder setTableType(HoodieTableType tableType) {
            this.tableType = tableType;
            return this;
        }

        public PropertyBuilder setTableType(String tableType) {
            return this.setTableType(HoodieTableType.valueOf(tableType));
        }

        public PropertyBuilder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public PropertyBuilder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public PropertyBuilder setTableCreateSchema(String tableCreateSchema) {
            this.tableCreateSchema = tableCreateSchema;
            return this;
        }

        public PropertyBuilder setRecordKeyFields(String recordKeyFields) {
            this.recordKeyFields = recordKeyFields;
            return this;
        }

        public PropertyBuilder setArchiveLogFolder(String archiveLogFolder) {
            this.archiveLogFolder = archiveLogFolder;
            return this;
        }

        public PropertyBuilder setPayloadClassName(String payloadClassName) {
            this.payloadClassName = payloadClassName;
            return this;
        }

        public PropertyBuilder setPayloadClass(Class<? extends HoodieRecordPayload> payloadClass) {
            return this.setPayloadClassName(payloadClass.getName());
        }

        public PropertyBuilder setTimelineLayoutVersion(Integer timelineLayoutVersion) {
            this.timelineLayoutVersion = timelineLayoutVersion;
            return this;
        }

        public PropertyBuilder setBaseFileFormat(String baseFileFormat) {
            this.baseFileFormat = baseFileFormat;
            return this;
        }

        public PropertyBuilder setPreCombineField(String preCombineField) {
            this.preCombineField = preCombineField;
            return this;
        }

        public PropertyBuilder setPartitionFields(String partitionFields) {
            this.partitionFields = partitionFields;
            return this;
        }

        public PropertyBuilder setBootstrapIndexClass(String bootstrapIndexClass) {
            this.bootstrapIndexClass = bootstrapIndexClass;
            return this;
        }

        public PropertyBuilder setBootstrapBasePath(String bootstrapBasePath) {
            this.bootstrapBasePath = bootstrapBasePath;
            return this;
        }

        public PropertyBuilder setBootstrapIndexEnable(Boolean bootstrapIndexEnable) {
            this.bootstrapIndexEnable = bootstrapIndexEnable;
            return this;
        }

        public PropertyBuilder setPopulateMetaFields(boolean populateMetaFields) {
            this.populateMetaFields = populateMetaFields;
            return this;
        }

        public PropertyBuilder setKeyGeneratorClassProp(String keyGeneratorClassProp) {
            this.keyGeneratorClassProp = keyGeneratorClassProp;
            return this;
        }

        public PropertyBuilder setHiveStylePartitioningEnable(Boolean hiveStylePartitioningEnable) {
            this.hiveStylePartitioningEnable = hiveStylePartitioningEnable;
            return this;
        }

        public PropertyBuilder setUrlEncodePartitioning(Boolean urlEncodePartitioning) {
            this.urlEncodePartitioning = urlEncodePartitioning;
            return this;
        }

        public PropertyBuilder setCommitTimezone(HoodieTimelineTimeZone timelineTimeZone) {
            this.commitTimeZone = timelineTimeZone;
            return this;
        }

        public PropertyBuilder setPartitionMetafileUseBaseFormat(Boolean useBaseFormat) {
            this.partitionMetafileUseBaseFormat = useBaseFormat;
            return this;
        }

        public PropertyBuilder setShouldDropPartitionColumns(Boolean shouldDropPartitionColumns) {
            this.shouldDropPartitionColumns = shouldDropPartitionColumns;
            return this;
        }

        public PropertyBuilder setMetadataPartitions(String partitions) {
            this.metadataPartitions = partitions;
            return this;
        }

        public PropertyBuilder setInflightMetadataPartitions(String partitions) {
            this.inflightMetadataPartitions = partitions;
            return this;
        }

        public PropertyBuilder set(String key, Object value) {
            if (HoodieTableConfig.PERSISTED_CONFIG_LIST.contains(key)) {
                this.others.put(key, value);
            }
            return this;
        }

        public PropertyBuilder set(Map<String, Object> props) {
            for (String key : HoodieTableConfig.PERSISTED_CONFIG_LIST) {
                Object value = props.get(key);
                if (value == null) continue;
                this.set(key, value);
            }
            return this;
        }

        public PropertyBuilder fromMetaClient(HoodieTableMetaClient metaClient) {
            return this.setTableType(metaClient.getTableType()).setTableName(metaClient.getTableConfig().getTableName()).setArchiveLogFolder(metaClient.getArchivePath()).setPayloadClassName(metaClient.getTableConfig().getPayloadClass());
        }

        public PropertyBuilder fromProperties(Properties properties) {
            HoodieConfig hoodieConfig = new HoodieConfig(properties);
            for (String key : HoodieTableConfig.PERSISTED_CONFIG_LIST) {
                String value = hoodieConfig.getString(key);
                if (value == null) continue;
                this.set(key, value);
            }
            if (hoodieConfig.contains(HoodieTableConfig.DATABASE_NAME)) {
                this.setDatabaseName(hoodieConfig.getString(HoodieTableConfig.DATABASE_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.NAME)) {
                this.setTableName(hoodieConfig.getString(HoodieTableConfig.NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TYPE)) {
                this.setTableType(hoodieConfig.getString(HoodieTableConfig.TYPE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.ARCHIVELOG_FOLDER)) {
                this.setArchiveLogFolder(hoodieConfig.getString(HoodieTableConfig.ARCHIVELOG_FOLDER));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PAYLOAD_CLASS_NAME)) {
                this.setPayloadClassName(hoodieConfig.getString(HoodieTableConfig.PAYLOAD_CLASS_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TIMELINE_LAYOUT_VERSION)) {
                this.setTimelineLayoutVersion(hoodieConfig.getInt(HoodieTableConfig.TIMELINE_LAYOUT_VERSION));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BASE_FILE_FORMAT)) {
                this.setBaseFileFormat(hoodieConfig.getString(HoodieTableConfig.BASE_FILE_FORMAT));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME)) {
                this.setBootstrapIndexClass(hoodieConfig.getString(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BOOTSTRAP_BASE_PATH)) {
                this.setBootstrapBasePath(hoodieConfig.getString(HoodieTableConfig.BOOTSTRAP_BASE_PATH));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE)) {
                this.setBootstrapIndexEnable(hoodieConfig.getBoolean(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PRECOMBINE_FIELD)) {
                this.setPreCombineField(hoodieConfig.getString(HoodieTableConfig.PRECOMBINE_FIELD));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PARTITION_FIELDS)) {
                this.setPartitionFields(hoodieConfig.getString(HoodieTableConfig.PARTITION_FIELDS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.RECORDKEY_FIELDS)) {
                this.setRecordKeyFields(hoodieConfig.getString(HoodieTableConfig.RECORDKEY_FIELDS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.CREATE_SCHEMA)) {
                this.setTableCreateSchema(hoodieConfig.getString(HoodieTableConfig.CREATE_SCHEMA));
            }
            if (hoodieConfig.contains(HoodieTableConfig.POPULATE_META_FIELDS)) {
                this.setPopulateMetaFields(hoodieConfig.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME)) {
                this.setKeyGeneratorClassProp(hoodieConfig.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE)) {
                this.setHiveStylePartitioningEnable(hoodieConfig.getBoolean(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.URL_ENCODE_PARTITIONING)) {
                this.setUrlEncodePartitioning(hoodieConfig.getBoolean(HoodieTableConfig.URL_ENCODE_PARTITIONING));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT)) {
                this.setPartitionMetafileUseBaseFormat(hoodieConfig.getBoolean(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT));
            }
            if (hoodieConfig.contains(HoodieTableConfig.DROP_PARTITION_COLUMNS)) {
                this.setShouldDropPartitionColumns(hoodieConfig.getBoolean(HoodieTableConfig.DROP_PARTITION_COLUMNS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TABLE_METADATA_PARTITIONS)) {
                this.setMetadataPartitions(hoodieConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT)) {
                this.setInflightMetadataPartitions(hoodieConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT));
            }
            return this;
        }

        public Properties build() {
            ValidationUtils.checkArgument(this.tableType != null, "tableType is null");
            ValidationUtils.checkArgument(this.tableName != null, "tableName is null");
            HoodieTableConfig tableConfig = new HoodieTableConfig();
            tableConfig.setAll(this.others);
            if (this.databaseName != null) {
                tableConfig.setValue(HoodieTableConfig.DATABASE_NAME, this.databaseName);
            }
            tableConfig.setValue(HoodieTableConfig.NAME, this.tableName);
            tableConfig.setValue(HoodieTableConfig.TYPE, this.tableType.name());
            tableConfig.setValue(HoodieTableConfig.VERSION, String.valueOf(HoodieTableVersion.current().versionCode()));
            if (this.tableType == HoodieTableType.MERGE_ON_READ && this.payloadClassName != null) {
                tableConfig.setValue(HoodieTableConfig.PAYLOAD_CLASS_NAME, this.payloadClassName);
            }
            if (null != this.tableCreateSchema) {
                tableConfig.setValue(HoodieTableConfig.CREATE_SCHEMA, this.tableCreateSchema);
            }
            if (!StringUtils.isNullOrEmpty(this.archiveLogFolder)) {
                tableConfig.setValue(HoodieTableConfig.ARCHIVELOG_FOLDER, this.archiveLogFolder);
            } else {
                tableConfig.setDefaultValue(HoodieTableConfig.ARCHIVELOG_FOLDER);
            }
            if (null != this.timelineLayoutVersion) {
                tableConfig.setValue(HoodieTableConfig.TIMELINE_LAYOUT_VERSION, String.valueOf(this.timelineLayoutVersion));
            }
            if (null != this.baseFileFormat) {
                tableConfig.setValue(HoodieTableConfig.BASE_FILE_FORMAT, this.baseFileFormat.toUpperCase());
            }
            if (null != this.bootstrapIndexClass) {
                tableConfig.setValue(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME, this.bootstrapIndexClass);
            }
            if (null != this.bootstrapIndexEnable) {
                tableConfig.setValue(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE, Boolean.toString(this.bootstrapIndexEnable));
            }
            if (null != this.bootstrapBasePath) {
                tableConfig.setValue(HoodieTableConfig.BOOTSTRAP_BASE_PATH, this.bootstrapBasePath);
            }
            if (null != this.preCombineField) {
                tableConfig.setValue(HoodieTableConfig.PRECOMBINE_FIELD, this.preCombineField);
            }
            if (null != this.partitionFields) {
                tableConfig.setValue(HoodieTableConfig.PARTITION_FIELDS, this.partitionFields);
            }
            if (null != this.recordKeyFields) {
                tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, this.recordKeyFields);
            }
            if (null != this.populateMetaFields) {
                tableConfig.setValue(HoodieTableConfig.POPULATE_META_FIELDS, Boolean.toString(this.populateMetaFields));
            }
            if (null != this.keyGeneratorClassProp) {
                tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, this.keyGeneratorClassProp);
            }
            if (null != this.hiveStylePartitioningEnable) {
                tableConfig.setValue(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE, Boolean.toString(this.hiveStylePartitioningEnable));
            }
            if (null != this.urlEncodePartitioning) {
                tableConfig.setValue(HoodieTableConfig.URL_ENCODE_PARTITIONING, Boolean.toString(this.urlEncodePartitioning));
            }
            if (null != this.commitTimeZone) {
                tableConfig.setValue(HoodieTableConfig.TIMELINE_TIMEZONE, this.commitTimeZone.toString());
            }
            if (null != this.partitionMetafileUseBaseFormat) {
                tableConfig.setValue(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT, this.partitionMetafileUseBaseFormat.toString());
            }
            if (null != this.shouldDropPartitionColumns) {
                tableConfig.setValue(HoodieTableConfig.DROP_PARTITION_COLUMNS, Boolean.toString(this.shouldDropPartitionColumns));
            }
            if (null != this.metadataPartitions) {
                tableConfig.setValue(HoodieTableConfig.TABLE_METADATA_PARTITIONS, this.metadataPartitions);
            }
            if (null != this.inflightMetadataPartitions) {
                tableConfig.setValue(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT, this.inflightMetadataPartitions);
            }
            return tableConfig.getProps();
        }

        public HoodieTableMetaClient initTable(Configuration configuration, String basePath) throws IOException {
            return HoodieTableMetaClient.initTableAndGetMetaClient(configuration, basePath, this.build());
        }
    }

    public static class Builder {
        private Configuration conf;
        private String basePath;
        private boolean loadActiveTimelineOnLoad = false;
        private String payloadClassName = null;
        private ConsistencyGuardConfig consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();
        private FileSystemRetryConfig fileSystemRetryConfig = FileSystemRetryConfig.newBuilder().build();
        private Option<TimelineLayoutVersion> layoutVersion = Option.of(TimelineLayoutVersion.CURR_LAYOUT_VERSION);

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder setLoadActiveTimelineOnLoad(boolean loadActiveTimelineOnLoad) {
            this.loadActiveTimelineOnLoad = loadActiveTimelineOnLoad;
            return this;
        }

        public Builder setPayloadClassName(String payloadClassName) {
            this.payloadClassName = payloadClassName;
            return this;
        }

        public Builder setConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
            this.consistencyGuardConfig = consistencyGuardConfig;
            return this;
        }

        public Builder setFileSystemRetryConfig(FileSystemRetryConfig fileSystemRetryConfig) {
            this.fileSystemRetryConfig = fileSystemRetryConfig;
            return this;
        }

        public Builder setLayoutVersion(Option<TimelineLayoutVersion> layoutVersion) {
            this.layoutVersion = layoutVersion;
            return this;
        }

        public HoodieTableMetaClient build() {
            ValidationUtils.checkArgument(this.conf != null, "Configuration needs to be set to init HoodieTableMetaClient");
            ValidationUtils.checkArgument(this.basePath != null, "basePath needs to be set to init HoodieTableMetaClient");
            return new HoodieTableMetaClient(this.conf, this.basePath, this.loadActiveTimelineOnLoad, this.consistencyGuardConfig, this.layoutVersion, this.payloadClassName, this.fileSystemRetryConfig);
        }
    }
}

