/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.bootstrap.BootstrapMode;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FileSystemRetryConfig;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieHBaseIndexConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLayoutConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieMemoryConfig;
import org.apache.hudi.config.HoodieMetricsCloudWatchConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodiePreCommitValidatorConfig;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.config.HoodieWriteCommitCallbackConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.config.metrics.HoodieMetricsDatadogConfig;
import org.apache.hudi.config.metrics.HoodieMetricsGraphiteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsJmxConfig;
import org.apache.hudi.config.metrics.HoodieMetricsPrometheusConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.table.RandomFileIdPrefixProvider;
import org.apache.hudi.table.action.clean.CleaningTriggerStrategy;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;
import org.apache.hudi.table.storage.HoodieStorageLayout;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.orc.CompressionKind;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

@ConfigClassProperty(name="Write Configurations", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations that control write behavior on Hudi tables. These can be directly passed down from even higher level frameworks (e.g Spark datasources, Flink sink) and utilities (e.g DeltaStreamer).")
@Immutable
public class HoodieWriteConfig
extends HoodieConfig {
    private static final Logger LOG = LogManager.getLogger(HoodieWriteConfig.class);
    private static final long serialVersionUID = 0L;
    public static final String DELTASTREAMER_CHECKPOINT_KEY = "deltastreamer.checkpoint.key";
    public static final ConfigProperty<String> TBL_NAME = ConfigProperty.key("hoodie.table.name").noDefaultValue().withDocumentation("Table name that will be used for registering with metastores like HMS. Needs to be same across runs.");
    public static final ConfigProperty<String> PRECOMBINE_FIELD_NAME = ConfigProperty.key("hoodie.datasource.write.precombine.field").defaultValue("ts").withDocumentation("Field used in preCombining before actual write. When two records have the same key value, we will pick the one with the largest value for the precombine field, determined by Object.compareTo(..)");
    public static final ConfigProperty<String> WRITE_PAYLOAD_CLASS_NAME = ConfigProperty.key("hoodie.datasource.write.payload.class").defaultValue(OverwriteWithLatestAvroPayload.class.getName()).withDocumentation("Payload class used. Override this, if you like to roll your own merge logic, when upserting/inserting. This will render any value set for PRECOMBINE_FIELD_OPT_VAL in-effective");
    public static final ConfigProperty<String> KEYGENERATOR_CLASS_NAME = ConfigProperty.key("hoodie.datasource.write.keygenerator.class").noDefaultValue().withDocumentation("Key generator class, that implements `org.apache.hudi.keygen.KeyGenerator` extract a key out of incoming records.");
    public static final ConfigProperty<String> KEYGENERATOR_TYPE = ConfigProperty.key("hoodie.datasource.write.keygenerator.type").defaultValue(KeyGeneratorType.SIMPLE.name()).withDocumentation("Easily configure one the built-in key generators, instead of specifying the key generator class.Currently supports SIMPLE, COMPLEX, TIMESTAMP, CUSTOM, NON_PARTITION, GLOBAL_DELETE");
    public static final ConfigProperty<String> ROLLBACK_USING_MARKERS_ENABLE = ConfigProperty.key("hoodie.rollback.using.markers").defaultValue("true").withDocumentation("Enables a more efficient mechanism for rollbacks based on the marker files generated during the writes. Turned on by default.");
    public static final ConfigProperty<String> TIMELINE_LAYOUT_VERSION_NUM = ConfigProperty.key("hoodie.timeline.layout.version").defaultValue(Integer.toString(TimelineLayoutVersion.VERSION_1)).sinceVersion("0.5.1").withDocumentation("Controls the layout of the timeline. Version 0 relied on renames, Version 1 (default) models the timeline as an immutable log relying only on atomic writes for object storage.");
    public static final ConfigProperty<HoodieFileFormat> BASE_FILE_FORMAT = ConfigProperty.key("hoodie.table.base.file.format").defaultValue(HoodieFileFormat.PARQUET).withAlternatives("hoodie.table.ro.file.format").withDocumentation("");
    public static final ConfigProperty<String> BASE_PATH = ConfigProperty.key("hoodie.base.path").noDefaultValue().withDocumentation("Base path on lake storage, under which all the table data is stored. Always prefix it explicitly with the storage scheme (e.g hdfs://, s3:// etc). Hudi stores all the main meta-data about commits, savepoints, cleaning audit logs etc in .hoodie directory under this base path directory.");
    public static final ConfigProperty<String> AVRO_SCHEMA_STRING = ConfigProperty.key("hoodie.avro.schema").noDefaultValue().withDocumentation("Schema string representing the current write schema of the table. Hudi passes this to implementations of HoodieRecordPayload to convert incoming records to avro. This is also used as the write schema evolving records during an update.");
    public static final ConfigProperty<String> INTERNAL_SCHEMA_STRING = ConfigProperty.key("hoodie.internal.schema").noDefaultValue().withDocumentation("Schema string representing the latest schema of the table. Hudi passes this to implementations of evolution of schema");
    public static final ConfigProperty<Boolean> SCHEMA_EVOLUTION_ENABLE = ConfigProperty.key("hoodie.schema.on.read.enable").defaultValue(false).withDocumentation("enable full schema evolution for hoodie");
    public static final ConfigProperty<Boolean> ENABLE_INTERNAL_SCHEMA_CACHE = ConfigProperty.key("hoodie.schema.cache.enable").defaultValue(false).withDocumentation("cache query internalSchemas in driver/executor side");
    public static final ConfigProperty<String> AVRO_SCHEMA_VALIDATE_ENABLE = ConfigProperty.key("hoodie.avro.schema.validate").defaultValue("false").withDocumentation("Validate the schema used for the write against the latest schema, for backwards compatibility.");
    public static final ConfigProperty<String> INSERT_PARALLELISM_VALUE = ConfigProperty.key("hoodie.insert.shuffle.parallelism").defaultValue("200").withDocumentation("Parallelism for inserting records into the table. Inserts can shuffle data before writing to tune file sizes and optimize the storage layout.");
    public static final ConfigProperty<String> BULKINSERT_PARALLELISM_VALUE = ConfigProperty.key("hoodie.bulkinsert.shuffle.parallelism").defaultValue("200").withDocumentation("For large initial imports using bulk_insert operation, controls the parallelism to use for sort modes or custom partitioning donebefore writing records to the table.");
    public static final ConfigProperty<String> BULKINSERT_USER_DEFINED_PARTITIONER_SORT_COLUMNS = ConfigProperty.key("hoodie.bulkinsert.user.defined.partitioner.sort.columns").noDefaultValue().withDocumentation("Columns to sort the data by when use org.apache.hudi.execution.bulkinsert.RDDCustomColumnsSortPartitioner as user defined partitioner during bulk_insert. For example 'column1,column2'");
    public static final ConfigProperty<String> BULKINSERT_USER_DEFINED_PARTITIONER_CLASS_NAME = ConfigProperty.key("hoodie.bulkinsert.user.defined.partitioner.class").noDefaultValue().withDocumentation("If specified, this class will be used to re-partition records before they are bulk inserted. This can be used to sort, pack, cluster data optimally for common query patterns. For now we support a build-in user defined bulkinsert partitioner org.apache.hudi.execution.bulkinsert.RDDCustomColumnsSortPartitioner which can does sorting based on specified column values set by " + BULKINSERT_USER_DEFINED_PARTITIONER_SORT_COLUMNS.key());
    public static final ConfigProperty<String> UPSERT_PARALLELISM_VALUE = ConfigProperty.key("hoodie.upsert.shuffle.parallelism").defaultValue("200").withDocumentation("Parallelism to use for upsert operation on the table. Upserts can shuffle data to perform index lookups, file sizing, bin packing records optimallyinto file groups.");
    public static final ConfigProperty<String> DELETE_PARALLELISM_VALUE = ConfigProperty.key("hoodie.delete.shuffle.parallelism").defaultValue("200").withDocumentation("Parallelism used for \u201cdelete\u201d operation. Delete operations also performs shuffles, similar to upsert operation.");
    public static final ConfigProperty<String> ROLLBACK_PARALLELISM_VALUE = ConfigProperty.key("hoodie.rollback.parallelism").defaultValue("100").withDocumentation("Parallelism for rollback of commits. Rollbacks perform delete of files or logging delete blocks to file groups on storage in parallel.");
    public static final ConfigProperty<String> WRITE_BUFFER_LIMIT_BYTES_VALUE = ConfigProperty.key("hoodie.write.buffer.limit.bytes").defaultValue(String.valueOf(0x400000)).withDocumentation("Size of in-memory buffer used for parallelizing network reads and lake storage writes.");
    public static final ConfigProperty<String> COMBINE_BEFORE_INSERT = ConfigProperty.key("hoodie.combine.before.insert").defaultValue("false").withDocumentation("When inserted records share same key, controls whether they should be first combined (i.e de-duplicated) before writing to storage.");
    public static final ConfigProperty<String> COMBINE_BEFORE_UPSERT = ConfigProperty.key("hoodie.combine.before.upsert").defaultValue("true").withDocumentation("When upserted records share same key, controls whether they should be first combined (i.e de-duplicated) before writing to storage. This should be turned off only if you are absolutely certain that there are no duplicates incoming,  otherwise it can lead to duplicate keys and violate the uniqueness guarantees.");
    public static final ConfigProperty<String> COMBINE_BEFORE_DELETE = ConfigProperty.key("hoodie.combine.before.delete").defaultValue("true").withDocumentation("During delete operations, controls whether we should combine deletes (and potentially also upserts) before  writing to storage.");
    public static final ConfigProperty<String> WRITE_STATUS_STORAGE_LEVEL_VALUE = ConfigProperty.key("hoodie.write.status.storage.level").defaultValue("MEMORY_AND_DISK_SER").withDocumentation("Write status objects hold metadata about a write (stats, errors), that is not yet committed to storage. This controls the how that information is cached for inspection by clients. We rarely expect this to be changed.");
    public static final ConfigProperty<String> AUTO_COMMIT_ENABLE = ConfigProperty.key("hoodie.auto.commit").defaultValue("true").withDocumentation("Controls whether a write operation should auto commit. This can be turned off to perform inspection of the uncommitted write before deciding to commit.");
    public static final ConfigProperty<String> WRITE_STATUS_CLASS_NAME = ConfigProperty.key("hoodie.writestatus.class").defaultValue(WriteStatus.class.getName()).withDocumentation("Subclass of " + WriteStatus.class.getName() + " to be used to collect information about a write. Can be overridden to collection additional metrics/statistics about the data if needed.");
    public static final ConfigProperty<String> FINALIZE_WRITE_PARALLELISM_VALUE = ConfigProperty.key("hoodie.finalize.write.parallelism").defaultValue("200").withDocumentation("Parallelism for the write finalization internal operation, which involves removing any partially written files from lake storage, before committing the write. Reduce this value, if the high number of tasks incur delays for smaller tables or low latency writes.");
    public static final ConfigProperty<String> MARKERS_TYPE = ConfigProperty.key("hoodie.write.markers.type").defaultValue(MarkerType.TIMELINE_SERVER_BASED.toString()).sinceVersion("0.9.0").withDocumentation("Marker type to use.  Two modes are supported: - DIRECT: individual marker file corresponding to each data file is directly created by the writer. - TIMELINE_SERVER_BASED: marker operations are all handled at the timeline service which serves as a proxy.  New marker entries are batch processed and stored in a limited number of underlying files for efficiency.  If HDFS is used or timeline server is disabled, DIRECT markers are used as fallback even if this is configure.  For Spark structured streaming, this configuration does not take effect, i.e., DIRECT markers are always used for Spark structured streaming.");
    public static final ConfigProperty<Integer> MARKERS_TIMELINE_SERVER_BASED_BATCH_NUM_THREADS = ConfigProperty.key("hoodie.markers.timeline_server_based.batch.num_threads").defaultValue(20).sinceVersion("0.9.0").withDocumentation("Number of threads to use for batch processing marker creation requests at the timeline server");
    public static final ConfigProperty<Long> MARKERS_TIMELINE_SERVER_BASED_BATCH_INTERVAL_MS = ConfigProperty.key("hoodie.markers.timeline_server_based.batch.interval_ms").defaultValue(50L).sinceVersion("0.9.0").withDocumentation("The batch interval in milliseconds for marker creation batch processing");
    public static final ConfigProperty<String> MARKERS_DELETE_PARALLELISM_VALUE = ConfigProperty.key("hoodie.markers.delete.parallelism").defaultValue("100").withDocumentation("Determines the parallelism for deleting marker files, which are used to track all files (valid or invalid/partial) written during a write operation. Increase this value if delays are observed, with large batch writes.");
    public static final ConfigProperty<String> BULK_INSERT_SORT_MODE = ConfigProperty.key("hoodie.bulkinsert.sort.mode").defaultValue(BulkInsertSortMode.GLOBAL_SORT.toString()).withDocumentation("Sorting modes to use for sorting records for bulk insert. This is use when user " + BULKINSERT_USER_DEFINED_PARTITIONER_CLASS_NAME.key() + "is not configured. Available values are - GLOBAL_SORT: this ensures best file sizes, with lowest memory overhead at cost of sorting. PARTITION_SORT: Strikes a balance by only sorting within a partition, still keeping the memory overhead of writing lowest and best effort file sizing. NONE: No sorting. Fastest and matches `spark.write.parquet()` in terms of number of files, overheads");
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_SERVER_ENABLE = ConfigProperty.key("hoodie.embed.timeline.server").defaultValue("true").withDocumentation("When true, spins up an instance of the timeline server (meta server that serves cached file listings, statistics),running on each writer's driver process, accepting requests during the write from executors.");
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_SERVER_REUSE_ENABLED = ConfigProperty.key("hoodie.embed.timeline.server.reuse.enabled").defaultValue("false").withDocumentation("Controls whether the timeline server instance should be cached and reused across the JVM (across task lifecycles)to avoid startup costs. This should rarely be changed.");
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_SERVER_PORT_NUM = ConfigProperty.key("hoodie.embed.timeline.server.port").defaultValue("0").withDocumentation("Port at which the timeline server listens for requests. When running embedded in each writer, it picks a free port and communicates to all the executors. This should rarely be changed.");
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_NUM_SERVER_THREADS = ConfigProperty.key("hoodie.embed.timeline.server.threads").defaultValue("-1").withDocumentation("Number of threads to serve requests in the timeline server. By default, auto configured based on the number of underlying cores.");
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_SERVER_COMPRESS_ENABLE = ConfigProperty.key("hoodie.embed.timeline.server.gzip").defaultValue("true").withDocumentation("Controls whether gzip compression is used, for large responses from the timeline server, to improve latency.");
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_SERVER_USE_ASYNC_ENABLE = ConfigProperty.key("hoodie.embed.timeline.server.async").defaultValue("false").withDocumentation("Controls whether or not, the requests to the timeline server are processed in asynchronous fashion, potentially improving throughput.");
    public static final ConfigProperty<String> FAIL_ON_TIMELINE_ARCHIVING_ENABLE = ConfigProperty.key("hoodie.fail.on.timeline.archiving").defaultValue("true").withDocumentation("Timeline archiving removes older instants from the timeline, after each write operation, to minimize metadata overhead. Controls whether or not, the write should be failed as well, if such archiving fails.");
    public static final ConfigProperty<Boolean> REFRESH_TIMELINE_SERVER_BASED_ON_LATEST_COMMIT = ConfigProperty.key("hoodie.refresh.timeline.server.based.on.latest.commit").defaultValue(false).withDocumentation("Refresh timeline in timeline server based on latest commit apart from timeline hash difference. By default (false), ");
    public static final ConfigProperty<Long> INITIAL_CONSISTENCY_CHECK_INTERVAL_MS = ConfigProperty.key("hoodie.consistency.check.initial_interval_ms").defaultValue(2000L).withDocumentation("Initial time between successive attempts to ensure written data's metadata is consistent on storage. Grows with exponential backoff after the initial value.");
    public static final ConfigProperty<Long> MAX_CONSISTENCY_CHECK_INTERVAL_MS = ConfigProperty.key("hoodie.consistency.check.max_interval_ms").defaultValue(300000L).withDocumentation("Max time to wait between successive attempts at performing consistency checks");
    public static final ConfigProperty<Integer> MAX_CONSISTENCY_CHECKS = ConfigProperty.key("hoodie.consistency.check.max_checks").defaultValue(7).withDocumentation("Maximum number of checks, for consistency of written data.");
    public static final ConfigProperty<String> MERGE_DATA_VALIDATION_CHECK_ENABLE = ConfigProperty.key("hoodie.merge.data.validation.enabled").defaultValue("false").withDocumentation("When enabled, data validation checks are performed during merges to ensure expected number of records after merge operation.");
    public static final ConfigProperty<String> MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE = ConfigProperty.key("hoodie.merge.allow.duplicate.on.inserts").defaultValue("false").withDocumentation("When enabled, we allow duplicate keys even if inserts are routed to merge with an existing file (for ensuring file sizing). This is only relevant for insert operation, since upsert, delete operations will ensure unique key constraints are maintained.");
    public static final ConfigProperty<Integer> MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT = ConfigProperty.key("hoodie.merge.small.file.group.candidates.limit").defaultValue(1).withDocumentation("Limits number of file groups, whose base file satisfies small-file limit, to consider for appending records during upsert operation. Only applicable to MOR tables");
    public static final ConfigProperty<Integer> CLIENT_HEARTBEAT_INTERVAL_IN_MS = ConfigProperty.key("hoodie.client.heartbeat.interval_in_ms").defaultValue(60000).withDocumentation("Writers perform heartbeats to indicate liveness. Controls how often (in ms), such heartbeats are registered to lake storage.");
    public static final ConfigProperty<Integer> CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES = ConfigProperty.key("hoodie.client.heartbeat.tolerable.misses").defaultValue(2).withDocumentation("Number of heartbeat misses, before a writer is deemed not alive and all pending writes are aborted.");
    public static final ConfigProperty<String> WRITE_CONCURRENCY_MODE = ConfigProperty.key("hoodie.write.concurrency.mode").defaultValue(WriteConcurrencyMode.SINGLE_WRITER.name()).withDocumentation("Enable different concurrency modes. Options are SINGLE_WRITER: Only one active writer to the table. Maximizes throughputOPTIMISTIC_CONCURRENCY_CONTROL: Multiple writers can operate on the table and exactly one of them succeed if a conflict (writes affect the same file group) is detected.");
    public static final ConfigProperty<String> WRITE_SCHEMA = ConfigProperty.key("hoodie.write.schema").noDefaultValue().withDocumentation("The specified write schema. In most case, we do not need set this parameter, but for the case the write schema is not equal to the specified table schema, we can specify the write schema by this parameter. Used by MergeIntoHoodieTableCommand");
    public static final ConfigProperty<String> ALLOW_MULTI_WRITE_ON_SAME_INSTANT_ENABLE = ConfigProperty.key("_.hoodie.allow.multi.write.on.same.instant").defaultValue("false").withDocumentation("");
    public static final ConfigProperty<String> AVRO_EXTERNAL_SCHEMA_TRANSFORMATION_ENABLE = ConfigProperty.key(AVRO_SCHEMA_STRING.key() + ".external.transformation").defaultValue("false").withAlternatives(AVRO_SCHEMA_STRING.key() + ".externalTransformation").withDocumentation("When enabled, records in older schema are rewritten into newer schema during upsert,delete and background compaction,clustering operations.");
    public static final ConfigProperty<Boolean> ALLOW_EMPTY_COMMIT = ConfigProperty.key("hoodie.allow.empty.commit").defaultValue(true).withDocumentation("Whether to allow generation of empty commits, even if no data was written in the commit. It's useful in cases where extra metadata needs to be published regardless e.g tracking source offsets when ingesting data");
    public static final ConfigProperty<Boolean> ALLOW_OPERATION_METADATA_FIELD = ConfigProperty.key("hoodie.allow.operation.metadata.field").defaultValue(false).sinceVersion("0.9.0").withDocumentation("Whether to include '_hoodie_operation' in the metadata fields. Once enabled, all the changes of a record are persisted to the delta log directly without merge");
    public static final ConfigProperty<String> FILEID_PREFIX_PROVIDER_CLASS = ConfigProperty.key("hoodie.fileid.prefix.provider.class").defaultValue(RandomFileIdPrefixProvider.class.getName()).sinceVersion("0.10.0").withDocumentation("File Id Prefix provider class, that implements `org.apache.hudi.fileid.FileIdPrefixProvider`");
    public static final ConfigProperty<Boolean> TABLE_SERVICES_ENABLED = ConfigProperty.key("hoodie.table.services.enabled").defaultValue(true).sinceVersion("0.11.0").withDocumentation("Master control to disable all table services including archive, clean, compact, cluster, etc.");
    public static final ConfigProperty<Boolean> RELEASE_RESOURCE_ENABLE = ConfigProperty.key("hoodie.release.resource.on.completion.enable").defaultValue(true).sinceVersion("0.11.0").withDocumentation("Control to enable release all persist rdds when the spark job finish.");
    public static final ConfigProperty<Boolean> AUTO_ADJUST_LOCK_CONFIGS = ConfigProperty.key("hoodie.auto.adjust.lock.configs").defaultValue(false).sinceVersion("0.11.0").withDocumentation("Auto adjust lock configurations when metadata table is enabled and for async table services.");
    private ConsistencyGuardConfig consistencyGuardConfig;
    private FileSystemRetryConfig fileSystemRetryConfig;
    private final FileSystemViewStorageConfig clientSpecifiedViewStorageConfig;
    private FileSystemViewStorageConfig viewStorageConfig;
    private HoodiePayloadConfig hoodiePayloadConfig;
    private HoodieMetadataConfig metadataConfig;
    private HoodieCommonConfig commonConfig;
    private EngineType engineType;
    @Deprecated
    public static final String TABLE_NAME = TBL_NAME.key();
    @Deprecated
    public static final String PRECOMBINE_FIELD_PROP = PRECOMBINE_FIELD_NAME.key();
    @Deprecated
    public static final String WRITE_PAYLOAD_CLASS = WRITE_PAYLOAD_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_WRITE_PAYLOAD_CLASS = WRITE_PAYLOAD_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String KEYGENERATOR_CLASS_PROP = KEYGENERATOR_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_KEYGENERATOR_CLASS = SimpleAvroKeyGenerator.class.getName();
    @Deprecated
    public static final String DEFAULT_ROLLBACK_USING_MARKERS = ROLLBACK_USING_MARKERS_ENABLE.defaultValue();
    @Deprecated
    public static final String ROLLBACK_USING_MARKERS = ROLLBACK_USING_MARKERS_ENABLE.key();
    @Deprecated
    public static final String TIMELINE_LAYOUT_VERSION = TIMELINE_LAYOUT_VERSION_NUM.key();
    @Deprecated
    public static final String BASE_PATH_PROP = BASE_PATH.key();
    @Deprecated
    public static final String AVRO_SCHEMA = AVRO_SCHEMA_STRING.key();
    @Deprecated
    public static final String AVRO_SCHEMA_VALIDATE = AVRO_SCHEMA_VALIDATE_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_AVRO_SCHEMA_VALIDATE = AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue();
    @Deprecated
    public static final String DEFAULT_PARALLELISM = INSERT_PARALLELISM_VALUE.defaultValue();
    @Deprecated
    public static final String INSERT_PARALLELISM = INSERT_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String BULKINSERT_PARALLELISM = BULKINSERT_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String BULKINSERT_USER_DEFINED_PARTITIONER_CLASS = BULKINSERT_USER_DEFINED_PARTITIONER_CLASS_NAME.key();
    @Deprecated
    public static final String BULKINSERT_INPUT_DATA_SCHEMA_DDL = "hoodie.bulkinsert.schema.ddl";
    @Deprecated
    public static final String UPSERT_PARALLELISM = UPSERT_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String DELETE_PARALLELISM = DELETE_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String DEFAULT_ROLLBACK_PARALLELISM = ROLLBACK_PARALLELISM_VALUE.defaultValue();
    @Deprecated
    public static final String ROLLBACK_PARALLELISM = ROLLBACK_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String WRITE_BUFFER_LIMIT_BYTES = WRITE_BUFFER_LIMIT_BYTES_VALUE.key();
    @Deprecated
    public static final String DEFAULT_WRITE_BUFFER_LIMIT_BYTES = WRITE_BUFFER_LIMIT_BYTES_VALUE.defaultValue();
    @Deprecated
    public static final String COMBINE_BEFORE_INSERT_PROP = COMBINE_BEFORE_INSERT.key();
    @Deprecated
    public static final String DEFAULT_COMBINE_BEFORE_INSERT = COMBINE_BEFORE_INSERT.defaultValue();
    @Deprecated
    public static final String COMBINE_BEFORE_UPSERT_PROP = COMBINE_BEFORE_UPSERT.key();
    @Deprecated
    public static final String DEFAULT_COMBINE_BEFORE_UPSERT = COMBINE_BEFORE_UPSERT.defaultValue();
    @Deprecated
    public static final String COMBINE_BEFORE_DELETE_PROP = COMBINE_BEFORE_DELETE.key();
    @Deprecated
    public static final String DEFAULT_COMBINE_BEFORE_DELETE = COMBINE_BEFORE_DELETE.defaultValue();
    @Deprecated
    public static final String WRITE_STATUS_STORAGE_LEVEL = WRITE_STATUS_STORAGE_LEVEL_VALUE.key();
    @Deprecated
    public static final String DEFAULT_WRITE_STATUS_STORAGE_LEVEL = WRITE_STATUS_STORAGE_LEVEL_VALUE.defaultValue();
    @Deprecated
    public static final String HOODIE_AUTO_COMMIT_PROP = AUTO_COMMIT_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_HOODIE_AUTO_COMMIT = AUTO_COMMIT_ENABLE.defaultValue();
    @Deprecated
    public static final String HOODIE_WRITE_STATUS_CLASS_PROP = WRITE_STATUS_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_HOODIE_WRITE_STATUS_CLASS = WRITE_STATUS_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String FINALIZE_WRITE_PARALLELISM = FINALIZE_WRITE_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String DEFAULT_FINALIZE_WRITE_PARALLELISM = FINALIZE_WRITE_PARALLELISM_VALUE.defaultValue();
    @Deprecated
    public static final String MARKERS_DELETE_PARALLELISM = MARKERS_DELETE_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String DEFAULT_MARKERS_DELETE_PARALLELISM = MARKERS_DELETE_PARALLELISM_VALUE.defaultValue();
    @Deprecated
    public static final String BULKINSERT_SORT_MODE = BULK_INSERT_SORT_MODE.key();
    @Deprecated
    public static final String DEFAULT_BULKINSERT_SORT_MODE = BULK_INSERT_SORT_MODE.defaultValue();
    @Deprecated
    public static final String EMBEDDED_TIMELINE_SERVER_ENABLED = EMBEDDED_TIMELINE_SERVER_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_ENABLED = EMBEDDED_TIMELINE_SERVER_ENABLE.defaultValue();
    @Deprecated
    public static final String EMBEDDED_TIMELINE_SERVER_PORT = EMBEDDED_TIMELINE_SERVER_PORT_NUM.key();
    @Deprecated
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_PORT = EMBEDDED_TIMELINE_SERVER_PORT_NUM.defaultValue();
    @Deprecated
    public static final String EMBEDDED_TIMELINE_SERVER_THREADS = EMBEDDED_TIMELINE_NUM_SERVER_THREADS.key();
    @Deprecated
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_THREADS = EMBEDDED_TIMELINE_NUM_SERVER_THREADS.defaultValue();
    @Deprecated
    public static final String EMBEDDED_TIMELINE_SERVER_COMPRESS_OUTPUT = EMBEDDED_TIMELINE_SERVER_COMPRESS_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_EMBEDDED_TIMELINE_COMPRESS_OUTPUT = EMBEDDED_TIMELINE_SERVER_COMPRESS_ENABLE.defaultValue();
    @Deprecated
    public static final String EMBEDDED_TIMELINE_SERVER_USE_ASYNC = EMBEDDED_TIMELINE_SERVER_USE_ASYNC_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_ASYNC = EMBEDDED_TIMELINE_SERVER_USE_ASYNC_ENABLE.defaultValue();
    @Deprecated
    public static final String FAIL_ON_TIMELINE_ARCHIVING_ENABLED_PROP = FAIL_ON_TIMELINE_ARCHIVING_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_FAIL_ON_TIMELINE_ARCHIVING_ENABLED = FAIL_ON_TIMELINE_ARCHIVING_ENABLE.defaultValue();
    @Deprecated
    public static final String INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP = INITIAL_CONSISTENCY_CHECK_INTERVAL_MS.key();
    @Deprecated
    public static long DEFAULT_INITIAL_CONSISTENCY_CHECK_INTERVAL_MS = INITIAL_CONSISTENCY_CHECK_INTERVAL_MS.defaultValue();
    @Deprecated
    public static final String MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP = MAX_CONSISTENCY_CHECK_INTERVAL_MS.key();
    @Deprecated
    public static long DEFAULT_MAX_CONSISTENCY_CHECK_INTERVAL_MS = MAX_CONSISTENCY_CHECK_INTERVAL_MS.defaultValue();
    @Deprecated
    public static final String MAX_CONSISTENCY_CHECKS_PROP = MAX_CONSISTENCY_CHECKS.key();
    @Deprecated
    public static int DEFAULT_MAX_CONSISTENCY_CHECKS = MAX_CONSISTENCY_CHECKS.defaultValue();
    @Deprecated
    private static final String MERGE_DATA_VALIDATION_CHECK_ENABLED = MERGE_DATA_VALIDATION_CHECK_ENABLE.key();
    @Deprecated
    private static final String DEFAULT_MERGE_DATA_VALIDATION_CHECK_ENABLED = MERGE_DATA_VALIDATION_CHECK_ENABLE.defaultValue();
    @Deprecated
    private static final String MERGE_ALLOW_DUPLICATE_ON_INSERTS = MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE.key();
    @Deprecated
    private static final String DEFAULT_MERGE_ALLOW_DUPLICATE_ON_INSERTS = MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE.defaultValue();
    @Deprecated
    public static final String CLIENT_HEARTBEAT_INTERVAL_IN_MS_PROP = CLIENT_HEARTBEAT_INTERVAL_IN_MS.key();
    @Deprecated
    public static final Integer DEFAULT_CLIENT_HEARTBEAT_INTERVAL_IN_MS = CLIENT_HEARTBEAT_INTERVAL_IN_MS.defaultValue();
    @Deprecated
    public static final String CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES_PROP = CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES.key();
    @Deprecated
    public static final Integer DEFAULT_CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES = CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES.defaultValue();
    @Deprecated
    public static final String WRITE_CONCURRENCY_MODE_PROP = WRITE_CONCURRENCY_MODE.key();
    @Deprecated
    public static final String DEFAULT_WRITE_CONCURRENCY_MODE = WRITE_CONCURRENCY_MODE.defaultValue();
    @Deprecated
    public static final String ALLOW_MULTI_WRITE_ON_SAME_INSTANT = ALLOW_MULTI_WRITE_ON_SAME_INSTANT_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_ALLOW_MULTI_WRITE_ON_SAME_INSTANT = ALLOW_MULTI_WRITE_ON_SAME_INSTANT_ENABLE.defaultValue();
    @Deprecated
    public static final String EXTERNAL_RECORD_AND_SCHEMA_TRANSFORMATION = AVRO_EXTERNAL_SCHEMA_TRANSFORMATION_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_EXTERNAL_RECORD_AND_SCHEMA_TRANSFORMATION = AVRO_EXTERNAL_SCHEMA_TRANSFORMATION_ENABLE.defaultValue();

    protected HoodieWriteConfig() {
        this.engineType = EngineType.SPARK;
        this.clientSpecifiedViewStorageConfig = null;
    }

    protected HoodieWriteConfig(EngineType engineType, Properties props) {
        super(props);
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)props);
        this.engineType = engineType;
        this.consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().fromProperties(newProps).build();
        this.fileSystemRetryConfig = FileSystemRetryConfig.newBuilder().fromProperties(newProps).build();
        this.viewStorageConfig = this.clientSpecifiedViewStorageConfig = FileSystemViewStorageConfig.newBuilder().fromProperties(newProps).build();
        this.hoodiePayloadConfig = HoodiePayloadConfig.newBuilder().fromProperties(newProps).build();
        this.metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(props).build();
        this.commonConfig = HoodieCommonConfig.newBuilder().fromProperties(props).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBasePath() {
        return this.getString(BASE_PATH);
    }

    public String getSchema() {
        return this.getString(AVRO_SCHEMA_STRING);
    }

    public void setSchema(String schemaStr) {
        this.setValue(AVRO_SCHEMA_STRING, schemaStr);
    }

    public String getInternalSchema() {
        return this.getString(INTERNAL_SCHEMA_STRING);
    }

    public boolean getInternalSchemaCacheEnable() {
        return this.getBoolean(ENABLE_INTERNAL_SCHEMA_CACHE);
    }

    public void setInternalSchemaString(String internalSchemaString) {
        this.setValue(INTERNAL_SCHEMA_STRING, internalSchemaString);
    }

    public void setInternalSchemaCacheEnable(boolean enable) {
        this.setValue(ENABLE_INTERNAL_SCHEMA_CACHE, String.valueOf(enable));
    }

    public boolean getSchemaEvolutionEnable() {
        return this.getBoolean(SCHEMA_EVOLUTION_ENABLE);
    }

    public void setSchemaEvolutionEnable(boolean enable) {
        this.setValue(SCHEMA_EVOLUTION_ENABLE, String.valueOf(enable));
    }

    public String getWriteSchema() {
        if (this.props.containsKey(WRITE_SCHEMA.key())) {
            return this.getString(WRITE_SCHEMA);
        }
        return this.getSchema();
    }

    public boolean getAvroSchemaValidate() {
        return this.getBoolean(AVRO_SCHEMA_VALIDATE_ENABLE);
    }

    public String getTableName() {
        return this.getString(TBL_NAME);
    }

    public HoodieTableType getTableType() {
        return HoodieTableType.valueOf(this.getStringOrDefault(HoodieTableConfig.TYPE, HoodieTableConfig.TYPE.defaultValue().name()).toUpperCase());
    }

    public String getPreCombineField() {
        return this.getString(PRECOMBINE_FIELD_NAME);
    }

    public String getWritePayloadClass() {
        return this.getString(WRITE_PAYLOAD_CLASS_NAME);
    }

    public String getKeyGeneratorClass() {
        return this.getString(KEYGENERATOR_CLASS_NAME);
    }

    public boolean isConsistentLogicalTimestampEnabled() {
        return this.getBooleanOrDefault(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED);
    }

    public Boolean shouldAutoCommit() {
        return this.getBoolean(AUTO_COMMIT_ENABLE);
    }

    public Boolean shouldAssumeDatePartitioning() {
        return this.metadataConfig.shouldAssumeDatePartitioning();
    }

    public boolean shouldUseExternalSchemaTransformation() {
        return this.getBoolean(AVRO_EXTERNAL_SCHEMA_TRANSFORMATION_ENABLE);
    }

    public Integer getTimelineLayoutVersion() {
        return this.getInt(TIMELINE_LAYOUT_VERSION_NUM);
    }

    public int getBulkInsertShuffleParallelism() {
        return this.getInt(BULKINSERT_PARALLELISM_VALUE);
    }

    public String getUserDefinedBulkInsertPartitionerClass() {
        return this.getString(BULKINSERT_USER_DEFINED_PARTITIONER_CLASS_NAME);
    }

    public String getUserDefinedBulkInsertPartitionerSortColumns() {
        return this.getString(BULKINSERT_USER_DEFINED_PARTITIONER_SORT_COLUMNS);
    }

    public int getInsertShuffleParallelism() {
        return this.getInt(INSERT_PARALLELISM_VALUE);
    }

    public int getUpsertShuffleParallelism() {
        return this.getInt(UPSERT_PARALLELISM_VALUE);
    }

    public int getDeleteShuffleParallelism() {
        return Math.max(this.getInt(DELETE_PARALLELISM_VALUE), 1);
    }

    public int getRollbackParallelism() {
        return this.getInt(ROLLBACK_PARALLELISM_VALUE);
    }

    public int getFileListingParallelism() {
        return this.metadataConfig.getFileListingParallelism();
    }

    public boolean shouldRollbackUsingMarkers() {
        return this.getBoolean(ROLLBACK_USING_MARKERS_ENABLE);
    }

    public int getWriteBufferLimitBytes() {
        return Integer.parseInt(this.getStringOrDefault(WRITE_BUFFER_LIMIT_BYTES_VALUE));
    }

    public boolean shouldCombineBeforeInsert() {
        return this.getBoolean(COMBINE_BEFORE_INSERT);
    }

    public boolean shouldCombineBeforeUpsert() {
        return this.getBoolean(COMBINE_BEFORE_UPSERT);
    }

    public boolean shouldCombineBeforeDelete() {
        return this.getBoolean(COMBINE_BEFORE_DELETE);
    }

    public boolean shouldAllowMultiWriteOnSameInstant() {
        return this.getBoolean(ALLOW_MULTI_WRITE_ON_SAME_INSTANT_ENABLE);
    }

    public String getWriteStatusClassName() {
        return this.getString(WRITE_STATUS_CLASS_NAME);
    }

    public int getFinalizeWriteParallelism() {
        return this.getInt(FINALIZE_WRITE_PARALLELISM_VALUE);
    }

    public MarkerType getMarkersType() {
        String markerType = this.getString(MARKERS_TYPE);
        return MarkerType.valueOf(markerType.toUpperCase());
    }

    public int getMarkersTimelineServerBasedBatchNumThreads() {
        return this.getInt(MARKERS_TIMELINE_SERVER_BASED_BATCH_NUM_THREADS);
    }

    public long getMarkersTimelineServerBasedBatchIntervalMs() {
        return this.getLong(MARKERS_TIMELINE_SERVER_BASED_BATCH_INTERVAL_MS);
    }

    public int getMarkersDeleteParallelism() {
        return this.getInt(MARKERS_DELETE_PARALLELISM_VALUE);
    }

    public boolean isEmbeddedTimelineServerEnabled() {
        return this.getBoolean(EMBEDDED_TIMELINE_SERVER_ENABLE);
    }

    public boolean isEmbeddedTimelineServerReuseEnabled() {
        return Boolean.parseBoolean(this.getStringOrDefault(EMBEDDED_TIMELINE_SERVER_REUSE_ENABLED));
    }

    public int getEmbeddedTimelineServerPort() {
        return Integer.parseInt(this.getStringOrDefault(EMBEDDED_TIMELINE_SERVER_PORT_NUM));
    }

    public int getEmbeddedTimelineServerThreads() {
        return Integer.parseInt(this.getStringOrDefault(EMBEDDED_TIMELINE_NUM_SERVER_THREADS));
    }

    public boolean getEmbeddedTimelineServerCompressOutput() {
        return Boolean.parseBoolean(this.getStringOrDefault(EMBEDDED_TIMELINE_SERVER_COMPRESS_ENABLE));
    }

    public boolean getEmbeddedTimelineServerUseAsync() {
        return Boolean.parseBoolean(this.getStringOrDefault(EMBEDDED_TIMELINE_SERVER_USE_ASYNC_ENABLE));
    }

    public boolean isFailOnTimelineArchivingEnabled() {
        return this.getBoolean(FAIL_ON_TIMELINE_ARCHIVING_ENABLE);
    }

    public boolean isRefreshTimelineServerBasedOnLatestCommit() {
        return this.getBoolean(REFRESH_TIMELINE_SERVER_BASED_ON_LATEST_COMMIT);
    }

    public int getMaxConsistencyChecks() {
        return this.getInt(MAX_CONSISTENCY_CHECKS);
    }

    public int getInitialConsistencyCheckIntervalMs() {
        return this.getInt(INITIAL_CONSISTENCY_CHECK_INTERVAL_MS);
    }

    public int getMaxConsistencyCheckIntervalMs() {
        return this.getInt(MAX_CONSISTENCY_CHECK_INTERVAL_MS);
    }

    public BulkInsertSortMode getBulkInsertSortMode() {
        String sortMode = this.getStringOrDefault(BULK_INSERT_SORT_MODE);
        return BulkInsertSortMode.valueOf(sortMode.toUpperCase());
    }

    public boolean isMergeDataValidationCheckEnabled() {
        return this.getBoolean(MERGE_DATA_VALIDATION_CHECK_ENABLE);
    }

    public boolean allowDuplicateInserts() {
        return this.getBoolean(MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE);
    }

    public int getSmallFileGroupCandidatesLimit() {
        return this.getInt(MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT);
    }

    public EngineType getEngineType() {
        return this.engineType;
    }

    public boolean populateMetaFields() {
        return this.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
    }

    public HoodieCleaningPolicy getCleanerPolicy() {
        return HoodieCleaningPolicy.valueOf(this.getString(HoodieCompactionConfig.CLEANER_POLICY));
    }

    public int getCleanerFileVersionsRetained() {
        return this.getInt(HoodieCompactionConfig.CLEANER_FILE_VERSIONS_RETAINED);
    }

    public int getCleanerCommitsRetained() {
        return this.getInt(HoodieCompactionConfig.CLEANER_COMMITS_RETAINED);
    }

    public int getCleanerHoursRetained() {
        return this.getInt(HoodieCompactionConfig.CLEANER_HOURS_RETAINED);
    }

    public int getMaxCommitsToKeep() {
        return this.getInt(HoodieCompactionConfig.MAX_COMMITS_TO_KEEP);
    }

    public int getMinCommitsToKeep() {
        return this.getInt(HoodieCompactionConfig.MIN_COMMITS_TO_KEEP);
    }

    public int getArchiveMergeFilesBatchSize() {
        return this.getInt(HoodieCompactionConfig.ARCHIVE_MERGE_FILES_BATCH_SIZE);
    }

    public int getParquetSmallFileLimit() {
        return this.getInt(HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT);
    }

    public double getRecordSizeEstimationThreshold() {
        return this.getDouble(HoodieCompactionConfig.RECORD_SIZE_ESTIMATION_THRESHOLD);
    }

    public int getCopyOnWriteInsertSplitSize() {
        return this.getInt(HoodieCompactionConfig.COPY_ON_WRITE_INSERT_SPLIT_SIZE);
    }

    public int getCopyOnWriteRecordSizeEstimate() {
        return this.getInt(HoodieCompactionConfig.COPY_ON_WRITE_RECORD_SIZE_ESTIMATE);
    }

    public boolean allowMultipleCleans() {
        return this.getBoolean(HoodieCompactionConfig.ALLOW_MULTIPLE_CLEANS);
    }

    public boolean shouldAutoTuneInsertSplits() {
        return this.getBoolean(HoodieCompactionConfig.COPY_ON_WRITE_AUTO_SPLIT_INSERTS);
    }

    public int getCleanerParallelism() {
        return this.getInt(HoodieCompactionConfig.CLEANER_PARALLELISM_VALUE);
    }

    public int getCleaningMaxCommits() {
        return this.getInt(HoodieCompactionConfig.CLEAN_MAX_COMMITS);
    }

    public CleaningTriggerStrategy getCleaningTriggerStrategy() {
        return CleaningTriggerStrategy.valueOf(this.getString(HoodieCompactionConfig.CLEAN_TRIGGER_STRATEGY));
    }

    public boolean isAutoClean() {
        return this.getBoolean(HoodieCompactionConfig.AUTO_CLEAN);
    }

    public boolean getArchiveMergeEnable() {
        return this.getBoolean(HoodieCompactionConfig.ARCHIVE_MERGE_ENABLE);
    }

    public long getArchiveMergeSmallFileLimitBytes() {
        return this.getLong(HoodieCompactionConfig.ARCHIVE_MERGE_SMALL_FILE_LIMIT_BYTES);
    }

    public boolean isAutoArchive() {
        return this.getBoolean(HoodieCompactionConfig.AUTO_ARCHIVE);
    }

    public boolean isAsyncArchive() {
        return this.getBoolean(HoodieCompactionConfig.ASYNC_ARCHIVE);
    }

    public boolean isAsyncClean() {
        return this.getBoolean(HoodieCompactionConfig.ASYNC_CLEAN);
    }

    public boolean incrementalCleanerModeEnabled() {
        return this.getBoolean(HoodieCompactionConfig.CLEANER_INCREMENTAL_MODE_ENABLE);
    }

    public boolean inlineCompactionEnabled() {
        return this.getBoolean(HoodieCompactionConfig.INLINE_COMPACT);
    }

    public boolean scheduleInlineCompaction() {
        return this.getBoolean(HoodieCompactionConfig.SCHEDULE_INLINE_COMPACT);
    }

    public CompactionTriggerStrategy getInlineCompactTriggerStrategy() {
        return CompactionTriggerStrategy.valueOf(this.getString(HoodieCompactionConfig.INLINE_COMPACT_TRIGGER_STRATEGY));
    }

    public int getInlineCompactDeltaCommitMax() {
        return this.getInt(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS);
    }

    public int getInlineCompactDeltaSecondsMax() {
        return this.getInt(HoodieCompactionConfig.INLINE_COMPACT_TIME_DELTA_SECONDS);
    }

    public CompactionStrategy getCompactionStrategy() {
        return (CompactionStrategy)ReflectionUtils.loadClass(this.getString(HoodieCompactionConfig.COMPACTION_STRATEGY));
    }

    public Long getTargetIOPerCompactionInMB() {
        return this.getLong(HoodieCompactionConfig.TARGET_IO_PER_COMPACTION_IN_MB);
    }

    public Long getCompactionLogFileSizeThreshold() {
        return this.getLong(HoodieCompactionConfig.COMPACTION_LOG_FILE_SIZE_THRESHOLD);
    }

    public Boolean getCompactionLazyBlockReadEnabled() {
        return this.getBoolean(HoodieCompactionConfig.COMPACTION_LAZY_BLOCK_READ_ENABLE);
    }

    public Boolean getCompactionReverseLogReadEnabled() {
        return this.getBoolean(HoodieCompactionConfig.COMPACTION_REVERSE_LOG_READ_ENABLE);
    }

    public int getArchiveDeleteParallelism() {
        return this.getInt(HoodieCompactionConfig.DELETE_ARCHIVED_INSTANT_PARALLELISM_VALUE);
    }

    public boolean inlineClusteringEnabled() {
        return this.getBoolean(HoodieClusteringConfig.INLINE_CLUSTERING);
    }

    public boolean scheduleInlineClustering() {
        return this.getBoolean(HoodieClusteringConfig.SCHEDULE_INLINE_CLUSTERING);
    }

    public boolean isAsyncClusteringEnabled() {
        return this.getBoolean(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE);
    }

    public boolean isPreserveHoodieCommitMetadataForClustering() {
        return this.getBoolean(HoodieClusteringConfig.PRESERVE_COMMIT_METADATA);
    }

    public boolean isPreserveHoodieCommitMetadataForCompaction() {
        return this.getBoolean(HoodieCompactionConfig.PRESERVE_COMMIT_METADATA);
    }

    public boolean isClusteringEnabled() {
        return this.inlineClusteringEnabled() || this.isAsyncClusteringEnabled();
    }

    public boolean isRollbackPendingClustering() {
        return this.getBoolean(HoodieClusteringConfig.ROLLBACK_PENDING_CLUSTERING_ON_CONFLICT);
    }

    public int getInlineClusterMaxCommits() {
        return this.getInt(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS);
    }

    public int getAsyncClusterMaxCommits() {
        return this.getInt(HoodieClusteringConfig.ASYNC_CLUSTERING_MAX_COMMITS);
    }

    public String getPayloadClass() {
        return this.getString(HoodieCompactionConfig.PAYLOAD_CLASS_NAME);
    }

    public int getTargetPartitionsPerDayBasedCompaction() {
        return this.getInt(HoodieCompactionConfig.TARGET_PARTITIONS_PER_DAYBASED_COMPACTION);
    }

    public int getCommitArchivalBatchSize() {
        return this.getInt(HoodieCompactionConfig.COMMITS_ARCHIVAL_BATCH_SIZE);
    }

    public Boolean shouldCleanBootstrapBaseFile() {
        return this.getBoolean(HoodieCompactionConfig.CLEANER_BOOTSTRAP_BASE_FILE_ENABLE);
    }

    public String getClusteringUpdatesStrategyClass() {
        return this.getString(HoodieClusteringConfig.UPDATES_STRATEGY);
    }

    public HoodieFailedWritesCleaningPolicy getFailedWritesCleanPolicy() {
        return HoodieFailedWritesCleaningPolicy.valueOf(this.getString(HoodieCompactionConfig.FAILED_WRITES_CLEANER_POLICY));
    }

    public String getClusteringPlanStrategyClass() {
        return this.getString(HoodieClusteringConfig.PLAN_STRATEGY_CLASS_NAME);
    }

    public ClusteringPlanPartitionFilterMode getClusteringPlanPartitionFilterMode() {
        String mode = this.getString(HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME);
        return ClusteringPlanPartitionFilterMode.valueOf(mode);
    }

    public String getBeginPartitionForClustering() {
        return this.getString(HoodieClusteringConfig.PARTITION_FILTER_BEGIN_PARTITION);
    }

    public String getEndPartitionForClustering() {
        return this.getString(HoodieClusteringConfig.PARTITION_FILTER_END_PARTITION);
    }

    public String getClusteringExecutionStrategyClass() {
        return this.getString(HoodieClusteringConfig.EXECUTION_STRATEGY_CLASS_NAME);
    }

    public long getClusteringMaxBytesInGroup() {
        return this.getLong(HoodieClusteringConfig.PLAN_STRATEGY_MAX_BYTES_PER_OUTPUT_FILEGROUP);
    }

    public long getClusteringSmallFileLimit() {
        return this.getLong(HoodieClusteringConfig.PLAN_STRATEGY_SMALL_FILE_LIMIT);
    }

    public String getClusteringPartitionSelected() {
        return this.getString(HoodieClusteringConfig.PARTITION_SELECTED);
    }

    public String getClusteringPartitionFilterRegexPattern() {
        return this.getString(HoodieClusteringConfig.PARTITION_REGEX_PATTERN);
    }

    public int getClusteringMaxNumGroups() {
        return this.getInt(HoodieClusteringConfig.PLAN_STRATEGY_MAX_GROUPS);
    }

    public long getClusteringTargetFileMaxBytes() {
        return this.getLong(HoodieClusteringConfig.PLAN_STRATEGY_TARGET_FILE_MAX_BYTES);
    }

    public int getTargetPartitionsForClustering() {
        return this.getInt(HoodieClusteringConfig.DAYBASED_LOOKBACK_PARTITIONS);
    }

    public int getSkipPartitionsFromLatestForClustering() {
        return this.getInt(HoodieClusteringConfig.PLAN_STRATEGY_SKIP_PARTITIONS_FROM_LATEST);
    }

    public String getClusteringSortColumns() {
        return this.getString(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS);
    }

    public HoodieClusteringConfig.LayoutOptimizationStrategy getLayoutOptimizationStrategy() {
        return HoodieClusteringConfig.LayoutOptimizationStrategy.fromValue(this.getStringOrDefault(HoodieClusteringConfig.LAYOUT_OPTIMIZE_STRATEGY));
    }

    public HoodieClusteringConfig.SpatialCurveCompositionStrategyType getLayoutOptimizationCurveBuildMethod() {
        return HoodieClusteringConfig.SpatialCurveCompositionStrategyType.fromValue(this.getString(HoodieClusteringConfig.LAYOUT_OPTIMIZE_SPATIAL_CURVE_BUILD_METHOD));
    }

    public int getLayoutOptimizationSampleSize() {
        return this.getInt(HoodieClusteringConfig.LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE);
    }

    public HoodieIndex.IndexType getIndexType() {
        return HoodieIndex.IndexType.valueOf(this.getString(HoodieIndexConfig.INDEX_TYPE));
    }

    public String getIndexClass() {
        return this.getString(HoodieIndexConfig.INDEX_CLASS_NAME);
    }

    public int getBloomFilterNumEntries() {
        return this.getInt(HoodieIndexConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE);
    }

    public double getBloomFilterFPP() {
        return this.getDouble(HoodieIndexConfig.BLOOM_FILTER_FPP_VALUE);
    }

    public String getHbaseZkQuorum() {
        return this.getString(HoodieHBaseIndexConfig.ZKQUORUM);
    }

    public int getHbaseZkPort() {
        return this.getInt(HoodieHBaseIndexConfig.ZKPORT);
    }

    public String getHBaseZkZnodeParent() {
        return this.getString(HoodieHBaseIndexConfig.ZK_NODE_PATH);
    }

    public String getHbaseTableName() {
        return this.getString(HoodieHBaseIndexConfig.TABLENAME);
    }

    public int getHbaseIndexGetBatchSize() {
        return this.getInt(HoodieHBaseIndexConfig.GET_BATCH_SIZE);
    }

    public Boolean getHBaseIndexRollbackSync() {
        return this.getBoolean(HoodieHBaseIndexConfig.ROLLBACK_SYNC_ENABLE);
    }

    public int getHbaseIndexPutBatchSize() {
        return this.getInt(HoodieHBaseIndexConfig.PUT_BATCH_SIZE);
    }

    public boolean getHbaseIndexPutBatchSizeAutoCompute() {
        return this.getBooleanOrDefault(HoodieHBaseIndexConfig.PUT_BATCH_SIZE_AUTO_COMPUTE);
    }

    public String getHBaseQPSResourceAllocatorClass() {
        return this.getString(HoodieHBaseIndexConfig.QPS_ALLOCATOR_CLASS_NAME);
    }

    public String getHBaseQPSZKnodePath() {
        return this.getString(HoodieHBaseIndexConfig.ZKPATH_QPS_ROOT);
    }

    public String getHBaseZkZnodeSessionTimeout() {
        return this.getString(HoodieHBaseIndexConfig.ZK_SESSION_TIMEOUT_MS);
    }

    public String getHBaseZkZnodeConnectionTimeout() {
        return this.getString(HoodieHBaseIndexConfig.ZK_CONNECTION_TIMEOUT_MS);
    }

    public boolean getHBaseIndexShouldComputeQPSDynamically() {
        return this.getBoolean(HoodieHBaseIndexConfig.COMPUTE_QPS_DYNAMICALLY);
    }

    public int getHBaseIndexDesiredPutsTime() {
        return this.getInt(HoodieHBaseIndexConfig.DESIRED_PUTS_TIME_IN_SECONDS);
    }

    public String getBloomFilterType() {
        return this.getString(HoodieIndexConfig.BLOOM_FILTER_TYPE);
    }

    public int getDynamicBloomFilterMaxNumEntries() {
        return this.getInt(HoodieIndexConfig.BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES);
    }

    public float getHbaseIndexQPSFraction() {
        return this.getFloat(HoodieHBaseIndexConfig.QPS_FRACTION).floatValue();
    }

    public float getHBaseIndexMinQPSFraction() {
        return this.getFloat(HoodieHBaseIndexConfig.MIN_QPS_FRACTION).floatValue();
    }

    public float getHBaseIndexMaxQPSFraction() {
        return this.getFloat(HoodieHBaseIndexConfig.MAX_QPS_FRACTION).floatValue();
    }

    public int getHbaseIndexMaxQPSPerRegionServer() {
        return this.getInt(HoodieHBaseIndexConfig.MAX_QPS_PER_REGION_SERVER);
    }

    public boolean getHbaseIndexUpdatePartitionPath() {
        return this.getBooleanOrDefault(HoodieHBaseIndexConfig.UPDATE_PARTITION_PATH_ENABLE);
    }

    public int getBloomIndexParallelism() {
        return this.getInt(HoodieIndexConfig.BLOOM_INDEX_PARALLELISM);
    }

    public boolean getBloomIndexPruneByRanges() {
        return this.getBoolean(HoodieIndexConfig.BLOOM_INDEX_PRUNE_BY_RANGES);
    }

    public boolean getBloomIndexUseCaching() {
        return this.getBoolean(HoodieIndexConfig.BLOOM_INDEX_USE_CACHING);
    }

    public boolean getBloomIndexUseMetadata() {
        return this.getBooleanOrDefault(HoodieIndexConfig.BLOOM_INDEX_USE_METADATA);
    }

    public boolean useBloomIndexTreebasedFilter() {
        return this.getBoolean(HoodieIndexConfig.BLOOM_INDEX_TREE_BASED_FILTER);
    }

    public boolean useBloomIndexBucketizedChecking() {
        return this.getBoolean(HoodieIndexConfig.BLOOM_INDEX_BUCKETIZED_CHECKING);
    }

    public boolean isMetadataBloomFilterIndexEnabled() {
        return this.isMetadataTableEnabled() && this.getMetadataConfig().isBloomFilterIndexEnabled();
    }

    public boolean isMetadataColumnStatsIndexEnabled() {
        return this.isMetadataTableEnabled() && this.getMetadataConfig().isColumnStatsIndexEnabled();
    }

    public List<String> getColumnsEnabledForColumnStatsIndex() {
        return this.getMetadataConfig().getColumnsEnabledForColumnStatsIndex();
    }

    public List<String> getColumnsEnabledForBloomFilterIndex() {
        return this.getMetadataConfig().getColumnsEnabledForBloomFilterIndex();
    }

    public int getIndexingCheckTimeoutSeconds() {
        return this.getMetadataConfig().getIndexingCheckTimeoutSeconds();
    }

    public int getMetadataBloomFilterIndexParallelism() {
        return this.metadataConfig.getBloomFilterIndexParallelism();
    }

    public int getColumnStatsIndexParallelism() {
        return this.metadataConfig.getColumnStatsIndexParallelism();
    }

    public int getBloomIndexKeysPerBucket() {
        return this.getInt(HoodieIndexConfig.BLOOM_INDEX_KEYS_PER_BUCKET);
    }

    public boolean getBloomIndexUpdatePartitionPath() {
        return this.getBoolean(HoodieIndexConfig.BLOOM_INDEX_UPDATE_PARTITION_PATH_ENABLE);
    }

    public int getSimpleIndexParallelism() {
        return this.getInt(HoodieIndexConfig.SIMPLE_INDEX_PARALLELISM);
    }

    public boolean getSimpleIndexUseCaching() {
        return this.getBoolean(HoodieIndexConfig.SIMPLE_INDEX_USE_CACHING);
    }

    public int getGlobalSimpleIndexParallelism() {
        return this.getInt(HoodieIndexConfig.GLOBAL_SIMPLE_INDEX_PARALLELISM);
    }

    public boolean getGlobalSimpleIndexUpdatePartitionPath() {
        return this.getBoolean(HoodieIndexConfig.SIMPLE_INDEX_UPDATE_PARTITION_PATH_ENABLE);
    }

    public int getBucketIndexNumBuckets() {
        return this.getIntOrDefault(HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS);
    }

    public String getBucketIndexHashField() {
        return this.getString(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD);
    }

    public long getParquetMaxFileSize() {
        return this.getLong(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE);
    }

    public int getParquetBlockSize() {
        return this.getInt(HoodieStorageConfig.PARQUET_BLOCK_SIZE);
    }

    public int getParquetPageSize() {
        return this.getInt(HoodieStorageConfig.PARQUET_PAGE_SIZE);
    }

    public int getLogFileDataBlockMaxSize() {
        return this.getInt(HoodieStorageConfig.LOGFILE_DATA_BLOCK_MAX_SIZE);
    }

    public double getParquetCompressionRatio() {
        return this.getDouble(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION);
    }

    public CompressionCodecName getParquetCompressionCodec() {
        String codecName = this.getString(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME);
        return CompressionCodecName.fromConf((String)(StringUtils.isNullOrEmpty(codecName) ? null : codecName));
    }

    public boolean parquetDictionaryEnabled() {
        return this.getBoolean(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED);
    }

    public String parquetWriteLegacyFormatEnabled() {
        return this.getString(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED);
    }

    public String parquetOutputTimestampType() {
        return this.getString(HoodieStorageConfig.PARQUET_OUTPUT_TIMESTAMP_TYPE);
    }

    public Option<HoodieLogBlock.HoodieLogBlockType> getLogDataBlockFormat() {
        return Option.ofNullable(this.getString(HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT)).map(HoodieLogBlock.HoodieLogBlockType::fromId);
    }

    public long getLogFileMaxSize() {
        return this.getLong(HoodieStorageConfig.LOGFILE_MAX_SIZE);
    }

    public double getLogFileToParquetCompressionRatio() {
        return this.getDouble(HoodieStorageConfig.LOGFILE_TO_PARQUET_COMPRESSION_RATIO_FRACTION);
    }

    public long getHFileMaxFileSize() {
        return this.getLong(HoodieStorageConfig.HFILE_MAX_FILE_SIZE);
    }

    public int getHFileBlockSize() {
        return this.getInt(HoodieStorageConfig.HFILE_BLOCK_SIZE);
    }

    public Compression.Algorithm getHFileCompressionAlgorithm() {
        return Compression.Algorithm.valueOf(this.getString(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME));
    }

    public long getOrcMaxFileSize() {
        return this.getLong(HoodieStorageConfig.ORC_FILE_MAX_SIZE);
    }

    public int getOrcStripeSize() {
        return this.getInt(HoodieStorageConfig.ORC_STRIPE_SIZE);
    }

    public int getOrcBlockSize() {
        return this.getInt(HoodieStorageConfig.ORC_BLOCK_SIZE);
    }

    public CompressionKind getOrcCompressionCodec() {
        return CompressionKind.valueOf((String)this.getString(HoodieStorageConfig.ORC_COMPRESSION_CODEC_NAME));
    }

    public boolean isMetricsOn() {
        return this.getBoolean(HoodieMetricsConfig.TURN_METRICS_ON);
    }

    public boolean isExecutorMetricsEnabled() {
        return Boolean.parseBoolean(this.getStringOrDefault(HoodieMetricsConfig.EXECUTOR_METRICS_ENABLE, "false"));
    }

    public MetricsReporterType getMetricsReporterType() {
        return MetricsReporterType.valueOf(this.getString(HoodieMetricsConfig.METRICS_REPORTER_TYPE_VALUE));
    }

    public String getGraphiteServerHost() {
        return this.getString(HoodieMetricsGraphiteConfig.GRAPHITE_SERVER_HOST_NAME);
    }

    public int getGraphiteServerPort() {
        return this.getInt(HoodieMetricsGraphiteConfig.GRAPHITE_SERVER_PORT_NUM);
    }

    public String getGraphiteMetricPrefix() {
        return this.getString(HoodieMetricsGraphiteConfig.GRAPHITE_METRIC_PREFIX_VALUE);
    }

    public int getGraphiteReportPeriodSeconds() {
        return this.getInt(HoodieMetricsGraphiteConfig.GRAPHITE_REPORT_PERIOD_IN_SECONDS);
    }

    public String getJmxHost() {
        return this.getString(HoodieMetricsJmxConfig.JMX_HOST_NAME);
    }

    public String getJmxPort() {
        return this.getString(HoodieMetricsJmxConfig.JMX_PORT_NUM);
    }

    public int getDatadogReportPeriodSeconds() {
        return this.getInt(HoodieMetricsDatadogConfig.REPORT_PERIOD_IN_SECONDS);
    }

    public DatadogHttpClient.ApiSite getDatadogApiSite() {
        return DatadogHttpClient.ApiSite.valueOf(this.getString(HoodieMetricsDatadogConfig.API_SITE_VALUE));
    }

    public String getDatadogApiKey() {
        if (this.props.containsKey(HoodieMetricsDatadogConfig.API_KEY.key())) {
            return this.getString(HoodieMetricsDatadogConfig.API_KEY);
        }
        Supplier apiKeySupplier = (Supplier)ReflectionUtils.loadClass(this.getString(HoodieMetricsDatadogConfig.API_KEY_SUPPLIER));
        return (String)apiKeySupplier.get();
    }

    public boolean getDatadogApiKeySkipValidation() {
        return this.getBoolean(HoodieMetricsDatadogConfig.API_KEY_SKIP_VALIDATION);
    }

    public int getDatadogApiTimeoutSeconds() {
        return this.getInt(HoodieMetricsDatadogConfig.API_TIMEOUT_IN_SECONDS);
    }

    public String getDatadogMetricPrefix() {
        return this.getString(HoodieMetricsDatadogConfig.METRIC_PREFIX_VALUE);
    }

    public String getDatadogMetricHost() {
        return this.getString(HoodieMetricsDatadogConfig.METRIC_HOST_NAME);
    }

    public List<String> getDatadogMetricTags() {
        return Arrays.stream(this.getStringOrDefault(HoodieMetricsDatadogConfig.METRIC_TAG_VALUES, ",").split("\\s*,\\s*")).collect(Collectors.toList());
    }

    public int getCloudWatchReportPeriodSeconds() {
        return this.getInt(HoodieMetricsCloudWatchConfig.REPORT_PERIOD_SECONDS);
    }

    public String getCloudWatchMetricPrefix() {
        return this.getString(HoodieMetricsCloudWatchConfig.METRIC_PREFIX);
    }

    public String getCloudWatchMetricNamespace() {
        return this.getString(HoodieMetricsCloudWatchConfig.METRIC_NAMESPACE);
    }

    public int getCloudWatchMaxDatumsPerRequest() {
        return this.getInt(HoodieMetricsCloudWatchConfig.MAX_DATUMS_PER_REQUEST);
    }

    public String getMetricReporterClassName() {
        return this.getString(HoodieMetricsConfig.METRICS_REPORTER_CLASS_NAME);
    }

    public int getPrometheusPort() {
        return this.getInt(HoodieMetricsPrometheusConfig.PROMETHEUS_PORT_NUM);
    }

    public String getPushGatewayHost() {
        return this.getString(HoodieMetricsPrometheusConfig.PUSHGATEWAY_HOST_NAME);
    }

    public int getPushGatewayPort() {
        return this.getInt(HoodieMetricsPrometheusConfig.PUSHGATEWAY_PORT_NUM);
    }

    public int getPushGatewayReportPeriodSeconds() {
        return this.getInt(HoodieMetricsPrometheusConfig.PUSHGATEWAY_REPORT_PERIOD_IN_SECONDS);
    }

    public boolean getPushGatewayDeleteOnShutdown() {
        return this.getBoolean(HoodieMetricsPrometheusConfig.PUSHGATEWAY_DELETE_ON_SHUTDOWN_ENABLE);
    }

    public String getPushGatewayJobName() {
        return this.getString(HoodieMetricsPrometheusConfig.PUSHGATEWAY_JOBNAME);
    }

    public boolean getPushGatewayRandomJobNameSuffix() {
        return this.getBoolean(HoodieMetricsPrometheusConfig.PUSHGATEWAY_RANDOM_JOBNAME_SUFFIX);
    }

    public String getMetricReporterMetricsNamePrefix() {
        return this.getStringOrDefault(HoodieMetricsConfig.METRICS_REPORTER_PREFIX);
    }

    public int getMaxDFSStreamBufferSize() {
        return this.getInt(HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE);
    }

    public String getSpillableMapBasePath() {
        return this.getString(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH);
    }

    public double getWriteStatusFailureFraction() {
        return this.getDouble(HoodieMemoryConfig.WRITESTATUS_FAILURE_FRACTION);
    }

    public ConsistencyGuardConfig getConsistencyGuardConfig() {
        return this.consistencyGuardConfig;
    }

    public FileSystemRetryConfig getFileSystemRetryConfig() {
        return this.fileSystemRetryConfig;
    }

    public void setConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
        this.consistencyGuardConfig = consistencyGuardConfig;
    }

    public FileSystemViewStorageConfig getViewStorageConfig() {
        return this.viewStorageConfig;
    }

    public void setViewStorageConfig(FileSystemViewStorageConfig viewStorageConfig) {
        this.viewStorageConfig = viewStorageConfig;
    }

    public void resetViewStorageConfig() {
        this.setViewStorageConfig(this.getClientSpecifiedViewStorageConfig());
    }

    public FileSystemViewStorageConfig getClientSpecifiedViewStorageConfig() {
        return this.clientSpecifiedViewStorageConfig;
    }

    public HoodiePayloadConfig getPayloadConfig() {
        return this.hoodiePayloadConfig;
    }

    public HoodieMetadataConfig getMetadataConfig() {
        return this.metadataConfig;
    }

    public HoodieCommonConfig getCommonConfig() {
        return this.commonConfig;
    }

    public boolean writeCommitCallbackOn() {
        return this.getBoolean(HoodieWriteCommitCallbackConfig.TURN_CALLBACK_ON);
    }

    public String getCallbackClass() {
        return this.getString(HoodieWriteCommitCallbackConfig.CALLBACK_CLASS_NAME);
    }

    public String getBootstrapSourceBasePath() {
        return this.getString(HoodieBootstrapConfig.BASE_PATH);
    }

    public String getBootstrapModeSelectorClass() {
        return this.getString(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME);
    }

    public String getFullBootstrapInputProvider() {
        return this.getString(HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME);
    }

    public String getBootstrapKeyGeneratorClass() {
        return this.getString(HoodieBootstrapConfig.KEYGEN_CLASS_NAME);
    }

    public String getBootstrapKeyGeneratorType() {
        return this.getString(HoodieBootstrapConfig.KEYGEN_TYPE);
    }

    public String getBootstrapModeSelectorRegex() {
        return this.getString(HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_PATTERN);
    }

    public BootstrapMode getBootstrapModeForRegexMatch() {
        return BootstrapMode.valueOf(this.getString(HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_MODE));
    }

    public String getBootstrapPartitionPathTranslatorClass() {
        return this.getString(HoodieBootstrapConfig.PARTITION_PATH_TRANSLATOR_CLASS_NAME);
    }

    public int getBootstrapParallelism() {
        return this.getInt(HoodieBootstrapConfig.PARALLELISM_VALUE);
    }

    public Long getMaxMemoryPerPartitionMerge() {
        return this.getLong(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE);
    }

    public Long getHoodieClientHeartbeatIntervalInMs() {
        return this.getLong(CLIENT_HEARTBEAT_INTERVAL_IN_MS);
    }

    public Integer getHoodieClientHeartbeatTolerableMisses() {
        return this.getInt(CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES);
    }

    public boolean isMetadataTableEnabled() {
        return this.metadataConfig.enabled();
    }

    public int getMetadataInsertParallelism() {
        return this.getInt(HoodieMetadataConfig.INSERT_PARALLELISM_VALUE);
    }

    public int getMetadataCompactDeltaCommitMax() {
        return this.getInt(HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS);
    }

    public boolean isMetadataAsyncClean() {
        return this.getBoolean(HoodieMetadataConfig.ASYNC_CLEAN_ENABLE);
    }

    public boolean isMetadataAsyncIndex() {
        return this.getBooleanOrDefault(HoodieMetadataConfig.ASYNC_INDEX_ENABLE);
    }

    public int getMetadataMaxCommitsToKeep() {
        return this.getInt(HoodieMetadataConfig.MAX_COMMITS_TO_KEEP);
    }

    public int getMetadataMinCommitsToKeep() {
        return this.getInt(HoodieMetadataConfig.MIN_COMMITS_TO_KEEP);
    }

    public int getMetadataCleanerCommitsRetained() {
        return this.getInt(HoodieMetadataConfig.CLEANER_COMMITS_RETAINED);
    }

    public boolean isAutoAdjustLockConfigs() {
        return this.getBooleanOrDefault(AUTO_ADJUST_LOCK_CONFIGS);
    }

    public String getLockProviderClass() {
        return this.getString(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME);
    }

    public String getLockHiveDatabaseName() {
        return this.getString(HoodieLockConfig.HIVE_DATABASE_NAME);
    }

    public String getLockHiveTableName() {
        return this.getString(HoodieLockConfig.HIVE_TABLE_NAME);
    }

    public ConflictResolutionStrategy getWriteConflictResolutionStrategy() {
        return (ConflictResolutionStrategy)ReflectionUtils.loadClass(this.getString(HoodieLockConfig.WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_NAME));
    }

    public Long getLockAcquireWaitTimeoutInMs() {
        return this.getLong(HoodieLockConfig.LOCK_ACQUIRE_WAIT_TIMEOUT_MS);
    }

    public WriteConcurrencyMode getWriteConcurrencyMode() {
        return WriteConcurrencyMode.fromValue(this.getString(WRITE_CONCURRENCY_MODE));
    }

    public Boolean areAnyTableServicesExecutedInline() {
        return this.areTableServicesEnabled() && (this.inlineClusteringEnabled() || this.inlineCompactionEnabled() || this.isAutoClean() && !this.isAsyncClean() || this.isAutoArchive() && !this.isAsyncArchive());
    }

    public Boolean areAnyTableServicesAsync() {
        return this.areTableServicesEnabled() && (this.isAsyncClusteringEnabled() || this.getTableType() == HoodieTableType.MERGE_ON_READ && !this.inlineCompactionEnabled() || this.isAutoClean() && this.isAsyncClean() || this.isAutoArchive() && this.isAsyncArchive());
    }

    public Boolean areAnyTableServicesScheduledInline() {
        return this.scheduleInlineCompaction() || this.scheduleInlineClustering();
    }

    public String getPreCommitValidators() {
        return this.getString(HoodiePreCommitValidatorConfig.VALIDATOR_CLASS_NAMES);
    }

    public String getPreCommitValidatorEqualitySqlQueries() {
        return this.getString(HoodiePreCommitValidatorConfig.EQUALITY_SQL_QUERIES);
    }

    public String getPreCommitValidatorSingleResultSqlQueries() {
        return this.getString(HoodiePreCommitValidatorConfig.SINGLE_VALUE_SQL_QUERIES);
    }

    public String getPreCommitValidatorInequalitySqlQueries() {
        return this.getString(HoodiePreCommitValidatorConfig.INEQUALITY_SQL_QUERIES);
    }

    public boolean allowEmptyCommit() {
        return this.getBooleanOrDefault(ALLOW_EMPTY_COMMIT);
    }

    public boolean allowOperationMetadataField() {
        return this.getBooleanOrDefault(ALLOW_OPERATION_METADATA_FIELD);
    }

    public String getFileIdPrefixProviderClassName() {
        return this.getString(FILEID_PREFIX_PROVIDER_CLASS);
    }

    public boolean areTableServicesEnabled() {
        return this.getBooleanOrDefault(TABLE_SERVICES_ENABLED);
    }

    public boolean areReleaseResourceEnabled() {
        return this.getBooleanOrDefault(RELEASE_RESOURCE_ENABLE);
    }

    public HoodieStorageLayout.LayoutType getLayoutType() {
        return HoodieStorageLayout.LayoutType.valueOf(this.getString(HoodieLayoutConfig.LAYOUT_TYPE));
    }

    public static class Builder {
        protected final HoodieWriteConfig writeConfig = new HoodieWriteConfig();
        protected EngineType engineType = EngineType.SPARK;
        private boolean isIndexConfigSet = false;
        private boolean isStorageConfigSet = false;
        private boolean isCompactionConfigSet = false;
        private boolean isClusteringConfigSet = false;
        private boolean isOptimizeConfigSet = false;
        private boolean isMetricsConfigSet = false;
        private boolean isBootstrapConfigSet = false;
        private boolean isMemoryConfigSet = false;
        private boolean isViewConfigSet = false;
        private boolean isConsistencyGuardSet = false;
        private boolean isCallbackConfigSet = false;
        private boolean isPayloadConfigSet = false;
        private boolean isMetadataConfigSet = false;
        private boolean isLockConfigSet = false;
        private boolean isPreCommitValidationConfigSet = false;
        private boolean isMetricsJmxConfigSet = false;
        private boolean isMetricsGraphiteConfigSet = false;
        private boolean isLayoutConfigSet = false;

        public Builder withEngineType(EngineType engineType) {
            this.engineType = engineType;
            return this;
        }

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.writeConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromInputStream(InputStream inputStream) throws IOException {
            try {
                this.writeConfig.getProps().load(inputStream);
                Builder builder = this;
                return builder;
            }
            finally {
                inputStream.close();
            }
        }

        public Builder withProps(Map kvprops) {
            this.writeConfig.getProps().putAll((Map<?, ?>)kvprops);
            return this;
        }

        public Builder withPath(String basePath) {
            this.writeConfig.setValue(BASE_PATH, basePath);
            return this;
        }

        public Builder withSchema(String schemaStr) {
            this.writeConfig.setValue(AVRO_SCHEMA_STRING, schemaStr);
            return this;
        }

        public Builder withSchemaEvolutionEnable(boolean enable) {
            this.writeConfig.setValue(SCHEMA_EVOLUTION_ENABLE, String.valueOf(enable));
            return this;
        }

        public Builder withInternalSchemaCacheEnable(boolean enable) {
            this.writeConfig.setValue(ENABLE_INTERNAL_SCHEMA_CACHE, String.valueOf(enable));
            return this;
        }

        public Builder withAvroSchemaValidate(boolean enable) {
            this.writeConfig.setValue(AVRO_SCHEMA_VALIDATE_ENABLE, String.valueOf(enable));
            return this;
        }

        public Builder forTable(String tableName) {
            this.writeConfig.setValue(TBL_NAME, tableName);
            return this;
        }

        public Builder withPreCombineField(String preCombineField) {
            this.writeConfig.setValue(PRECOMBINE_FIELD_NAME, preCombineField);
            return this;
        }

        public Builder withWritePayLoad(String payload) {
            this.writeConfig.setValue(WRITE_PAYLOAD_CLASS_NAME, payload);
            return this;
        }

        public Builder withKeyGenerator(String keyGeneratorClass) {
            this.writeConfig.setValue(KEYGENERATOR_CLASS_NAME, keyGeneratorClass);
            return this;
        }

        public Builder withTimelineLayoutVersion(int version) {
            this.writeConfig.setValue(TIMELINE_LAYOUT_VERSION_NUM, String.valueOf(version));
            return this;
        }

        public Builder withBulkInsertParallelism(int bulkInsertParallelism) {
            this.writeConfig.setValue(BULKINSERT_PARALLELISM_VALUE, String.valueOf(bulkInsertParallelism));
            return this;
        }

        public Builder withUserDefinedBulkInsertPartitionerClass(String className) {
            this.writeConfig.setValue(BULKINSERT_USER_DEFINED_PARTITIONER_CLASS_NAME, className);
            return this;
        }

        public Builder withUserDefinedBulkInsertPartitionerSortColumns(String columns) {
            this.writeConfig.setValue(BULKINSERT_USER_DEFINED_PARTITIONER_SORT_COLUMNS, columns);
            return this;
        }

        public Builder withDeleteParallelism(int parallelism) {
            this.writeConfig.setValue(DELETE_PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withParallelism(int insertShuffleParallelism, int upsertShuffleParallelism) {
            this.writeConfig.setValue(INSERT_PARALLELISM_VALUE, String.valueOf(insertShuffleParallelism));
            this.writeConfig.setValue(UPSERT_PARALLELISM_VALUE, String.valueOf(upsertShuffleParallelism));
            return this;
        }

        public Builder withRollbackParallelism(int rollbackParallelism) {
            this.writeConfig.setValue(ROLLBACK_PARALLELISM_VALUE, String.valueOf(rollbackParallelism));
            return this;
        }

        public Builder withRollbackUsingMarkers(boolean rollbackUsingMarkers) {
            this.writeConfig.setValue(ROLLBACK_USING_MARKERS_ENABLE, String.valueOf(rollbackUsingMarkers));
            return this;
        }

        public Builder withWriteBufferLimitBytes(int writeBufferLimit) {
            this.writeConfig.setValue(WRITE_BUFFER_LIMIT_BYTES_VALUE, String.valueOf(writeBufferLimit));
            return this;
        }

        public Builder combineInput(boolean onInsert, boolean onUpsert) {
            this.writeConfig.setValue(COMBINE_BEFORE_INSERT, String.valueOf(onInsert));
            this.writeConfig.setValue(COMBINE_BEFORE_UPSERT, String.valueOf(onUpsert));
            return this;
        }

        public Builder combineDeleteInput(boolean onDelete) {
            this.writeConfig.setValue(COMBINE_BEFORE_DELETE, String.valueOf(onDelete));
            return this;
        }

        public Builder withWriteStatusStorageLevel(String level) {
            this.writeConfig.setValue(WRITE_STATUS_STORAGE_LEVEL_VALUE, level);
            return this;
        }

        public Builder withIndexConfig(HoodieIndexConfig indexConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)indexConfig.getProps());
            this.isIndexConfigSet = true;
            return this;
        }

        public Builder withStorageConfig(HoodieStorageConfig storageConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)storageConfig.getProps());
            this.isStorageConfigSet = true;
            return this;
        }

        public Builder withCompactionConfig(HoodieCompactionConfig compactionConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)compactionConfig.getProps());
            this.isCompactionConfigSet = true;
            return this;
        }

        public Builder withClusteringConfig(HoodieClusteringConfig clusteringConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)clusteringConfig.getProps());
            this.isClusteringConfigSet = true;
            return this;
        }

        public Builder withLockConfig(HoodieLockConfig lockConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)lockConfig.getProps());
            this.isLockConfigSet = true;
            return this;
        }

        public Builder withMetricsJmxConfig(HoodieMetricsJmxConfig metricsJmxConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)metricsJmxConfig.getProps());
            this.isMetricsJmxConfigSet = true;
            return this;
        }

        public Builder withMetricsGraphiteConfig(HoodieMetricsGraphiteConfig mericsGraphiteConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)mericsGraphiteConfig.getProps());
            this.isMetricsGraphiteConfigSet = true;
            return this;
        }

        public Builder withPreCommitValidatorConfig(HoodiePreCommitValidatorConfig validatorConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)validatorConfig.getProps());
            this.isPreCommitValidationConfigSet = true;
            return this;
        }

        public Builder withMetricsConfig(HoodieMetricsConfig metricsConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)metricsConfig.getProps());
            this.isMetricsConfigSet = true;
            return this;
        }

        public Builder withMemoryConfig(HoodieMemoryConfig memoryConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)memoryConfig.getProps());
            this.isMemoryConfigSet = true;
            return this;
        }

        public Builder withBootstrapConfig(HoodieBootstrapConfig bootstrapConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)bootstrapConfig.getProps());
            this.isBootstrapConfigSet = true;
            return this;
        }

        public Builder withPayloadConfig(HoodiePayloadConfig payloadConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)payloadConfig.getProps());
            this.isPayloadConfigSet = true;
            return this;
        }

        public Builder withMetadataConfig(HoodieMetadataConfig metadataConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)metadataConfig.getProps());
            this.isMetadataConfigSet = true;
            return this;
        }

        public Builder withAutoCommit(boolean autoCommit) {
            this.writeConfig.setValue(AUTO_COMMIT_ENABLE, String.valueOf(autoCommit));
            return this;
        }

        public Builder withWriteStatusClass(Class<? extends WriteStatus> writeStatusClass) {
            this.writeConfig.setValue(WRITE_STATUS_CLASS_NAME, writeStatusClass.getName());
            return this;
        }

        public Builder withFileSystemViewConfig(FileSystemViewStorageConfig viewStorageConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)viewStorageConfig.getProps());
            this.isViewConfigSet = true;
            return this;
        }

        public Builder withConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)consistencyGuardConfig.getProps());
            this.isConsistencyGuardSet = true;
            return this;
        }

        public Builder withCallbackConfig(HoodieWriteCommitCallbackConfig callbackConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)callbackConfig.getProps());
            this.isCallbackConfigSet = true;
            return this;
        }

        public Builder withLayoutConfig(HoodieLayoutConfig layoutConfig) {
            this.writeConfig.getProps().putAll((Map<?, ?>)layoutConfig.getProps());
            this.isLayoutConfigSet = true;
            return this;
        }

        public Builder withFinalizeWriteParallelism(int parallelism) {
            this.writeConfig.setValue(FINALIZE_WRITE_PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withMarkersType(String markerType) {
            this.writeConfig.setValue(MARKERS_TYPE, markerType);
            return this;
        }

        public Builder withMarkersTimelineServerBasedBatchNumThreads(int numThreads) {
            this.writeConfig.setValue(MARKERS_TIMELINE_SERVER_BASED_BATCH_NUM_THREADS, String.valueOf(numThreads));
            return this;
        }

        public Builder withMarkersTimelineServerBasedBatchIntervalMs(long intervalMs) {
            this.writeConfig.setValue(MARKERS_TIMELINE_SERVER_BASED_BATCH_INTERVAL_MS, String.valueOf(intervalMs));
            return this;
        }

        public Builder withMarkersDeleteParallelism(int parallelism) {
            this.writeConfig.setValue(MARKERS_DELETE_PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withEmbeddedTimelineServerEnabled(boolean enabled) {
            this.writeConfig.setValue(EMBEDDED_TIMELINE_SERVER_ENABLE, String.valueOf(enabled));
            return this;
        }

        public Builder withEmbeddedTimelineServerReuseEnabled(boolean enabled) {
            this.writeConfig.setValue(EMBEDDED_TIMELINE_SERVER_REUSE_ENABLED, String.valueOf(enabled));
            return this;
        }

        public Builder withEmbeddedTimelineServerPort(int port) {
            this.writeConfig.setValue(EMBEDDED_TIMELINE_SERVER_PORT_NUM, String.valueOf(port));
            return this;
        }

        public Builder withBulkInsertSortMode(String mode) {
            this.writeConfig.setValue(BULK_INSERT_SORT_MODE, mode);
            return this;
        }

        public Builder withAllowMultiWriteOnSameInstant(boolean allow) {
            this.writeConfig.setValue(ALLOW_MULTI_WRITE_ON_SAME_INSTANT_ENABLE, String.valueOf(allow));
            return this;
        }

        public Builder withExternalSchemaTrasformation(boolean enabled) {
            this.writeConfig.setValue(AVRO_EXTERNAL_SCHEMA_TRANSFORMATION_ENABLE, String.valueOf(enabled));
            return this;
        }

        public Builder withMergeDataValidationCheckEnabled(boolean enabled) {
            this.writeConfig.setValue(MERGE_DATA_VALIDATION_CHECK_ENABLE, String.valueOf(enabled));
            return this;
        }

        public Builder withMergeAllowDuplicateOnInserts(boolean routeInsertsToNewFiles) {
            this.writeConfig.setValue(MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE, String.valueOf(routeInsertsToNewFiles));
            return this;
        }

        public Builder withMergeSmallFileGroupCandidatesLimit(int limit) {
            this.writeConfig.setValue(MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT, String.valueOf(limit));
            return this;
        }

        public Builder withHeartbeatIntervalInMs(Integer heartbeatIntervalInMs) {
            this.writeConfig.setValue(CLIENT_HEARTBEAT_INTERVAL_IN_MS, String.valueOf(heartbeatIntervalInMs));
            return this;
        }

        public Builder withHeartbeatTolerableMisses(Integer heartbeatTolerableMisses) {
            this.writeConfig.setValue(CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES, String.valueOf(heartbeatTolerableMisses));
            return this;
        }

        public Builder withWriteConcurrencyMode(WriteConcurrencyMode concurrencyMode) {
            this.writeConfig.setValue(WRITE_CONCURRENCY_MODE, concurrencyMode.value());
            return this;
        }

        public Builder withPopulateMetaFields(boolean populateMetaFields) {
            this.writeConfig.setValue(HoodieTableConfig.POPULATE_META_FIELDS, Boolean.toString(populateMetaFields));
            return this;
        }

        public Builder withAllowOperationMetadataField(boolean allowOperationMetadataField) {
            this.writeConfig.setValue(ALLOW_OPERATION_METADATA_FIELD, Boolean.toString(allowOperationMetadataField));
            return this;
        }

        public Builder withFileIdPrefixProviderClassName(String fileIdPrefixProviderClassName) {
            this.writeConfig.setValue(FILEID_PREFIX_PROVIDER_CLASS, fileIdPrefixProviderClassName);
            return this;
        }

        public Builder withTableServicesEnabled(boolean enabled) {
            this.writeConfig.setValue(TABLE_SERVICES_ENABLED, Boolean.toString(enabled));
            return this;
        }

        public Builder withReleaseResourceEnabled(boolean enabled) {
            this.writeConfig.setValue(RELEASE_RESOURCE_ENABLE, Boolean.toString(enabled));
            return this;
        }

        public Builder withProperties(Properties properties) {
            this.writeConfig.getProps().putAll((Map<?, ?>)properties);
            return this;
        }

        public Builder withAutoAdjustLockConfigs(boolean autoAdjustLockConfigs) {
            this.writeConfig.setValue(AUTO_ADJUST_LOCK_CONFIGS, String.valueOf(autoAdjustLockConfigs));
            return this;
        }

        protected void setDefaults() {
            this.writeConfig.setDefaultValue(MARKERS_TYPE, this.getDefaultMarkersType(this.engineType));
            this.writeConfig.setDefaults(HoodieWriteConfig.class.getName());
            this.writeConfig.setDefaultOnCondition(!this.isIndexConfigSet, HoodieIndexConfig.newBuilder().withEngineType(this.engineType).fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isStorageConfigSet, HoodieStorageConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isCompactionConfigSet, HoodieCompactionConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isClusteringConfigSet, HoodieClusteringConfig.newBuilder().withEngineType(this.engineType).fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isMetricsConfigSet, HoodieMetricsConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isBootstrapConfigSet, HoodieBootstrapConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isMemoryConfigSet, HoodieMemoryConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isViewConfigSet, FileSystemViewStorageConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isConsistencyGuardSet, ConsistencyGuardConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isCallbackConfigSet, HoodieWriteCommitCallbackConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isPayloadConfigSet, HoodiePayloadConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isMetadataConfigSet, HoodieMetadataConfig.newBuilder().withEngineType(this.engineType).fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isPreCommitValidationConfigSet, HoodiePreCommitValidatorConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isLayoutConfigSet, HoodieLayoutConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultValue(TIMELINE_LAYOUT_VERSION_NUM, String.valueOf(TimelineLayoutVersion.CURR_VERSION));
            TypedProperties writeConfigProperties = this.writeConfig.getProps();
            boolean isLockProviderPropertySet = writeConfigProperties.containsKey(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME) || writeConfigProperties.containsKey(HoodieLockConfig.LOCK_PROVIDER_CLASS_PROP);
            this.writeConfig.setDefaultOnCondition(!this.isLockConfigSet, HoodieLockConfig.newBuilder().fromProperties(this.writeConfig.getProps()).build());
            this.autoAdjustConfigsForConcurrencyMode(isLockProviderPropertySet);
        }

        private void autoAdjustConfigsForConcurrencyMode(boolean isLockProviderPropertySet) {
            boolean isMetadataTableEnabled;
            if (this.writeConfig.isAutoAdjustLockConfigs() && (isMetadataTableEnabled = this.writeConfig.getBoolean(HoodieMetadataConfig.ENABLE).booleanValue())) {
                boolean areTableServicesEnabled = this.writeConfig.areTableServicesEnabled();
                boolean areAsyncTableServicesEnabled = this.writeConfig.areAnyTableServicesAsync();
                if (!isLockProviderPropertySet && areTableServicesEnabled && areAsyncTableServicesEnabled) {
                    this.writeConfig.setValue(WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.value());
                    this.writeConfig.setValue(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), InProcessLockProvider.class.getName());
                    LOG.info((Object)String.format("Automatically set %s=%s and %s=%s since user has not set the lock provider for single writer with async table services", WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.value(), HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), InProcessLockProvider.class.getName()));
                }
            }
            String writeConcurrencyMode = this.writeConfig.getString(WRITE_CONCURRENCY_MODE);
            if (WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.value().equalsIgnoreCase(writeConcurrencyMode)) {
                this.writeConfig.setValue(HoodieCompactionConfig.FAILED_WRITES_CLEANER_POLICY.key(), HoodieFailedWritesCleaningPolicy.LAZY.name());
                LOG.info((Object)String.format("Automatically set %s=%s since optimistic concurrency control is used", HoodieCompactionConfig.FAILED_WRITES_CLEANER_POLICY.key(), HoodieFailedWritesCleaningPolicy.LAZY.name()));
            }
        }

        private void validate() {
            String layoutVersion = this.writeConfig.getString(TIMELINE_LAYOUT_VERSION_NUM);
            new TimelineLayoutVersion(Integer.parseInt(layoutVersion));
            Objects.requireNonNull(this.writeConfig.getString(BASE_PATH));
            if (this.writeConfig.getString(WRITE_CONCURRENCY_MODE).equalsIgnoreCase(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.value())) {
                ValidationUtils.checkArgument(!this.writeConfig.getString(HoodieCompactionConfig.FAILED_WRITES_CLEANER_POLICY).equals(HoodieFailedWritesCleaningPolicy.EAGER.name()), "To enable optimistic concurrency control, set hoodie.cleaner.policy.failed.writes=LAZY");
            }
        }

        public HoodieWriteConfig build() {
            this.setDefaults();
            this.validate();
            return new HoodieWriteConfig(this.engineType, this.writeConfig.getProps());
        }

        private String getDefaultMarkersType(EngineType engineType) {
            switch (engineType) {
                case SPARK: {
                    return MarkerType.TIMELINE_SERVER_BASED.toString();
                }
                case FLINK: 
                case JAVA: {
                    return MarkerType.DIRECT.toString();
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + (Object)((Object)engineType));
        }
    }
}

