/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplitWithLocationInfo;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.InputSplitUtils;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;

public interface RealtimeSplit
extends InputSplitWithLocationInfo {
    default public List<String> getDeltaLogPaths() {
        return this.getDeltaLogFiles().stream().map(entry -> entry.getPath().toString()).collect(Collectors.toList());
    }

    public List<HoodieLogFile> getDeltaLogFiles();

    public void setDeltaLogFiles(List<HoodieLogFile> var1);

    public String getMaxCommitTime();

    public String getBasePath();

    public Option<HoodieVirtualKeyInfo> getVirtualKeyInfo();

    public boolean getBelongsToIncrementalQuery();

    public void setMaxCommitTime(String var1);

    public void setBasePath(String var1);

    public void setBelongsToIncrementalQuery(boolean var1);

    public void setVirtualKeyInfo(Option<HoodieVirtualKeyInfo> var1);

    default public void writeToOutput(DataOutput out) throws IOException {
        InputSplitUtils.writeString(this.getBasePath(), out);
        InputSplitUtils.writeString(this.getMaxCommitTime(), out);
        InputSplitUtils.writeBoolean(this.getBelongsToIncrementalQuery(), out);
        out.writeInt(this.getDeltaLogFiles().size());
        for (HoodieLogFile logFile : this.getDeltaLogFiles()) {
            InputSplitUtils.writeString(logFile.getPath().toString(), out);
            out.writeLong(logFile.getFileSize());
        }
        Option<HoodieVirtualKeyInfo> virtualKeyInfoOpt = this.getVirtualKeyInfo();
        if (!virtualKeyInfoOpt.isPresent()) {
            InputSplitUtils.writeBoolean(false, out);
        } else {
            InputSplitUtils.writeBoolean(true, out);
            InputSplitUtils.writeString(virtualKeyInfoOpt.get().getRecordKeyField(), out);
            InputSplitUtils.writeString(virtualKeyInfoOpt.get().getPartitionPathField(), out);
            InputSplitUtils.writeString(String.valueOf(virtualKeyInfoOpt.get().getRecordKeyFieldIndex()), out);
            InputSplitUtils.writeString(String.valueOf(virtualKeyInfoOpt.get().getPartitionPathFieldIndex()), out);
        }
    }

    default public void readFromInput(DataInput in) throws IOException {
        this.setBasePath(InputSplitUtils.readString(in));
        this.setMaxCommitTime(InputSplitUtils.readString(in));
        this.setBelongsToIncrementalQuery(InputSplitUtils.readBoolean(in));
        int totalLogFiles = in.readInt();
        ArrayList<HoodieLogFile> deltaLogPaths = new ArrayList<HoodieLogFile>(totalLogFiles);
        for (int i = 0; i < totalLogFiles; ++i) {
            String logFilePath = InputSplitUtils.readString(in);
            long logFileSize = in.readLong();
            deltaLogPaths.add(new HoodieLogFile(new Path(logFilePath), logFileSize));
        }
        this.setDeltaLogFiles(deltaLogPaths);
        boolean hoodieVirtualKeyPresent = InputSplitUtils.readBoolean(in);
        if (hoodieVirtualKeyPresent) {
            String recordKeyField = InputSplitUtils.readString(in);
            String partitionPathField = InputSplitUtils.readString(in);
            int recordFieldIndex = Integer.parseInt(InputSplitUtils.readString(in));
            int partitionPathIndex = Integer.parseInt(InputSplitUtils.readString(in));
            this.setVirtualKeyInfo(Option.of(new HoodieVirtualKeyInfo(recordKeyField, partitionPathField, recordFieldIndex, partitionPathIndex)));
        }
    }

    public Path getPath();

    public long getStart();

    public long getLength();
}

