/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.table.HoodieTable;

public class HoodieSortedMergeHandle<T extends HoodieRecordPayload, I, K, O>
extends HoodieMergeHandle<T, I, K, O> {
    private final Queue<String> newRecordKeysSorted = new PriorityQueue<String>();

    public HoodieSortedMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, instantTime, hoodieTable, recordItr, partitionPath, fileId, taskContextSupplier, keyGeneratorOpt);
        this.newRecordKeysSorted.addAll(this.keyToNewRecords.keySet());
    }

    public HoodieSortedMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Map<String, HoodieRecord<T>> keyToNewRecordsOrig, String partitionPath, String fileId, HoodieBaseFile dataFileToBeMerged, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, instantTime, hoodieTable, keyToNewRecordsOrig, partitionPath, fileId, dataFileToBeMerged, taskContextSupplier, keyGeneratorOpt);
        this.newRecordKeysSorted.addAll(this.keyToNewRecords.keySet());
    }

    @Override
    public void write(GenericRecord oldRecord) {
        String keyToPreWrite;
        String key = KeyGenUtils.getRecordKeyFromGenericRecord(oldRecord, this.keyGeneratorOpt);
        while (!this.newRecordKeysSorted.isEmpty() && this.newRecordKeysSorted.peek().compareTo(key) <= 0 && !(keyToPreWrite = this.newRecordKeysSorted.remove()).equals(key)) {
            HoodieRecord hoodieRecord = ((HoodieRecord)this.keyToNewRecords.get(keyToPreWrite)).newInstance();
            if (this.writtenRecordKeys.contains(keyToPreWrite)) {
                throw new HoodieUpsertException("Insert/Update not in sorted order");
            }
            try {
                if (this.useWriterSchemaForCompaction) {
                    this.writeRecord(hoodieRecord, ((HoodieRecordPayload)hoodieRecord.getData()).getInsertValue(this.tableSchemaWithMetaFields, this.config.getProps()));
                } else {
                    this.writeRecord(hoodieRecord, ((HoodieRecordPayload)hoodieRecord.getData()).getInsertValue(this.tableSchema, this.config.getProps()));
                }
                ++this.insertRecordsWritten;
                this.writtenRecordKeys.add(keyToPreWrite);
            }
            catch (IOException e) {
                throw new HoodieUpsertException("Failed to write records", e);
            }
        }
        super.write(oldRecord);
    }

    @Override
    public List<WriteStatus> close() {
        while (!this.newRecordKeysSorted.isEmpty()) {
            try {
                String key = this.newRecordKeysSorted.poll();
                HoodieRecord hoodieRecord = (HoodieRecord)this.keyToNewRecords.get(key);
                if (this.writtenRecordKeys.contains(hoodieRecord.getRecordKey())) continue;
                if (this.useWriterSchemaForCompaction) {
                    this.writeRecord(hoodieRecord, ((HoodieRecordPayload)hoodieRecord.getData()).getInsertValue(this.tableSchemaWithMetaFields, this.config.getProps()));
                } else {
                    this.writeRecord(hoodieRecord, ((HoodieRecordPayload)hoodieRecord.getData()).getInsertValue(this.tableSchema, this.config.getProps()));
                }
                ++this.insertRecordsWritten;
            }
            catch (IOException e) {
                throw new HoodieUpsertException("Failed to close UpdateHandle", e);
            }
        }
        this.newRecordKeysSorted.clear();
        this.keyToNewRecords.clear();
        return super.close();
    }
}

