/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.clean;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanFileInfo;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.clean.CleanPlanner;
import org.apache.hudi.table.action.clean.CleaningTriggerStrategy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CleanPlanActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieCleanerPlan>> {
    private static final Logger LOG = LogManager.getLogger(CleanPlanner.class);
    private final Option<Map<String, String>> extraMetadata;

    public CleanPlanActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime);
        this.extraMetadata = extraMetadata;
    }

    private int getCommitsSinceLastCleaning() {
        Option<HoodieInstant> lastCleanInstant = this.table.getActiveTimeline().getCleanerTimeline().filterCompletedInstants().lastInstant();
        HoodieTimeline commitTimeline = this.table.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        int numCommits = 0;
        if (lastCleanInstant.isPresent()) {
            String latestCleanTs = lastCleanInstant.get().getTimestamp();
            numCommits = commitTimeline.findInstantsAfter(latestCleanTs).countInstants();
        } else {
            numCommits = commitTimeline.countInstants();
        }
        return numCommits;
    }

    private boolean needsCleaning(CleaningTriggerStrategy strategy) {
        if (strategy == CleaningTriggerStrategy.NUM_COMMITS) {
            int maxInlineCommitsForNextClean;
            int numberOfCommits = this.getCommitsSinceLastCleaning();
            return numberOfCommits >= (maxInlineCommitsForNextClean = this.config.getCleaningMaxCommits());
        }
        throw new HoodieException("Unsupported cleaning trigger strategy: " + (Object)((Object)this.config.getCleaningTriggerStrategy()));
    }

    HoodieCleanerPlan requestClean(HoodieEngineContext context) {
        try {
            CleanPlanner planner = new CleanPlanner(context, this.table, this.config);
            Option<HoodieInstant> earliestInstant = planner.getEarliestCommitToRetain();
            context.setJobStatus(this.getClass().getSimpleName(), "Obtaining list of partitions to be cleaned");
            List<String> partitionsToClean = planner.getPartitionPathsToClean(earliestInstant);
            if (partitionsToClean.isEmpty()) {
                LOG.info((Object)"Nothing to clean here. It is already clean");
                return HoodieCleanerPlan.newBuilder().setPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).build();
            }
            LOG.info((Object)("Total Partitions to clean : " + partitionsToClean.size() + ", with policy " + (Object)((Object)this.config.getCleanerPolicy())));
            int cleanerParallelism = Math.min(partitionsToClean.size(), this.config.getCleanerParallelism());
            LOG.info((Object)("Using cleanerParallelism: " + cleanerParallelism));
            context.setJobStatus(this.getClass().getSimpleName(), "Generating list of file slices to be cleaned");
            Map<String, Pair> cleanOpsWithPartitionMeta = context.map(partitionsToClean, partitionPathToClean -> Pair.of(partitionPathToClean, planner.getDeletePaths((String)partitionPathToClean)), cleanerParallelism).stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            Map<String, List<HoodieCleanFileInfo>> cleanOps = cleanOpsWithPartitionMeta.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CleanerUtils.convertToHoodieCleanFileInfoList((List)((Pair)e.getValue()).getValue())));
            List<String> partitionsToDelete = cleanOpsWithPartitionMeta.entrySet().stream().filter(entry -> (Boolean)((Pair)entry.getValue()).getKey()).map(Map.Entry::getKey).collect(Collectors.toList());
            return new HoodieCleanerPlan(earliestInstant.map(x -> new HoodieActionInstant(x.getTimestamp(), x.getAction(), x.getState().name())).orElse(null), this.config.getCleanerPolicy().name(), CollectionUtils.createImmutableMap(new Pair[0]), CleanPlanner.LATEST_CLEAN_PLAN_VERSION, cleanOps, partitionsToDelete);
        }
        catch (IOException e2) {
            throw new HoodieIOException("Failed to schedule clean operation", e2);
        }
    }

    protected Option<HoodieCleanerPlan> requestClean(String startCleanTime) {
        HoodieCleanerPlan cleanerPlan = this.requestClean(this.context);
        if (cleanerPlan.getFilePathsToBeDeletedPerPartition() != null && !cleanerPlan.getFilePathsToBeDeletedPerPartition().isEmpty() && cleanerPlan.getFilePathsToBeDeletedPerPartition().values().stream().mapToInt(List::size).sum() > 0) {
            HoodieInstant cleanInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", startCleanTime);
            try {
                this.table.getActiveTimeline().saveToCleanRequested(cleanInstant, TimelineMetadataUtils.serializeCleanerPlan(cleanerPlan));
                LOG.info((Object)("Requesting Cleaning with instant time " + cleanInstant));
            }
            catch (IOException e) {
                LOG.error((Object)"Got exception when saving cleaner requested file", (Throwable)e);
                throw new HoodieIOException(e.getMessage(), e);
            }
            return Option.of(cleanerPlan);
        }
        return Option.empty();
    }

    @Override
    public Option<HoodieCleanerPlan> execute() {
        if (!this.needsCleaning(this.config.getCleaningTriggerStrategy())) {
            return Option.empty();
        }
        return this.requestClean(this.instantTime);
    }
}

