/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BaseWriteHelper;

public class HoodieWriteHelper<T extends HoodieRecordPayload, R>
extends BaseWriteHelper<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>, R> {
    private HoodieWriteHelper() {
    }

    public static HoodieWriteHelper newInstance() {
        return WriteHelperHolder.HOODIE_WRITE_HELPER;
    }

    @Override
    protected HoodieData<HoodieRecord<T>> tag(HoodieData<HoodieRecord<T>> dedupedRecords, HoodieEngineContext context, HoodieTable<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> table) {
        return table.getIndex().tagLocation(dedupedRecords, context, table);
    }

    @Override
    public HoodieData<HoodieRecord<T>> deduplicateRecords(HoodieData<HoodieRecord<T>> records, HoodieIndex<?, ?> index, int parallelism) {
        boolean isIndexingGlobal = index.isGlobal();
        return records.mapToPair(record -> {
            HoodieKey hoodieKey = record.getKey();
            Object key = isIndexingGlobal ? hoodieKey.getRecordKey() : hoodieKey;
            return Pair.of(key, record);
        }).reduceByKey((rec1, rec2) -> {
            HoodieRecordPayload reducedData = ((HoodieRecordPayload)rec2.getData()).preCombine((HoodieRecordPayload)rec1.getData());
            HoodieKey reducedKey = ((HoodieRecordPayload)rec1.getData()).equals(reducedData) ? rec1.getKey() : rec2.getKey();
            return new HoodieAvroRecord<HoodieRecordPayload>(reducedKey, reducedData);
        }, parallelism).map(Pair::getRight);
    }

    private static class WriteHelperHolder {
        private static final HoodieWriteHelper HOODIE_WRITE_HELPER = new HoodieWriteHelper();

        private WriteHelperHolder() {
        }
    }
}

