/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.storage;

import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.table.storage.HoodieBucketLayout;
import org.apache.hudi.table.storage.HoodieDefaultLayout;
import org.apache.hudi.table.storage.HoodieStorageLayout;

public final class HoodieLayoutFactory {
    public static HoodieStorageLayout createLayout(HoodieWriteConfig config) {
        switch (config.getLayoutType()) {
            case DEFAULT: {
                return new HoodieDefaultLayout(config);
            }
            case BUCKET: {
                return new HoodieBucketLayout(config);
            }
        }
        throw new HoodieNotSupportedException("Unknown layout type, set " + (Object)((Object)config.getLayoutType()));
    }
}

