/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.transform;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class ChainedTransformer
implements Transformer {
    private List<Transformer> transformers;

    public ChainedTransformer(List<Transformer> transformers) {
        this.transformers = transformers;
    }

    public List<String> getTransformersNames() {
        return this.transformers.stream().map(t -> t.getClass().getName()).collect(Collectors.toList());
    }

    @Override
    public Dataset<Row> apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties properties) {
        Dataset<Row> dataset = rowDataset;
        for (Transformer t : this.transformers) {
            dataset = t.apply(jsc, sparkSession, dataset, properties);
        }
        return dataset;
    }
}

