/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.UUID;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class SqlFileBasedTransformer
implements Transformer {
    private static final Logger LOG = LogManager.getLogger(SqlFileBasedTransformer.class);
    private static final String SRC_PATTERN = "<SRC>";
    private static final String TMP_TABLE = "HOODIE_SRC_TMP_TABLE_";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Dataset<Row> apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties props) {
        String sqlFile = props.getString("hoodie.deltastreamer.transformer.sql.file");
        if (null == sqlFile) {
            throw new IllegalArgumentException("Missing required configuration : (hoodie.deltastreamer.transformer.sql.file)");
        }
        FileSystem fs = FSUtils.getFs(sqlFile, jsc.hadoopConfiguration(), true);
        String tmpTable = TMP_TABLE.concat(UUID.randomUUID().toString().replace("-", "_"));
        LOG.info((Object)("Registering tmp table : " + tmpTable));
        rowDataset.registerTempTable(tmpTable);
        try (Scanner scanner = new Scanner((InputStream)fs.open(new Path(sqlFile)), "UTF-8");){
            Dataset rows = null;
            scanner.useDelimiter(";");
            LOG.info((Object)"SQL Query for transformation : ");
            while (scanner.hasNext()) {
                String sqlStr = scanner.next();
                if ((sqlStr = sqlStr.replaceAll(SRC_PATTERN, tmpTable).trim()).isEmpty()) continue;
                LOG.info((Object)sqlStr);
                rows = sparkSession.sql(sqlStr);
            }
            Dataset dataset = rows;
            return dataset;
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading transformer SQL file.", ioe);
        }
    }

    private static class Config {
        private static final String TRANSFORMER_SQL_FILE = "hoodie.deltastreamer.transformer.sql.file";

        private Config() {
        }
    }
}

