/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001\u0002\u0016,\u0001aB\u0001B\r\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\r\"A1\n\u0001BC\u0002\u0013\u0005A\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003N\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001d9\u0006A1A\u0005\naCa!\u0019\u0001!\u0002\u0013I\u0006b\u00022\u0001\u0005\u0004%\ta\u0019\u0005\u0007_\u0002\u0001\u000b\u0011\u00023\t\u000fA\u0004!\u0019!C\u0001c\"1Q\u000f\u0001Q\u0001\nIDqA\u001e\u0001C\u0002\u0013\u00051\r\u0003\u0004x\u0001\u0001\u0006I\u0001\u001a\u0005\bq\u0002\u0011\r\u0011\"\u0001z\u0011\u0019i\b\u0001)A\u0005u\"Aa\u0010\u0001EC\u0002\u0013\u0005q\u0010\u0003\u0006\u0002\u0014\u0001A)\u0019!C\u0001\u0003+A\u0011\"!\b\u0001\u0011\u000b\u0007I\u0011A2\t\u0015\u0005}\u0001\u0001#b\u0001\n\u0003\t\t\u0003C\u0005\u00020\u0001A)\u0019!C\u0001G\"Q\u0011\u0011\u0007\u0001\t\u0006\u0004%\t!a\r\t\u0015\u0005m\u0002\u0001#b\u0001\n\u0003\ti\u0004\u0003\u0006\u0002F\u0001A)\u0019!C\u0001\u0003gA\u0011\"a\u0012\u0001\u0011\u000b\u0007I\u0011A2\t\u0015\u0005%\u0003\u0001#b\u0001\n\u0003\tY\u0005\u0003\u0006\u0002Z\u0001A)\u0019!C\u0001\u0003\u0017B!\"a\u0017\u0001\u0011\u000b\u0007I\u0011AA&\u0011)\ti\u0006\u0001EC\u0002\u0013\u0005\u00111\n\u0005\u000b\u0003?\u0002\u0001R1A\u0005\u0002\u0005-\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\u0007\u0003o\u0002A\u0011A=\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005bBAG\u0001\u0011%\u0011q\u0012\u0005\n\u0003;\u0003\u0011\u0013!C\u0005\u0003?Cq!!.\u0001\t\u0013\t9lB\u0004\u0002X.B\t!!7\u0007\r)Z\u0003\u0012AAn\u0011\u0019\u0011f\u0005\"\u0001\u0002^\"9\u0011q\u001c\u0014\u0005\u0002\u0005\u0005\bbBApM\u0011\u0005\u0011q\u001d\u0002\u0013\u0011>|G-[3DCR\fGn\\4UC\ndWM\u0003\u0002-[\u000591-\u0019;bY><'B\u0001\u00180\u0003!\u0019\u0017\r^1msN$(B\u0001\u00192\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003eM\nQa\u001d9be.T!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sO\u000e\u00011c\u0001\u0001:\u007fA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0019\u0002\u0011%tG/\u001a:oC2L!\u0001R!\u0003\u000f1{wmZ5oOV\ta\t\u0005\u0002H\u00116\tq&\u0003\u0002J_\ta1\u000b]1sWN+7o]5p]\u000611\u000f]1sW\u0002\nQ\u0001^1cY\u0016,\u0012!\u0014\t\u0003\u001d>k\u0011aK\u0005\u0003!.\u0012AbQ1uC2|w\rV1cY\u0016\fa\u0001^1cY\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0002U+Z\u0003\"A\u0014\u0001\t\u000bI*\u0001\u0019\u0001$\t\u000b-+\u0001\u0019A'\u0002\u0015!\fGm\\8q\u0007>tg-F\u0001Z!\tQv,D\u0001\\\u0015\taV,\u0001\u0003d_:4'B\u000104\u0003\u0019A\u0017\rZ8pa&\u0011\u0001m\u0017\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0017!\fGm\\8q\u0007>tg\rI\u0001\u0011G\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a(b[\u0016,\u0012\u0001\u001a\t\u0003K2t!A\u001a6\u0011\u0005\u001d\\T\"\u00015\u000b\u0005%<\u0014A\u0002\u001fs_>$h(\u0003\u0002lw\u00051\u0001K]3eK\u001aL!!\u001c8\u0003\rM#(/\u001b8h\u0015\tY7(A\tdCR\fGn\\4UC\ndWMT1nK\u0002\n\u0011cY1uC2|w\r\u0015:pa\u0016\u0014H/[3t+\u0005\u0011\b\u0003B3tI\u0012L!\u0001\u001e8\u0003\u00075\u000b\u0007/\u0001\ndCR\fGn\\4Qe>\u0004XM\u001d;jKN\u0004\u0013!\u0004;bE2,Gj\\2bi&|g.\u0001\buC\ndW\rT8dCRLwN\u001c\u0011\u0002#!|w\u000eZ5f)\u0006\u0014G.Z#ySN$8/F\u0001{!\tQ40\u0003\u0002}w\t9!i\\8mK\u0006t\u0017A\u00055p_\u0012LW\rV1cY\u0016,\u00050[:ug\u0002\n!\"\\3uC\u000ec\u0017.\u001a8u+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005=QBAA\u0003\u0015\rY\u0015q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0004d_6lwN\u001c\u0006\u0004\u0003\u001b\u0019\u0014\u0001\u00025vI&LA!!\u0005\u0002\u0006\t)\u0002j\\8eS\u0016$\u0016M\u00197f\u001b\u0016$\u0018m\u00117jK:$\u0018a\u0003;bE2,7i\u001c8gS\u001e,\"!a\u0006\u0011\t\u0005\r\u0011\u0011D\u0005\u0005\u00037\t)AA\tI_>$\u0017.\u001a+bE2,7i\u001c8gS\u001e\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\u0013Q\f'\r\\3UsB,WCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003\u000f\tQ!\\8eK2LA!!\f\u0002(\ty\u0001j\\8eS\u0016$\u0016M\u00197f)f\u0004X-A\u0007uC\ndW\rV=qK:\u000bW.Z\u0001\faJLW.\u0019:z\u0017\u0016L8/\u0006\u0002\u00026A!!(a\u000ee\u0013\r\tId\u000f\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000eaJ,7i\\7cS:,7*Z=\u0016\u0005\u0005}\u0002\u0003\u0002\u001e\u0002B\u0011L1!a\u0011<\u0005\u0019y\u0005\u000f^5p]\u0006y\u0001/\u0019:uSRLwN\u001c$jK2$7/\u0001\bcCN,g)\u001b7f\r>\u0014X.\u0019;\u0002\u0017Q\f'\r\\3TG\",W.Y\u000b\u0003\u0003\u001b\u0002B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'z\u0013!\u0002;za\u0016\u001c\u0018\u0002BA,\u0003#\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003q!\u0018M\u00197f'\u000eDW-\\1XSRDw.\u001e;NKR\fg)[3mIN\f!\u0002Z1uCN\u001b\u0007.Z7b\u0003m!\u0017\r^1TG\",W.Y,ji\"|W\u000f^'fi\u00064\u0015.\u001a7eg\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017-A\thKR\u0004\u0016M\u001d;ji&|g\u000eU1uQN,\"!!\u001a\u0011\u000b\u0005\u001d\u0014\u0011\u000f3\u000f\t\u0005%\u0014Q\u000e\b\u0004O\u0006-\u0014\"\u0001\u001f\n\u0007\u0005=4(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0014Q\u000f\u0002\u0004'\u0016\f(bAA8w\u0005\u0011\u0012n\u001d)beRLG/[8oK\u0012$\u0016M\u00197f\u0003=Ig.\u001b;I_>$\u0017.\u001a+bE2,GCAA?!\rQ\u0014qP\u0005\u0004\u0003\u0003[$\u0001B+oSR\fQ\u0003]1sg\u0016\u001c6\r[3nC\u0006sGmQ8oM&<7\u000f\u0006\u0002\u0002\bB1!(!#\u0002NIL1!a#<\u0005\u0019!V\u000f\u001d7fe\u0005\u0001R\r\u001f;sCR\u000b'\r\\3D_:4\u0017n\u001a\u000b\be\u0006E\u0015QSAM\u0011\u0019\t\u0019J\ta\u0001\r\u0006a1\u000f]1sWN+7o]5p]\"1\u0011q\u0013\u0012A\u0002i\fQ\"[:UC\ndW-\u0012=jgR\u001c\b\u0002CANEA\u0005\t\u0019\u0001:\u0002#=\u0014\u0018nZ5o)\u0006\u0014G.Z\"p]\u001aLw-\u0001\u000efqR\u0014\u0018\rV1cY\u0016\u001cuN\u001c4jO\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\"*\u001a!/a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a,<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001C^3sS\u001aLH)\u0019;b'\u000eDW-\\1\u0015\u0011\u0005u\u0014\u0011XAc\u0003\u001bDq!a/%\u0001\u0004\ti,A\buC\ndW-\u00133f]RLg-[3s!\u0011\ty,!1\u000e\u00035J1!a1.\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBA\u0010I\u0001\u0007\u0011q\u0019\t\u0004\u001d\u0006%\u0017bAAfW\t\u00012)\u0019;bY><G+\u00192mKRK\b/\u001a\u0005\b\u00037\"\u0003\u0019AAh!\u0019\t9'!\u001d\u0002RB!\u0011qJAj\u0013\u0011\t).!\u0015\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\u0013\u0011>|G-[3DCR\fGn\\4UC\ndW\r\u0005\u0002OMM\u0011a%\u000f\u000b\u0003\u00033\fQ!\u00199qYf$R\u0001VAr\u0003KDa!a%)\u0001\u00041\u0005bBA^Q\u0001\u0007\u0011Q\u0018\u000b\u0006)\u0006%\u00181\u001e\u0005\u0007\u0003'K\u0003\u0019\u0001$\t\r\u00055\u0018\u00061\u0001N\u00031\u0019\u0017\r^1m_\u001e$\u0016M\u00197f\u0001")
public class HoodieCatalogTable
implements Logging {
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private String tableName;
    private HoodieTableType tableType;
    private String tableTypeName;
    private String[] primaryKeys;
    private Option<String> preCombineKey;
    private String[] partitionFields;
    private String baseFileFormat;
    private StructType tableSchema;
    private StructType tableSchemaWithoutMetaFields;
    private StructType dataSchema;
    private StructType dataSchemaWithoutMetaFields;
    private StructType partitionSchema;
    private final SparkSession spark;
    private final CatalogTable table;
    private final Configuration hadoopConf;
    private final String catalogTableName;
    private final scala.collection.immutable.Map<String, String> catalogProperties;
    private final String tableLocation;
    private final boolean hoodieTableExists;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public static HoodieCatalogTable apply(SparkSession sparkSession, CatalogTable catalogTable) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
    }

    public static HoodieCatalogTable apply(SparkSession sparkSession, TableIdentifier tableIdentifier) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public CatalogTable table() {
        return this.table;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String catalogTableName() {
        return this.catalogTableName;
    }

    public scala.collection.immutable.Map<String, String> catalogProperties() {
        return this.catalogProperties;
    }

    public String tableLocation() {
        return this.tableLocation;
    }

    public boolean hoodieTableExists() {
        return this.hoodieTableExists;
    }

    private HoodieTableMetaClient metaClient$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.tableLocation()).setConf(this.hadoopConf()).build();
                this.bitmap$0 |= 1;
            }
        }
        return this.metaClient;
    }

    public HoodieTableMetaClient metaClient() {
        return (this.bitmap$0 & 1) == 0 ? this.metaClient$lzycompute() : this.metaClient;
    }

    private HoodieTableConfig tableConfig$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tableConfig = this.metaClient().getTableConfig();
                this.bitmap$0 |= 2;
            }
        }
        return this.tableConfig;
    }

    public HoodieTableConfig tableConfig() {
        return (this.bitmap$0 & 2) == 0 ? this.tableConfig$lzycompute() : this.tableConfig;
    }

    private String tableName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tableName = this.tableConfig().getTableName();
                this.bitmap$0 |= 4;
            }
        }
        return this.tableName;
    }

    public String tableName() {
        return (this.bitmap$0 & 4) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 8) == 0) {
                this.tableType = this.tableConfig().getTableType();
                this.bitmap$0 |= 8;
            }
        }
        return this.tableType;
    }

    public HoodieTableType tableType() {
        return (this.bitmap$0 & 8) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    private String tableTypeName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableTypeName = this.tableType().name();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.tableTypeName;
    }

    public String tableTypeName() {
        return (this.bitmap$0 & 0x10) == 0 ? this.tableTypeName$lzycompute() : this.tableTypeName;
    }

    private String[] primaryKeys$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.primaryKeys = this.tableConfig().getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.primaryKeys;
    }

    public String[] primaryKeys() {
        return (this.bitmap$0 & 0x20) == 0 ? this.primaryKeys$lzycompute() : this.primaryKeys;
    }

    private Option<String> preCombineKey$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.preCombineKey = Option$.MODULE$.apply((Object)this.tableConfig().getPreCombineField());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.preCombineKey;
    }

    public Option<String> preCombineKey() {
        return (this.bitmap$0 & 0x40) == 0 ? this.preCombineKey$lzycompute() : this.preCombineKey;
    }

    private String[] partitionFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.partitionFields = this.tableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x80;
            }
        }
        return this.partitionFields;
    }

    public String[] partitionFields() {
        return (this.bitmap$0 & 0x80) == 0 ? this.partitionFields$lzycompute() : this.partitionFields;
    }

    private String baseFileFormat$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.baseFileFormat = this.metaClient().getTableConfig().getBaseFileFormat().name();
                this.bitmap$0 |= 0x100;
            }
        }
        return this.baseFileFormat;
    }

    public String baseFileFormat() {
        return (this.bitmap$0 & 0x100) == 0 ? this.baseFileFormat$lzycompute() : this.baseFileFormat;
    }

    private StructType tableSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x200) == 0) {
                Function2 resolver = this.spark().sessionState().conf().resolver();
                StructType originSchema = (StructType)HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(this.metaClient(), true).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.table().schema());
                StructField[] fields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
                    void var3_7;
                    boolean x$1 = true;
                    String x$2 = f.copy$default$1();
                    DataType x$3 = f.copy$default$2();
                    Metadata x$4 = f.copy$default$4();
                    StructField nullableField = f.copy(x$2, x$3, x$1, x$4);
                    Option<StructField> catalogField = HoodieSqlCommonUtils$.MODULE$.findColumnByName(this.table().schema(), nullableField.name(), (Function2<String, String, Object>)resolver);
                    return catalogField.isDefined() ? (StructField)((StructField)catalogField.get()).getComment().map((Function1 & Serializable & scala.Serializable)comment -> nullableField.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> nullableField) : var3_7;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
                this.tableSchema = new StructType(fields);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.tableSchema;
    }

    public StructType tableSchema() {
        return (this.bitmap$0 & 0x200) == 0 ? this.tableSchema$lzycompute() : this.tableSchema;
    }

    private StructType tableSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.tableSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.tableSchema());
                this.bitmap$0 |= 0x400;
            }
        }
        return this.tableSchemaWithoutMetaFields;
    }

    public StructType tableSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x400) == 0 ? this.tableSchemaWithoutMetaFields$lzycompute() : this.tableSchemaWithoutMetaFields;
    }

    private StructType dataSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.dataSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$dataSchema$1(this, f))));
                this.bitmap$0 |= 0x800;
            }
        }
        return this.dataSchema;
    }

    public StructType dataSchema() {
        return (this.bitmap$0 & 0x800) == 0 ? this.dataSchema$lzycompute() : this.dataSchema;
    }

    private StructType dataSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.dataSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.dataSchema());
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.dataSchemaWithoutMetaFields;
    }

    public StructType dataSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.dataSchemaWithoutMetaFields$lzycompute() : this.dataSchemaWithoutMetaFields;
    }

    private StructType partitionSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.partitionSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$partitionSchema$1(this, f))));
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    public Seq<String> getPartitionPaths() {
        return HoodieSqlCommonUtils$.MODULE$.getAllPartitionPaths(this.spark(), this.table());
    }

    public boolean isPartitionedTable() {
        return this.table().partitionColumnNames().nonEmpty();
    }

    public void initHoodieTable() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Init hoodie.properties for ").append(this.table().identifier().unquotedString()).toString());
        Tuple2<StructType, scala.collection.immutable.Map<String, String>> tuple2 = this.parseSchemaAndConfigs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StructType finalSchema = (StructType)tuple2._1();
        scala.collection.immutable.Map tableConfigs = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        Tuple2 tuple23 = tuple22;
        StructType finalSchema2 = (StructType)tuple23._1();
        scala.collection.immutable.Map tableConfigs2 = (scala.collection.immutable.Map)tuple23._2();
        Properties properties = new Properties();
        properties.putAll((java.util.Map<?, ?>)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableConfigs2).asJava()));
        if (this.hoodieTableExists()) {
            HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setTableCreateSchema(SchemaConverters$.MODULE$.toAvroType((DataType)finalSchema2, SchemaConverters$.MODULE$.toAvroType$default$2(), SchemaConverters$.MODULE$.toAvroType$default$3(), SchemaConverters$.MODULE$.toAvroType$default$4()).toString()).initTable(this.hadoopConf(), this.tableLocation());
        } else {
            Tuple2<String, String> tuple24 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.table().identifier().table());
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            String recordName = (String)tuple24._1();
            String namespace = (String)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)recordName, (Object)namespace);
            Tuple2 tuple26 = tuple25;
            String recordName2 = (String)tuple26._1();
            String namespace2 = (String)tuple26._2();
            Schema schema = SchemaConverters$.MODULE$.toAvroType((DataType)finalSchema2, false, recordName2, namespace2);
            String hoodieDatabaseName = HoodieSqlCommonUtils$.MODULE$.formatName(this.spark(), (String)this.table().identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.spark().sessionState().catalog().getCurrentDatabase()));
            HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setDatabaseName(hoodieDatabaseName).setTableName(this.table().identifier().table()).setTableCreateSchema(schema.toString()).setPartitionFields(this.table().partitionColumnNames().mkString(",")).initTable(this.hadoopConf(), this.tableLocation());
        }
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<StructType, scala.collection.immutable.Map<String, String>> parseSchemaAndConfigs() {
        globalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        globalTableConfigs = HoodieWriterUtils$.MODULE$.mappingSparkDatasourceConfigsToTableConfigs((scala.collection.immutable.Map<String, String>)globalProps);
        globalSqlOptions = HoodieOptionConfig$.MODULE$.mappingTableConfigToSqlOption(globalTableConfigs);
        sqlOptions = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions((scala.collection.immutable.Map<String, String>)globalSqlOptions.$plus$plus(this.catalogProperties()));
        var9_5 = new Tuple2((Object)this.table().tableType(), (Object)BoxesRunTime.boxToBoolean((boolean)this.hoodieTableExists()));
        if (var9_5 == null) ** GOTO lbl-1000
        var10_6 = (CatalogTableType)var9_5._1();
        var11_7 = var9_5._2$mcZ$sp();
        v0 = CatalogTableType$.MODULE$.EXTERNAL();
        var12_8 = var10_6;
        if (!(v0 != null ? v0.equals(var12_8) == false : var12_8 != null) && var11_7) {
            existingTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
            currentTableConfig = globalTableConfigs.$plus$plus((GenTraversableOnce)existingTableConfig);
            catalogTableProps = HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(this.catalogProperties());
            HoodieWriterUtils$.MODULE$.validateTableConfig(this.spark(), catalogTableProps, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)existingTableConfig));
            options = this.extraTableConfig(this.spark(), this.hoodieTableExists(), (scala.collection.immutable.Map<String, String>)currentTableConfig).$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(sqlOptions)).$plus$plus((GenTraversableOnce)currentTableConfig);
            ValidationUtils.checkArgument(this.tableSchema().nonEmpty() != false || this.table().schema().nonEmpty() != false, new StringBuilder(33).append("Missing schema for Create Table: ").append(this.catalogTableName()).toString());
            schema = this.tableSchema().nonEmpty() != false ? this.tableSchema() : HoodieSqlCommonUtils$.MODULE$.addMetaFields(this.table().schema());
            var2_14 = new Tuple2((Object)schema, (Object)options);
        } else if (var9_5 != null && !(var18_15 = var9_5._2$mcZ$sp())) {
            ValidationUtils.checkArgument(this.table().schema().nonEmpty(), new StringBuilder(33).append("Missing schema for Create Table: ").append(this.catalogTableName()).toString());
            schema = this.table().schema();
            options = this.extraTableConfig(this.spark(), false, globalTableConfigs).$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(sqlOptions));
            var2_14 = new Tuple2((Object)HoodieSqlCommonUtils$.MODULE$.addMetaFields(schema), (Object)options);
        } else {
            if (var9_5 != null) {
                var21_18 = (CatalogTableType)var9_5._1();
                var22_19 = var9_5._2$mcZ$sp();
                v1 = CatalogTableType$.MODULE$.MANAGED();
                var23_20 = var21_18;
                if (!(v1 != null ? v1.equals(var23_20) == false : var23_20 != null) && var22_19) {
                    throw new AnalysisException(new StringBuilder(81).append("Can not create the managed table('").append(this.catalogTableName()).append("')").append(". The associated location('").append(this.tableLocation()).append("') already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            throw new MatchError((Object)var9_5);
        }
        var8_21 = var2_14;
        if (var8_21 == null) {
            throw new MatchError((Object)var8_21);
        }
        finalSchema = (StructType)var8_21._1();
        tableConfigs = (scala.collection.immutable.Map)var8_21._2();
        var1_24 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        var7_25 = var1_24;
        finalSchema = (StructType)var7_25._1();
        tableConfigs = (scala.collection.immutable.Map)var7_25._2();
        HoodieOptionConfig$.MODULE$.validateTable(this.spark(), finalSchema, HoodieOptionConfig$.MODULE$.mappingTableConfigToSqlOption((scala.collection.immutable.Map<String, String>)tableConfigs));
        resolver = this.spark().sessionState().conf().resolver();
        dataSchema = (Seq)finalSchema.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseSchemaAndConfigs$1$adapted(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable scala.Function2 org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/Object;)((HoodieCatalogTable)this, (Function2)resolver));
        this.verifyDataSchema(this.table().identifier(), this.table().tableType(), (Seq<StructField>)dataSchema);
        return new Tuple2((Object)finalSchema, (Object)tableConfigs);
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig(SparkSession sparkSession, boolean isTableExists, scala.collection.immutable.Map<String, String> originTableConfig) {
        scala.collection.mutable.Map extraConfig = Map$.MODULE$.empty();
        if (isTableExists) {
            Seq<String> allPartitionPaths = this.getPartitionPaths();
            if (originTableConfig.contains((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key())) {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), originTableConfig.apply((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isHiveStyledPartitioning(allPartitionPaths, this.table())));
            }
            if (originTableConfig.contains((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key())) {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), originTableConfig.apply((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isUrlEncodeEnabled(allPartitionPaths, this.table())));
            }
        } else {
            extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
            extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.defaultValue());
        }
        if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())));
        } else {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)ComplexKeyGenerator.class.getCanonicalName());
        }
        return extraConfig.toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private void verifyDataSchema(TableIdentifier tableIdentifier, CatalogTableType tableType, Seq<StructField> dataSchema) {
        block0: {
            CatalogTableType catalogTableType = tableType;
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2))) break block0;
            Seq invalidChars = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", ":", ";"}));
            dataSchema.foreach((Function1 & Serializable & scala.Serializable)f -> {
                HoodieCatalogTable.$anonfun$verifyDataSchema$4(tableIdentifier, invalidChars, f);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$dataSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$partitionSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$2(Function2 resolver$2, StructField f$1, String x$5) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$2.apply((Object)x$5, (Object)f$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$1(HoodieCatalogTable $this, Function2 resolver$2, StructField f) {
        return $this.table().partitionColumnNames().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$2(resolver$2, f, x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyDataSchema$2(StructField f$2, CharSequence x$1) {
        return f$2.name().contains(x$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$1(Seq invalidChars$1, TableIdentifier tableIdentifier$1, StructField f) {
        DataType dataType = f.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (invalidChars$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$verifyDataSchema$2(f, x$1)))) {
                String invalidCharsString = ((TraversableOnce)invalidChars$1.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append((String)c).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String errMsg = new StringBuilder(123).append("Cannot create a table having a nested column whose name contains ").append("invalid characters (").append(invalidCharsString).append(") in Hive metastore. Table: ").append(tableIdentifier$1).append("; ").append("Column: ").append(f.name()).toString();
                throw new AnalysisException(errMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void verifyNestedColumnNames$1(StructType schema, Seq invalidChars$1, TableIdentifier tableIdentifier$1) {
        schema.foreach((Function1 & Serializable & scala.Serializable)f -> {
            HoodieCatalogTable.$anonfun$verifyDataSchema$1(invalidChars$1, tableIdentifier$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$4(TableIdentifier tableIdentifier$1, Seq invalidChars$1, StructField f) {
        DataType dataType = f.dataType();
        if (f.name().contains(",")) {
            throw new AnalysisException(new StringBuilder(101).append("Cannot create a table having a column whose name ").append("contains commas in Hive metastore. Table: ").append(tableIdentifier$1).append("; Column: ").append(f.name()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public HoodieCatalogTable(SparkSession spark, CatalogTable table) {
        this.spark = spark;
        this.table = table;
        Logging.$init$((Logging)this);
        Object object = table.provider().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string) : string != null), (Function0 & Serializable & scala.Serializable)() -> "It's not a Hudi table");
        this.hadoopConf = spark.sessionState().newHadoopConf();
        this.catalogTableName = table.qualifiedName();
        this.catalogProperties = table.storage().properties().$plus$plus((GenTraversableOnce)table.properties());
        this.tableLocation = HoodieSqlCommonUtils$.MODULE$.getTableLocation(table, spark);
        this.hoodieTableExists = HoodieSqlCommonUtils$.MODULE$.tableExistsInPath(this.tableLocation(), this.hadoopConf());
    }

    public static final /* synthetic */ Object $anonfun$parseSchemaAndConfigs$1$adapted(HoodieCatalogTable $this, Function2 resolver$2, StructField f) {
        return BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$1($this, resolver$2, f));
    }
}

