/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hive.HiveClientUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.command.DropHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0013'\u0001NB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001b\"A!\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003U\u0011!A\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C-\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u0011i\u0003!Q3A\u0005\u0002MC\u0001b\u0017\u0001\u0003\u0012\u0003\u0006I\u0001\u0016\u0005\u00069\u0002!\t!\u0018\u0005\bG\u0002\u0011\r\u0011\"\u0001e\u0011\u0019i\u0007\u0001)A\u0005K\"9a\u000e\u0001b\u0001\n\u0003!\u0007BB8\u0001A\u0003%Q\rC\u0003q\u0001\u0011\u0005\u0013\u000fC\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002\"CA+\u0001E\u0005I\u0011BA,\u0011%\ti\u0007AA\u0001\n\u0003\ty\u0007C\u0005\u0002z\u0001\t\n\u0011\"\u0001\u0002|!I\u0011q\u0010\u0001\u0012\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003\u0003\u0003\u0011\u0013!C\u0001\u0003/B\u0011\"a!\u0001#\u0003%\t!a\u0016\t\u0011\u0005\u0015\u0005!!A\u0005B\u0011D\u0011\"a\"\u0001\u0003\u0003%\t!!#\t\u0013\u0005E\u0005!!A\u0005\u0002\u0005M\u0005\"CAP\u0001\u0005\u0005I\u0011IAQ\u0011%\ty\u000bAA\u0001\n\u0003\t\t\fC\u0005\u00026\u0002\t\t\u0011\"\u0011\u00028\u001eI\u00111\u0018\u0014\u0002\u0002#\u0005\u0011Q\u0018\u0004\tK\u0019\n\t\u0011#\u0001\u0002@\"1Al\bC\u0001\u0003\u001bD\u0011\"a4 \u0003\u0003%)%!5\t\u0013\u0005Mw$!A\u0005\u0002\u0006U\u0007\"CAp?\u0005\u0005I\u0011QAq\u0011%\t\u0019pHA\u0001\n\u0013\t)P\u0001\fEe>\u0004\bj\\8eS\u0016$\u0016M\u00197f\u0007>lW.\u00198e\u0015\t9\u0003&A\u0004d_6l\u0017M\u001c3\u000b\u0005%R\u0013\u0001\u00025vI&T!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u001b?\u0005\"\u0003\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u000f1|w-[2bY*\u0011\u0011HO\u0001\u0006a2\fgn\u001d\u0006\u0003w)\n\u0001bY1uC2L8\u000f^\u0005\u0003{Y\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011q\bQ\u0007\u0002M%\u0011\u0011I\n\u0002\u001a\u0011>|G-[3MK\u00064'+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EIA\u0004Qe>$Wo\u0019;\u0011\u0005\rK\u0015B\u0001&E\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003=!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014X#A'\u0011\u00059{U\"\u0001\u001e\n\u0005AS$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002!Q\f'\r\\3JI\u0016tG/\u001b4jKJ\u0004\u0013\u0001C5g\u000bbL7\u000f^:\u0016\u0003Q\u0003\"aQ+\n\u0005Y#%a\u0002\"p_2,\u0017M\\\u0001\nS\u001a,\u00050[:ug\u0002\na![:WS\u0016<\u0018aB5t-&,w\u000fI\u0001\u0006aV\u0014x-Z\u0001\u0007aV\u0014x-\u001a\u0011\u0002\rqJg.\u001b;?)\u0015qv\fY1c!\ty\u0004\u0001C\u0003L\u0013\u0001\u0007Q\nC\u0003S\u0013\u0001\u0007A\u000bC\u0003Y\u0013\u0001\u0007A\u000bC\u0003[\u0013\u0001\u0007A+A\rN\u001fJ{6KT!Q'\"{Ek\u0018+B\u00052+ulU+G\r&CV#A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017\u0001\u00027b]\u001eT\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\n11\u000b\u001e:j]\u001e\f!$T(S?Ns\u0015\tU*I\u001fR{F+\u0011\"M\u000b~\u001bVK\u0012$J1\u0002\nq$T(S?J+\u0015\tR0P!RKU*\u0013.F\t~#\u0016I\u0011'F?N+fIR%Y\u0003\u0001juJU0S\u000b\u0006#ul\u0014)U\u00136K%,\u0012#`)\u0006\u0013E*R0T+\u001a3\u0015\n\u0017\u0011\u0002\u0007I,h\u000eF\u0002s\u0003\u000b\u00012a]>\u007f\u001d\t!\u0018P\u0004\u0002vq6\taO\u0003\u0002xe\u00051AH]8pizJ\u0011!R\u0005\u0003u\u0012\u000bq\u0001]1dW\u0006<W-\u0003\u0002}{\n\u00191+Z9\u000b\u0005i$\u0005cA@\u0002\u00025\t!&C\u0002\u0002\u0004)\u00121AU8x\u0011\u001d\t9A\u0004a\u0001\u0003\u0013\tAb\u001d9be.\u001cVm]:j_:\u00042a`A\u0006\u0013\r\tiA\u000b\u0002\r'B\f'o[*fgNLwN\\\u0001\u0013IJ|\u0007\u000fV1cY\u0016LenQ1uC2|w\r\u0006\u0006\u0002\u0014\u0005e\u00111DA\u000f\u0003?\u00012aQA\u000b\u0013\r\t9\u0002\u0012\u0002\u0005+:LG\u000fC\u0004\u0002\b=\u0001\r!!\u0003\t\u000b-{\u0001\u0019A'\t\u000bI{\u0001\u0019\u0001+\t\u000bi{\u0001\u0019\u0001+\u0002/\u0011\u0014x\u000e\u001d%jm\u0016$\u0015\r^1T_V\u00148-\u001a+bE2,GCBA\n\u0003K\t9\u0003C\u0004\u0002\bA\u0001\r!!\u0003\t\u000f\u0005%\u0002\u00031\u0001\u0002,\u0005\u0011\u0002n\\8eS\u0016\u001c\u0015\r^1m_\u001e$\u0016M\u00197f!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019u\u000591-\u0019;bY><\u0017\u0002BA\u001b\u0003_\u0011!\u0003S8pI&,7)\u0019;bY><G+\u00192mK\u0006iAM]8q\u0011&4X\rV1cY\u0016$\"\"a\u0005\u0002<\u0005u\u0012qJA*\u0011\u001d\t9!\u0005a\u0001\u0003\u0013Aq!a\u0010\u0012\u0001\u0004\t\t%\u0001\u0004eE:\u000bW.\u001a\t\u0005\u0003\u0007\nYE\u0004\u0003\u0002F\u0005\u001d\u0003CA;E\u0013\r\tI\u0005R\u0001\u0007!J,G-\u001a4\n\u00071\fiEC\u0002\u0002J\u0011Cq!!\u0015\u0012\u0001\u0004\t\t%A\u0005uC\ndWMT1nK\"9!,\u0005I\u0001\u0002\u0004!\u0016a\u00063s_BD\u0015N^3UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tIFK\u0002U\u00037Z#!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O\"\u0015AC1o]>$\u0018\r^5p]&!\u00111NA1\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0005G>\u0004\u0018\u0010F\u0005_\u0003c\n\u0019(!\u001e\u0002x!91j\u0005I\u0001\u0002\u0004i\u0005b\u0002*\u0014!\u0003\u0005\r\u0001\u0016\u0005\b1N\u0001\n\u00111\u0001U\u0011\u001dQ6\u0003%AA\u0002Q\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002~)\u001aQ*a\u0017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0005cA\"\u0002\u000e&\u0019\u0011q\u0012#\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00151\u0014\t\u0004\u0007\u0006]\u0015bAAM\t\n\u0019\u0011I\\=\t\u0013\u0005u%$!AA\u0002\u0005-\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002$B1\u0011QUAV\u0003+k!!a*\u000b\u0007\u0005%F)\u0001\u0006d_2dWm\u0019;j_:LA!!,\u0002(\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r!\u00161\u0017\u0005\n\u0003;c\u0012\u0011!a\u0001\u0003+\u000ba!Z9vC2\u001cHc\u0001+\u0002:\"I\u0011QT\u000f\u0002\u0002\u0003\u0007\u0011QS\u0001\u0017\tJ|\u0007\u000fS8pI&,G+\u00192mK\u000e{W.\\1oIB\u0011qhH\n\u0005?\u0005\u0005\u0007\nE\u0005\u0002D\u0006%W\n\u0016+U=6\u0011\u0011Q\u0019\u0006\u0004\u0003\u000f$\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003\u0017\f)MA\tBEN$(/Y2u\rVt7\r^5p]R\"\"!!0\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!Z\u0001\u0006CB\u0004H.\u001f\u000b\n=\u0006]\u0017\u0011\\An\u0003;DQa\u0013\u0012A\u00025CQA\u0015\u0012A\u0002QCQ\u0001\u0017\u0012A\u0002QCQA\u0017\u0012A\u0002Q\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002d\u0006=\b#B\"\u0002f\u0006%\u0018bAAt\t\n1q\n\u001d;j_:\u0004raQAv\u001bR#F+C\u0002\u0002n\u0012\u0013a\u0001V;qY\u0016$\u0004\u0002CAyG\u0005\u0005\t\u0019\u00010\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAA|!\r1\u0017\u0011`\u0005\u0004\u0003w<'AB(cU\u0016\u001cG\u000f")
public class DropHoodieTableCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier tableIdentifier;
    private final boolean ifExists;
    private final boolean isView;
    private final boolean purge;
    private final String MOR_SNAPSHOT_TABLE_SUFFIX;
    private final String MOR_READ_OPTIMIZED_TABLE_SUFFIX;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Object, Object, Object>> unapply(DropHoodieTableCommand dropHoodieTableCommand) {
        return DropHoodieTableCommand$.MODULE$.unapply(dropHoodieTableCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, Object>, DropHoodieTableCommand> tupled() {
        return DropHoodieTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<Object, DropHoodieTableCommand>>>> curried() {
        return DropHoodieTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DropHoodieTableCommand dropHoodieTableCommand = this;
        synchronized (dropHoodieTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean isView() {
        return this.isView;
    }

    public boolean purge() {
        return this.purge;
    }

    public String MOR_SNAPSHOT_TABLE_SUFFIX() {
        return this.MOR_SNAPSHOT_TABLE_SUFFIX;
    }

    public String MOR_READ_OPTIMIZED_TABLE_SUFFIX() {
        return this.MOR_READ_OPTIMIZED_TABLE_SUFFIX;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        String fullTableName = new StringBuilder(1).append(this.tableIdentifier().database()).append(".").append(this.tableIdentifier().table()).toString();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("start execute drop table command for ").append(fullTableName).toString());
        sparkSession.catalog().refreshTable(this.tableIdentifier().unquotedString());
        try {
            this.dropTableInCatalog(sparkSession, this.tableIdentifier(), this.ifExists(), this.purge());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Failed to drop catalog table in metastore: ").append(e.getMessage()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Finish execute drop table command for ").append(fullTableName).toString());
        return (Seq)Seq$.MODULE$.empty();
    }

    public void dropTableInCatalog(SparkSession sparkSession, TableIdentifier tableIdentifier, boolean ifExists, boolean purge) {
        block3: {
            HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
            CatalogTable table = hoodieCatalogTable.table();
            CatalogTableType catalogTableType = table.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            Predef$.MODULE$.assert(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2));
            String basePath = hoodieCatalogTable.tableLocation();
            SessionCatalog catalog = sparkSession.sessionState().catalog();
            boolean enableHive = HoodieSqlCommonUtils$.MODULE$.isEnableHive(sparkSession);
            if (enableHive) {
                this.dropHiveDataSourceTable(sparkSession, hoodieCatalogTable);
            } else if (catalog.tableExists(tableIdentifier)) {
                catalog.dropTable(tableIdentifier, ifExists, purge);
            }
            if (!purge) break block3;
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Clean up ").append(basePath).toString());
            Path targetPath = new Path(basePath);
            HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(JavaSparkContext$.MODULE$.fromSparkContext(sparkSession.sparkContext()));
            FileSystem fs = FSUtils.getFs(basePath, sparkSession.sparkContext().hadoopConfiguration());
            FSUtils.deleteDir(engineContext, fs, targetPath, sparkSession.sparkContext().defaultParallelism());
        }
    }

    private void dropHiveDataSourceTable(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable) {
        CatalogTable table = hoodieCatalogTable.table();
        String dbName = (String)table.identifier().database().get();
        String tableName = hoodieCatalogTable.tableName();
        boolean dbExists = sparkSession.sessionState().catalog().databaseExists(dbName);
        if (!dbExists) {
            throw new NoSuchDatabaseException(dbName);
        }
        if (((Object)((Object)HoodieTableType.MERGE_ON_READ)).equals((Object)hoodieCatalogTable.tableType()) && this.purge()) {
            String snapshotTableName = new StringBuilder(0).append(tableName).append(this.MOR_SNAPSHOT_TABLE_SUFFIX()).toString();
            String roTableName = new StringBuilder(0).append(tableName).append(this.MOR_READ_OPTIMIZED_TABLE_SUFFIX()).toString();
            this.dropHiveTable(sparkSession, dbName, snapshotTableName, this.dropHiveTable$default$4());
            this.dropHiveTable(sparkSession, dbName, roTableName, this.dropHiveTable$default$4());
        }
        this.dropHiveTable(sparkSession, dbName, tableName, this.purge());
    }

    private void dropHiveTable(SparkSession sparkSession, String dbName, String tableName, boolean purge) {
        block0: {
            if (!sparkSession.sessionState().catalog().tableExists(new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName)))) break block0;
            HiveClient client = HiveClientUtils$.MODULE$.newClientForMetadata(sparkSession.sparkContext().conf(), sparkSession.sessionState().newHadoopConf());
            client.dropTable(dbName, tableName, this.ifExists(), purge);
        }
    }

    private boolean dropHiveTable$default$4() {
        return false;
    }

    public DropHoodieTableCommand copy(TableIdentifier tableIdentifier, boolean ifExists, boolean isView, boolean purge) {
        return new DropHoodieTableCommand(tableIdentifier, ifExists, isView, purge);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public boolean copy$default$2() {
        return this.ifExists();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public boolean copy$default$4() {
        return this.purge();
    }

    public String productPrefix() {
        return "DropHoodieTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableIdentifier();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifExists());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.purge());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropHoodieTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropHoodieTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropHoodieTableCommand dropHoodieTableCommand = (DropHoodieTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = dropHoodieTableCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.ifExists() != dropHoodieTableCommand.ifExists()) return false;
        if (this.isView() != dropHoodieTableCommand.isView()) return false;
        if (this.purge() != dropHoodieTableCommand.purge()) return false;
        if (!dropHoodieTableCommand.canEqual(this)) return false;
        return true;
    }

    public DropHoodieTableCommand(TableIdentifier tableIdentifier, boolean ifExists, boolean isView, boolean purge) {
        this.tableIdentifier = tableIdentifier;
        this.ifExists = ifExists;
        this.isView = isView;
        this.purge = purge;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
        this.MOR_SNAPSHOT_TABLE_SUFFIX = "_rt";
        this.MOR_READ_OPTIMIZED_TABLE_SUFFIX = "_ro";
    }
}

