/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RollbackSavepointsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\t\u0012\u0001\u0001BQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004=\u0001\u0001\u0006Ia\r\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!)a\t\u0001C\u0001e!)q\t\u0001C\u0001}!)\u0001\n\u0001C!\u0013\")q\f\u0001C!A\u001e)A-\u0005E\u0001K\u001a)\u0001#\u0005E\u0001M\")af\u0003C\u0001U\"91n\u0003b\u0001\n\u0003a\u0007BB;\fA\u0003%Q\u000eC\u0003w\u0017\u0011\u0005qOA\u000eS_2d'-Y2l'\u00064X\r]8j]R\u001c\bK]8dK\u0012,(/\u001a\u0006\u0003%M\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t!R#A\u0004d_6l\u0017M\u001c3\u000b\u0005Y9\u0012\u0001\u00025vI&T!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u0011&QA\u0011!eI\u0007\u0002#%\u0011A%\u0005\u0002\u000e\u0005\u0006\u001cX\r\u0015:pG\u0016$WO]3\u0011\u0005\t2\u0013BA\u0014\u0012\u0005A\u0001&o\\2fIV\u0014XMQ;jY\u0012,'\u000f\u0005\u0002*Y5\t!F\u0003\u0002,3\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002.U\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00011!\t\u0011\u0003!\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012a\r\t\u0004i]JT\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\tR\u0014BA\u001e\u0012\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\u0002\u0017A\u000b%+Q'F)\u0016\u00136\u000bI\u0001\f\u001fV#\u0006+\u0016+`)f\u0003V)F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011u#A\u0003usB,7/\u0003\u0002E\u0003\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0019=+F\u000bU+U?RK\u0006+\u0012\u0011\u0002\u0015A\f'/Y7fi\u0016\u00148/\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016\fAaY1mYR\u0011!J\u0017\t\u0004\u0017N3fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\tyu$\u0001\u0004=e>|GOP\u0005\u0002m%\u0011!+N\u0001\ba\u0006\u001c7.Y4f\u0013\t!VKA\u0002TKFT!AU\u001b\u0011\u0005]CV\"A\f\n\u0005e;\"a\u0001*po\")1\f\u0003a\u00019\u0006!\u0011M]4t!\t\u0011S,\u0003\u0002_#\ti\u0001K]8dK\u0012,(/Z!sON\fQAY;jY\u0012,\u0012!\u0019\t\u0003E\tL!aY\t\u0003\u0013A\u0013xnY3ekJ,\u0017a\u0007*pY2\u0014\u0017mY6TCZ,\u0007o\\5oiN\u0004&o\\2fIV\u0014X\r\u0005\u0002#\u0017M\u00111b\u001a\t\u0003i!L!![\u001b\u0003\r\u0005s\u0017PU3g)\u0005)\u0017\u0001\u0002(B\u001b\u0016+\u0012!\u001c\t\u0003]Jt!a\u001c9\u0011\u00055+\u0014BA96\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E,\u0014!\u0002(B\u001b\u0016\u0003\u0013a\u00022vS2$WM]\u000b\u0002qB!\u00110!\u0001&\u001b\u0005Q(BA>}\u0003!1WO\\2uS>t'BA?\u007f\u0003\u0011)H/\u001b7\u000b\u0003}\fAA[1wC&\u0019\u00111\u0001>\u0003\u0011M+\b\u000f\u001d7jKJ\u0004")
public class RollbackSavepointsProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RollbackSavepointsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RollbackSavepointsProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        String instantTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieTimeline completedInstants = metaClient.getActiveTimeline().getSavePointTimeline().filterCompletedInstants();
        if (completedInstants.empty()) {
            throw new HoodieException("There are no completed savepoint to run delete");
        }
        HoodieInstant savePoint = new HoodieInstant(false, "savepoint", instantTime);
        if (!completedInstants.containsInstant(savePoint)) {
            throw new HoodieException(new StringBuilder(29).append("Commit ").append(instantTime).append(" not found in Commits ").append(completedInstants).toString());
        }
        SparkRDDWriteClient<HoodieRecordPayload<?>> client = this.createHoodieClient(this.jsc(), basePath);
        boolean result = false;
        try {
            client.restoreToSavepoint(instantTime);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The commit $instantTime rolled back.");
            result = true;
        }
        catch (HoodieSavepointException hoodieSavepointException) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("The commit ").append(instantTime).append(" failed to roll back.").toString());
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)}))}));
    }

    @Override
    public Procedure build() {
        return new RollbackSavepointsProcedure();
    }

    public RollbackSavepointsProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "instant_time", DataTypes.StringType, None$.MODULE$)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("rollback_savepoint_result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }
}

