/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContextImpl;
import org.apache.spark.TaskContextImpl$;
import org.apache.spark.streaming.kafka010.CacheKey;
import org.apache.spark.streaming.kafka010.InternalKafkaConsumer;
import org.apache.spark.streaming.kafka010.KafkaDataConsumer;
import org.apache.spark.streaming.kafka010.KafkaDataConsumer$;
import org.apache.spark.streaming.kafka010.KafkaTestUtils;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001E4AAD\b\u00015!)Q\u0006\u0001C\u0001]!I\u0011\u0007\u0001a\u0001\u0002\u0004%IA\r\u0005\nm\u0001\u0001\r\u00111A\u0005\n]B\u0011\u0002\u0011\u0001A\u0002\u0003\u0005\u000b\u0015B\u001a\t\u000f\u0005\u0003!\u0019!C\u0005\u0005\"11\n\u0001Q\u0001\n\rCq\u0001\u0014\u0001C\u0002\u0013%Q\n\u0003\u0004W\u0001\u0001\u0006IA\u0014\u0005\b/\u0002\u0011\r\u0011\"\u0003C\u0011\u0019A\u0006\u0001)A\u0005\u0007\")\u0011\f\u0001C!5\")1\f\u0001C!5\")A\f\u0001C\u0005;\n12*\u00194lC\u0012\u000bG/Y\"p]N,X.\u001a:Tk&$XM\u0003\u0002\u0011#\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u0013'\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003)U\tQa\u001d9be.T!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u001c?\u001d\u0002\"\u0001H\u000f\u000e\u0003MI!AH\n\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0001S%D\u0001\"\u0015\t\u00113%A\u0004n_\u000e\\\u0017\u000e^8\u000b\u0005\u0011:\u0012!D:dC2\fG/Z:ua2,8/\u0003\u0002'C\taQj\\2lSR|7+^4beB\u0011\u0001fK\u0007\u0002S)\u0011!fF\u0001\ng\u000e\fG.\u0019;fgRL!\u0001L\u0015\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG.\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011\u0001\u0007A\u0007\u0002\u001f\u0005IA/Z:u+RLGn]\u000b\u0002gA\u0011\u0001\u0007N\u0005\u0003k=\u0011abS1gW\u0006$Vm\u001d;Vi&d7/A\u0007uKN$X\u000b^5mg~#S-\u001d\u000b\u0003qy\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012A!\u00168ji\"9qhAA\u0001\u0002\u0004\u0019\u0014a\u0001=%c\u0005QA/Z:u+RLGn\u001d\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\t1\fgn\u001a\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUI\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\ta\n\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u000611m\\7n_:T!aU\u000b\u0002\u000b-\fgm[1\n\u0005U\u0003&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u00059qM]8va&#\u0017\u0001C4s_V\u0004\u0018\n\u001a\u0011\u0002\u0013\t,gm\u001c:f\u00032dG#\u0001\u001d\u0002\u0011\u00054G/\u001a:BY2\fabZ3u\u0017\u000647.\u0019)be\u0006l7\u000fF\u0001_!\u0011y&\r\u001a8\u000e\u0003\u0001T!!Y$\u0002\tU$\u0018\u000e\\\u0005\u0003G\u0002\u00141!T1q!\t)GN\u0004\u0002gUB\u0011qMO\u0007\u0002Q*\u0011\u0011.G\u0001\u0007yI|w\u000e\u001e \n\u0005-T\u0014A\u0002)sK\u0012,g-\u0003\u0002K[*\u00111N\u000f\t\u0003\t>L!\u0001]#\u0003\r=\u0013'.Z2u\u0001")
public class KafkaDataConsumerSuite
extends SparkFunSuite
implements MockitoSugar {
    private KafkaTestUtils testUtils;
    private final String topic;
    private final TopicPartition topicPartition;
    private final String groupId;

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    private KafkaTestUtils testUtils() {
        return this.testUtils;
    }

    private void testUtils_$eq(KafkaTestUtils x$1) {
        this.testUtils = x$1;
    }

    private String topic() {
        return this.topic;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private String groupId() {
        return this.groupId;
    }

    public void beforeAll() {
        super.beforeAll();
        SparkConf conf = new SparkConf();
        SparkEnv env = (SparkEnv)this.mock(ClassTag$.MODULE$.apply(SparkEnv.class));
        SparkEnv$.MODULE$.set(env);
        Mockito.when((Object)env.conf()).thenReturn((Object)conf);
        this.testUtils_$eq(new KafkaTestUtils());
        this.testUtils().setup();
        KafkaDataConsumer$.MODULE$.init(16, 64, 0.75f);
    }

    public void afterAll() {
        if (this.testUtils() != null) {
            this.testUtils().teardown();
            this.testUtils_$eq(null);
        }
        SparkEnv$.MODULE$.set(null);
        super.afterAll();
    }

    private java.util.Map<String, Object> getKafkaParams() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)this.groupId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.testUtils().brokerAddress()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key.deserializer"), (Object)ByteArrayDeserializer.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value.deserializer"), (Object)ByteArrayDeserializer.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"auto.offset.reset"), (Object)"earliest"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"enable.auto.commit"), (Object)"false")}))).asJava();
    }

    public static final /* synthetic */ String $anonfun$new$4(int x$1) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
    }

    public static final /* synthetic */ String $anonfun$new$5(KafkaDataConsumer consumer$1, int offset) {
        byte[] bytes = (byte[])consumer$1.get(offset, 10000L).value();
        return new String(bytes);
    }

    public final void org$apache$spark$streaming$kafka010$KafkaDataConsumerSuite$$consume$1(int i, java.util.Map kafkaParams$1, IndexedSeq data$1, VolatileObjectRef error$1) {
        boolean useCache = Random$.MODULE$.nextBoolean();
        TaskContextImpl taskContext = Random$.MODULE$.nextBoolean() ? new TaskContextImpl(0, 0, 0, 0L, Random$.MODULE$.nextInt(2), null, null, null, TaskContextImpl$.MODULE$.$lessinit$greater$default$9(), TaskContextImpl$.MODULE$.$lessinit$greater$default$10()) : null;
        KafkaDataConsumer consumer = KafkaDataConsumer$.MODULE$.acquire(this.topicPartition(), kafkaParams$1, (TaskContext)taskContext, useCache);
        try {
            try {
                IndexedSeq rcvd;
                IndexedSeq $org_scalatest_assert_macro_left = rcvd = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), data$1.length()).map((Function1 & Serializable & scala.Serializable)offset -> KafkaDataConsumerSuite.$anonfun$new$5(consumer, BoxesRunTime.unboxToInt((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq $org_scalatest_assert_macro_right = data$1;
                IndexedSeq indexedSeq = $org_scalatest_assert_macro_left;
                IndexedSeq indexedSeq2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(indexedSeq != null ? !indexedSeq.equals(indexedSeq2) : indexedSeq2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            }
            catch (Throwable e) {
                error$1.elem = e;
                throw e;
            }
        }
        finally {
            consumer.release();
        }
    }

    public KafkaDataConsumerSuite() {
        MockitoSugar.$init$((MockitoSugar)this);
        this.topic = new StringBuilder(5).append("topic").append(Random$.MODULE$.nextInt()).toString();
        this.topicPartition = new TopicPartition(this.topic(), 0);
        this.groupId = "groupId";
        this.test("KafkaDataConsumer reuse in case of same groupId and TopicPartition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InternalKafkaConsumer<?, ?> existingInternalConsumer;
            KafkaDataConsumer$.MODULE$.cache().clear();
            java.util.Map<String, Object> kafkaParams = this.getKafkaParams();
            KafkaDataConsumer consumer1 = KafkaDataConsumer$.MODULE$.acquire(this.topicPartition(), kafkaParams, null, true);
            consumer1.release();
            KafkaDataConsumer consumer2 = KafkaDataConsumer$.MODULE$.acquire(this.topicPartition(), kafkaParams, null, true);
            consumer2.release();
            java.util.Map<CacheKey, InternalKafkaConsumer<?, ?>> $org_scalatest_assert_macro_left = KafkaDataConsumer$.MODULE$.cache();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            CacheKey key = new CacheKey(this.groupId(), this.topicPartition());
            InternalKafkaConsumer<?, ?> $org_scalatest_assert_macro_left2 = existingInternalConsumer = KafkaDataConsumer$.MODULE$.cache().get(key);
            InternalKafkaConsumer $org_scalatest_assert_macro_right2 = consumer1.internalConsumer();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "eq", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            InternalKafkaConsumer<?, ?> $org_scalatest_assert_macro_left3 = existingInternalConsumer;
            InternalKafkaConsumer $org_scalatest_assert_macro_right3 = consumer2.internalConsumer();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "eq", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }, new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("new KafkaDataConsumer instance in case of Task retry", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KafkaDataConsumer$.MODULE$.cache().clear();
            java.util.Map<String, Object> kafkaParams = this.getKafkaParams();
            CacheKey key = new CacheKey(this.groupId(), this.topicPartition());
            TaskContextImpl context1 = new TaskContextImpl(0, 0, 0, 0L, 0, null, null, null, TaskContextImpl$.MODULE$.$lessinit$greater$default$9(), TaskContextImpl$.MODULE$.$lessinit$greater$default$10());
            KafkaDataConsumer consumer1 = KafkaDataConsumer$.MODULE$.acquire(this.topicPartition(), kafkaParams, (TaskContext)context1, true);
            consumer1.release();
            java.util.Map<CacheKey, InternalKafkaConsumer<?, ?>> $org_scalatest_assert_macro_left = KafkaDataConsumer$.MODULE$.cache();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            InternalKafkaConsumer<?, ?> $org_scalatest_assert_macro_left2 = KafkaDataConsumer$.MODULE$.cache().get(key);
            InternalKafkaConsumer $org_scalatest_assert_macro_right2 = consumer1.internalConsumer();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "eq", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            TaskContextImpl context2 = new TaskContextImpl(0, 0, 0, 0L, 1, null, null, null, TaskContextImpl$.MODULE$.$lessinit$greater$default$9(), TaskContextImpl$.MODULE$.$lessinit$greater$default$10());
            KafkaDataConsumer consumer2 = KafkaDataConsumer$.MODULE$.acquire(this.topicPartition(), kafkaParams, (TaskContext)context2, true);
            consumer2.release();
            java.util.Map<CacheKey, InternalKafkaConsumer<?, ?>> $org_scalatest_assert_macro_left3 = KafkaDataConsumer$.MODULE$.cache();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            InternalKafkaConsumer $org_scalatest_assert_macro_left4 = consumer1.internalConsumer();
            InternalKafkaConsumer $org_scalatest_assert_macro_right4 = consumer2.internalConsumer();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "ne", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4 != $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        }, new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("concurrent use of KafkaDataConsumer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            IndexedSeq data = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaDataConsumerSuite.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
            this.testUtils().createTopic(this.topic());
            this.testUtils().sendMessages(this.topic(), (String[])data.toArray(ClassTag$.MODULE$.apply(String.class)));
            java.util.Map<String, Object> kafkaParams = this.getKafkaParams();
            int numThreads = 100;
            int numConsumerUsages = 500;
            VolatileObjectRef error = VolatileObjectRef.create(null);
            ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
            try {
                IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numConsumerUsages).map((Function1 & Serializable & scala.Serializable)i -> threadPool.submit(new Runnable(this, BoxesRunTime.unboxToInt((Object)i), kafkaParams, data, error){
                    private final /* synthetic */ KafkaDataConsumerSuite $outer;
                    private final int i$1;
                    private final java.util.Map kafkaParams$1;
                    private final IndexedSeq data$1;
                    private final VolatileObjectRef error$1;

                    public void run() {
                        this.$outer.org$apache$spark$streaming$kafka010$KafkaDataConsumerSuite$$consume$1(this.i$1, this.kafkaParams$1, this.data$1, this.error$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                        this.kafkaParams$1 = kafkaParams$1;
                        this.data$1 = data$1;
                        this.error$1 = error$1;
                    }
                }), IndexedSeq$.MODULE$.canBuildFrom());
                futures.foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(1L, TimeUnit.MINUTES));
                Throwable $org_scalatest_assert_macro_left = (Throwable)error.elem;
                Object $org_scalatest_assert_macro_right = null;
                Throwable throwable = $org_scalatest_assert_macro_left;
                Object var11_10 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(throwable != null ? !throwable.equals(var11_10) : var11_10 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            }
            finally {
                threadPool.shutdown();
            }
            return assertion;
        }, new Position("KafkaDataConsumerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
    }
}

