/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.BadGatewayResponse;
import io.javalin.BadRequestResponse;
import io.javalin.ConflictResponse;
import io.javalin.Context;
import io.javalin.ForbiddenResponse;
import io.javalin.GatewayTimeoutResponse;
import io.javalin.GoneResponse;
import io.javalin.HttpResponseException;
import io.javalin.InternalServerErrorResponse;
import io.javalin.MethodNotAllowedResponse;
import io.javalin.NotFoundResponse;
import io.javalin.RedirectResponse;
import io.javalin.ServiceUnavailableResponse;
import io.javalin.UnauthorizedResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u001a\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u000b2\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/javalin/core/util/HttpResponseExceptionMapper;", "", "()V", "docsUrl", "", "canHandle", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "classUrl", "Lio/javalin/HttpResponseException;", "getTypeUrl", "handle", "", "exception", "ctx", "Lio/javalin/Context;", "isHttpResponseException", "t", "", "unwrap", "javalin"})
public final class HttpResponseExceptionMapper {
    private static final String docsUrl = "https://javalin.io/documentation#";
    public static final HttpResponseExceptionMapper INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canHandle(@NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        if (this.isHttpResponseException(e)) return true;
        if (!(e instanceof CompletionException)) return false;
        Throwable throwable = e.getCause();
        if (throwable == null) {
            Intrinsics.throwNpe();
        }
        if (!this.isHttpResponseException(throwable)) return false;
        return true;
    }

    private final boolean isHttpResponseException(Throwable t) {
        return HttpResponseException.class.isAssignableFrom(t.getClass());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void handle(@NotNull Exception exception, @NotNull Context ctx) {
        String string;
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        HttpResponseException e = this.unwrap(exception);
        String string2 = ctx.header("Accept");
        if (string2 != null && StringsKt.contains$default((CharSequence)string2, "application/json", false, 2, null) || Intrinsics.areEqual(ctx.res.getContentType(), "application/json")) {
            void $receiver$iv$iv2;
            void $receiver$iv;
            Object object = this.getTypeUrl(e);
            StringBuilder stringBuilder = new StringBuilder().append("{\n                |    \"title\": \"").append(e.getMessage()).append("\",\n                |    \"status\": ").append(e.getStatus()).append(",\n                |    \"type\": \"");
            Context context = ctx.status(e.getStatus());
            String string3 = object;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).toLowerCase()");
            Object object2 = string4;
            object = e.getDetails();
            stringBuilder = stringBuilder.append((String)object2).append("\",\n                |    \"details\": ");
            void var5_12 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList($receiver$iv.size());
            void var7_16 = $receiver$iv$iv2;
            Iterator iterator2 = var7_16.entrySet().iterator();
            while (true) {
                void it;
                Map.Entry item$iv$iv;
                if (!iterator2.hasNext()) {
                    object2 = (List)destination$iv$iv;
                    context.result(StringsKt.trimMargin$default(stringBuilder.append(object2).append("\n                |}").toString(), null, 1, null)).contentType("application/json");
                    return;
                }
                Map.Entry entry = item$iv$iv = iterator2.next();
                object2 = destination$iv$iv;
                String string5 = "{\"" + (String)it.getKey() + "\": \"" + (String)it.getValue() + "\"}";
                object2.add(string5);
            }
        }
        if (e.getDetails().isEmpty()) {
            string = String.valueOf(e.getMessage());
        } else {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Map<String, String> $receiver$iv$iv2 = e.getDetails();
            StringBuilder stringBuilder = new StringBuilder().append("\n                |").append(e.getMessage()).append("\n                |");
            void destination$iv$iv = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList($receiver$iv.size());
            void var8_19 = $receiver$iv$iv;
            Iterator iterator3 = var8_19.entrySet().iterator();
            while (iterator3.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry $i$a$1$map = item$iv$iv = iterator3.next();
                collection = destination$iv$iv2;
                String string6 = "\n                |" + (String)it.getKey() + ":\n                |" + (String)it.getValue() + "\n                |";
                collection.add(string6);
            }
            collection = (List)destination$iv$iv2;
            string = StringsKt.trimMargin$default(stringBuilder.append(CollectionsKt.joinToString$default(collection, "", null, null, 0, null, null, 62, null)).toString(), null, 1, null);
        }
        String result = string;
        ctx.status(e.getStatus()).result(result);
    }

    private final String classUrl(HttpResponseException e) {
        return docsUrl + e.getClass().getSimpleName();
    }

    private final HttpResponseException unwrap(Exception e) {
        Throwable throwable = e instanceof CompletionException ? e.getCause() : (Throwable)e;
        if (throwable == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.javalin.HttpResponseException");
        }
        return (HttpResponseException)throwable;
    }

    private final String getTypeUrl(HttpResponseException e) {
        HttpResponseException httpResponseException = e;
        return httpResponseException instanceof RedirectResponse ? this.classUrl(e) : (httpResponseException instanceof BadRequestResponse ? this.classUrl(e) : (httpResponseException instanceof UnauthorizedResponse ? this.classUrl(e) : (httpResponseException instanceof ForbiddenResponse ? this.classUrl(e) : (httpResponseException instanceof NotFoundResponse ? this.classUrl(e) : (httpResponseException instanceof MethodNotAllowedResponse ? this.classUrl(e) : (httpResponseException instanceof ConflictResponse ? this.classUrl(e) : (httpResponseException instanceof GoneResponse ? this.classUrl(e) : (httpResponseException instanceof InternalServerErrorResponse ? this.classUrl(e) : (httpResponseException instanceof ServiceUnavailableResponse ? this.classUrl(e) : (httpResponseException instanceof BadGatewayResponse ? this.classUrl(e) : (httpResponseException instanceof GatewayTimeoutResponse ? this.classUrl(e) : "https://javalin.io/documentation#error-responses")))))))))));
    }

    private HttpResponseExceptionMapper() {
    }

    static {
        HttpResponseExceptionMapper httpResponseExceptionMapper;
        INSTANCE = httpResponseExceptionMapper = new HttpResponseExceptionMapper();
    }
}

