/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.Context;
import io.javalin.core.HandlerEntry;
import io.javalin.core.HandlerType;
import io.javalin.core.PathMatcher;
import io.javalin.core.util.LogUtil;
import io.javalin.websocket.WsHandler;
import io.javalin.websocket.WsSession;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u001e\u0010\u0017\u001a\u00020\u000b*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u000fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/javalin/core/util/LogUtil;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "executionTimeMs", "", "ctx", "Lio/javalin/Context;", "logRequestAndResponse", "", "matcher", "Lio/javalin/core/PathMatcher;", "resBody", "", "gzipped", "", "staticFile", "startTimer", "wsDebugLogger", "ws", "Lio/javalin/websocket/WsHandler;", "logEvent", "Lio/javalin/websocket/WsSession;", "event", "additionalInfo", "javalin"})
public final class LogUtil {
    private static final Logger log;
    public static final LogUtil INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void logRequestAndResponse(@NotNull Context ctx, @NotNull PathMatcher matcher) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        Intrinsics.checkParameterIsNotNull(matcher, "matcher");
        try {
            String string;
            List v;
            Map.Entry entry;
            Map.Entry $$_$_v;
            Map map;
            Object k;
            Object k2;
            Map.Entry it$iv$iv;
            Map map2;
            Map<String, List<String>> $receiver$iv$iv;
            Map<String, List<String>> $receiver$iv;
            Object it3;
            Map<String, List<String>> $receiver;
            Object object;
            List allMatching;
            CharSequence charSequence;
            Collection collection;
            Context $receiver2;
            boolean staticFile;
            boolean gzipped;
            Formatter executionTimeMs;
            block14: {
                block13: {
                    Object object2;
                    Object item$iv$iv;
                    Object $receiver$iv$iv2;
                    Iterable $receiver$iv2;
                    HandlerType type = HandlerType.Companion.fromServletRequest(ctx.req);
                    String requestUri = ctx.req.getRequestURI();
                    executionTimeMs = new Formatter(Locale.US).format("%.2f", Float.valueOf(this.executionTimeMs(ctx)));
                    gzipped = Intrinsics.areEqual(ctx.res.getHeader("Content-Encoding"), "gzip");
                    staticFile = Intrinsics.areEqual(ctx.req.getAttribute("handled-as-static-file"), true);
                    $receiver2 = ctx;
                    String string2 = requestUri;
                    Intrinsics.checkExpressionValueIsNotNull(string2, "requestUri");
                    Iterable iterable = $receiver$iv2 = (Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)matcher.findEntries(HandlerType.BEFORE, string2), (Iterable)matcher.findEntries(type, requestUri)), (Iterable)matcher.findEntries(HandlerType.AFTER, requestUri));
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                    Iterator iterator2 = $receiver$iv$iv2.iterator();
                    while (iterator2.hasNext()) {
                        void it2;
                        item$iv$iv = iterator2.next();
                        HandlerEntry handlerEntry = (HandlerEntry)item$iv$iv;
                        collection = destination$iv$iv;
                        charSequence = it2.getType().name() + "=" + it2.getPath();
                        collection.add(charSequence);
                    }
                    allMatching = (List)destination$iv$iv;
                    object = $receiver2.resultStream();
                    if (object == null) break block13;
                    $receiver$iv$iv2 = object;
                    $receiver = $receiver$iv$iv2;
                    ((InputStream)((Object)$receiver)).reset();
                    object = $receiver$iv$iv2;
                    if (object == null) break block13;
                    $receiver$iv$iv2 = object;
                    $receiver = Charsets.UTF_8;
                    item$iv$iv = $receiver$iv$iv2;
                    item$iv$iv = new InputStreamReader((InputStream)item$iv$iv, (Charset)((Object)$receiver));
                    int it2 = 8192;
                    $receiver$iv$iv2 = item$iv$iv instanceof BufferedReader ? (BufferedReader)item$iv$iv : new BufferedReader((Reader)item$iv$iv, it2);
                    $receiver = null;
                    try {
                        it3 = (BufferedReader)$receiver$iv$iv2;
                        it3 = TextStreamsKt.readText((Reader)it3);
                        object2 = it3;
                    }
                    catch (Throwable it3) {
                        $receiver = it3;
                        throw it3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)$receiver$iv$iv2, (Throwable)((Object)$receiver));
                    }
                    object = object2;
                    if (object2 != null) break block14;
                }
                object = "";
            }
            Object resBody = object;
            Collection collection2 = $receiver2.res.getHeaderNames();
            Intrinsics.checkExpressionValueIsNotNull(collection2, "res.headerNames");
            Map resHeaders2 = MapsKt.toMap(SequencesKt.map(CollectionsKt.asSequence(collection2), (Function1)new Function1<String, Pair<? extends String, ? extends String>>($receiver2){
                final /* synthetic */ Context receiver$0;

                @NotNull
                public final Pair<String, String> invoke(String it) {
                    return TuplesKt.to(it, this.receiver$0.res.getHeader(it));
                }
                {
                    this.receiver$0 = context;
                    super(1);
                }
            }));
            $receiver = $receiver2.queryParamMap();
            charSequence = new StringBuilder().append("JAVALIN REQUEST DEBUG LOG:\n                        |Request: ").append($receiver2.method()).append(" [").append($receiver2.path()).append("]\n                        |    Matching endpoint-handlers: ").append(allMatching).append("\n                        |    Headers: ").append($receiver2.headerMap()).append("\n                        |    Cookies: ").append($receiver2.cookieMap()).append("\n                        |    Body: ").append($receiver2.isMultipart() ? "Multipart data ..." : $receiver2.body()).append("\n                        |    QueryString: ").append($receiver2.queryString()).append("\n                        |    QueryParams: ");
            collection = log;
            it3 = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Map.Entry $i$f$map = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                k2 = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map = map2;
                entry = $$_$_v;
                v = (List)entry.getValue();
                string = v.toString();
                map.put(k, string);
            }
            map = destination$iv$iv;
            $receiver$iv = $receiver2.formParamMap();
            charSequence = ((StringBuilder)charSequence).append(map).append("\n                        |    FormParams: ");
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
            $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                k2 = it$iv$iv.getKey();
                $$_$_v = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map = map2;
                entry = $$_$_v;
                v = (List)entry.getValue();
                string = v.toString();
                map.put(k, string);
            }
            map = destination$iv$iv;
            collection.info(StringsKt.trimMargin$default(((StringBuilder)charSequence).append(map).append("\n                        |Response: [").append($receiver2.status()).append("], execution took ").append(executionTimeMs).append(" ms\n                        |    Headers: ").append(resHeaders2).append("\n                        |    ").append(INSTANCE.resBody((String)resBody, gzipped, staticFile)).append("\n                        |----------------------------------------------------------------------------------").toString(), null, 1, null));
        }
        catch (Exception e) {
            log.info("An exception occurred while logging debug-info", (Throwable)e);
        }
    }

    private final String resBody(String resBody, boolean gzipped, boolean staticFile) {
        CharSequence charSequence;
        return staticFile ? "Body is a static file (not logged)" : ((charSequence = (CharSequence)resBody).length() > 0 && gzipped ? "Body is gzipped (" + resBody.length() + " bytes, not logged)" : ((charSequence = (CharSequence)resBody).length() > 0 && !gzipped ? "Body is " + resBody.length() + " bytes (starts on next line):\n    " + resBody : "No body was set"));
    }

    public final void startTimer(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        ctx.attribute("javalin-request-log-start-time", System.nanoTime());
    }

    public final float executionTimeMs(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        long l = System.nanoTime();
        Object t = ctx.attribute("javalin-request-log-start-time");
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return (float)(l - ((Number)t).longValue()) / 1000000.0f;
    }

    @JvmStatic
    public static final void wsDebugLogger(@NotNull WsHandler ws) {
        Intrinsics.checkParameterIsNotNull(ws, "ws");
        ws.onConnect(wsDebugLogger.1.INSTANCE);
        ws.onMessage(wsDebugLogger.2.INSTANCE);
        ws.onMessage(wsDebugLogger.3.INSTANCE);
        ws.onClose(wsDebugLogger.4.INSTANCE);
        ws.onError(wsDebugLogger.5.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void logEvent(@NotNull WsSession $receiver, String event, String additionalInfo) {
        String string;
        Logger logger = log;
        StringBuilder stringBuilder = new StringBuilder().append("JAVALIN WEBSOCKET DEBUG LOG\n                |WebSocket Event: ").append(event).append("\n                |Session Id: ").append($receiver.getId()).append("\n                |Host: ").append($receiver.host()).append("\n                |Matched Path: ").append($receiver.matchedPath()).append("\n                |PathParams: ").append($receiver.pathParamMap()).append("\n                |QueryParams: ");
        if ($receiver.queryString() != null) {
            Map map;
            void $receiver$iv$iv;
            void $receiver$iv;
            Map<String, List<String>> map2 = $receiver.queryParamMap();
            StringBuilder stringBuilder2 = stringBuilder;
            Logger logger2 = logger;
            void var5_7 = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                void $$_$_v;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                map = map3;
                void var14_16 = $$_$_v;
                List v = (List)var14_16.getValue();
                String string2 = v.toString();
                map.put(k2, string2);
            }
            map = destination$iv$iv;
            logger = logger2;
            stringBuilder = stringBuilder2;
            string = map.toString();
        } else {
            string = "No query string was provided";
        }
        logger.info(StringsKt.trimMargin$default(stringBuilder.append(string).append("\n                |").append(additionalInfo).append("\n                |----------------------------------------------------------------------------------").toString(), null, 1, null));
    }

    static /* bridge */ /* synthetic */ void logEvent$default(LogUtil logUtil, WsSession wsSession, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        logUtil.logEvent(wsSession, string, string2);
    }

    private LogUtil() {
    }

    static {
        LogUtil logUtil;
        INSTANCE = logUtil = new LogUtil();
        log = LoggerFactory.getLogger(LogUtil.class);
    }

    public static final /* synthetic */ void access$logEvent(LogUtil $this, @NotNull WsSession $receiver, @NotNull String event, @NotNull String additionalInfo) {
        $this.logEvent($receiver, event, additionalInfo);
    }
}

