/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieBaseRelation;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieDataSourceHelper$;
import org.apache.hudi.HoodieFileIndex$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieMergeOnReadRDD;
import org.apache.hudi.HoodieTableSchema;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.MergeOnReadSnapshotRelation$;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.spark.execution.datasources.HoodieInMemoryFileIndex;
import org.apache.spark.execution.datasources.HoodieInMemoryFileIndex$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.PartitionedFile$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001\u0002\u000b\u0016\u0001qA\u0011\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0016\t\u0013-\u0002!\u0011!Q\u0001\n1b\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011!\u0003!\u0011!Q\u0001\n%C\u0011B\u0017\u0001\u0003\u0002\u0003\u0006IaW2\t\u000b\u0011\u0004A\u0011A3\u0006\t1\u0004\u0001%\u001c\u0005\ta\u0002A)\u0019!C!c\"91\u000f\u0001b\u0001\n#!\bBB;\u0001A\u0003%\u0011\bC\u0003w\u0001\u0011\u0005s\u000fC\u0003}\u0001\u0011ES\u0010C\u0004\u00022\u0001!\t&a\r\t\u000f\u0005U\u0003\u0001\"\u0005\u0002X!9\u00111\u000e\u0001\u0005\n\u00055taBA:+!\u0005\u0011Q\u000f\u0004\u0007)UA\t!a\u001e\t\r\u0011\fB\u0011AA@\u0011\u001d\t\t)\u0005C\u0001\u0003\u0007\u00131$T3sO\u0016|eNU3bINs\u0017\r]:i_R\u0014V\r\\1uS>t'B\u0001\f\u0018\u0003\u0011AW\u000fZ5\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001f?5\tQ#\u0003\u0002!+\t\u0011\u0002j\\8eS\u0016\u0014\u0015m]3SK2\fG/[8o\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\n1a]9m\u0015\t9s#A\u0003ta\u0006\u00148.\u0003\u0002*I\tQ1+\u0015'D_:$X\r\u001f;\n\u0005\u0005z\u0012!C8qiB\u000b'/Y7t!\u0011ic'O\u001d\u000f\u00059\"\u0004CA\u00183\u001b\u0005\u0001$BA\u0019\u001c\u0003\u0019a$o\\8u})\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\u00075\u000b\u0007O\u0003\u00026eA\u0011QFO\u0005\u0003wa\u0012aa\u0015;sS:<\u0017BA\u0016 \u0003))8/\u001a:TG\",W.\u0019\t\u0004\u007f\u0001\u0013U\"\u0001\u001a\n\u0005\u0005\u0013$AB(qi&|g\u000e\u0005\u0002D\r6\tAI\u0003\u0002FI\u0005)A/\u001f9fg&\u0011q\t\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017!C4m_\n\u0004\u0016\r\u001e5t!\rQuJ\u0015\b\u0003\u00176s!a\f'\n\u0003MJ!A\u0014\u001a\u0002\u000fA\f7m[1hK&\u0011\u0001+\u0015\u0002\u0004'\u0016\f(B\u0001(3!\t\u0019\u0006,D\u0001U\u0015\t)f+\u0001\u0002gg*\u0011qkF\u0001\u0007Q\u0006$wn\u001c9\n\u0005e#&\u0001\u0002)bi\"\f!\"\\3uC\u000ec\u0017.\u001a8u!\ta\u0016-D\u0001^\u0015\tqv,A\u0003uC\ndWM\u0003\u0002a+\u000511m\\7n_:L!AY/\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi&\u0011!lH\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0019<\u0007.\u001b6l!\tq\u0002\u0001C\u0003\"\r\u0001\u0007!\u0005C\u0003,\r\u0001\u0007A\u0006C\u0003>\r\u0001\u0007a\bC\u0003I\r\u0001\u0007\u0011\nC\u0003[\r\u0001\u00071LA\u0005GS2,7\u000b\u001d7jiB\u0011aD\\\u0005\u0003_V\u0011!\u0004S8pI&,W*\u001a:hK>s'+Z1e\r&dWm\u00159mSR\fq\"\\1oI\u0006$xN]=GS\u0016dGm]\u000b\u0002eB\u0019!jT\u001d\u0002\u00135,'oZ3UsB,W#A\u001d\u0002\u00155,'oZ3UsB,\u0007%\u0001\u0007j[\n,XmQ8oM&<7\u000f\u0006\u0002ywB\u0011q(_\u0005\u0003uJ\u0012A!\u00168ji\")\u0011e\u0003a\u0001E\u0005Q1m\\7q_N,'\u000b\u0012#\u0015\u0017y\f\u0019!!\u0003\u0002\u000e\u0005]\u00111\u0004\t\u0003=}L1!!\u0001\u0016\u0005QAun\u001c3jK6+'oZ3P]J+\u0017\r\u001a*E\t\"9\u0011Q\u0001\u0007A\u0002\u0005\u001d\u0011A\u00034jY\u0016\u001c\u0006\u000f\\5ugB\u0019!jT7\t\r\u0005-A\u00021\u0001C\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007bBA\b\u0019\u0001\u0007\u0011\u0011C\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007c\u0001\u0010\u0002\u0014%\u0019\u0011QC\u000b\u0003#!{w\u000eZ5f)\u0006\u0014G.Z*dQ\u0016l\u0017\rC\u0004\u0002\u001a1\u0001\r!!\u0005\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u0011Q\u0004\u0007A\u0002\u0005}\u0011a\u00024jYR,'o\u001d\t\u0006\u007f\u0005\u0005\u0012QE\u0005\u0004\u0003G\u0011$!B!se\u0006L\b\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-B%A\u0004t_V\u00148-Z:\n\t\u0005=\u0012\u0011\u0006\u0002\u0007\r&dG/\u001a:\u0002#\r|G\u000e\\3di\u001aKG.Z*qY&$8\u000f\u0006\u0004\u00026\u0005m\u0012\u0011\u000b\t\u0005\u0015\u0006]R.C\u0002\u0002:E\u0013A\u0001T5ti\"9\u0011QH\u0007A\u0002\u0005}\u0012\u0001\u00059beRLG/[8o\r&dG/\u001a:t!\u0011Qu*!\u0011\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\tY\u0005J\u0001\tG\u0006$\u0018\r\\=ti&!\u0011qJA#\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0003'j\u0001\u0019AA \u0003-!\u0017\r^1GS2$XM]:\u0002\u0017\t,\u0018\u000e\u001c3Ta2LGo\u001d\u000b\u0005\u0003k\tI\u0006C\u0004\u0002\\9\u0001\r!!\u0018\u0002\u0015\u0019LG.Z*mS\u000e,7\u000f\u0005\u0003K\u001f\u0006}\u0003\u0003BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015t,A\u0003n_\u0012,G.\u0003\u0003\u0002j\u0005\r$!\u0003$jY\u0016\u001cF.[2f\u00039a\u0017n\u001d;GS2,7\u000b\\5dKN$B!!\u0018\u0002p!1\u0011\u0011O\bA\u0002%\u000ba\u0002]1si&$\u0018n\u001c8QCRD7/A\u000eNKJ<Wm\u00148SK\u0006$7K\\1qg\"|GOU3mCRLwN\u001c\t\u0003=E\u00192!EA=!\ry\u00141P\u0005\u0004\u0003{\u0012$AB!osJ+g\r\u0006\u0002\u0002v\u0005Yq-\u001a;GS2,\u0007+\u0019;i)\rI\u0014Q\u0011\u0005\u0007\u0003\u000f\u001b\u0002\u0019\u0001*\u0002\tA\fG\u000f\u001b")
public class MergeOnReadSnapshotRelation
extends HoodieBaseRelation {
    private Seq<String> mandatoryFields;
    private final Seq<Path> globPaths;
    private final String mergeType;
    private volatile boolean bitmap$0;

    public static String getFilePath(Path path) {
        return MergeOnReadSnapshotRelation$.MODULE$.getFilePath(path);
    }

    private Seq<String> mandatoryFields$lzycompute() {
        MergeOnReadSnapshotRelation mergeOnReadSnapshotRelation = this;
        synchronized (mergeOnReadSnapshotRelation) {
            if (!this.bitmap$0) {
                this.mandatoryFields = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.recordKeyField()}))).$plus$plus((GenTraversableOnce)this.preCombineFieldOpt().map((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$1}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = true;
            }
        }
        return this.mandatoryFields;
    }

    @Override
    public Seq<String> mandatoryFields() {
        return !this.bitmap$0 ? this.mandatoryFields$lzycompute() : this.mandatoryFields;
    }

    public String mergeType() {
        return this.mergeType;
    }

    @Override
    public void imbueConfigs(SQLContext sqlContext) {
        super.imbueConfigs(sqlContext);
        sqlContext.sparkSession().sessionState().conf().setConfString("spark.sql.parquet.enableVectorizedReader", "true");
    }

    public HoodieMergeOnReadRDD composeRDD(Seq<HoodieMergeOnReadFileSplit> fileSplits, StructType partitionSchema, HoodieTableSchema dataSchema, HoodieTableSchema requiredSchema, Filter[] filters) {
        Function1<PartitionedFile, Iterator<InternalRow>> fullSchemaParquetReader = this.createBaseFileReader(super.sqlContext().sparkSession(), partitionSchema, dataSchema, dataSchema, (Seq<Filter>)((Seq)Seq$.MODULE$.empty()), super.optParams(), HoodieDataSourceHelper$.MODULE$.getConfigurationWithInternalSchema(new Configuration(this.conf()), this.internalSchema(), super.metaClient().getBasePath(), this.validCommits()));
        Function1<PartitionedFile, Iterator<InternalRow>> requiredSchemaParquetReader = this.createBaseFileReader(super.sqlContext().sparkSession(), partitionSchema, dataSchema, requiredSchema, (Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])filters), super.optParams(), HoodieDataSourceHelper$.MODULE$.getConfigurationWithInternalSchema(new Configuration(this.conf()), requiredSchema.internalSchema(), super.metaClient().getBasePath(), this.validCommits()));
        HoodieTableState tableState = this.getTableState();
        return new HoodieMergeOnReadRDD(super.sqlContext().sparkContext(), (Configuration)this.jobConf(), fullSchemaParquetReader, requiredSchemaParquetReader, dataSchema, requiredSchema, tableState, this.mergeType(), fileSplits);
    }

    public List<HoodieMergeOnReadFileSplit> collectFileSplits(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        List<HoodieMergeOnReadFileSplit> list;
        Seq<Expression> convertedPartitionFilters = HoodieFileIndex$.MODULE$.convertFilterForTimestampKeyGenerator(super.metaClient(), partitionFilters);
        if (this.globPaths.isEmpty()) {
            Map<String, Seq<FileSlice>> fileSlices = this.fileIndex().listFileSlices(convertedPartitionFilters);
            list = this.buildSplits((Seq<FileSlice>)((TraversableOnce)fileSlices.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq());
        } else {
            Map<Path, Seq<FileStatus>> partitions = this.listLatestBaseFiles(this.globPaths, convertedPartitionFilters, dataFilters);
            Seq partitionPaths = partitions.keys().toSeq();
            if (partitionPaths.isEmpty() || this.latestInstant().isEmpty()) {
                list = List$.MODULE$.empty();
            } else {
                Seq<FileSlice> fileSlices = this.listFileSlices((Seq<Path>)partitionPaths);
                list = this.buildSplits(fileSlices);
            }
        }
        return list;
    }

    public List<HoodieMergeOnReadFileSplit> buildSplits(Seq<FileSlice> fileSlices) {
        return ((TraversableOnce)fileSlices.map((Function1 & Serializable & scala.Serializable)fileSlice -> {
            Option<HoodieBaseFile> baseFile = HoodieConversionUtils$.MODULE$.toScalaOption(fileSlice.getBaseFile());
            List logFiles = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(fileSlice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).iterator()).asScala()).toList();
            Option partitionedBaseFile = baseFile.map((Function1 & Serializable & scala.Serializable)file -> {
                String filePath = MergeOnReadSnapshotRelation$.MODULE$.getFilePath(file.getFileStatus().getPath());
                return new PartitionedFile(this.getPartitionColumnsAsInternalRow(file.getFileStatus()), filePath, 0L, file.getFileLen(), PartitionedFile$.MODULE$.apply$default$5());
            });
            return new HoodieMergeOnReadFileSplit((Option<PartitionedFile>)partitionedBaseFile, (List<HoodieLogFile>)logFiles);
        }, Seq$.MODULE$.canBuildFrom())).toList();
    }

    private Seq<FileSlice> listFileSlices(Seq<Path> partitionPaths) {
        HoodieInMemoryFileIndex inMemoryFileIndex = HoodieInMemoryFileIndex$.MODULE$.create(this.sparkSession(), partitionPaths);
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(super.metaClient(), this.timeline(), (FileStatus[])inMemoryFileIndex.allFiles().toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
        String queryTimestamp = (String)this.queryTimestamp().get();
        return (Seq)partitionPaths.flatMap((Function1 & Serializable & scala.Serializable)partitionPath -> {
            String relativePath = FSUtils.getRelativePartitionPath(new Path(this.basePath()), partitionPath);
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestMergedFileSlicesBeforeOrOn(relativePath, queryTimestamp).iterator()).asScala()).toSeq();
        }, Seq$.MODULE$.canBuildFrom());
    }

    public MergeOnReadSnapshotRelation(SQLContext sqlContext, Map<String, String> optParams, Option<StructType> userSchema, Seq<Path> globPaths, HoodieTableMetaClient metaClient) {
        this.globPaths = globPaths;
        super(sqlContext, metaClient, optParams, userSchema);
        this.mergeType = (String)super.optParams().getOrElse((Object)DataSourceReadOptions$.MODULE$.REALTIME_MERGE().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceReadOptions$.MODULE$.REALTIME_MERGE().defaultValue());
    }
}

