/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.sync;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.aws.sync.AWSGlueCatalogSyncClient;
import org.apache.hudi.com.beust.jcommander.JCommander;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncTool;

public class AwsGlueCatalogSyncTool
extends HiveSyncTool {
    public AwsGlueCatalogSyncTool(TypedProperties props, Configuration conf, FileSystem fs) {
        super(props, (Configuration)new HiveConf(conf, HiveConf.class), fs);
    }

    public AwsGlueCatalogSyncTool(HiveSyncConfig hiveSyncConfig, HiveConf hiveConf, FileSystem fs) {
        super(hiveSyncConfig, hiveConf, fs);
    }

    @Override
    protected void initClient(HiveSyncConfig hiveSyncConfig, HiveConf hiveConf) {
        this.hoodieHiveClient = new AWSGlueCatalogSyncClient(hiveSyncConfig, (Configuration)hiveConf, this.fs);
    }

    public static void main(String[] args) {
        HiveSyncConfig cfg = new HiveSyncConfig();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        FileSystem fs = FSUtils.getFs(cfg.basePath, new Configuration());
        HiveConf hiveConf = new HiveConf();
        hiveConf.addResource(fs.getConf());
        new AwsGlueCatalogSyncTool(cfg, hiveConf, fs).syncHoodieTable();
    }
}

