/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.bootstrap;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.client.bootstrap.HoodieBootstrapSchemaProvider;
import org.apache.hudi.common.bootstrap.FileStatusUtils;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class HoodieSparkBootstrapSchemaProvider
extends HoodieBootstrapSchemaProvider {
    public HoodieSparkBootstrapSchemaProvider(HoodieWriteConfig writeConfig) {
        super(writeConfig);
    }

    @Override
    protected Schema getBootstrapSourceSchema(HoodieEngineContext context, List<Pair<String, List<HoodieFileStatus>>> partitions) {
        Schema schema = partitions.stream().flatMap(p -> ((List)p.getValue()).stream()).map(fs -> {
            Path filePath = FileStatusUtils.toPath(fs.getPath());
            String extension = FSUtils.getFileExtension(filePath.getName());
            if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
                return HoodieSparkBootstrapSchemaProvider.getBootstrapSourceSchemaParquet(this.writeConfig, context, filePath);
            }
            if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
                return HoodieSparkBootstrapSchemaProvider.getBootstrapSourceSchemaOrc(this.writeConfig, context, filePath);
            }
            throw new HoodieException("Could not determine schema from the data files.");
        }).filter(Objects::nonNull).findAny().orElseThrow(() -> new HoodieException("Could not determine schema from the data files."));
        return schema;
    }

    private static Schema getBootstrapSourceSchemaParquet(HoodieWriteConfig writeConfig, HoodieEngineContext context, Path filePath) {
        MessageType parquetSchema = new ParquetUtils().readSchema(context.getHadoopConf().get(), filePath);
        ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(Boolean.parseBoolean(SQLConf.PARQUET_BINARY_AS_STRING().defaultValueString()), Boolean.parseBoolean(SQLConf.PARQUET_INT96_AS_TIMESTAMP().defaultValueString()));
        StructType sparkSchema = converter.convert(parquetSchema);
        String tableName = HoodieAvroUtils.sanitizeName(writeConfig.getTableName());
        String structName = tableName + "_record";
        String recordNamespace = "hoodie." + tableName;
        return AvroConversionUtils.convertStructTypeToAvroSchema((DataType)sparkSchema, structName, recordNamespace);
    }

    private static Schema getBootstrapSourceSchemaOrc(HoodieWriteConfig writeConfig, HoodieEngineContext context, Path filePath) {
        Reader orcReader = null;
        try {
            orcReader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)context.getHadoopConf().get()));
        }
        catch (IOException e) {
            throw new HoodieException("Could not determine schema from the data files.");
        }
        TypeDescription orcSchema = orcReader.getSchema();
        String tableName = HoodieAvroUtils.sanitizeName(writeConfig.getTableName());
        String structName = tableName + "_record";
        String recordNamespace = "hoodie." + tableName;
        return AvroOrcUtils.createAvroSchemaWithDefaultValue(orcSchema, structName, recordNamespace, true);
    }
}

