/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.model;

import org.apache.hudi.common.model.HoodieRecord;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class HoodieInternalRow
extends InternalRow {
    private String commitTime;
    private String commitSeqNumber;
    private String recordKey;
    private String partitionPath;
    private String fileName;
    private InternalRow row;

    public HoodieInternalRow(String commitTime, String commitSeqNumber, String recordKey, String partitionPath, String fileName, InternalRow row) {
        this.commitTime = commitTime;
        this.commitSeqNumber = commitSeqNumber;
        this.recordKey = recordKey;
        this.partitionPath = partitionPath;
        this.fileName = fileName;
        this.row = row;
    }

    public int numFields() {
        return this.row.numFields();
    }

    public void setNullAt(int i) {
        block8: {
            block7: {
                if (i >= HoodieRecord.HOODIE_META_COLUMNS.size()) break block7;
                switch (i) {
                    case 0: {
                        this.commitTime = null;
                        break block8;
                    }
                    case 1: {
                        this.commitSeqNumber = null;
                        break block8;
                    }
                    case 2: {
                        this.recordKey = null;
                        break block8;
                    }
                    case 3: {
                        this.partitionPath = null;
                        break block8;
                    }
                    case 4: {
                        this.fileName = null;
                        break block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Not expected");
                    }
                }
            }
            this.row.setNullAt(i);
        }
    }

    public void update(int i, Object value) {
        block8: {
            block7: {
                if (i >= HoodieRecord.HOODIE_META_COLUMNS.size()) break block7;
                switch (i) {
                    case 0: {
                        this.commitTime = value.toString();
                        break block8;
                    }
                    case 1: {
                        this.commitSeqNumber = value.toString();
                        break block8;
                    }
                    case 2: {
                        this.recordKey = value.toString();
                        break block8;
                    }
                    case 3: {
                        this.partitionPath = value.toString();
                        break block8;
                    }
                    case 4: {
                        this.fileName = value.toString();
                        break block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Not expected");
                    }
                }
            }
            this.row.update(i, value);
        }
    }

    private String getMetaColumnVal(int ordinal) {
        switch (ordinal) {
            case 0: {
                return this.commitTime;
            }
            case 1: {
                return this.commitSeqNumber;
            }
            case 2: {
                return this.recordKey;
            }
            case 3: {
                return this.partitionPath;
            }
            case 4: {
                return this.fileName;
            }
        }
        throw new IllegalArgumentException("Not expected");
    }

    public boolean isNullAt(int ordinal) {
        if (ordinal < HoodieRecord.HOODIE_META_COLUMNS.size()) {
            return null == this.getMetaColumnVal(ordinal);
        }
        return this.row.isNullAt(ordinal);
    }

    public boolean getBoolean(int ordinal) {
        return this.row.getBoolean(ordinal);
    }

    public byte getByte(int ordinal) {
        return this.row.getByte(ordinal);
    }

    public short getShort(int ordinal) {
        return this.row.getShort(ordinal);
    }

    public int getInt(int ordinal) {
        return this.row.getInt(ordinal);
    }

    public long getLong(int ordinal) {
        return this.row.getLong(ordinal);
    }

    public float getFloat(int ordinal) {
        return this.row.getFloat(ordinal);
    }

    public double getDouble(int ordinal) {
        return this.row.getDouble(ordinal);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.row.getDecimal(ordinal, precision, scale);
    }

    public UTF8String getUTF8String(int ordinal) {
        if (ordinal < HoodieRecord.HOODIE_META_COLUMNS.size()) {
            return UTF8String.fromBytes((byte[])this.getMetaColumnVal(ordinal).getBytes());
        }
        return this.row.getUTF8String(ordinal);
    }

    public String getString(int ordinal) {
        if (ordinal < HoodieRecord.HOODIE_META_COLUMNS.size()) {
            return new String(this.getMetaColumnVal(ordinal).getBytes());
        }
        return this.row.getString(ordinal);
    }

    public byte[] getBinary(int ordinal) {
        return this.row.getBinary(ordinal);
    }

    public CalendarInterval getInterval(int ordinal) {
        return this.row.getInterval(ordinal);
    }

    public InternalRow getStruct(int ordinal, int numFields) {
        return this.row.getStruct(ordinal, numFields);
    }

    public ArrayData getArray(int ordinal) {
        return this.row.getArray(ordinal);
    }

    public MapData getMap(int ordinal) {
        return this.row.getMap(ordinal);
    }

    public Object get(int ordinal, DataType dataType) {
        if (ordinal < HoodieRecord.HOODIE_META_COLUMNS.size()) {
            return UTF8String.fromBytes((byte[])this.getMetaColumnVal(ordinal).getBytes());
        }
        return this.row.get(ordinal, dataType);
    }

    public InternalRow copy() {
        return new HoodieInternalRow(this.commitTime, this.commitSeqNumber, this.recordKey, this.partitionPath, this.fileName, this.row.copy());
    }
}

