/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LockManager
implements Serializable,
AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(LockManager.class);
    private final HoodieWriteConfig writeConfig;
    private final LockConfiguration lockConfiguration;
    private final SerializableConfiguration hadoopConf;
    private final int maxRetries;
    private final long maxWaitTimeInMs;
    private volatile LockProvider lockProvider;

    public LockManager(HoodieWriteConfig writeConfig, FileSystem fs) {
        this.writeConfig = writeConfig;
        this.hadoopConf = new SerializableConfiguration(fs.getConf());
        this.lockConfiguration = new LockConfiguration(writeConfig.getProps());
        this.maxRetries = this.lockConfiguration.getConfig().getInteger("hoodie.write.lock.client.num_retries", Integer.parseInt(HoodieLockConfig.LOCK_ACQUIRE_CLIENT_NUM_RETRIES.defaultValue()));
        this.maxWaitTimeInMs = this.lockConfiguration.getConfig().getLong("hoodie.write.lock.client.wait_time_ms_between_retry", Long.parseLong(HoodieLockConfig.LOCK_ACQUIRE_CLIENT_RETRY_WAIT_TIME_IN_MILLIS.defaultValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        if (this.writeConfig.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl()) {
            LockProvider lockProvider = this.getLockProvider();
            int retryCount = 0;
            boolean acquired = false;
            while (retryCount <= this.maxRetries) {
                try {
                    acquired = lockProvider.tryLock(this.writeConfig.getLockAcquireWaitTimeoutInMs(), TimeUnit.MILLISECONDS);
                    if (acquired) break;
                    LOG.info((Object)"Retrying to acquire lock...");
                    Thread.sleep(this.maxWaitTimeInMs);
                }
                catch (InterruptedException | HoodieLockException e) {
                    if (retryCount < this.maxRetries) continue;
                    throw new HoodieLockException("Unable to acquire lock, lock object ", e);
                }
                finally {
                    ++retryCount;
                }
            }
            if (!acquired) {
                throw new HoodieLockException("Unable to acquire lock, lock object " + lockProvider.getLock());
            }
        }
    }

    public void unlock() {
        if (this.writeConfig.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl()) {
            this.getLockProvider().unlock();
        }
    }

    public synchronized LockProvider getLockProvider() {
        if (this.lockProvider == null) {
            LOG.info((Object)("LockProvider " + this.writeConfig.getLockProviderClass()));
            this.lockProvider = (LockProvider)ReflectionUtils.loadClass(this.writeConfig.getLockProviderClass(), this.lockConfiguration, this.hadoopConf.get());
        }
        return this.lockProvider;
    }

    @Override
    public void close() {
        this.closeQuietly();
    }

    private void closeQuietly() {
        try {
            if (this.lockProvider != null) {
                this.lockProvider.close();
                LOG.info((Object)"Released connection created for acquiring lock");
                this.lockProvider = null;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to close and release connection created for acquiring lock", (Throwable)e);
        }
    }
}

