/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieConfig
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(HoodieConfig.class);
    protected static final String CONFIG_VALUES_DELIMITER = ",";
    protected TypedProperties props;

    public static HoodieConfig create(FSDataInputStream inputStream) throws IOException {
        HoodieConfig config = new HoodieConfig();
        config.props.load((InputStream)inputStream);
        return config;
    }

    public HoodieConfig() {
        this.props = new TypedProperties();
    }

    public HoodieConfig(Properties props) {
        this.props = new TypedProperties(props);
    }

    public <T> void setValue(ConfigProperty<T> cfg, String val) {
        cfg.checkValues(val);
        this.props.setProperty(cfg.key(), val);
    }

    public <T> void setValue(String key, String val) {
        this.props.setProperty(key, val);
    }

    public void setAll(Properties properties) {
        this.props.putAll((Map<?, ?>)properties);
    }

    public <T> void setDefaultValue(ConfigProperty<T> configProperty) {
        if (!this.contains(configProperty)) {
            Option inferValue = Option.empty();
            if (configProperty.getInferFunc().isPresent()) {
                inferValue = configProperty.getInferFunc().get().apply(this);
            }
            this.props.setProperty(configProperty.key(), inferValue.isPresent() ? inferValue.get().toString() : configProperty.defaultValue().toString());
        }
    }

    public <T> void setDefaultValue(ConfigProperty<T> configProperty, T defaultVal) {
        if (!this.contains(configProperty)) {
            this.props.setProperty(configProperty.key(), defaultVal.toString());
        }
    }

    public Boolean contains(String key) {
        return this.props.containsKey(key);
    }

    public <T> boolean contains(ConfigProperty<T> configProperty) {
        if (this.props.containsKey(configProperty.key())) {
            return true;
        }
        return configProperty.getAlternatives().stream().anyMatch(this.props::containsKey);
    }

    private <T> Option<Object> getRawValue(ConfigProperty<T> configProperty) {
        if (this.props.containsKey(configProperty.key())) {
            return Option.ofNullable(this.props.get(configProperty.key()));
        }
        for (String alternative : configProperty.getAlternatives()) {
            if (!this.props.containsKey(alternative)) continue;
            LOG.warn((Object)String.format("The configuration key '%s' has been deprecated and may be removed in the future. Please use the new key '%s' instead.", alternative, configProperty.key()));
            return Option.ofNullable(this.props.get(alternative));
        }
        return Option.empty();
    }

    protected void setDefaults(String configClassName) {
        Class<?> configClass = ReflectionUtils.getClass(configClassName);
        Arrays.stream(configClass.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> f.getType().isAssignableFrom(ConfigProperty.class)).forEach(f -> {
            try {
                ConfigProperty cfgProp = (ConfigProperty)f.get("null");
                if (cfgProp.hasDefaultValue()) {
                    this.setDefaultValue(cfgProp);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    public <T> String getString(ConfigProperty<T> configProperty) {
        Option<Object> rawValue = this.getRawValue(configProperty);
        return rawValue.map(Object::toString).orElse(null);
    }

    public String getString(String key) {
        return this.props.getProperty(key);
    }

    public <T> Integer getInt(ConfigProperty<T> configProperty) {
        Option<Object> rawValue = this.getRawValue(configProperty);
        return rawValue.map(v -> Integer.parseInt(v.toString())).orElse(null);
    }

    public <T> Integer getIntOrDefault(ConfigProperty<T> configProperty) {
        Option<Object> rawValue = this.getRawValue(configProperty);
        return rawValue.map(v -> Integer.parseInt(v.toString())).orElse((Integer)configProperty.defaultValue());
    }

    public <T> Boolean getBoolean(ConfigProperty<T> configProperty) {
        if (configProperty.hasDefaultValue()) {
            return this.getBooleanOrDefault(configProperty);
        }
        Option<Object> rawValue = this.getRawValue(configProperty);
        return rawValue.map(v -> Boolean.parseBoolean(v.toString())).orElse(null);
    }

    public <T> boolean getBooleanOrDefault(ConfigProperty<T> configProperty) {
        Option<Object> rawValue = this.getRawValue(configProperty);
        return rawValue.map(v -> Boolean.parseBoolean(v.toString())).orElseGet(() -> Boolean.parseBoolean(configProperty.defaultValue().toString()));
    }

    public <T> Long getLong(ConfigProperty<T> configProperty) {
        Option<Object> rawValue = this.getRawValue(configProperty);
        return rawValue.map(v -> Long.parseLong(v.toString())).orElse(null);
    }

    public <T> Float getFloat(ConfigProperty<T> configProperty) {
        Option<Object> rawValue = this.getRawValue(configProperty);
        return rawValue.map(v -> Float.valueOf(Float.parseFloat(v.toString()))).orElse(null);
    }

    public <T> Double getDouble(ConfigProperty<T> configProperty) {
        Option<Object> rawValue = this.getRawValue(configProperty);
        return rawValue.map(v -> Double.parseDouble(v.toString())).orElse(null);
    }

    public <T> String getStringOrDefault(ConfigProperty<T> configProperty) {
        return this.getStringOrDefault(configProperty, configProperty.defaultValue().toString());
    }

    public <T> String getStringOrDefault(ConfigProperty<T> configProperty, String defaultVal) {
        Option<Object> rawValue = this.getRawValue(configProperty);
        return rawValue.map(Object::toString).orElse(defaultVal);
    }

    public TypedProperties getProps() {
        return this.getProps(false);
    }

    public TypedProperties getProps(boolean includeGlobalProps) {
        if (includeGlobalProps) {
            TypedProperties mergedProps = DFSPropertiesConfiguration.getGlobalProps();
            mergedProps.putAll((Map<?, ?>)this.props);
            return mergedProps;
        }
        return this.props;
    }

    public void setDefaultOnCondition(boolean condition, HoodieConfig config) {
        if (condition) {
            this.setDefault(config);
        }
    }

    public void setDefault(HoodieConfig config) {
        this.props.putAll((Map<?, ?>)config.getProps());
    }

    public <T> String getStringOrThrow(ConfigProperty<T> configProperty, String errorMessage) throws HoodieException {
        Option<Object> rawValue = this.getRawValue(configProperty);
        if (rawValue.isPresent()) {
            return rawValue.get().toString();
        }
        throw new HoodieException(errorMessage);
    }
}

