/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieList;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.FunctionWrapper;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieMapPair<K, V>
extends HoodiePairData<K, V> {
    private final Map<K, List<V>> mapPairData;

    private HoodieMapPair(Map<K, List<V>> mapPairData) {
        this.mapPairData = mapPairData;
    }

    public static <K, V> HoodieMapPair<K, V> of(Map<K, List<V>> mapPairData) {
        return new HoodieMapPair<K, V>(mapPairData);
    }

    public static <K, V> Map<K, List<V>> getMapPair(HoodiePairData<K, V> hoodiePairData) {
        return ((HoodieMapPair)hoodiePairData).get();
    }

    @Override
    public Map<K, List<V>> get() {
        return this.mapPairData;
    }

    @Override
    public void persist(String cacheConfig) {
    }

    @Override
    public void unpersist() {
    }

    @Override
    public HoodieData<K> keys() {
        return HoodieList.of(new ArrayList<K>(this.mapPairData.keySet()));
    }

    @Override
    public HoodieData<V> values() {
        return HoodieList.of(this.mapPairData.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    @Override
    public long count() {
        return this.mapPairData.values().stream().map((? super T list) -> list.size()).reduce(Long::sum).orElse(0L);
    }

    @Override
    public Map<K, Long> countByKey() {
        return this.mapPairData.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).size()));
    }

    @Override
    public HoodiePairData<K, V> reduceByKey(SerializableBiFunction<V, V, V> func, int parallelism) {
        return HoodieMapPair.of(this.mapPairData.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Option reducedValue = Option.fromJavaOptional(((List)e.getValue()).stream().reduce(func::apply));
            return reducedValue.isPresent() ? Collections.singletonList(reducedValue.get()) : Collections.emptyList();
        })));
    }

    @Override
    public <O> HoodieData<O> map(SerializableFunction<Pair<K, V>, O> func) {
        Function<Pair<K, V>, O> throwableFunc = FunctionWrapper.throwingMapWrapper(func);
        return HoodieList.of(this.streamAllPairs().map(throwableFunc).collect(Collectors.toList()));
    }

    @Override
    public <L, W> HoodiePairData<L, W> mapToPair(SerializablePairFunction<Pair<K, V>, L, W> mapToPairFunc) {
        HashMap newMap = new HashMap();
        Function throwableMapToPairFunc = FunctionWrapper.throwingMapToPairWrapper(mapToPairFunc);
        this.streamAllPairs().map((? super T pair) -> (Pair)throwableMapToPairFunc.apply((Pair)pair)).forEach(newPair -> {
            List list = newMap.computeIfAbsent(newPair.getKey(), k -> new ArrayList());
            list.add(newPair.getValue());
        });
        return HoodieMapPair.of(newMap);
    }

    @Override
    public <W> HoodiePairData<K, Pair<V, Option<W>>> leftOuterJoin(HoodiePairData<K, W> other) {
        Map otherMapPairData = HoodieMapPair.getMapPair(other);
        Stream<ImmutablePair> pairs = this.streamAllPairs().map((? super T pair) -> new ImmutablePair(pair.getKey(), new ImmutablePair(pair.getValue(), Option.ofNullable(otherMapPairData.get(pair.getKey())))));
        HashMap resultMap = new HashMap();
        pairs.forEach(pair -> {
            Object key = pair.getKey();
            ImmutablePair valuePair = (ImmutablePair)pair.getValue();
            List resultList = resultMap.computeIfAbsent(key, k -> new ArrayList());
            if (!((Option)valuePair.getRight()).isPresent()) {
                resultList.add(new ImmutablePair(valuePair.getLeft(), Option.empty()));
            } else {
                resultList.addAll(((List)((Option)valuePair.getRight()).get()).stream().map((? super T w) -> new ImmutablePair(valuePair.getLeft(), Option.of(w))).collect(Collectors.toList()));
            }
        });
        return HoodieMapPair.of(resultMap);
    }

    private Stream<ImmutablePair<K, V>> streamAllPairs() {
        return this.mapPairData.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map((? super T e) -> new ImmutablePair(entry.getKey(), e)));
    }
}

