/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.io.storage.HoodieAvroParquetConfig;
import org.apache.hudi.io.storage.HoodieBaseParquetWriter;
import org.apache.hudi.io.storage.HoodieFileWriter;

@NotThreadSafe
public class HoodieAvroParquetWriter<R extends IndexedRecord>
extends HoodieBaseParquetWriter<IndexedRecord>
implements HoodieFileWriter<R> {
    private final String fileName;
    private final String instantTime;
    private final TaskContextSupplier taskContextSupplier;
    private final boolean populateMetaFields;
    private final HoodieAvroWriteSupport writeSupport;

    public HoodieAvroParquetWriter(Path file, HoodieAvroParquetConfig parquetConfig, String instantTime, TaskContextSupplier taskContextSupplier, boolean populateMetaFields) throws IOException {
        super(file, parquetConfig);
        this.fileName = file.getName();
        this.writeSupport = (HoodieAvroWriteSupport)((Object)parquetConfig.getWriteSupport());
        this.instantTime = instantTime;
        this.taskContextSupplier = taskContextSupplier;
        this.populateMetaFields = populateMetaFields;
    }

    @Override
    public void writeAvroWithMetadata(HoodieKey key, R avroRecord) throws IOException {
        if (this.populateMetaFields) {
            this.prepRecordWithMetadata(key, (IndexedRecord)avroRecord, this.instantTime, this.taskContextSupplier.getPartitionIdSupplier().get(), this.getWrittenRecordCount(), this.fileName);
            super.write(avroRecord);
            this.writeSupport.add(key.getRecordKey());
        } else {
            super.write(avroRecord);
        }
    }

    @Override
    public void writeAvro(String key, IndexedRecord object) throws IOException {
        super.write(object);
        if (this.populateMetaFields) {
            this.writeSupport.add(key);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

