/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.hadoop.ParquetReader;

public class HoodieParquetReader<R extends IndexedRecord>
implements HoodieFileReader<R> {
    private final Path path;
    private final Configuration conf;
    private final BaseFileUtils parquetUtils;
    private List<ParquetReaderIterator> readerIterators = new ArrayList<ParquetReaderIterator>();

    public HoodieParquetReader(Configuration configuration, Path path) {
        this.conf = configuration;
        this.path = path;
        this.parquetUtils = BaseFileUtils.getInstance(HoodieFileFormat.PARQUET);
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        return this.parquetUtils.readMinMaxRecordKeys(this.conf, this.path);
    }

    @Override
    public BloomFilter readBloomFilter() {
        return this.parquetUtils.readBloomFilterFromMetadata(this.conf, this.path);
    }

    @Override
    public Set<String> filterRowKeys(Set<String> candidateRowKeys) {
        return this.parquetUtils.filterRowKeys(this.conf, this.path, candidateRowKeys);
    }

    @Override
    public ClosableIterator<R> getRecordIterator(Schema schema) throws IOException {
        AvroReadSupport.setAvroReadSchema(this.conf, schema);
        ParquetReader reader = AvroParquetReader.builder(this.path).withConf(this.conf).build();
        ParquetReaderIterator parquetReaderIterator = new ParquetReaderIterator(reader);
        this.readerIterators.add(parquetReaderIterator);
        return parquetReaderIterator;
    }

    @Override
    public Schema getSchema() {
        return this.parquetUtils.readAvroSchema(this.conf, this.path);
    }

    @Override
    public void close() {
        this.readerIterators.forEach(ParquetReaderIterator::close);
    }

    @Override
    public long getTotalRecords() {
        return this.parquetUtils.getRowCount(this.conf, this.path);
    }
}

