/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.factory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.GlobalDeleteKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieSparkKeyGeneratorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSparkKeyGeneratorFactory.class);
    private static final Map<String, String> COMMON_TO_SPARK_KEYGENERATOR = new HashMap<String, String>();

    public static KeyGenerator createKeyGenerator(TypedProperties props) throws IOException {
        String keyGeneratorClass = HoodieSparkKeyGeneratorFactory.getKeyGeneratorClassName(props);
        try {
            return (KeyGenerator)ReflectionUtils.loadClass(keyGeneratorClass, props);
        }
        catch (Throwable e) {
            throw new IOException("Could not load key generator class " + keyGeneratorClass, e);
        }
    }

    public static String getKeyGeneratorClassName(TypedProperties props) {
        String keyGeneratorClass = props.getString(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), null);
        if (StringUtils.isNullOrEmpty(keyGeneratorClass)) {
            KeyGeneratorType keyGeneratorTypeEnum;
            String keyGeneratorType = props.getString(HoodieWriteConfig.KEYGENERATOR_TYPE.key(), KeyGeneratorType.SIMPLE.name());
            LOG.info("The value of {} is empty, use SIMPLE", (Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key());
            try {
                keyGeneratorTypeEnum = KeyGeneratorType.valueOf(keyGeneratorType.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new HoodieKeyGeneratorException("Unsupported keyGenerator Type " + keyGeneratorType);
            }
            switch (keyGeneratorTypeEnum) {
                case SIMPLE: {
                    keyGeneratorClass = SimpleKeyGenerator.class.getName();
                    break;
                }
                case COMPLEX: {
                    keyGeneratorClass = ComplexKeyGenerator.class.getName();
                    break;
                }
                case TIMESTAMP: {
                    keyGeneratorClass = TimestampBasedKeyGenerator.class.getName();
                    break;
                }
                case CUSTOM: {
                    keyGeneratorClass = CustomKeyGenerator.class.getName();
                    break;
                }
                case NON_PARTITION: {
                    keyGeneratorClass = NonpartitionedKeyGenerator.class.getName();
                    break;
                }
                case GLOBAL_DELETE: {
                    keyGeneratorClass = GlobalDeleteKeyGenerator.class.getName();
                    break;
                }
                default: {
                    throw new HoodieKeyGeneratorException("Unsupported keyGenerator Type " + keyGeneratorType);
                }
            }
        }
        return keyGeneratorClass;
    }

    public static String convertToSparkKeyGenerator(String keyGeneratorClassName) {
        return COMMON_TO_SPARK_KEYGENERATOR.getOrDefault(keyGeneratorClassName, keyGeneratorClassName);
    }

    static {
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.ComplexAvroKeyGenerator", "org.apache.hudi.keygen.ComplexKeyGenerator");
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.CustomAvroKeyGenerator", "org.apache.hudi.keygen.CustomKeyGenerator");
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator", "org.apache.hudi.keygen.GlobalDeleteKeyGenerator");
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator", "org.apache.hudi.keygen.NonpartitionedKeyGenerator");
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.SimpleAvroKeyGenerator", "org.apache.hudi.keygen.SimpleKeyGenerator");
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator", "org.apache.hudi.keygen.TimestampBasedKeyGenerator");
    }
}

