/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;

public class FileSystemBackedTableMetadata
implements HoodieTableMetadata {
    private static final int DEFAULT_LISTING_PARALLELISM = 1500;
    private final transient HoodieEngineContext engineContext;
    private final SerializableConfiguration hadoopConf;
    private final String datasetBasePath;
    private final boolean assumeDatePartitioning;

    public FileSystemBackedTableMetadata(HoodieEngineContext engineContext, SerializableConfiguration conf, String datasetBasePath, boolean assumeDatePartitioning) {
        this.engineContext = engineContext;
        this.hadoopConf = conf;
        this.datasetBasePath = datasetBasePath;
        this.assumeDatePartitioning = assumeDatePartitioning;
    }

    @Override
    public FileStatus[] getAllFilesInPartition(Path partitionPath) throws IOException {
        FileSystem fs = partitionPath.getFileSystem(this.hadoopConf.get());
        return FSUtils.getAllDataFilesInPartition(fs, partitionPath);
    }

    @Override
    public List<String> getAllPartitionPaths() throws IOException {
        Path basePath = new Path(this.datasetBasePath);
        FileSystem fs = basePath.getFileSystem(this.hadoopConf.get());
        if (this.assumeDatePartitioning) {
            return FSUtils.getAllPartitionFoldersThreeLevelsDown(fs, this.datasetBasePath);
        }
        CopyOnWriteArrayList<Path> pathsToList = new CopyOnWriteArrayList<Path>();
        pathsToList.add(basePath);
        CopyOnWriteArrayList<String> partitionPaths = new CopyOnWriteArrayList<String>();
        while (!pathsToList.isEmpty()) {
            int listingParallelism = Math.min(1500, pathsToList.size());
            List<Pair> dirToFileListing = this.engineContext.map(pathsToList, path -> {
                FileSystem fileSystem = path.getFileSystem(this.hadoopConf.get());
                return Pair.of(path, fileSystem.listStatus(path));
            }, listingParallelism);
            pathsToList.clear();
            dirToFileListing.forEach(p -> {
                Option<FileStatus> partitionMetaFile = Option.fromJavaOptional(((Stream)Arrays.stream((Object[])p.getRight()).parallel()).filter(fileStatus -> fileStatus.getPath().getName().startsWith(".hoodie_partition_metadata")).findFirst());
                if (partitionMetaFile.isPresent()) {
                    String partitionName = FSUtils.getRelativePartitionPath(basePath, (Path)p.getLeft());
                    partitionPaths.add(partitionName);
                } else {
                    pathsToList.addAll(Arrays.stream((Object[])p.getRight()).filter(fileStatus -> fileStatus.isDirectory() && !fileStatus.getPath().getName().equals(".hoodie")).map(fileStatus -> fileStatus.getPath()).collect(Collectors.toList()));
                }
            });
        }
        return partitionPaths;
    }

    @Override
    public Map<String, FileStatus[]> getAllFilesInPartitions(List<String> partitionPaths) throws IOException {
        if (partitionPaths == null || partitionPaths.isEmpty()) {
            return Collections.emptyMap();
        }
        int parallelism = Math.min(1500, partitionPaths.size());
        List<Pair> partitionToFiles = this.engineContext.map(partitionPaths, partitionPathStr -> {
            Path partitionPath = new Path(partitionPathStr);
            FileSystem fs = partitionPath.getFileSystem(this.hadoopConf.get());
            return Pair.of(partitionPathStr, FSUtils.getAllDataFilesInPartition(fs, partitionPath));
        }, parallelism);
        return partitionToFiles.stream().collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    @Override
    public Option<String> getSyncedInstantTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Option<String> getLatestCompactionTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void reset() {
    }

    @Override
    public Option<BloomFilter> getBloomFilter(String partitionName, String fileName) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getBloomFilter for " + fileName);
    }

    @Override
    public Map<Pair<String, String>, BloomFilter> getBloomFilters(List<Pair<String, String>> partitionNameFileNameList) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getBloomFilters!");
    }

    @Override
    public Map<Pair<String, String>, HoodieMetadataColumnStats> getColumnStats(List<Pair<String, String>> partitionNameFileNameList, String columnName) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getColumnsStats!");
    }

    @Override
    public HoodieData<HoodieRecord<HoodieMetadataPayload>> getRecordsByKeyPrefixes(List<String> keyPrefixes, String partitionName) {
        throw new HoodieMetadataException("Unsupported operation: getRecordsByKeyPrefixes!");
    }
}

