/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hudi.org.apache.commons.io.IOUtils;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.codec.Codec;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBuffInputStream;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBufferInputStream;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBufferListOutputStream;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBufferOutputStream;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.CellScannerButNoCodecException;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBufOutputStream;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class CellBlockBuilder {
    static final Logger LOG = LoggerFactory.getLogger(CellBlockBuilder.class);
    private final Configuration conf;
    private final int cellBlockDecompressionMultiplier;
    private final int cellBlockBuildingInitialBufferSize;

    public CellBlockBuilder(Configuration conf) {
        this.conf = conf;
        this.cellBlockDecompressionMultiplier = conf.getInt("hbase.ipc.cellblock.decompression.buffersize.multiplier", 3);
        this.cellBlockBuildingInitialBufferSize = ClassSize.align(conf.getInt("hbase.ipc.cellblock.building.initial.buffersize", 16384));
    }

    public ByteBuffer buildCellBlock(Codec codec, CompressionCodec compressor, CellScanner cellScanner) throws IOException {
        ByteBufferOutputStreamSupplier supplier = new ByteBufferOutputStreamSupplier();
        if (this.buildCellBlock(codec, compressor, cellScanner, supplier)) {
            ByteBuffer bb = supplier.baos.getByteBuffer();
            return bb.hasRemaining() ? bb : null;
        }
        return null;
    }

    public ByteBuf buildCellBlock(Codec codec, CompressionCodec compressor, CellScanner cellScanner, ByteBufAllocator alloc) throws IOException {
        ByteBufOutputStreamSupplier supplier = new ByteBufOutputStreamSupplier(alloc);
        if (this.buildCellBlock(codec, compressor, cellScanner, supplier)) {
            return supplier.buf;
        }
        return null;
    }

    private boolean buildCellBlock(Codec codec, CompressionCodec compressor, CellScanner cellScanner, OutputStreamSupplier supplier) throws IOException {
        if (cellScanner == null) {
            return false;
        }
        if (codec == null) {
            throw new CellScannerButNoCodecException();
        }
        int bufferSize = this.cellBlockBuildingInitialBufferSize;
        this.encodeCellsTo(supplier.get(bufferSize), cellScanner, codec, compressor);
        if (LOG.isTraceEnabled() && bufferSize < supplier.size()) {
            LOG.trace("Buffer grew from initial bufferSize=" + bufferSize + " to " + supplier.size() + "; up hbase.ipc.cellblock.building.initial.buffersize?");
        }
        return true;
    }

    private void encodeCellsTo(OutputStream os, CellScanner cellScanner, Codec codec, CompressionCodec compressor) throws IOException {
        Compressor poolCompressor = null;
        try {
            if (compressor != null) {
                if (compressor instanceof Configurable) {
                    ((Configurable)compressor).setConf(this.conf);
                }
                poolCompressor = CodecPool.getCompressor((CompressionCodec)compressor);
                os = compressor.createOutputStream(os, poolCompressor);
            }
            Codec.Encoder encoder = codec.getEncoder(os);
            while (cellScanner.advance()) {
                encoder.write(cellScanner.current());
            }
            encoder.flush();
        }
        catch (IndexOutOfBoundsException | BufferOverflowException e) {
            throw new DoNotRetryIOException(e);
        }
        finally {
            os.close();
            if (poolCompressor != null) {
                CodecPool.returnCompressor((Compressor)poolCompressor);
            }
        }
    }

    public ByteBufferListOutputStream buildCellBlockStream(Codec codec, CompressionCodec compressor, CellScanner cellScanner, ByteBuffAllocator allocator) throws IOException {
        if (cellScanner == null) {
            return null;
        }
        if (codec == null) {
            throw new CellScannerButNoCodecException();
        }
        ByteBufferListOutputStream bbos = new ByteBufferListOutputStream(allocator);
        this.encodeCellsTo(bbos, cellScanner, codec, compressor);
        if (bbos.size() == 0) {
            bbos.releaseResources();
            return null;
        }
        return bbos;
    }

    public CellScanner createCellScanner(Codec codec, CompressionCodec compressor, byte[] cellBlock) throws IOException {
        if (compressor != null) {
            ByteBuffer cellBlockBuf = this.decompress(compressor, cellBlock);
            return codec.getDecoder(new ByteBufferInputStream(cellBlockBuf));
        }
        return codec.getDecoder(new ByteArrayInputStream(cellBlock));
    }

    public CellScanner createCellScannerReusingBuffers(Codec codec, CompressionCodec compressor, ByteBuff cellBlock) throws IOException {
        if (compressor != null) {
            cellBlock = this.decompress(compressor, cellBlock);
        }
        return codec.getDecoder(cellBlock);
    }

    private ByteBuffer decompress(CompressionCodec compressor, byte[] compressedCellBlock) throws IOException {
        ByteBuffer cellBlock = this.decompress(compressor, new ByteArrayInputStream(compressedCellBlock), compressedCellBlock.length * this.cellBlockDecompressionMultiplier);
        return cellBlock;
    }

    private ByteBuff decompress(CompressionCodec compressor, ByteBuff compressedCellBlock) throws IOException {
        ByteBuffer cellBlock = this.decompress(compressor, new ByteBuffInputStream(compressedCellBlock), compressedCellBlock.remaining() * this.cellBlockDecompressionMultiplier);
        return new SingleByteBuff(cellBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer decompress(CompressionCodec compressor, InputStream cellBlockStream, int osInitialSize) throws IOException {
        if (compressor instanceof Configurable) {
            ((Configurable)compressor).setConf(this.conf);
        }
        Decompressor poolDecompressor = CodecPool.getDecompressor((CompressionCodec)compressor);
        CompressionInputStream cis = compressor.createInputStream(cellBlockStream, poolDecompressor);
        try {
            ByteBufferOutputStream bbos = new ByteBufferOutputStream(osInitialSize);
            IOUtils.copy((InputStream)cis, (OutputStream)bbos);
            bbos.close();
            ByteBuffer byteBuffer = bbos.getByteBuffer();
            return byteBuffer;
        }
        finally {
            CodecPool.returnDecompressor((Decompressor)poolDecompressor);
        }
    }

    private static final class ByteBufOutputStreamSupplier
    implements OutputStreamSupplier {
        private final ByteBufAllocator alloc;
        private ByteBuf buf;

        public ByteBufOutputStreamSupplier(ByteBufAllocator alloc) {
            this.alloc = alloc;
        }

        @Override
        public OutputStream get(int expectedSize) {
            this.buf = this.alloc.buffer(expectedSize);
            return new ByteBufOutputStream(this.buf);
        }

        @Override
        public int size() {
            return this.buf.writerIndex();
        }
    }

    private static final class ByteBufferOutputStreamSupplier
    implements OutputStreamSupplier {
        private ByteBufferOutputStream baos;

        private ByteBufferOutputStreamSupplier() {
        }

        @Override
        public OutputStream get(int expectedSize) {
            this.baos = new ByteBufferOutputStream(expectedSize);
            return this.baos;
        }

        @Override
        public int size() {
            return this.baos.size();
        }
    }

    private static interface OutputStreamSupplier {
        public OutputStream get(int var1);

        public int size();
    }
}

