/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaSparkContext;

public class SchemaRegistryProvider
extends SchemaProvider {
    public String fetchSchemaFromRegistry(String registryUrl) throws IOException {
        HttpURLConnection connection;
        Matcher matcher = Pattern.compile("://(.*?)@").matcher(registryUrl);
        if (matcher.find()) {
            String creds = matcher.group(1);
            String urlWithoutCreds = registryUrl.replace(creds + "@", "");
            URL registry = new URL(urlWithoutCreds);
            connection = (HttpURLConnection)registry.openConnection();
            this.setAuthorizationHeader(matcher.group(1), connection);
        } else {
            URL registry = new URL(registryUrl);
            connection = (HttpURLConnection)registry.openConnection();
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(this.getStream(connection));
        return node.get("schema").asText();
    }

    protected void setAuthorizationHeader(String creds, HttpURLConnection connection) {
        String encodedAuth = Base64.getEncoder().encodeToString(creds.getBytes(StandardCharsets.UTF_8));
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
    }

    protected InputStream getStream(HttpURLConnection connection) throws IOException {
        return connection.getInputStream();
    }

    public SchemaRegistryProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        DataSourceUtils.checkRequiredProperties(props, Collections.singletonList("hoodie.deltastreamer.schemaprovider.registry.url"));
    }

    private Schema getSchema(String registryUrl) throws IOException {
        return new Schema.Parser().parse(this.fetchSchemaFromRegistry(registryUrl));
    }

    @Override
    public Schema getSourceSchema() {
        String registryUrl = this.config.getString("hoodie.deltastreamer.schemaprovider.registry.url");
        try {
            return this.getSchema(registryUrl);
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading source schema from registry :" + registryUrl, ioe);
        }
    }

    @Override
    public Schema getTargetSchema() {
        String registryUrl = this.config.getString("hoodie.deltastreamer.schemaprovider.registry.url");
        String targetRegistryUrl = this.config.getString("hoodie.deltastreamer.schemaprovider.registry.targetUrl", registryUrl);
        try {
            return this.getSchema(targetRegistryUrl);
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading target schema from registry :" + registryUrl, ioe);
        }
    }

    public static class Config {
        public static final String SRC_SCHEMA_REGISTRY_URL_PROP = "hoodie.deltastreamer.schemaprovider.registry.url";
        public static final String TARGET_SCHEMA_REGISTRY_URL_PROP = "hoodie.deltastreamer.schemaprovider.registry.targetUrl";
    }
}

