/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u000e\u001d\u0001&B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\u0007\"A\u0001\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005V\u0001\tE\t\u0015!\u0003K\u0011!1\u0006A!f\u0001\n\u00039\u0006\u0002\u00030\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u000b}\u0003A\u0011\u00011\t\u000b\u0015\u0004A\u0011\t4\t\u000be\u0004A\u0011\u0002>\t\u0013\u0005\r\u0002!!A\u0005\u0002\u0005\u0015\u0002\"CA\u0017\u0001E\u0005I\u0011AA\u0018\u0011%\t)\u0005AI\u0001\n\u0003\t9\u0005C\u0005\u0002L\u0001\t\n\u0011\"\u0001\u0002N!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00131\u000b\u0005\n\u0003G\u0002\u0011\u0011!C\u0001\u0003KB\u0011\"!\u001c\u0001\u0003\u0003%\t!a\u001c\t\u0013\u0005m\u0004!!A\u0005B\u0005u\u0004\"CAF\u0001\u0005\u0005I\u0011AAG\u0011%\t9\nAA\u0001\n\u0003\nIjB\u0005\u0002\u001er\t\t\u0011#\u0001\u0002 \u001aA1\u0004HA\u0001\u0012\u0003\t\t\u000b\u0003\u0004`+\u0011\u0005\u0011q\u0016\u0005\n\u0003c+\u0012\u0011!C#\u0003gC\u0011\"!.\u0016\u0003\u0003%\t)a.\t\u0013\u0005}V#!A\u0005\u0002\u0006\u0005\u0007\"CAj+\u0005\u0005I\u0011BAk\u0005\r\nE\u000e^3s\u0011>|G-[3UC\ndWm\u00115b]\u001e,7i\u001c7v[:\u001cu.\\7b]\u0012T!!\b\u0010\u0002\u000f\r|W.\\1oI*\u0011q\u0004I\u0001\u0005QV$\u0017N\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001UQBd\b\u0005\u0002,e5\tAF\u0003\u0002.]\u00059An\\4jG\u0006d'BA\u00181\u0003\u0015\u0001H.\u00198t\u0015\t\t\u0004%\u0001\u0005dCR\fG._:u\u0013\t\u0019DFA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA\u001b7\u001b\u0005a\u0012BA\u001c\u001d\u0005eAun\u001c3jK2+\u0017M\u001a*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011hP\u0005\u0003\u0001j\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fq\u0002^1cY\u0016LE-\u001a8uS\u001aLWM]\u000b\u0002\u0007B\u0011A)R\u0007\u0002a%\u0011a\t\r\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0006\u0001B/\u00192mK&#WM\u001c;jM&,'\u000fI\u0001\u000bG>dW/\u001c8OC6,W#\u0001&\u0011\u0005-\u0013fB\u0001'Q!\ti%(D\u0001O\u0015\ty\u0005&\u0001\u0004=e>|GOP\u0005\u0003#j\na\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011KO\u0001\fG>dW/\u001c8OC6,\u0007%A\u0005oK^\u001cu\u000e\\;n]V\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\A\u0005)A/\u001f9fg&\u0011QL\u0017\u0002\f'R\u0014Xo\u0019;GS\u0016dG-\u0001\u0006oK^\u001cu\u000e\\;n]\u0002\na\u0001P5oSRtD\u0003B1cG\u0012\u0004\"!\u000e\u0001\t\u000b\u0005;\u0001\u0019A\"\t\u000b!;\u0001\u0019\u0001&\t\u000bY;\u0001\u0019\u0001-\u0002\u0007I,h\u000e\u0006\u0002hiB\u0019\u0001.\u001c9\u000f\u0005%\\gBA'k\u0013\u0005Y\u0014B\u00017;\u0003\u001d\u0001\u0018mY6bO\u0016L!A\\8\u0003\u0007M+\u0017O\u0003\u0002muA\u0011\u0011O]\u0007\u0002A%\u00111\u000f\t\u0002\u0004%><\b\"B;\t\u0001\u00041\u0018\u0001D:qCJ\\7+Z:tS>t\u0007CA9x\u0013\tA\bE\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\bwC2LG-\u0019;f'\u000eDW-\\1\u0015\tmt\u0018Q\u0002\t\u0003sqL!! \u001e\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u007f&\u0001\r!!\u0001\u0002\u00139,woU2iK6\f\u0007\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dA%\u0001\u0003bmJ|\u0017\u0002BA\u0006\u0003\u000b\u0011aaU2iK6\f\u0007bBA\b\u0013\u0001\u0007\u0011\u0011C\u0001\u000b[\u0016$\u0018m\u00117jK:$\b\u0003BA\n\u0003?i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0005\u00037\ti\"\u0001\u0004d_6lwN\u001c\u0006\u0003?\u0011JA!!\t\u0002\u0016\t)\u0002j\\8eS\u0016$\u0016M\u00197f\u001b\u0016$\u0018m\u00117jK:$\u0018\u0001B2paf$r!YA\u0014\u0003S\tY\u0003C\u0004B\u0015A\u0005\t\u0019A\"\t\u000f!S\u0001\u0013!a\u0001\u0015\"9aK\u0003I\u0001\u0002\u0004A\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003cQ3aQA\u001aW\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0013Ut7\r[3dW\u0016$'bAA u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0013\u0011\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0013R3ASA\u001a\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\u0014+\u0007a\u000b\u0019$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003+\u0002B!a\u0016\u0002b5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0003mC:<'BAA0\u0003\u0011Q\u0017M^1\n\u0007M\u000bI&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002hA\u0019\u0011(!\u001b\n\u0007\u0005-$HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002r\u0005]\u0004cA\u001d\u0002t%\u0019\u0011Q\u000f\u001e\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002zA\t\t\u00111\u0001\u0002h\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a \u0011\r\u0005\u0005\u0015qQA9\u001b\t\t\u0019IC\u0002\u0002\u0006j\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI)a!\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u001f\u000b)\nE\u0002:\u0003#K1!a%;\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u001f\u0013\u0003\u0003\u0005\r!!\u001d\u0002\r\u0015\fX/\u00197t)\u0011\ty)a'\t\u0013\u0005e4#!AA\u0002\u0005E\u0014aI!mi\u0016\u0014\bj\\8eS\u0016$\u0016M\u00197f\u0007\"\fgnZ3D_2,XN\\\"p[6\fg\u000e\u001a\t\u0003kU\u0019B!FAR}AA\u0011QUAV\u0007*C\u0016-\u0004\u0002\u0002(*\u0019\u0011\u0011\u0016\u001e\u0002\u000fI,h\u000e^5nK&!\u0011QVAT\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003?\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003+\nQ!\u00199qYf$r!YA]\u0003w\u000bi\fC\u0003B1\u0001\u00071\tC\u0003I1\u0001\u0007!\nC\u0003W1\u0001\u0007\u0001,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u0017q\u001a\t\u0006s\u0005\u0015\u0017\u0011Z\u0005\u0004\u0003\u000fT$AB(qi&|g\u000e\u0005\u0004:\u0003\u0017\u001c%\nW\u0005\u0004\u0003\u001bT$A\u0002+va2,7\u0007\u0003\u0005\u0002Rf\t\t\u00111\u0001b\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002XB!\u0011qKAm\u0013\u0011\tY.!\u0017\u0003\r=\u0013'.Z2u\u0001")
public class AlterHoodieTableChangeColumnCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier tableIdentifier;
    private final String columnName;
    private final StructField newColumn;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand) {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.unapply(alterHoodieTableChangeColumnCommand);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterHoodieTableChangeColumnCommand> tupled() {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterHoodieTableChangeColumnCommand>>> curried() {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = this;
        synchronized (alterHoodieTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableIdentifier());
        StructField originColumn = (StructField)HoodieSqlCommonUtils$.MODULE$.findColumnByName(hoodieCatalogTable.dataSchema(), this.columnName(), (Function2<String, String, Object>)resolver).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AnalysisException(new StringBuilder(46).append("Can't find column `").append(this.columnName()).append("` given table data columns ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.dataSchema().fieldNames())).mkString("[`", "`, `", "`]")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        });
        if (!HoodieSqlCommonUtils$.MODULE$.columnEqual(originColumn, this.newColumn(), (Function2<String, String, Object>)resolver)) {
            throw new AnalysisException(new StringBuilder(97).append("ALTER TABLE CHANGE COLUMN is not supported for changing column ").append("'").append(originColumn.name()).append("' with type '").append(originColumn.dataType()).append("' to ").append("'").append(this.newColumn().name()).append("' with type '").append(this.newColumn().dataType()).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        StructType newTableSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.tableSchema().fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String string = field.name();
            String string2 = originColumn.name();
            return !(string != null ? !string.equals(string2) : string2 != null) ? this.newColumn() : field;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        StructType newDataSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.dataSchema().fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String string = field.name();
            String string2 = this.columnName();
            return !(string != null ? !string.equals(string2) : string2 != null) ? this.newColumn() : field;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Tuple2<String, String> tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.tableIdentifier().table());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String structName = (String)tuple2._1();
        String nameSpace = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
        Tuple2 tuple23 = tuple22;
        String structName2 = (String)tuple23._1();
        String nameSpace2 = (String)tuple23._2();
        Schema newSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)newTableSchema, structName2, nameSpace2);
        this.validateSchema(newSchema, hoodieCatalogTable.metaClient());
        AlterHoodieTableAddColumnsCommand$.MODULE$.commitWithSchema(newSchema, hoodieCatalogTable, sparkSession);
        try {
            sparkSession.catalog().uncacheTable(this.tableIdentifier().quotedString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.log().warn(new StringBuilder(43).append("Exception when attempting to uncache table ").append(this.tableIdentifier().quotedString()).toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        sparkSession.catalog().refreshTable(this.tableIdentifier().unquotedString());
        sparkSession.sessionState().catalog().alterTableDataSchema(this.tableIdentifier(), newDataSchema);
        return (Seq)Seq$.MODULE$.empty();
    }

    private void validateSchema(Schema newSchema, HoodieTableMetaClient metaClient) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        Schema tableSchema = HoodieAvroUtils.createHoodieWriteSchema(schemaUtil.getTableAvroSchemaWithoutMetadataFields());
        if (!TableSchemaResolver.isSchemaCompatible(tableSchema, newSchema)) {
            throw new HoodieException(new StringBuilder(85).append("Failed schema compatibility check for newSchema :").append(newSchema).append(", origin table schema :").append(tableSchema).append(", base path :").append(metaClient.getBasePath()).toString());
        }
    }

    public AlterHoodieTableChangeColumnCommand copy(TableIdentifier tableIdentifier, String columnName, StructField newColumn) {
        return new AlterHoodieTableChangeColumnCommand(tableIdentifier, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterHoodieTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableIdentifier();
                break;
            }
            case 1: {
                object = this.columnName();
                break;
            }
            case 2: {
                object = this.newColumn();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterHoodieTableChangeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterHoodieTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = (AlterHoodieTableChangeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = alterHoodieTableChangeColumnCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterHoodieTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterHoodieTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterHoodieTableChangeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public AlterHoodieTableChangeColumnCommand(TableIdentifier tableIdentifier, String columnName, StructField newColumn) {
        this.tableIdentifier = tableIdentifier;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        HoodieLeafLike.$init$(this);
    }
}

