/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.debug.AddAttributeEvent;
import org.stringtemplate.v4.debug.ConstructionEvent;
import org.stringtemplate.v4.debug.EvalTemplateEvent;
import org.stringtemplate.v4.debug.InterpEvent;
import org.stringtemplate.v4.gui.STViz;
import org.stringtemplate.v4.misc.Aggregate;
import org.stringtemplate.v4.misc.ErrorBuffer;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.MultiMap;
import org.stringtemplate.v4.misc.STNoSuchAttributeException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ST {
    public static final String VERSION = "@version@";
    public static final String UNKNOWN_NAME = "anonymous";
    public static final Object EMPTY_ATTR = new Object();
    public static STNoSuchAttributeException cachedNoSuchAttrException;
    public CompiledST impl;
    protected Object[] locals;
    public STGroup groupThatCreatedThisInstance;
    public DebugState debugState;
    static /* synthetic */ Class class$org$stringtemplate$v4$ST$RegionType;
    static /* synthetic */ Class class$org$stringtemplate$v4$ST$AttributeList;

    public ST() {
        if (STGroup.trackCreationEvents) {
            if (this.debugState == null) {
                this.debugState = new DebugState();
            }
            this.debugState.newSTEvent = new ConstructionEvent();
        }
    }

    public ST(String template) {
        this(STGroup.defaultGroup, template);
    }

    public ST(String template, char delimiterStartChar, char delimiterStopChar) {
        this(new STGroup(delimiterStartChar, delimiterStopChar), template);
    }

    public ST(STGroup group, String template) {
        this();
        this.groupThatCreatedThisInstance = group;
        this.impl = this.groupThatCreatedThisInstance.compile(group.getFileName(), null, null, template, null);
        this.impl.hasFormalArgs = false;
        this.impl.name = UNKNOWN_NAME;
        this.impl.defineImplicitlyDefinedTemplates(this.groupThatCreatedThisInstance);
    }

    public ST(ST proto) {
        this.impl = proto.impl;
        if (proto.locals != null) {
            this.locals = new Object[proto.locals.length];
            System.arraycopy(proto.locals, 0, this.locals, 0, proto.locals.length);
        }
        this.groupThatCreatedThisInstance = proto.groupThatCreatedThisInstance;
    }

    public synchronized ST add(String name, Object value) {
        AttributeList<Object> multi;
        Object curvalue;
        if (name == null) {
            return this;
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in attribute names");
        }
        if (STGroup.trackCreationEvents) {
            if (this.debugState == null) {
                this.debugState = new DebugState();
            }
            this.debugState.addAttrEvents.map(name, new AddAttributeEvent(name, value));
        }
        FormalArgument arg = null;
        if (this.impl.hasFormalArgs) {
            if (this.impl.formalArguments != null) {
                arg = this.impl.formalArguments.get(name);
            }
            if (arg == null) {
                throw new IllegalArgumentException(new StringBuffer().append("no such attribute: ").append(name).toString());
            }
        } else {
            if (this.impl.formalArguments != null) {
                arg = this.impl.formalArguments.get(name);
            }
            if (arg == null) {
                arg = new FormalArgument(name);
                this.impl.addArg(arg);
                if (this.locals == null) {
                    this.locals = new Object[1];
                } else {
                    Object[] copy = new Object[this.impl.formalArguments.size()];
                    System.arraycopy(this.locals, 0, copy, 0, Math.min(this.locals.length, this.impl.formalArguments.size()));
                    this.locals = copy;
                }
                this.locals[arg.index] = EMPTY_ATTR;
            }
        }
        if ((curvalue = this.locals[arg.index]) == EMPTY_ATTR) {
            this.locals[arg.index] = value;
            return this;
        }
        this.locals[arg.index] = multi = ST.convertToAttributeList(curvalue);
        if (value instanceof List) {
            multi.addAll((List)value);
        } else if (value != null && value.getClass().isArray()) {
            multi.addAll(Arrays.asList(value));
        } else {
            multi.add(value);
        }
        return this;
    }

    public synchronized ST addAggr(String aggrSpec, Object[] values2) {
        int dot = aggrSpec.indexOf(".{");
        if (values2 == null || values2.length == 0) {
            throw new IllegalArgumentException(new StringBuffer().append("missing values for aggregate attribute format: ").append(aggrSpec).toString());
        }
        int finalCurly = aggrSpec.indexOf(125);
        if (dot < 0 || finalCurly < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("invalid aggregate attribute format: ").append(aggrSpec).toString());
        }
        String aggrName = aggrSpec.substring(0, dot);
        String propString = aggrSpec.substring(dot + 2, aggrSpec.length() - 1);
        String[] propNames = (propString = propString.trim()).split("\\ *,\\ *");
        if (propNames == null || propNames.length == 0) {
            throw new IllegalArgumentException(new StringBuffer().append("invalid aggregate attribute format: ").append(aggrSpec).toString());
        }
        if (values2.length != propNames.length) {
            throw new IllegalArgumentException(new StringBuffer().append("number of properties and values mismatch for aggregate attribute format: ").append(aggrSpec).toString());
        }
        int i = 0;
        Aggregate aggr = new Aggregate();
        for (String p : propNames) {
            Object v = values2[i++];
            aggr.properties.put(p, v);
        }
        this.add(aggrName, aggr);
        return this;
    }

    public void remove(String name) {
        if (this.impl.formalArguments == null) {
            if (this.impl.hasFormalArgs) {
                throw new IllegalArgumentException(new StringBuffer().append("no such attribute: ").append(name).toString());
            }
            return;
        }
        FormalArgument arg = this.impl.formalArguments.get(name);
        if (arg == null) {
            throw new IllegalArgumentException(new StringBuffer().append("no such attribute: ").append(name).toString());
        }
        this.locals[arg.index] = EMPTY_ATTR;
    }

    protected void rawSetAttribute(String name, Object value) {
        if (this.impl.formalArguments == null) {
            throw new IllegalArgumentException(new StringBuffer().append("no such attribute: ").append(name).toString());
        }
        FormalArgument arg = this.impl.formalArguments.get(name);
        if (arg == null) {
            throw new IllegalArgumentException(new StringBuffer().append("no such attribute: ").append(name).toString());
        }
        this.locals[arg.index] = value;
    }

    public Object getAttribute(String name) {
        FormalArgument localArg = null;
        if (this.impl.formalArguments != null) {
            localArg = this.impl.formalArguments.get(name);
        }
        if (localArg != null) {
            Object o = this.locals[localArg.index];
            if (o == EMPTY_ATTR) {
                o = null;
            }
            return o;
        }
        return null;
    }

    public Map<String, Object> getAttributes() {
        if (this.impl.formalArguments == null) {
            return null;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (FormalArgument a : this.impl.formalArguments.values()) {
            Object o = this.locals[a.index];
            if (o == EMPTY_ATTR) {
                o = null;
            }
            attributes.put(a.name, o);
        }
        return attributes;
    }

    protected static AttributeList<Object> convertToAttributeList(Object curvalue) {
        AttributeList multi;
        if (curvalue == null) {
            multi = new AttributeList();
            multi.add(curvalue);
        } else if (curvalue.getClass() == (class$org$stringtemplate$v4$ST$AttributeList == null ? (class$org$stringtemplate$v4$ST$AttributeList = ST.class$("org.stringtemplate.v4.ST$AttributeList")) : class$org$stringtemplate$v4$ST$AttributeList)) {
            multi = (AttributeList)curvalue;
        } else if (curvalue instanceof List) {
            List listAttr = (List)curvalue;
            multi = new AttributeList(listAttr.size());
            multi.addAll(listAttr);
        } else if (curvalue.getClass().isArray()) {
            Object[] a = (Object[])curvalue;
            multi = new AttributeList(a.length);
            multi.addAll(Arrays.asList(a));
        } else {
            multi = new AttributeList();
            multi.add(curvalue);
        }
        return multi;
    }

    public String getName() {
        return this.impl.name;
    }

    public boolean isAnonSubtemplate() {
        return this.impl.isAnonSubtemplate;
    }

    public int write(STWriter out) throws IOException {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, this.impl.nativeGroup.errMgr, false);
        return interp.exec(out, this);
    }

    public int write(STWriter out, Locale locale) {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale, this.impl.nativeGroup.errMgr, false);
        return interp.exec(out, this);
    }

    public int write(STWriter out, STErrorListener listener) {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, new ErrorManager(listener), false);
        return interp.exec(out, this);
    }

    public int write(STWriter out, Locale locale, STErrorListener listener) {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale, new ErrorManager(listener), false);
        return interp.exec(out, this);
    }

    public int write(File outputFile, STErrorListener listener) throws IOException {
        return this.write(outputFile, listener, "UTF-8", Locale.getDefault(), -1);
    }

    public int write(File outputFile, STErrorListener listener, String encoding) throws IOException {
        return this.write(outputFile, listener, encoding, Locale.getDefault(), -1);
    }

    public int write(File outputFile, STErrorListener listener, String encoding, int lineWidth) throws IOException {
        return this.write(outputFile, listener, encoding, Locale.getDefault(), lineWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(File outputFile, STErrorListener listener, String encoding, Locale locale, int lineWidth) throws IOException {
        Writer bw = null;
        try {
            FileOutputStream fos = new FileOutputStream(outputFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);
            bw = new BufferedWriter(osw);
            AutoIndentWriter w = new AutoIndentWriter(bw);
            w.setLineWidth(lineWidth);
            int n = this.write(w, locale, listener);
            bw.close();
            bw = null;
            int n2 = n;
            return n2;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }

    public String render() {
        return this.render(Locale.getDefault());
    }

    public String render(int lineWidth) {
        return this.render(Locale.getDefault(), lineWidth);
    }

    public String render(Locale locale) {
        return this.render(locale, -1);
    }

    public String render(Locale locale, int lineWidth) {
        StringWriter out = new StringWriter();
        AutoIndentWriter wr = new AutoIndentWriter(out);
        wr.setLineWidth(lineWidth);
        this.write((STWriter)wr, locale);
        return out.toString();
    }

    public STViz inspect() {
        return this.inspect(Locale.getDefault());
    }

    public STViz inspect(int lineWidth) {
        return this.inspect(this.impl.nativeGroup.errMgr, Locale.getDefault(), lineWidth);
    }

    public STViz inspect(Locale locale) {
        return this.inspect(this.impl.nativeGroup.errMgr, locale, -1);
    }

    public STViz inspect(ErrorManager errMgr, Locale locale, int lineWidth) {
        ErrorBuffer errors = new ErrorBuffer();
        this.impl.nativeGroup.setListener(errors);
        StringWriter out = new StringWriter();
        AutoIndentWriter wr = new AutoIndentWriter(out);
        wr.setLineWidth(lineWidth);
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale, true);
        interp.exec(wr, this);
        List<InterpEvent> events = interp.getEvents();
        EvalTemplateEvent overallTemplateEval = (EvalTemplateEvent)events.get(events.size() - 1);
        STViz viz = new STViz(errMgr, overallTemplateEval, out.toString(), interp, interp.getExecutionTrace(), errors.errors);
        viz.open();
        return viz;
    }

    public List<InterpEvent> getEvents() {
        return this.getEvents(Locale.getDefault());
    }

    public List<InterpEvent> getEvents(int lineWidth) {
        return this.getEvents(Locale.getDefault(), lineWidth);
    }

    public List<InterpEvent> getEvents(Locale locale) {
        return this.getEvents(locale, -1);
    }

    public List<InterpEvent> getEvents(Locale locale, int lineWidth) {
        StringWriter out = new StringWriter();
        AutoIndentWriter wr = new AutoIndentWriter(out);
        wr.setLineWidth(lineWidth);
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale, true);
        interp.exec(wr, this);
        return interp.getEvents();
    }

    public String toString() {
        if (this.impl == null) {
            return "bad-template()";
        }
        String name = new StringBuffer().append(this.impl.name).append("()").toString();
        if (this.impl.isRegion) {
            name = new StringBuffer().append("@").append(STGroup.getUnMangledTemplateName(name)).toString();
        }
        return name;
    }

    public static String format(String template, Object[] attributes) {
        return ST.format(-1, template, attributes);
    }

    public static String format(int lineWidth, String template, Object[] attributes) {
        template = template.replaceAll("%([0-9]+)", "arg$1");
        System.out.println(template);
        ST st = new ST(template);
        int i = 1;
        for (Object a : attributes) {
            st.add(new StringBuffer().append("arg").append(i).toString(), a);
            ++i;
        }
        return st.render(lineWidth);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AttributeList<T>
    extends ArrayList<T> {
        public AttributeList(int size) {
            super(size);
        }

        public AttributeList() {
        }
    }

    public static class DebugState {
        public ConstructionEvent newSTEvent;
        public MultiMap<String, AddAttributeEvent> addAttrEvents = new MultiMap();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RegionType
    extends Enum<RegionType> {
        public static final RegionType IMPLICIT = new RegionType("IMPLICIT", 0);
        public static final RegionType EMBEDDED = new RegionType("EMBEDDED", 1);
        public static final RegionType EXPLICIT = new RegionType("EXPLICIT", 2);
        private static final /* synthetic */ RegionType[] $VALUES;

        public static RegionType[] values() {
            return (RegionType[])$VALUES.clone();
        }

        public static RegionType valueOf(String name) {
            return (RegionType)((Object)Enum.valueOf(class$org$stringtemplate$v4$ST$RegionType == null ? (class$org$stringtemplate$v4$ST$RegionType = ST.class$("org.stringtemplate.v4.ST$RegionType")) : class$org$stringtemplate$v4$ST$RegionType, name));
        }

        private RegionType() {
        }

        static {
            $VALUES = new RegionType[]{IMPLICIT, EMBEDDED, EXPLICIT};
        }
    }
}

