/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.NoopCache$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class HoodieFileIndex$
implements Logging,
scala.Serializable {
    public static HoodieFileIndex$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HoodieFileIndex$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public FileStatusCache $lessinit$greater$default$5() {
        return NoopCache$.MODULE$;
    }

    public Seq<String> org$apache$hudi$HoodieFileIndex$$collectReferencedColumns(SparkSession spark, Seq<Expression> queryFilters, StructType schema) {
        Function2 resolver = spark.sessionState().analyzer().resolver();
        Seq refs = (Seq)queryFilters.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.references(), Seq$.MODULE$.canBuildFrom());
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).filter((Function1 & Serializable & scala.Serializable)colName -> BoxesRunTime.boxToBoolean((boolean)refs.exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)HoodieFileIndex$.$anonfun$collectReferencedColumns$3(resolver$1, colName, r))))));
    }

    public TypedProperties getConfigProperties(SparkSession spark, scala.collection.immutable.Map<String, String> options) {
        SQLConf sqlConf = spark.sessionState().conf();
        TypedProperties properties = new TypedProperties();
        properties.setProperty(HoodieMetadataConfig.ENABLE.key(), sqlConf.getConfString(HoodieMetadataConfig.ENABLE.key(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString()));
        properties.putAll((java.util.Map<?, ?>)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HoodieFileIndex$.$anonfun$getConfigProperties$1(p)))).asJava()));
        return properties;
    }

    public Seq<Expression> convertFilterForTimestampKeyGenerator(HoodieTableMetaClient metaClient, Seq<Expression> partitionFilters) {
        Seq seq;
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        String keyGenerator = tableConfig.getKeyGeneratorClassName();
        if (keyGenerator != null && (keyGenerator.equals(TimestampBasedKeyGenerator.class.getCanonicalName()) || keyGenerator.equals(TimestampBasedAvroKeyGenerator.class.getCanonicalName()))) {
            String inputFormat = tableConfig.getString("hoodie.deltastreamer.keygen.timebased.input.dateformat");
            String outputFormat = tableConfig.getString("hoodie.deltastreamer.keygen.timebased.output.dateformat");
            if (StringUtils.isNullOrEmpty(inputFormat) || StringUtils.isNullOrEmpty(outputFormat) || inputFormat.equals(outputFormat)) {
                seq = partitionFilters;
            } else {
                try {
                    SimpleDateFormat inDateFormat = new SimpleDateFormat(inputFormat);
                    SimpleDateFormat outDateFormat = new SimpleDateFormat(outputFormat);
                    seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFilters.toArray(ClassTag$.MODULE$.apply(Expression.class)))).map((Function1 & Serializable & scala.Serializable)x$13 -> (Expression)x$13.transformDown((PartialFunction)new scala.Serializable(outDateFormat, inDateFormat){
                        public static final long serialVersionUID = 0L;
                        private final SimpleDateFormat outDateFormat$1;
                        private final SimpleDateFormat inDateFormat$1;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof Literal) {
                                Literal literal = (Literal)A1;
                                Object value = literal.value();
                                DataType dataType = literal.dataType();
                                if (dataType instanceof StringType) {
                                    String converted = this.outDateFormat$1.format(this.inDateFormat$1.parse(value.toString()));
                                    object = new Literal((Object)UTF8String.fromString((String)converted), (DataType)StringType$.MODULE$);
                                    return (B1)object;
                                }
                            }
                            object = function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Literal literal;
                            DataType dataType;
                            Expression expression = x1;
                            boolean bl = expression instanceof Literal && (dataType = (literal = (Literal)expression).dataType()) instanceof StringType;
                            return bl;
                        }
                        {
                            this.outDateFormat$1 = outDateFormat$1;
                            this.inDateFormat$1 = inDateFormat$1;
                        }
                    }), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fail to convert filters for TimestampBaseAvroKeyGenerator", e);
                    Seq seq2 = partitionFilters;
                    seq = seq2;
                }
            }
        } else {
            seq = partitionFilters;
        }
        return seq;
    }

    public Seq<Path> org$apache$hudi$HoodieFileIndex$$getQueryPaths(scala.collection.immutable.Map<String, String> options) {
        Seq seq;
        Option option = options.get((Object)"path");
        if (option instanceof Some) {
            Some some = (Some)option;
            String p = (String)some.value();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path(p)}));
        } else if (None$.MODULE$.equals(option)) {
            seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)options.getOrElse((Object)"glob.paths", (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("'path' or 'glob paths' option required");
            })).split(","))).map((Function1 & Serializable & scala.Serializable)x$14 -> new Path(x$14), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).toSeq();
        } else {
            throw new MatchError((Object)option);
        }
        return seq;
    }

    public HoodieFileIndex apply(SparkSession spark, HoodieTableMetaClient metaClient, Option<StructType> schemaSpec, scala.collection.immutable.Map<String, String> options, FileStatusCache fileStatusCache) {
        return new HoodieFileIndex(spark, metaClient, schemaSpec, options, fileStatusCache);
    }

    public FileStatusCache apply$default$5() {
        return NoopCache$.MODULE$;
    }

    public Option<Tuple5<SparkSession, HoodieTableMetaClient, Option<StructType>, scala.collection.immutable.Map<String, String>, FileStatusCache>> unapply(HoodieFileIndex x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.spark(), (Object)x$0.metaClient(), x$0.schemaSpec(), x$0.options(), (Object)x$0.fileStatusCache()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$collectReferencedColumns$3(Function2 resolver$1, String colName$1, Attribute r) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)colName$1, (Object)r.name()));
    }

    public static final /* synthetic */ boolean $anonfun$getConfigProperties$1(Tuple2 p) {
        return p._2() != null;
    }

    private HoodieFileIndex$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

