/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.simple;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.io.HoodieKeyLocationFetchHandle;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;

public class HoodieSimpleIndex
extends HoodieIndex<Object, Object> {
    private final Option<BaseKeyGenerator> keyGeneratorOpt;

    public HoodieSimpleIndex(HoodieWriteConfig config, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config);
        this.keyGeneratorOpt = keyGeneratorOpt;
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable) {
        return writeStatuses;
    }

    @Override
    public boolean rollbackCommit(String commitTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean canIndexLogFiles() {
        return false;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return true;
    }

    @Override
    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable) {
        return this.tagLocationInternal(records, context, hoodieTable);
    }

    protected <R> HoodieData<HoodieRecord<R>> tagLocationInternal(HoodieData<HoodieRecord<R>> inputRecords, HoodieEngineContext context, HoodieTable hoodieTable) {
        if (this.config.getSimpleIndexUseCaching()) {
            inputRecords.persist(new HoodieConfig(this.config.getProps()).getString(HoodieIndexConfig.SIMPLE_INDEX_INPUT_STORAGE_LEVEL_VALUE));
        }
        HoodiePairData keyedInputRecords = inputRecords.mapToPair(record -> new ImmutablePair<HoodieKey, HoodieRecord>(record.getKey(), (HoodieRecord)record));
        HoodiePairData<HoodieKey, HoodieRecordLocation> existingLocationsOnTable = this.fetchRecordLocationsForAffectedPartitions(keyedInputRecords.keys(), context, hoodieTable, this.config.getSimpleIndexParallelism());
        HoodieData<HoodieRecord<R>> taggedRecords = keyedInputRecords.leftOuterJoin(existingLocationsOnTable).map(entry -> {
            HoodieRecord untaggedRecord = (HoodieRecord)((Pair)entry.getRight()).getLeft();
            Option<Object> location = Option.ofNullable(((Option)((Pair)entry.getRight()).getRight()).orElse(null));
            return HoodieIndexUtils.getTaggedRecord(untaggedRecord, location);
        });
        if (this.config.getSimpleIndexUseCaching()) {
            inputRecords.unpersist();
        }
        return taggedRecords;
    }

    protected HoodiePairData<HoodieKey, HoodieRecordLocation> fetchRecordLocationsForAffectedPartitions(HoodieData<HoodieKey> hoodieKeys, HoodieEngineContext context, HoodieTable hoodieTable, int parallelism) {
        List<String> affectedPartitionPathList = hoodieKeys.map(HoodieKey::getPartitionPath).distinct().collectAsList();
        List<Pair<String, HoodieBaseFile>> latestBaseFiles = HoodieIndexUtils.getLatestBaseFilesForAllPartitions(affectedPartitionPathList, context, hoodieTable);
        return this.fetchRecordLocations(context, hoodieTable, parallelism, latestBaseFiles);
    }

    protected HoodiePairData<HoodieKey, HoodieRecordLocation> fetchRecordLocations(HoodieEngineContext context, HoodieTable hoodieTable, int parallelism, List<Pair<String, HoodieBaseFile>> baseFiles) {
        int fetchParallelism = Math.max(1, Math.min(baseFiles.size(), parallelism));
        return context.parallelize(baseFiles, fetchParallelism).flatMap(partitionPathBaseFile -> new HoodieKeyLocationFetchHandle(this.config, hoodieTable, (Pair<String, HoodieBaseFile>)partitionPathBaseFile, this.keyGeneratorOpt).locations().iterator()).mapToPair(e -> (Pair)e);
    }
}

