/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.HoodieBloomFilterWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class HoodieRowParquetWriteSupport
extends ParquetWriteSupport {
    private final Configuration hadoopConf;
    private final Option<HoodieBloomFilterWriteSupport<UTF8String>> bloomFilterWriteSupportOpt;

    public HoodieRowParquetWriteSupport(Configuration conf, StructType structType, Option<BloomFilter> bloomFilterOpt, HoodieWriteConfig writeConfig) {
        Configuration hadoopConf = new Configuration(conf);
        hadoopConf.set("spark.sql.parquet.writeLegacyFormat", writeConfig.parquetWriteLegacyFormatEnabled());
        hadoopConf.set("spark.sql.parquet.outputTimestampType", writeConfig.parquetOutputTimestampType());
        hadoopConf.set("spark.sql.parquet.fieldId.write.enabled", writeConfig.parquetFieldIdWriteEnabled());
        HoodieRowParquetWriteSupport.setSchema((StructType)structType, (Configuration)hadoopConf);
        this.hadoopConf = hadoopConf;
        this.bloomFilterWriteSupportOpt = bloomFilterOpt.map(HoodieBloomFilterRowWriteSupport::new);
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        Map extraMetadata = this.bloomFilterWriteSupportOpt.map(HoodieBloomFilterWriteSupport::finalizeMetadata).orElse(Collections.emptyMap());
        return new WriteSupport.FinalizedWriteContext(extraMetadata);
    }

    public void add(UTF8String recordKey) {
        this.bloomFilterWriteSupportOpt.ifPresent(bloomFilterWriteSupport -> bloomFilterWriteSupport.addKey(recordKey));
    }

    private static class HoodieBloomFilterRowWriteSupport
    extends HoodieBloomFilterWriteSupport<UTF8String> {
        public HoodieBloomFilterRowWriteSupport(BloomFilter bloomFilter) {
            super(bloomFilter);
        }

        @Override
        protected byte[] getUTF8Bytes(UTF8String key) {
            return key.getBytes();
        }

        @Override
        protected UTF8String dereference(UTF8String key) {
            return key.clone();
        }
    }
}

