/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.com.codahale.metrics.MetricFilter;
import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.apache.hudi.metrics.datadog.DatadogReporter;

public class DatadogMetricsReporter
extends MetricsReporter {
    private final DatadogReporter reporter;
    private final int reportPeriodSeconds;

    public DatadogMetricsReporter(HoodieWriteConfig config, MetricRegistry registry) {
        this.reportPeriodSeconds = config.getDatadogReportPeriodSeconds();
        DatadogHttpClient.ApiSite apiSite = config.getDatadogApiSite();
        String apiKey = config.getDatadogApiKey();
        ValidationUtils.checkState(!StringUtils.isNullOrEmpty(apiKey), "Datadog cannot be initialized: API key is null or empty.");
        boolean skipValidation = config.getDatadogApiKeySkipValidation();
        int timeoutSeconds = config.getDatadogApiTimeoutSeconds();
        String prefix = config.getDatadogMetricPrefix();
        ValidationUtils.checkState(!StringUtils.isNullOrEmpty(prefix), "Datadog cannot be initialized: Metric prefix is null or empty.");
        Option<String> host = Option.ofNullable(config.getDatadogMetricHost());
        List<String> tagList = config.getDatadogMetricTags();
        Option<List<String>> tags = tagList.isEmpty() ? Option.empty() : Option.of(tagList);
        this.reporter = new DatadogReporter(registry, new DatadogHttpClient(apiSite, apiKey, skipValidation, timeoutSeconds), prefix, host, tags, MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS);
    }

    @Override
    public void start() {
        this.reporter.start(this.reportPeriodSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void report() {
        this.reporter.report();
    }

    @Override
    public void stop() {
        this.reporter.stop();
    }
}

