/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.com.beust.jcommander.JCommander;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.utilities.IdentitySplitter;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class HoodieDropPartitionsTool
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(HoodieDropPartitionsTool.class);
    private final transient JavaSparkContext jsc;
    private final Config cfg;
    private TypedProperties props;
    private final HoodieTableMetaClient metaClient;

    public HoodieDropPartitionsTool(JavaSparkContext jsc, Config cfg) {
        this.jsc = jsc;
        this.cfg = cfg;
        this.props = cfg.propsFilePath == null ? UtilHelpers.buildProperties(cfg.configs) : this.readConfigFromFileSystem(jsc, cfg);
        this.metaClient = HoodieTableMetaClient.builder().setConf(jsc.hadoopConfiguration()).setBasePath(cfg.basePath).setLoadActiveTimelineOnLoad(true).build();
    }

    private TypedProperties readConfigFromFileSystem(JavaSparkContext jsc, Config cfg) {
        return UtilHelpers.readConfig(jsc.hadoopConfiguration(), new Path(cfg.propsFilePath), cfg.configs).getProps(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        SparkConf sparkConf = UtilHelpers.buildSparkConf("Hoodie-Drop-Table-Partitions", cfg.sparkMaster);
        sparkConf.set("spark.executor.memory", cfg.sparkMemory);
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        HoodieDropPartitionsTool tool = new HoodieDropPartitionsTool(jsc, cfg);
        try {
            tool.run();
        }
        catch (Throwable throwable) {
            LOG.error((Object)("Fail to run deleting table partitions for " + cfg.toString()), throwable);
        }
        finally {
            jsc.stop();
        }
    }

    public void run() {
        try {
            if (StringUtils.isNullOrEmpty(this.cfg.instantTime)) {
                this.cfg.instantTime = HoodieActiveTimeline.createNewInstantTime();
            }
            LOG.info((Object)this.cfg.toString());
            Mode mode = Mode.valueOf(this.cfg.runningMode.toUpperCase());
            switch (mode) {
                case DELETE: {
                    LOG.info((Object)" ****** The Hoodie Drop Partitions Tool is in delete mode ****** ");
                    this.doDeleteTablePartitions();
                    this.syncToHiveIfNecessary();
                    break;
                }
                case DRY_RUN: {
                    LOG.info((Object)" ****** The Hoodie Drop Partitions Tool is in dry-run mode ****** ");
                    this.dryRun();
                    break;
                }
                default: {
                    LOG.info((Object)("Unsupported running mode [" + this.cfg.runningMode + "], quit the job directly"));
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new HoodieException("Unable to delete table partitions in " + this.cfg.basePath, e);
        }
    }

    public void dryRun() {
        try (SparkRDDWriteClient<HoodieRecordPayload> client = UtilHelpers.createHoodieClient(this.jsc, this.cfg.basePath, "", this.cfg.parallelism, Option.empty(), this.props);){
            HoodieSparkTable table = HoodieSparkTable.create(client.getConfig(), client.getEngineContext());
            List<String> parts = Arrays.asList(this.cfg.partitions.split(","));
            Map partitionToReplaceFileIds = this.jsc.parallelize(parts, parts.size()).distinct().mapToPair((PairFunction & Serializable)partitionPath -> new Tuple2(partitionPath, table.getSliceView().getLatestFileSlices((String)partitionPath).map(fg -> fg.getFileId()).distinct().collect(Collectors.toList()))).collectAsMap();
            this.printDeleteFilesInfo(partitionToReplaceFileIds);
        }
    }

    private void syncToHiveIfNecessary() {
        if (this.cfg.syncToHive) {
            HiveSyncConfig hiveSyncConfig = this.buildHiveSyncProps();
            this.syncHive(hiveSyncConfig);
        }
    }

    private void doDeleteTablePartitions() {
        this.props.put(HoodieWriteConfig.AUTO_COMMIT_ENABLE.key(), "true");
        try (SparkRDDWriteClient<HoodieRecordPayload> client = UtilHelpers.createHoodieClient(this.jsc, this.cfg.basePath, "", this.cfg.parallelism, Option.empty(), this.props);){
            List<String> partitionsToDelete = Arrays.asList(this.cfg.partitions.split(","));
            client.startCommitWithTime(this.cfg.instantTime, "replacecommit");
            client.deletePartitions(partitionsToDelete, this.cfg.instantTime);
        }
    }

    private HiveSyncConfig buildHiveSyncProps() {
        this.verifyHiveConfigs();
        TypedProperties props = new TypedProperties();
        props.put(DataSourceWriteOptions.HIVE_DATABASE().key(), this.cfg.hiveDataBase);
        props.put(DataSourceWriteOptions.HIVE_TABLE().key(), this.cfg.hiveTableName);
        props.put(DataSourceWriteOptions.HIVE_USER().key(), this.cfg.hiveUserName);
        props.put(DataSourceWriteOptions.HIVE_PASS().key(), this.cfg.hivePassWord);
        props.put(DataSourceWriteOptions.HIVE_URL().key(), this.cfg.hiveURL);
        props.put(DataSourceWriteOptions.HIVE_PARTITION_FIELDS().key(), this.cfg.hivePartitionsField);
        props.put(DataSourceWriteOptions.HIVE_USE_JDBC().key(), (Object)this.cfg.hiveUseJdbc);
        props.put(DataSourceWriteOptions.HIVE_SYNC_MODE().key(), this.cfg.hiveSyncMode);
        props.put(DataSourceWriteOptions.HIVE_IGNORE_EXCEPTIONS().key(), (Object)this.cfg.hiveSyncIgnoreException);
        props.put(DataSourceWriteOptions.HIVE_PASS().key(), this.cfg.hivePassWord);
        props.put(HiveSyncConfig.META_SYNC_BASE_PATH, this.cfg.basePath);
        props.put(HiveSyncConfig.META_SYNC_BASE_FILE_FORMAT, "PARQUET");
        props.put(DataSourceWriteOptions.PARTITIONS_TO_DELETE().key(), this.cfg.partitions);
        props.put(DataSourceWriteOptions.HIVE_PARTITION_EXTRACTOR_CLASS().key(), this.cfg.partitionValueExtractorClass);
        props.put(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), this.cfg.hivePartitionsField);
        return new HiveSyncConfig(props, new Configuration());
    }

    private void verifyHiveConfigs() {
        ValidationUtils.checkArgument(!StringUtils.isNullOrEmpty(this.cfg.hiveDataBase), "Hive database name couldn't be null or empty when enable sync meta, please set --hive-database/-db.");
        ValidationUtils.checkArgument(!StringUtils.isNullOrEmpty(this.cfg.hiveTableName), "Hive table name couldn't be null or empty when enable sync meta, please set --hive-table-name/-tn.");
    }

    private void syncHive(HiveSyncConfig hiveSyncConfig) {
        LOG.info((Object)("Syncing target hoodie table with hive table(" + hiveSyncConfig.getStringOrDefault(HoodieSyncConfig.META_SYNC_TABLE_NAME) + "). Hive metastore URL :" + hiveSyncConfig.getStringOrDefault(HiveSyncConfigHolder.HIVE_URL) + ", basePath :" + this.cfg.basePath));
        LOG.info((Object)("Hive Sync Conf => " + hiveSyncConfig.toString()));
        FileSystem fs = FSUtils.getFs(this.cfg.basePath, this.jsc.hadoopConfiguration());
        HiveConf hiveConf = new HiveConf();
        if (!StringUtils.isNullOrEmpty(this.cfg.hiveHMSUris)) {
            hiveConf.set("hive.metastore.uris", this.cfg.hiveHMSUris);
        }
        hiveConf.addResource(fs.getConf());
        LOG.info((Object)("Hive Conf => " + hiveConf.getAllProperties().toString()));
        HiveSyncTool hiveSyncTool = new HiveSyncTool((Properties)hiveSyncConfig.getProps(), (Configuration)hiveConf);
        hiveSyncTool.syncHoodieTable();
    }

    private void printDeleteFilesInfo(Map<String, List<String>> partitionToReplaceFileIds) {
        LOG.info((Object)"Data files and partitions to delete : ");
        for (Map.Entry<String, List<String>> entry : partitionToReplaceFileIds.entrySet()) {
            LOG.info((Object)String.format("Partitions : %s, corresponding data file IDs : %s", entry.getKey(), entry.getValue()));
        }
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--base-path", "-sp"}, description="Base path for the table", required=true)
        public String basePath = null;
        @Parameter(names={"--mode", "-m"}, description="Set job mode: Set \"delete\" means mask/tombstone these partitions and corresponding data files table partitions and let cleaner delete these files later;Set \"dry_run\" means only looking for the table partitions will be deleted and corresponding data files.", required=true)
        public String runningMode = null;
        @Parameter(names={"--table-name", "-tn"}, description="Table name", required=true)
        public String tableName = null;
        @Parameter(names={"--partitions", "-p"}, description="Comma separated list of partitions to delete.", required=true)
        public String partitions = null;
        @Parameter(names={"--parallelism", "-pl"}, description="Parallelism for hoodie insert/upsert/delete", required=false)
        public int parallelism = 1500;
        @Parameter(names={"--instant-time", "-it"}, description="instant time for delete table partitions operation.", required=false)
        public String instantTime = null;
        @Parameter(names={"--sync-hive-meta", "-sync"}, description="Sync information to HMS.", required=false)
        public boolean syncToHive = false;
        @Parameter(names={"--hive-database", "-db"}, description="Database to sync to.", required=false)
        public String hiveDataBase = null;
        @Parameter(names={"--hive-table-name"}, description="Table to sync to.", required=false)
        public String hiveTableName = null;
        @Parameter(names={"--hive-user-name", "-user"}, description="hive user name to use.", required=false)
        public String hiveUserName = "hive";
        @Parameter(names={"--hive-pass-word", "-pass"}, description="hive password to use.", required=false)
        public String hivePassWord = "hive";
        @Parameter(names={"--hive-jdbc-url", "-jdbc"}, description="hive url to use.", required=false)
        public String hiveURL = "jdbc:hive2://localhost:10000";
        @Parameter(names={"--hive-partition-field"}, description="Comma separated list of field in the hive table to use for determining hive partition columns.", required=false)
        public String hivePartitionsField = "";
        @Parameter(names={"--hive-sync-use-jdbc"}, description="Use JDBC when hive synchronization.", required=false)
        public boolean hiveUseJdbc = true;
        @Parameter(names={"--hive-metastore-uris"}, description="hive meta store uris to use.", required=false)
        public String hiveHMSUris = null;
        @Parameter(names={"--hive-sync-mode"}, description="Mode to choose for Hive ops. Valid values are hms, jdbc and hiveql.", required=false)
        public String hiveSyncMode = "hms";
        @Parameter(names={"--hive-sync-ignore-exception"}, description="Ignore hive sync exception.", required=false)
        public boolean hiveSyncIgnoreException = false;
        @Parameter(names={"--hive-partition-value-extractor-class"}, description="Class which implements PartitionValueExtractor to extract the partition values, default 'SlashEncodedDayPartitionValueExtractor'.", required=false)
        public String partitionValueExtractorClass = "org.apache.hudi.hive.SlashEncodedDayPartitionValueExtractor";
        @Parameter(names={"--spark-master", "-ms"}, description="Spark master", required=false)
        public String sparkMaster = null;
        @Parameter(names={"--spark-memory", "-sm"}, description="spark memory to use", required=false)
        public String sparkMemory = "1g";
        @Parameter(names={"--props"}, description="path to properties file on localfs or dfs, with configurations for hoodie client for deleting table partitions")
        public String propsFilePath = null;
        @Parameter(names={"--hoodie-conf"}, description="Any configuration that can be set in the properties file (using the CLI parameter \"--props\") can also be passed command line using this parameter. This can be repeated", splitter=IdentitySplitter.class)
        public List<String> configs = new ArrayList<String>();
        @Parameter(names={"--help", "-h"}, help=true)
        public Boolean help = false;

        public String toString() {
            return "HoodieDropPartitionsToolConfig {\n   --base-path " + this.basePath + ", \n   --mode " + this.runningMode + ", \n   --table-name " + this.tableName + ", \n   --partitions " + this.partitions + ", \n   --parallelism " + this.parallelism + ", \n   --instantTime " + this.instantTime + ", \n   --sync-hive-meta " + this.syncToHive + ", \n   --hive-database " + this.hiveDataBase + ", \n   --hive-table-name " + this.hiveTableName + ", \n   --hive-user-name Masked, \n   --hive-pass-word Masked, \n   --hive-jdbc-url " + this.hiveURL + ", \n   --hive-partition-field " + this.hivePartitionsField + ", \n   --hive-sync-use-jdbc " + this.hiveUseJdbc + ", \n   --hive-metastore-uris " + this.hiveHMSUris + ", \n   --hive-sync-ignore-exception " + this.hiveSyncIgnoreException + ", \n   --hive-partition-value-extractor-class " + this.partitionValueExtractorClass + ", \n   --spark-master " + this.sparkMaster + ", \n   --spark-memory " + this.sparkMemory + ", \n   --props " + this.propsFilePath + ", \n   --hoodie-conf " + this.configs + "\n}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Config config = (Config)o;
            return this.basePath.equals(config.basePath) && Objects.equals(this.runningMode, config.runningMode) && Objects.equals(this.tableName, config.tableName) && Objects.equals(this.partitions, config.partitions) && Objects.equals(this.instantTime, config.instantTime) && Objects.equals(this.syncToHive, config.syncToHive) && Objects.equals(this.hiveDataBase, config.hiveDataBase) && Objects.equals(this.hiveTableName, config.hiveTableName) && Objects.equals(this.hiveUserName, config.hiveUserName) && Objects.equals(this.hivePassWord, config.hivePassWord) && Objects.equals(this.hiveURL, config.hiveURL) && Objects.equals(this.hivePartitionsField, config.hivePartitionsField) && Objects.equals(this.hiveUseJdbc, config.hiveUseJdbc) && Objects.equals(this.hiveHMSUris, config.hiveHMSUris) && Objects.equals(this.partitionValueExtractorClass, config.partitionValueExtractorClass) && Objects.equals(this.sparkMaster, config.sparkMaster) && Objects.equals(this.sparkMemory, config.sparkMemory) && Objects.equals(this.propsFilePath, config.propsFilePath) && Objects.equals(this.configs, config.configs) && Objects.equals(this.hiveSyncIgnoreException, config.hiveSyncIgnoreException);
        }

        public int hashCode() {
            return Objects.hash(this.basePath, this.runningMode, this.tableName, this.partitions, this.instantTime, this.syncToHive, this.hiveDataBase, this.hiveTableName, this.hiveUserName, this.hivePassWord, this.hiveURL, this.hivePartitionsField, this.hiveUseJdbc, this.hiveHMSUris, this.partitionValueExtractorClass, this.sparkMaster, this.sparkMemory, this.propsFilePath, this.configs, this.hiveSyncIgnoreException, this.help);
        }
    }

    public static enum Mode {
        DELETE,
        DRY_RUN;

    }
}

