/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.checkpointing;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.exception.HoodieException;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public abstract class InitialCheckPointProvider {
    protected transient Path path;
    protected transient FileSystem fs;
    protected transient TypedProperties props;

    public InitialCheckPointProvider(TypedProperties props) {
        this.props = props;
        this.path = new Path(props.getString(Config.CHECKPOINT_PROVIDER_PATH_PROP));
    }

    public void init(Configuration config) throws HoodieException {
        try {
            this.fs = FileSystem.get((Configuration)config);
        }
        catch (IOException e) {
            throw new HoodieException("CheckpointProvider initialization failed");
        }
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract String getCheckpoint() throws HoodieException;

    static class Config {
        private static String CHECKPOINT_PROVIDER_PATH_PROP = "hoodie.deltastreamer.checkpoint.provider.path";

        Config() {
        }
    }
}

