/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RepairMigratePartitionMetaProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\t\u0012\u0001\u0001BQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004=\u0001\u0001\u0006Ia\r\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!)a\t\u0001C\u0001e!)q\t\u0001C\u0001}!)\u0001\n\u0001C!\u0013\")q\f\u0001C!A\u001e)A-\u0005E\u0001K\u001a)\u0001#\u0005E\u0001M\")af\u0003C\u0001U\"91n\u0003b\u0001\n\u0003a\u0007BB;\fA\u0003%Q\u000eC\u0003w\u0017\u0011\u0005qOA\u0012SKB\f\u0017N]'jOJ\fG/\u001a)beRLG/[8o\u001b\u0016$\u0018\r\u0015:pG\u0016$WO]3\u000b\u0005I\u0019\u0012A\u00039s_\u000e,G-\u001e:fg*\u0011A#F\u0001\bG>lW.\u00198e\u0015\t1r#\u0001\u0003ik\u0012L'B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\"K!\u0002\"AI\u0012\u000e\u0003EI!\u0001J\t\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t\u0011c%\u0003\u0002(#\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM\u001d\t\u0003S1j\u0011A\u000b\u0006\u0003We\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002aA\u0011!\u0005A\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#A\u001a\u0011\u0007Q:\u0014(D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0015\t%O]1z!\t\u0011#(\u0003\u0002<#\t\u0011\u0002K]8dK\u0012,(/\u001a)be\u0006lW\r^3s\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\u0002\u0017=+F\u000bU+U?RK\u0006+R\u000b\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iF\u0001\u0006if\u0004Xm]\u0005\u0003\t\u0006\u0013!b\u0015;sk\u000e$H+\u001f9f\u00031yU\u000b\u0016)V)~#\u0016\fU#!\u0003)\u0001\u0018M]1nKR,'o]\u0001\u000b_V$\b/\u001e;UsB,\u0017\u0001B2bY2$\"A\u0013.\u0011\u0007-\u001bfK\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011qjH\u0001\u0007yI|w\u000e\u001e \n\u0003YJ!AU\u001b\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\u0004'\u0016\f(B\u0001*6!\t9\u0006,D\u0001\u0018\u0013\tIvCA\u0002S_^DQa\u0017\u0005A\u0002q\u000bA!\u0019:hgB\u0011!%X\u0005\u0003=F\u0011Q\u0002\u0015:pG\u0016$WO]3Be\u001e\u001c\u0018!\u00022vS2$W#A1\u0011\u0005\t\u0012\u0017BA2\u0012\u0005%\u0001&o\\2fIV\u0014X-A\u0012SKB\f\u0017N]'jOJ\fG/\u001a)beRLG/[8o\u001b\u0016$\u0018\r\u0015:pG\u0016$WO]3\u0011\u0005\tZ1CA\u0006h!\t!\u0004.\u0003\u0002jk\t1\u0011I\\=SK\u001a$\u0012!Z\u0001\u0005\u001d\u0006kU)F\u0001n!\tq7/D\u0001p\u0015\t\u0001\u0018/\u0001\u0003mC:<'\"\u0001:\u0002\t)\fg/Y\u0005\u0003i>\u0014aa\u0015;sS:<\u0017!\u0002(B\u001b\u0016\u0003\u0013a\u00022vS2$WM]\u000b\u0002qB\u0019\u0011P`\u0013\u000e\u0003iT!a\u001f?\u0002\u0011\u0019,hn\u0019;j_:T!!`9\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fj\u0014\u0001bU;qa2LWM\u001d")
public class RepairMigratePartitionMetaProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RepairMigratePartitionMetaProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RepairMigratePartitionMetaProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        boolean dryRun = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String tablePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(tablePath).build();
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(metaClient.getHadoopConf());
        List<String> partitionPaths = FSUtils.getAllPartitionPaths(engineContext, tablePath, false, false);
        Path basePath = new Path(tablePath);
        ArrayList rows = new ArrayList(partitionPaths.size());
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(partitionPaths).foreach((Function1 & Serializable & scala.Serializable)partitionPath -> BoxesRunTime.boxToBoolean((boolean)RepairMigratePartitionMetaProcedure.$anonfun$call$1(tablePath, metaClient, dryRun, basePath, rows, partitionPath)));
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.key(), "true");
        HoodieTableConfig.update(metaClient.getFs(), new Path(metaClient.getMetaPath()), props);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new RepairMigratePartitionMetaProcedure();
    }

    public static final /* synthetic */ boolean $anonfun$call$1(String tablePath$1, HoodieTableMetaClient metaClient$1, boolean dryRun$1, Path basePath$1, ArrayList rows$1, String partitionPath) {
        String action;
        Path partition = FSUtils.getPartitionPath(tablePath$1, partitionPath);
        org.apache.hudi.common.util.Option<Path> textFormatFile = HoodiePartitionMetadata.textFormatMetaPathIfExists(metaClient$1.getFs(), partition);
        org.apache.hudi.common.util.Option<Path> baseFormatFile = HoodiePartitionMetadata.baseFormatMetaPathIfExists(metaClient$1.getFs(), partition);
        String latestCommit = metaClient$1.getActiveTimeline().getCommitTimeline().lastInstant().get().getTimestamp();
        String string = action = textFormatFile.isPresent() ? "MIGRATE" : "NONE";
        if (!dryRun$1) {
            if (!baseFormatFile.isPresent()) {
                HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(metaClient$1.getFs(), latestCommit, basePath$1, partition, org.apache.hudi.common.util.Option.of(metaClient$1.getTableConfig().getBaseFileFormat()));
                partitionMetadata.trySave(0);
            }
            textFormatFile.ifPresent(new Consumer<Path>(null, metaClient$1){
                private final HoodieTableMetaClient metaClient$1;

                public Consumer<Path> andThen(Consumer<? super Path> x$1) {
                    return Consumer.super.andThen(x$1);
                }

                public void accept(Path p) {
                    try {
                        this.metaClient$1.getFs().delete(p, false);
                    }
                    catch (IOException e) {
                        throw new HoodieIOException(e.getMessage(), e);
                    }
                }
                {
                    this.metaClient$1 = metaClient$1;
                }
            });
            action = "MIGRATED";
        }
        return rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPath, String.valueOf(textFormatFile.isPresent()), String.valueOf(baseFormatFile.isPresent()), action})));
    }

    public RepairMigratePartitionMetaProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "dry_run", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)true))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("text_metafile_present", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("base_metafile_present", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

