/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowRollbacksProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001\u0002\u000e\u001c\u0001)B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006s\u0001!\tA\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!9a\t\u0001b\u0001\n\u0013q\u0004BB$\u0001A\u0003%q\bC\u0004I\u0001\t\u0007I\u0011B%\t\rA\u0003\u0001\u0015!\u0003K\u0011\u001d\t\u0006A1A\u0005\n%CaA\u0015\u0001!\u0002\u0013Q\u0005\"B*\u0001\t\u0003q\u0004\"\u0002+\u0001\t\u0003I\u0005\"B+\u0001\t\u00032\u0006\"\u00027\u0001\t\u0003jg\u0001B9\u0001\u0001ID\u0001B`\b\u0003\u0002\u0003\u0006Ia \u0005\u0007s=!\t!a\u0002\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011Q\u0007\u0001\u0005\u0002\u0005]raBA\u001f7!\u0005\u0011q\b\u0004\u00075mA\t!!\u0011\t\re*B\u0011AA%\u0011%\tY%\u0006b\u0001\n\u0003\ti\u0005\u0003\u0005\u0002^U\u0001\u000b\u0011BA(\u0011\u001d\ty&\u0006C\u0001\u0003C\u0012ac\u00155poJ{G\u000e\u001c2bG.\u001c\bK]8dK\u0012,(/\u001a\u0006\u00039u\t!\u0002\u001d:pG\u0016$WO]3t\u0015\tqr$A\u0004d_6l\u0017M\u001c3\u000b\u0005\u0001\n\u0013\u0001\u00025vI&T!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00160!\taS&D\u0001\u001c\u0013\tq3DA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003YAJ!!M\u000e\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\u0018aC:i_^$U\r^1jYN\u0004\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0003wq\u0002\"\u0001\f\u0001\t\u000bI\u0012\u0001\u0019A\u001a\u0002)I{E\n\u0014\"B\u0007.\u001bv\fU!S\u00036+E+\u0012*T+\u0005y\u0004c\u0001\u001bA\u0005&\u0011\u0011)\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003Y\rK!\u0001R\u000e\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM]\u0001\u0016%>cEJQ!D\u0017N{\u0006+\u0011*B\u001b\u0016#VIU*!\u0003M\u0011v\n\u0014'C\u0003\u000e[u\fU!S\u00036+E+\u0012*T\u0003Q\u0011v\n\u0014'C\u0003\u000e[u\fU!S\u00036+E+\u0012*TA\u0005)\"k\u0014'M\u0005\u0006\u001b5jU0P+R\u0003V\u000bV0U3B+U#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055\u000b\u0013!\u0002;za\u0016\u001c\u0018BA(M\u0005)\u0019FO];diRK\b/Z\u0001\u0017%>cEJQ!D\u0017N{v*\u0016+Q+R{F+\u0017)FA\u0005!\"k\u0014'M\u0005\u0006\u001b5jX(V)B+Fk\u0018+Z!\u0016\u000bQCU(M\u0019\n\u000b5iS0P+R\u0003V\u000bV0U3B+\u0005%\u0001\u0006qCJ\fW.\u001a;feN\f!b\\;uaV$H+\u001f9f\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005];\u0007c\u0001-aG:\u0011\u0011L\u0018\b\u00035vk\u0011a\u0017\u0006\u00039&\na\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005}+\u0014a\u00029bG.\fw-Z\u0005\u0003C\n\u00141aU3r\u0015\tyV\u0007\u0005\u0002eK6\t\u0011%\u0003\u0002gC\t\u0019!k\\<\t\u000b!l\u0001\u0019A5\u0002\t\u0005\u0014xm\u001d\t\u0003Y)L!a[\u000e\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0003\u0015\u0011W/\u001b7e+\u0005q\u0007C\u0001\u0017p\u0013\t\u00018DA\u0005Qe>\u001cW\rZ;sK\n\u0001\"k\u001c7mE\u0006\u001c7\u000eV5nK2Lg.Z\n\u0003\u001fM\u0004\"\u0001\u001e?\u000e\u0003UT!A^<\u0002\u0011QLW.\u001a7j]\u0016T!\u0001_=\u0002\u000bQ\f'\r\\3\u000b\u0005i\\\u0018AB2p[6|gN\u0003\u0002!K%\u0011Q0\u001e\u0002\u0015\u0011>|G-[3BGRLg/\u001a+j[\u0016d\u0017N\\3\u0002\u00155,G/Y\"mS\u0016tG\u000f\u0005\u0003\u0002\u0002\u0005\rQ\"A<\n\u0007\u0005\u0015qOA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;\u0015\t\u0005%\u0011Q\u0002\t\u0004\u0003\u0017yQ\"\u0001\u0001\t\u000by\f\u0002\u0019A@\u0002#\u001d,GOU8mY\n\f7m\u001b#fi\u0006LG\u000eF\u0004X\u0003'\t9\"a\u000b\t\u000f\u0005U!\u00031\u0001\u0002\n\u0005q\u0011m\u0019;jm\u0016$\u0016.\\3mS:,\u0007bBA\r%\u0001\u0007\u00111D\u0001\fS:\u001cH/\u00198u)&lW\r\u0005\u0003\u0002\u001e\u0005\u0015b\u0002BA\u0010\u0003C\u0001\"AW\u001b\n\u0007\u0005\rR'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\tIC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003G)\u0004bBA\u0017%\u0001\u0007\u0011qF\u0001\u0006Y&l\u0017\u000e\u001e\t\u0004i\u0005E\u0012bAA\u001ak\t\u0019\u0011J\u001c;\u0002\u0019\u001d,GOU8mY\n\f7m[:\u0015\u000b]\u000bI$a\u000f\t\u000f\u0005U1\u00031\u0001\u0002\n!9\u0011QF\nA\u0002\u0005=\u0012AF*i_^\u0014v\u000e\u001c7cC\u000e\\7\u000f\u0015:pG\u0016$WO]3\u0011\u00051*2cA\u000b\u0002DA\u0019A'!\u0012\n\u0007\u0005\u001dSG\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u007f\tAAT!N\u000bV\u0011\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0013\u0001\u00026bm\u0006LA!a\n\u0002T\u0005)a*Q'FA\u00059!-^5mI\u0016\u0014XCAA2!\u0015\t)'a\u001c0\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\t\u00055\u0014qK\u0001\u0005kRLG.\u0003\u0003\u0002r\u0005\u001d$\u0001C*vaBd\u0017.\u001a:")
public class ShowRollbacksProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final boolean showDetails;
    private final ProcedureParameter[] ROLLBACKS_PARAMETERS;
    private final ProcedureParameter[] ROLLBACK_PARAMETERS;
    private final StructType ROLLBACKS_OUTPUT_TYPE;
    private final StructType ROLLBACK_OUTPUT_TYPE;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowRollbacksProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowRollbacksProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] ROLLBACKS_PARAMETERS() {
        return this.ROLLBACKS_PARAMETERS;
    }

    private ProcedureParameter[] ROLLBACK_PARAMETERS() {
        return this.ROLLBACK_PARAMETERS;
    }

    private StructType ROLLBACKS_OUTPUT_TYPE() {
        return this.ROLLBACKS_OUTPUT_TYPE;
    }

    private StructType ROLLBACK_OUTPUT_TYPE() {
        return this.ROLLBACK_OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.showDetails ? this.ROLLBACK_PARAMETERS() : this.ROLLBACKS_PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.showDetails ? this.ROLLBACK_OUTPUT_TYPE() : this.ROLLBACKS_OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Seq<Row> seq;
        super.checkArgs(this.parameters(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.parameters()[0]);
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.parameters()[1]).get());
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        RollbackTimeline activeTimeline = new RollbackTimeline(metaClient);
        if (this.showDetails) {
            String instantTime = (String)this.getArgValueOrDefault(args, this.parameters()[2]).get();
            seq = this.getRollbackDetail(activeTimeline, instantTime, limit);
        } else {
            seq = this.getRollbacks(activeTimeline, limit);
        }
        return seq;
    }

    @Override
    public Procedure build() {
        return new ShowRollbacksProcedure(this.showDetails);
    }

    public Seq<Row> getRollbackDetail(RollbackTimeline activeTimeline, String instantTime, int limit) {
        ArrayList rows = new ArrayList();
        HoodieRollbackMetadata metadata = TimelineMetadataUtils.deserializeAvroMetadata(activeTimeline.getInstantDetails(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", instantTime)).get(), HoodieRollbackMetadata.class);
        ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getPartitionMetadata()).asScala()).toMap(Predef$.MODULE$.$conforms()).iterator().foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ShowRollbacksProcedure.$anonfun$getRollbackDetail$1(rows, metadata, entry);
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    public Seq<Row> getRollbacks(RollbackTimeline activeTimeline, int limit) {
        ArrayList rows = new ArrayList();
        HoodieTimeline rollback = activeTimeline.getRollbackTimeline().filterCompletedInstants();
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(rollback.getInstants().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)instant -> {
            ShowRollbacksProcedure.$anonfun$getRollbacks$1(activeTimeline, rows, instant);
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    public static final /* synthetic */ void $anonfun$getRollbackDetail$1(ArrayList rows$1, HoodieRollbackMetadata metadata$1, Tuple2 entry) {
        ((Stream)package$.MODULE$.Stream().concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Traversable[]{(Traversable)JavaConversions$.MODULE$.asScalaBuffer(((HoodieRollbackPartitionMetadata)((Object)entry._2())).getSuccessDeleteFiles()).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(f, (Object)BoxesRunTime.boxToBoolean((boolean)true)), Buffer$.MODULE$.canBuildFrom()), (Traversable)JavaConversions$.MODULE$.asScalaBuffer(((HoodieRollbackPartitionMetadata)((Object)entry._2())).getFailedDeleteFiles()).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(f, (Object)BoxesRunTime.boxToBoolean((boolean)false)), Buffer$.MODULE$.canBuildFrom())}))).iterator().foreach((Function1 & Serializable & scala.Serializable)fileWithDeleteStatus -> BoxesRunTime.boxToBoolean((boolean)rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata$1.getStartRollbackTime(), metadata$1.getCommitsRollback().toString(), entry._1(), fileWithDeleteStatus._1(), BoxesRunTime.boxToBoolean((boolean)fileWithDeleteStatus._2$mcZ$sp())})))));
    }

    public static final /* synthetic */ void $anonfun$getRollbacks$1(RollbackTimeline activeTimeline$1, ArrayList rows$2, HoodieInstant instant) {
        try {
            HoodieRollbackMetadata metadata = TimelineMetadataUtils.deserializeAvroMetadata(activeTimeline$1.getInstantDetails(instant).get(), HoodieRollbackMetadata.class);
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metadata.getCommitsRollback().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)rows$2.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata.getStartRollbackTime(), c, metadata.getTotalFilesDeleted(), metadata.getTimeTakenInMillis(), metadata.getPartitionMetadata() != null ? BoxesRunTime.boxToInteger((int)metadata.getPartitionMetadata().size()) : BoxesRunTime.boxToInteger((int)0)})))));
        }
        catch (IOException e) {
            throw new HoodieException(new StringBuilder(44).append("Failed to get rollback's info from instant ").append(instant.getTimestamp()).append(".").toString());
        }
    }

    public ShowRollbacksProcedure(boolean showDetails) {
        this.showDetails = showDetails;
        this.ROLLBACKS_PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
        this.ROLLBACK_PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(2, "instant_time", DataTypes.StringType, None$.MODULE$)});
        this.ROLLBACKS_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("rollback_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_files_deleted", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("time_taken_in_millis", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_partitions", DataTypes.IntegerType, true, Metadata$.MODULE$.empty())}));
        this.ROLLBACK_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("rollback_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("deleted_file", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("succeeded", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }

    public class RollbackTimeline
    extends HoodieActiveTimeline {
        public /* synthetic */ ShowRollbacksProcedure org$apache$spark$sql$hudi$command$procedures$ShowRollbacksProcedure$RollbackTimeline$$$outer() {
            return ShowRollbacksProcedure.this;
        }

        public RollbackTimeline(HoodieTableMetaClient metaClient) {
            if (ShowRollbacksProcedure.this == null) {
                throw null;
            }
            super(metaClient, CollectionUtils.createImmutableSet((Object[])new String[]{".rollback"}));
        }
    }
}

