/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieBaseRelation;
import org.apache.hudi.HoodieTableSchema;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.io.storage.HoodieHFileReader;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroSchemaConverters;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class HoodieBaseRelation$
implements SparkAdapterSupport {
    public static HoodieBaseRelation$ MODULE$;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new HoodieBaseRelation$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieBaseRelation$ hoodieBaseRelation$ = this;
        synchronized (hoodieBaseRelation$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public UnsafeProjection generateUnsafeProjection(StructType from, StructType to) {
        return HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(from, to);
    }

    public Schema convertToAvroSchema(StructType structSchema) {
        HoodieAvroSchemaConverters qual$1 = this.sparkAdapter().getAvroSchemaConverters();
        StructType x$1 = structSchema;
        boolean x$2 = false;
        String x$3 = "Record";
        String x$4 = qual$1.toAvroType$default$4();
        return qual$1.toAvroType((DataType)x$1, x$2, x$3, x$4);
    }

    public Path getPartitionPath(FileStatus fileStatus) {
        return fileStatus.getPath().getParent();
    }

    public HoodieBaseRelation.BaseFileReader projectReader(HoodieBaseRelation.BaseFileReader reader, StructType requiredSchema) {
        HoodieBaseRelation.BaseFileReader baseFileReader;
        ValidationUtils.checkState(((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])reader.schema().fields())).toSet().intersect((GenSet)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).toSet())).size() == requiredSchema.size());
        StructType structType = reader.schema();
        StructType structType2 = requiredSchema;
        if (!(structType != null ? !structType.equals(structType2) : structType2 != null)) {
            baseFileReader = reader;
        } else {
            Function1 & Serializable & scala.Serializable read = (Function1 & Serializable & scala.Serializable)x$19 -> reader.apply((PartitionedFile)x$19);
            Function1 & Serializable & scala.Serializable projectedRead = (Function1 & Serializable & scala.Serializable)file -> {
                UnsafeProjection unsafeProjection = MODULE$.generateUnsafeProjection(reader.schema(), requiredSchema);
                return ((Iterator)read.apply(file)).map((Function1)unsafeProjection);
            };
            baseFileReader = new HoodieBaseRelation.BaseFileReader((Function1<PartitionedFile, Iterator<InternalRow>>)projectedRead, requiredSchema);
        }
        return baseFileReader;
    }

    public Tuple3<Schema, StructType, InternalSchema> projectSchema(Either<Schema, InternalSchema> tableSchema, String[] requiredColumns) {
        Tuple3 tuple3;
        Either<Schema, InternalSchema> either = tableSchema;
        if (either instanceof Right) {
            Right right = (Right)either;
            InternalSchema internalSchema = (InternalSchema)right.value();
            ValidationUtils.checkState(!internalSchema.isEmptySchema());
            InternalSchema prunedInternalSchema = InternalSchemaUtils.pruneInternalSchema(internalSchema, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).toList()).asJava());
            Schema requiredAvroSchema = AvroInternalSchemaConverter.convert(prunedInternalSchema, "schema");
            StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
            tuple3 = new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)prunedInternalSchema);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Schema avroSchema = (Schema)left.value();
            Map fieldMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List requiredFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)col -> {
                Schema.Field f = (Schema.Field)fieldMap.apply(col);
                return new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal(), f.order());
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Schema.Field.class))))).toList();
            Schema requiredAvroSchema = Schema.createRecord((String)avroSchema.getName(), (String)avroSchema.getDoc(), (String)avroSchema.getNamespace(), (boolean)avroSchema.isError(), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requiredFields).asJava()));
            StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
            tuple3 = new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)InternalSchema.getEmptyInternalSchema());
        } else {
            throw new MatchError(either);
        }
        return tuple3;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> org$apache$hudi$HoodieBaseRelation$$createHFileReader(SparkSession spark, HoodieTableSchema dataSchema, HoodieTableSchema requiredDataSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast hadoopConfBroadcast = spark.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return (Function1 & Serializable & scala.Serializable)partitionedFile -> {
            Configuration hadoopConf = ((SerializableConfiguration)hadoopConfBroadcast.value()).get();
            HoodieHFileReader reader = new HoodieHFileReader(hadoopConf, new Path(partitionedFile.filePath()), new CacheConfig(hadoopConf));
            StructType requiredRowSchema = requiredDataSchema.structTypeSchema();
            Schema requiredAvroSchema = new Schema.Parser().parse(requiredDataSchema.avroSchemaStr());
            Function1<GenericRecord, Option<InternalRow>> avroToRowConverter = AvroConversionUtils$.MODULE$.createAvroToInternalRowConverter(requiredAvroSchema, requiredRowSchema);
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(reader.getRecordIterator(requiredAvroSchema)).asScala()).map((Function1 & Serializable & scala.Serializable)record -> (InternalRow)((Option)avroToRowConverter.apply(record)).get());
        };
    }

    public boolean isSchemaEvolutionEnabledOnRead(Map<String, String> optParams, SparkSession sparkSession) {
        return new StringOps(Predef$.MODULE$.augmentString((String)optParams.getOrElse((Object)DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().defaultValue().toString()))).toBoolean() || new StringOps(Predef$.MODULE$.augmentString(sparkSession.conf().get(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().key(), DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().defaultValue().toString()))).toBoolean();
    }

    private HoodieBaseRelation$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$(this);
    }
}

