/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieMemoryConfig;

public class IOUtils {
    public static long getMaxMemoryAllowedForMerge(TaskContextSupplier context, String maxMemoryFraction) {
        Option<String> totalMemoryOpt = context.getProperty(EngineProperty.TOTAL_MEMORY_AVAILABLE);
        Option<String> memoryFractionOpt = context.getProperty(EngineProperty.MEMORY_FRACTION_IN_USE);
        Option<String> totalCoresOpt = context.getProperty(EngineProperty.TOTAL_CORES_PER_EXECUTOR);
        if (totalMemoryOpt.isPresent() && memoryFractionOpt.isPresent() && totalCoresOpt.isPresent()) {
            long executorMemoryInBytes = Long.parseLong(totalMemoryOpt.get());
            double memoryFraction = Double.parseDouble(memoryFractionOpt.get());
            double maxMemoryFractionForMerge = Double.parseDouble(maxMemoryFraction);
            long executorCores = Long.parseLong(totalCoresOpt.get());
            double userAvailableMemory = (double)executorMemoryInBytes * (1.0 - memoryFraction) / (double)executorCores;
            long maxMemoryForMerge = (long)Math.floor(userAvailableMemory * maxMemoryFractionForMerge);
            return Math.max(0x6400000L, maxMemoryForMerge);
        }
        return 0x40000000L;
    }

    public static long getMaxMemoryPerPartitionMerge(TaskContextSupplier context, HoodieConfig hoodieConfig) {
        if (hoodieConfig.contains(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE)) {
            return hoodieConfig.getLong(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE);
        }
        String fraction = hoodieConfig.getStringOrDefault(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_MERGE);
        return IOUtils.getMaxMemoryAllowedForMerge(context, fraction);
    }

    public static long getMaxMemoryPerCompaction(TaskContextSupplier context, HoodieConfig hoodieConfig) {
        if (hoodieConfig.contains(HoodieMemoryConfig.MAX_MEMORY_FOR_COMPACTION)) {
            return hoodieConfig.getLong(HoodieMemoryConfig.MAX_MEMORY_FOR_COMPACTION);
        }
        String fraction = hoodieConfig.getStringOrDefault(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION);
        return IOUtils.getMaxMemoryAllowedForMerge(context, fraction);
    }
}

