/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCompactionException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.table.action.compact.HoodieCompactor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ScheduleCompactionActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieCompactionPlan>> {
    private static final Logger LOG = LogManager.getLogger(ScheduleCompactionActionExecutor.class);
    private final Option<Map<String, String>> extraMetadata;
    private final HoodieCompactor compactor;

    public ScheduleCompactionActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, Option<Map<String, String>> extraMetadata, HoodieCompactor compactor) {
        super(context, config, table, instantTime);
        this.extraMetadata = extraMetadata;
        this.compactor = compactor;
    }

    @Override
    public Option<HoodieCompactionPlan> execute() {
        HoodieCompactionPlan plan;
        if (!this.config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl() && !this.config.getFailedWritesCleanPolicy().isLazy()) {
            if (this.config.getEngineType() == EngineType.SPARK) {
                this.table.getActiveTimeline().getCommitsTimeline().filterPendingExcludingCompaction().firstInstant().ifPresent(earliestInflight -> ValidationUtils.checkArgument(HoodieTimeline.compareTimestamps(earliestInflight.getTimestamp(), HoodieTimeline.GREATER_THAN, this.instantTime), "Earliest write inflight instant time must be later than compaction time. Earliest :" + earliestInflight + ", Compaction scheduled at " + this.instantTime));
            }
            List conflictingInstants = this.table.getActiveTimeline().getWriteTimeline().filterCompletedAndCompactionInstants().getInstants().filter(instant -> HoodieTimeline.compareTimestamps(instant.getTimestamp(), HoodieTimeline.GREATER_THAN_OR_EQUALS, this.instantTime)).collect(Collectors.toList());
            ValidationUtils.checkArgument(conflictingInstants.isEmpty(), "Following instants have timestamps >= compactionInstant (" + this.instantTime + ") Instants :" + conflictingInstants);
        }
        if ((plan = this.scheduleCompaction()) != null && plan.getOperations() != null && !plan.getOperations().isEmpty()) {
            this.extraMetadata.ifPresent(plan::setExtraMetadata);
            HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", this.instantTime);
            try {
                this.table.getActiveTimeline().saveToCompactionRequested(compactionInstant, TimelineMetadataUtils.serializeCompactionPlan(plan));
            }
            catch (IOException ioe) {
                throw new HoodieIOException("Exception scheduling compaction", ioe);
            }
            return Option.of(plan);
        }
        return Option.empty();
    }

    private HoodieCompactionPlan scheduleCompaction() {
        LOG.info((Object)("Checking if compaction needs to be run on " + this.config.getBasePath()));
        boolean compactable = this.needCompact(this.config.getInlineCompactTriggerStrategy());
        if (compactable) {
            LOG.info((Object)("Generating compaction plan for merge on read table " + this.config.getBasePath()));
            try {
                SyncableFileSystemView fileSystemView = (SyncableFileSystemView)this.table.getSliceView();
                Set<HoodieFileGroupId> fgInPendingCompactionAndClustering = fileSystemView.getPendingCompactionOperations().map(instantTimeOpPair -> ((CompactionOperation)instantTimeOpPair.getValue()).getFileGroupId()).collect(Collectors.toSet());
                fgInPendingCompactionAndClustering.addAll(fileSystemView.getFileGroupsInPendingClustering().map(Pair::getLeft).collect(Collectors.toSet()));
                this.context.setJobStatus(this.getClass().getSimpleName(), "Compaction: generating compaction plan: " + this.config.getTableName());
                return this.compactor.generateCompactionPlan(this.context, this.table, this.config, this.instantTime, fgInPendingCompactionAndClustering);
            }
            catch (IOException e) {
                throw new HoodieCompactionException("Could not schedule compaction " + this.config.getBasePath(), e);
            }
        }
        return new HoodieCompactionPlan();
    }

    private Option<Pair<Integer, String>> getLatestDeltaCommitInfo() {
        Option<Pair<HoodieTimeline, HoodieInstant>> deltaCommitsInfo = CompactionUtils.getDeltaCommitsSinceLatestCompaction(this.table.getActiveTimeline());
        if (deltaCommitsInfo.isPresent()) {
            return Option.of(Pair.of(deltaCommitsInfo.get().getLeft().countInstants(), deltaCommitsInfo.get().getRight().getTimestamp()));
        }
        return Option.empty();
    }

    private Option<Pair<Integer, String>> getLatestDeltaCommitInfoSinceLastCompactionRequest() {
        Option<Pair<HoodieTimeline, HoodieInstant>> deltaCommitsInfo = CompactionUtils.getDeltaCommitsSinceLatestCompactionRequest(this.table.getActiveTimeline());
        if (deltaCommitsInfo.isPresent()) {
            return Option.of(Pair.of(deltaCommitsInfo.get().getLeft().countInstants(), deltaCommitsInfo.get().getRight().getTimestamp()));
        }
        return Option.empty();
    }

    private boolean needCompact(CompactionTriggerStrategy compactionTriggerStrategy) {
        boolean compactable;
        Option<Pair<Integer, String>> latestDeltaCommitInfoOption = this.getLatestDeltaCommitInfo();
        if (!latestDeltaCommitInfoOption.isPresent()) {
            return false;
        }
        Pair<Integer, String> latestDeltaCommitInfo = latestDeltaCommitInfoOption.get();
        int inlineCompactDeltaCommitMax = this.config.getInlineCompactDeltaCommitMax();
        int inlineCompactDeltaSecondsMax = this.config.getInlineCompactDeltaSecondsMax();
        switch (compactionTriggerStrategy) {
            case NUM_COMMITS: {
                boolean bl = compactable = inlineCompactDeltaCommitMax <= latestDeltaCommitInfo.getLeft();
                if (!compactable) break;
                LOG.info((Object)String.format("The delta commits >= %s, trigger compaction scheduler.", inlineCompactDeltaCommitMax));
                break;
            }
            case NUM_COMMITS_AFTER_LAST_REQUEST: {
                latestDeltaCommitInfoOption = this.getLatestDeltaCommitInfoSinceLastCompactionRequest();
                if (!latestDeltaCommitInfoOption.isPresent()) {
                    return false;
                }
                latestDeltaCommitInfo = latestDeltaCommitInfoOption.get();
                boolean bl = compactable = inlineCompactDeltaCommitMax <= latestDeltaCommitInfo.getLeft();
                if (!compactable) break;
                LOG.info((Object)String.format("The delta commits >= %s since the last compaction request, trigger compaction scheduler.", inlineCompactDeltaCommitMax));
                break;
            }
            case TIME_ELAPSED: {
                boolean bl = compactable = (long)inlineCompactDeltaSecondsMax <= this.parsedToSeconds(this.instantTime) - this.parsedToSeconds(latestDeltaCommitInfo.getRight());
                if (!compactable) break;
                LOG.info((Object)String.format("The elapsed time >=%ss, trigger compaction scheduler.", inlineCompactDeltaSecondsMax));
                break;
            }
            case NUM_OR_TIME: {
                boolean bl = compactable = inlineCompactDeltaCommitMax <= latestDeltaCommitInfo.getLeft() || (long)inlineCompactDeltaSecondsMax <= this.parsedToSeconds(this.instantTime) - this.parsedToSeconds(latestDeltaCommitInfo.getRight());
                if (!compactable) break;
                LOG.info((Object)String.format("The delta commits >= %s or elapsed_time >=%ss, trigger compaction scheduler.", inlineCompactDeltaCommitMax, inlineCompactDeltaSecondsMax));
                break;
            }
            case NUM_AND_TIME: {
                boolean bl = compactable = inlineCompactDeltaCommitMax <= latestDeltaCommitInfo.getLeft() && (long)inlineCompactDeltaSecondsMax <= this.parsedToSeconds(this.instantTime) - this.parsedToSeconds(latestDeltaCommitInfo.getRight());
                if (!compactable) break;
                LOG.info((Object)String.format("The delta commits >= %s and elapsed_time >=%ss, trigger compaction scheduler.", inlineCompactDeltaCommitMax, inlineCompactDeltaSecondsMax));
                break;
            }
            default: {
                throw new HoodieCompactionException("Unsupported compaction trigger strategy: " + (Object)((Object)this.config.getInlineCompactTriggerStrategy()));
            }
        }
        return compactable;
    }

    private Long parsedToSeconds(String time) {
        long timestamp;
        try {
            timestamp = HoodieActiveTimeline.parseDateFromInstantTime(time).getTime() / 1000L;
        }
        catch (ParseException e) {
            throw new HoodieCompactionException(e.getMessage(), e);
        }
        return timestamp;
    }
}

